/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Anno;
import com.klg.jclass.chart3d.Changeable;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Cube;
import com.klg.jclass.chart3d.JCAction;
import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCBar;
import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.JCData3dIndex;
import com.klg.jclass.chart3d.JCPlotCube;
import com.klg.jclass.chart3d.JCScatter;
import com.klg.jclass.chart3d.JCSurface;
import com.klg.jclass.chart3d.JCView3d;
import com.klg.jclass.chart3d.JCViewport;
import com.klg.jclass.chart3d.Transform;
import com.klg.jclass.util.legend.JCLegend;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import javax.swing.JComponent;

public class JCChart3dArea
extends JComponent
implements Changeable,
Serializable {
    static final long serialVersionUID = -5542417106751358122L;
    protected boolean updateParent = true;
    protected Graphics rbGC = null;
    protected boolean changed = true;
    protected int changedFlag = 0;
    protected boolean inAction = false;
    protected transient JCAction actionHandler = null;
    protected Dimension preferredSize = null;
    private Graphics prevSetGraphics = null;
    protected JCChart3d chart3d = null;
    protected JCAxis xAxis = null;
    protected JCAxis yAxis = null;
    protected JCAxis zAxis = null;
    protected JCAxis[] axes = null;
    protected JCViewport viewport = null;
    protected JCView3d view3d = null;
    protected Cube cube = null;
    protected JCPlotCube plotCube = null;
    protected Transform transform = null;
    protected Anno anno = null;
    protected JCSurface surface = null;
    protected JCBar bar = null;
    protected JCScatter scatter = null;
    protected Point last = new Point(-1, -1);

    public JCChart3dArea() {
    }

    public JCChart3dArea(JCChart3d jCChart3d) {
        this.setOpaque(false);
        this.chart3d = jCChart3d;
    }

    protected void animateAction(InputEvent inputEvent, int n2, int n3) {
        if (this.actionHandler == null) {
            return;
        }
        if (this.last.x == n2 && this.last.y == n3) {
            return;
        }
        this.last.x = n2;
        this.last.y = n3;
        this.actionHandler.animate(inputEvent, n2, n3);
    }

    public void cancel() {
        this.actionHandler.cancel();
        this.actionHandler = null;
        this.inAction = false;
        this.setChanged(true, 2);
    }

    public void drawPreview(double d2, double d3, double d4, double d5, double d6, double d7, int n2, int n3, int n4) {
        Graphics graphics = this.getGraphics();
        this.viewport.scale = d2;
        this.viewport.horizontalShift = d3;
        this.viewport.verticalShift = d4;
        this.viewport.normalized = d2 == 1.0 && d3 == 0.0 && d4 == 0.0;
        this.view3d.xRotation = d5;
        this.view3d.yRotation = d6;
        this.view3d.zRotation = d7;
        this.transform.computeTransformations(graphics);
        this.fillWithBackgroundColor(graphics);
        if (this.getChart3d().getDataView(0).getElevationData().isDataOK()) {
            this.plotCube.updateBoundingBox(graphics, n2, n3, n4);
        }
    }

    public void drawZoomRectangle(Point point, Point point2) {
        int n2;
        Graphics graphics;
        if (point == null) {
            return;
        }
        if (point.x == point2.x || point.y == point2.y) {
            return;
        }
        int n3 = point2.x;
        int n4 = point2.y;
        int n5 = point.x;
        int n6 = point.y;
        if (this.rbGC == null && this.getParent() == null) {
            return;
        }
        Graphics graphics2 = graphics = this.rbGC == null ? this.getGraphics().create() : this.rbGC.create();
        if (n5 - n3 < 0) {
            n2 = n5;
            n5 = n3;
            n3 = n2;
        }
        if (n6 - n4 < 0) {
            n2 = n6;
            n6 = n4;
            n4 = n2;
        }
        graphics.setXORMode(Color.white);
        graphics.drawRect(n3, n4, n5 - n3, n6 - n4);
        graphics.setXORMode(Color.black);
        graphics.drawRect(n3 + 1, n4 + 1, n5 - n3, n6 - n4);
        graphics.dispose();
    }

    protected void endAction(InputEvent inputEvent, int n2, int n3) {
        if (this.actionHandler == null) {
            return;
        }
        JCAction jCAction = this.actionHandler;
        this.actionHandler = null;
        this.last.x = n2;
        this.last.y = n3;
        jCAction.end(inputEvent, n2, n3);
    }

    protected void fillWithBackgroundColor(Graphics graphics) {
        if (!graphics.getColor().equals(this.getBackground())) {
            graphics.setColor(this.getBackground());
        }
        Rectangle rectangle = this.getBounds();
        graphics.fillRect(0, 0, rectangle.width, rectangle.height);
    }

    public JCAction getActionHandler() {
        return this.actionHandler;
    }

    public Anno getAnno() {
        return this.anno;
    }

    public JCAxis[] getAxes() {
        return this.axes;
    }

    public JCAxis getAxis(int n2) {
        if (this.axes == null) {
            return null;
        }
        int n3 = 0;
        while (n3 < 3) {
            if (this.axes[n3].getAxisId() == n2) {
                return this.axes[n3];
            }
            ++n3;
        }
        return null;
    }

    public JCBar getBar() {
        return this.bar;
    }

    public boolean getChanged() {
        return this.changed;
    }

    public boolean getChanged(int n2) {
        return (this.changedFlag & n2) == n2;
    }

    public JCChart3d getChart3d() {
        return this.chart3d;
    }

    public Cube getCube() {
        return this.cube;
    }

    public Rectangle getDrawingArea() {
        Rectangle rectangle = new Rectangle();
        this.getDrawingArea(rectangle);
        return rectangle;
    }

    public void getDrawingArea(Rectangle rectangle) {
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        rectangle.setBounds(insets.left, insets.top, Math.max(0, dimension.width - (insets.left + insets.right)), Math.max(0, dimension.height - (insets.top + insets.bottom)));
    }

    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public JCPlotCube getPlotCube() {
        return this.plotCube;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.preferredSize;
        if (dimension == null || dimension.width <= 0 || dimension.height <= 0) {
            dimension = new Dimension();
            dimension.width = 250;
            dimension.height = 250;
        }
        return dimension;
    }

    public JCScatter getScatter() {
        return this.scatter;
    }

    public JCSurface getSurface() {
        return this.surface;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public JCView3d getView3d() {
        return this.view3d;
    }

    public JCViewport getViewport() {
        return this.viewport;
    }

    public JCAxis getXAxis() {
        return this.xAxis;
    }

    public JCAxis getYAxis() {
        return this.yAxis;
    }

    public JCAxis getZAxis() {
        return this.zAxis;
    }

    public boolean isBatched() {
        return false;
    }

    public final boolean isChanged() {
        return this.getChanged();
    }

    public final boolean isChanged(int n2) {
        return this.getChanged(n2);
    }

    public boolean isInAction() {
        return this.inAction;
    }

    public void paintComponent(Graphics graphics) {
        if (this.getParent() == null || this.chart3d == null || graphics == null || !this.isVisible()) {
            return;
        }
        try {
            Chart3dDataView chart3dDataView = this.chart3d.getDataView(0);
            chart3dDataView.calcDefaults();
            if (this.transform != null) {
                this.transform.computeTransformations(graphics);
            }
            chart3dDataView.getContour().recalcContours();
            if (this.isOpaque()) {
                this.fillWithBackgroundColor(graphics);
            }
            chart3dDataView.drawGraph(graphics);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        this.rbGC = graphics;
        if (this.actionHandler != null) {
            this.actionHandler.reanimate(this.last.x, this.last.y);
        }
        this.rbGC = null;
        this.setChanged(false, 0);
    }

    protected JCData3dIndex pick(Point point, Chart3dDataView chart3dDataView) {
        JCData3dIndex jCData3dIndex = null;
        if (point == null || this.chart3d == null) {
            return jCData3dIndex;
        }
        if (chart3dDataView == null) {
            chart3dDataView = this.chart3d.getDataView(0);
        }
        chart3dDataView.createDraw();
        jCData3dIndex = chart3dDataView.getDraw().getMapping().pick(point.x, point.y);
        if (jCData3dIndex != null) {
            jCData3dIndex.setObject(this);
            jCData3dIndex.setDataView(chart3dDataView);
        }
        return jCData3dIndex;
    }

    public void recalc() {
        this.chart3d.getDataView(0).calcDefaults();
    }

    public void reset() {
        if (this.chart3d == null) {
            return;
        }
        boolean bl = this.chart3d.isBatched();
        this.chart3d.setBatched(true);
        this.viewport.setNormalized(true);
        this.actionHandler = null;
        this.inAction = false;
        this.setChanged(true, 2);
        this.chart3d.setBatched(bl);
    }

    protected void setActionHandler(JCAction jCAction) {
        this.actionHandler = jCAction;
    }

    public void setAnno(Anno anno) {
        this.anno = anno;
        anno.setChart3dArea(this);
    }

    public void setAxes(JCAxis[] jCAxisArray) {
        if (jCAxisArray.length != 3) {
            throw new IllegalArgumentException("Invalid value. Array has incorrect length!");
        }
        this.axes = jCAxisArray;
        boolean bl = false;
        if (this.xAxis != jCAxisArray[0]) {
            if (jCAxisArray[0].getAxisId() != 1) {
                throw new IllegalArgumentException("AxisId does not match ID of Axis!");
            }
            this.xAxis = jCAxisArray[0];
            jCAxisArray[0].addParent(this);
            bl = true;
        }
        if (this.yAxis != jCAxisArray[1]) {
            if (jCAxisArray[1].getAxisId() != 2) {
                throw new IllegalArgumentException("AxisId does not match ID of Axis!");
            }
            this.yAxis = jCAxisArray[1];
            jCAxisArray[1].addParent(this);
            bl = true;
        }
        if (this.zAxis != jCAxisArray[2]) {
            if (jCAxisArray[2].getAxisId() != 3) {
                throw new IllegalArgumentException("AxisId does not match ID of Axis!");
            }
            this.zAxis = jCAxisArray[2];
            jCAxisArray[2].addParent(this);
            bl = true;
        }
        if (bl) {
            this.setChanged(true, 34);
        }
    }

    public void setAxis(JCAxis jCAxis, int n2) {
        if (jCAxis == null) {
            throw new IllegalArgumentException("Invalid value. Cannot be null.");
        }
        if (n2 < 1 || n2 > 3) {
            return;
        }
        if (jCAxis.getAxisId() != n2) {
            throw new IllegalArgumentException("AxisId does not match ID of Axis!");
        }
        this.axes[n2 - 1] = jCAxis;
        if (n2 == 1) {
            if (this.xAxis == jCAxis) {
                return;
            }
            this.xAxis = jCAxis;
        } else if (n2 == 2) {
            if (this.yAxis == jCAxis) {
                return;
            }
            this.yAxis = jCAxis;
        } else if (n2 == 3) {
            if (this.zAxis == jCAxis) {
                return;
            }
            this.zAxis = jCAxis;
        }
        jCAxis.addParent(this);
        this.setChanged(true, 34);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            container.validate();
        }
    }

    public void setBar(JCBar jCBar) {
        if (this.bar == jCBar) {
            return;
        }
        this.bar = jCBar;
        if (this.bar == null) {
            throw new IllegalArgumentException("Invalid value. Cannot be null.");
        }
        this.bar.addParent(this);
        this.setChanged(true, 2);
    }

    public void setChanged(boolean bl, int n2) {
        if (this.chart3d == null) {
            return;
        }
        Chart3dDataView chart3dDataView = this.chart3d.getDataView(0);
        if (bl) {
            chart3dDataView.setChanged(true, n2, false);
        } else {
            this.chart3d.getDataView(0).setChanged(false, 0, false);
        }
        this.changed = bl;
        this.changedFlag = this.changed ? (this.changedFlag |= n2) : n2;
        if (this.changed) {
            if (!this.chart3d.isBatched()) {
                JCLegend jCLegend = this.chart3d.getLegend();
                if (jCLegend != null && (n2 & 0x20) > 0) {
                    jCLegend.setChanged(true, 2, false);
                    jCLegend.recalc();
                }
                if (jCLegend != null && (n2 & 0x10) > 0) {
                    jCLegend.setChanged(true, 1, false);
                }
                if ((n2 & 2) > 0) {
                    this.chart3d.repaint();
                } else if ((n2 & 1) > 0) {
                    this.chart3d.repaint();
                }
            }
            return;
        }
    }

    public void setChanged(boolean bl, int n2, boolean bl2) {
        if (bl2) {
            this.setChanged(bl, n2);
        } else {
            this.changed = bl;
            this.changedFlag = bl ? (this.changedFlag |= n2) : n2;
        }
    }

    public void setChart3d(JCChart3d jCChart3d) {
        if (this.chart3d == jCChart3d) {
            return;
        }
        this.chart3d = jCChart3d;
        this.setChanged(true, 34);
    }

    public void setCube(Cube cube) {
        this.cube = cube;
        cube.setChart3dArea(this);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.setChanged(true, 33);
    }

    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
    }

    public void setInAction(boolean bl) {
        this.inAction = bl;
    }

    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            container.validate();
        }
    }

    public void setPlotCube(JCPlotCube jCPlotCube) {
        if (this.plotCube == jCPlotCube) {
            return;
        }
        this.plotCube = jCPlotCube;
        if (this.plotCube == null) {
            throw new IllegalArgumentException("Invalid value. Cannot be null.");
        }
        this.plotCube.setChart3dArea(this);
    }

    public void setPreferredSize(Dimension dimension) {
        this.preferredSize = dimension;
    }

    public void setScatter(JCScatter jCScatter) {
        if (this.scatter == jCScatter) {
            return;
        }
        this.scatter = jCScatter;
        if (this.scatter == null) {
            throw new IllegalArgumentException("Invalid value. Cannot be null.");
        }
        this.scatter.addParent(this);
        this.setChanged(true, 2);
    }

    public void setSurface(JCSurface jCSurface) {
        if (this.surface == jCSurface) {
            return;
        }
        this.surface = jCSurface;
        if (this.surface == null) {
            throw new IllegalArgumentException("Invalid value. Cannot be null.");
        }
        this.surface.addParent(this);
        this.setChanged(true, 2);
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
        transform.setChart3dArea(this);
    }

    public void setView3d(JCView3d jCView3d) {
        if (this.view3d == jCView3d) {
            return;
        }
        this.view3d = jCView3d;
        if (this.view3d == null) {
            throw new IllegalArgumentException("Invalid value. Cannot be null.");
        }
        this.view3d.addParent(this);
        this.setChanged(true, 2);
    }

    public void setViewport(JCViewport jCViewport) {
        if (this.viewport == jCViewport) {
            return;
        }
        this.viewport = jCViewport;
        if (this.viewport == null) {
            throw new IllegalArgumentException("Invalid value. Cannot be null.");
        }
        this.viewport.addParent(this);
        this.setChanged(true, 2);
    }

    public void setXAxis(JCAxis jCAxis) {
        if (jCAxis == null) {
            throw new IllegalArgumentException("Invalid value. Cannot be null.");
        }
        if (jCAxis.getAxisId() != 1) {
            throw new IllegalArgumentException("AxisId does not match ID of Axis!");
        }
        this.axes[0] = jCAxis;
        this.xAxis = jCAxis;
        jCAxis.addParent(this);
        this.setChanged(true, 34);
    }

    public void setYAxis(JCAxis jCAxis) {
        if (jCAxis == null) {
            throw new IllegalArgumentException("Invalid value. Cannot be null.");
        }
        if (jCAxis.getAxisId() != 2) {
            throw new IllegalArgumentException("AxisId does not match ID of Axis!");
        }
        this.axes[1] = jCAxis;
        this.yAxis = jCAxis;
        jCAxis.addParent(this);
        this.setChanged(true, 34);
    }

    public void setZAxis(JCAxis jCAxis) {
        if (jCAxis == null) {
            throw new IllegalArgumentException("Invalid value. Cannot be null.");
        }
        if (jCAxis.getAxisId() != 3) {
            throw new IllegalArgumentException("AxisId does not match ID of Axis!");
        }
        this.axes[2] = jCAxis;
        this.zAxis = jCAxis;
        jCAxis.addParent(this);
        this.setChanged(true, 34);
    }

    protected void startAction(InputEvent inputEvent, int n2, int n3) {
        if (this.actionHandler == null) {
            return;
        }
        this.actionHandler.start(inputEvent, n2, n3);
    }

    public void updateParent(int n2) {
        JCChart3d jCChart3d = (JCChart3d)this.getParent();
        if (jCChart3d != null) {
            if ((n2 & 2) > 0 || (n2 & 8) > 0) {
                jCChart3d.invalidate();
                if (!jCChart3d.isBatched()) {
                    jCChart3d.validate();
                    jCChart3d.repaint();
                }
            } else if ((n2 & 1) > 0 && !jCChart3d.isBatched()) {
                jCChart3d.repaint();
            }
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.changed;
        int n2 = this.changedFlag;
        this.changed = true;
        this.changedFlag = 2;
        objectOutputStream.defaultWriteObject();
        this.changed = bl;
        this.changedFlag = n2;
    }
}

