/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Changeable;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Chart3dGridDataModel;
import com.klg.jclass.chart3d.Chart3dPointDataModel;
import com.klg.jclass.chart3d.ErrorDialog;
import com.klg.jclass.chart3d.JCAction;
import com.klg.jclass.chart3d.JCActionTable;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dCustomizer;
import com.klg.jclass.chart3d.JCChart3dLegend;
import com.klg.jclass.chart3d.JCChart3dLegendManager;
import com.klg.jclass.chart3d.JCChart3dUI;
import com.klg.jclass.chart3d.JCData3dContourIndex;
import com.klg.jclass.chart3d.JCData3dIndex;
import com.klg.jclass.chart3d.JCData3dPointIndex;
import com.klg.jclass.chart3d.JCElevation;
import com.klg.jclass.chart3d.JCVersion;
import com.klg.jclass.chart3d.LegendEntry;
import com.klg.jclass.chart3d.event.JCChart3dEvent;
import com.klg.jclass.chart3d.event.JCChart3dListener;
import com.klg.jclass.chart3d.event.JCPick3dEvent;
import com.klg.jclass.chart3d.event.JCPick3dListener;
import com.klg.jclass.util.JCDebug;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.ServerRenderable;
import com.klg.jclass.util.ServerRenderer;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.JCLegendItem;
import com.klg.jclass.util.legend.LegendComponentLayout;
import com.klg.jclass.util.legend.LegendComponentLayoutUser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.vecmath.Point3d;

public abstract class JCChart3d
extends JComponent
implements Changeable,
LegendComponentLayoutUser,
ServerRenderable,
Serializable,
KeyListener,
MouseListener,
MouseMotionListener,
Chart3dGridDataModel,
Chart3dPointDataModel {
    private static final String uiClassID = "JCChart3dUI";
    protected JCChart3dArea chart3dArea = null;
    protected Vector dataViews = new Vector();
    protected JCLegend legend = null;
    protected JCChart3dLegendManager legendManager = null;
    protected JComponent footer = null;
    protected JComponent header = null;
    protected JCListenerList listeners = null;
    protected JCListenerList pickListeners = null;
    private int flip = 1;
    private boolean warningOn = true;
    private boolean batched = false;
    private boolean allowUserChanges = false;
    protected boolean inKeyPress = false;
    public static final int NONE = -1;
    public static final int SURFACE = 0;
    public static final int BAR = 1;
    public static final int SCATTER = 2;
    public static final int LAST_PREDEFINED_CHART_TYPE = 3;
    public static final String ERRMSG_CUSTOMIZER_FAILURE = "Could not initialize Customizer.";
    protected int lineColorIndex;
    protected int symbolColorIndex;
    protected int fillColorIndex;
    protected int symbolShapeIndex;
    private Dimension curSize = new Dimension(-1, -1);
    protected Rectangle chart3dAreaLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle legendLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle headerLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle footerLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private int offset = 5;
    private boolean changed = false;
    private Graphics prevSetGraphics = null;
    protected JCActionTable actionTable;
    public transient JCChart3dCustomizer customizer = null;

    public JCChart3d() {
        try {
            this.init(0);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public JCChart3d(int n2) {
        this.init(n2);
    }

    public void addChart3dListener(JCChart3dListener jCChart3dListener) {
        this.listeners = JCListenerList.add(this.listeners, jCChart3dListener);
    }

    public Chart3dDataView addDataView(int n2, int n3) {
        Chart3dDataView chart3dDataView = new Chart3dDataView(this, n2, n3);
        this.setDataView(n2, chart3dDataView);
        return chart3dDataView;
    }

    public void addNotify() {
        super.addNotify();
        this.moreAddNotify();
    }

    public void addPick3dListener(JCPick3dListener jCPick3dListener) {
        this.pickListeners = JCListenerList.add(this.pickListeners, jCPick3dListener);
    }

    public void cancel() {
        this.chart3dArea.cancel();
    }

    public int convertChartAreaXToX(int n2) {
        return n2 + this.chart3dArea.getLocation().x;
    }

    public int convertChartAreaYToY(int n2) {
        return n2 + this.chart3dArea.getLocation().y;
    }

    public int convertXToChartAreaX(int n2) {
        return n2 - this.chart3dArea.getLocation().x;
    }

    public int convertYToChartAreaY(int n2) {
        return n2 - this.chart3dArea.getLocation().y;
    }

    protected abstract void createActionTable();

    protected void createChart3dArea() {
        this.chart3dArea = new JCChart3dArea(this);
        this.add(this.chart3dArea);
    }

    protected void createFooter() {
        this.footer = new JLabel();
        this.footer.setVisible(false);
        this.add(this.footer);
    }

    protected void createHeader() {
        this.header = new JLabel();
        this.header.setVisible(false);
        this.add(this.header);
    }

    public static JCChart3d createJava2dChart() {
        JCChart3d jCChart3d = null;
        try {
            Class<?> clazz = Class.forName("com.klg.jclass.chart3d.j2d.JCChart3dJava2d");
            jCChart3d = (JCChart3d)clazz.newInstance();
        }
        catch (Exception exception) {
            jCChart3d = null;
        }
        return jCChart3d;
    }

    public static JCChart3d createJava3dChart() {
        return JCChart3d.createJava3dChart(false);
    }

    public static JCChart3d createJava3dChart(boolean bl) {
        JCChart3d jCChart3d = null;
        try {
            Class<?> clazz = Class.forName("com.klg.jclass.chart3d.j3d.JCChart3dJava3d");
            jCChart3d = (JCChart3d)clazz.newInstance();
        }
        catch (Throwable throwable) {
            jCChart3d = bl ? JCChart3d.createJava2dChart() : null;
        }
        return jCChart3d;
    }

    protected void createLegend() {
        this.legend = new JCChart3dLegend();
        this.legendManager = new JCChart3dLegendManager(this, this.legend);
        this.legend.setLegendPopulator(this.legendManager);
        this.legend.setLegendRenderer(this.legendManager);
        this.add(this.legend);
    }

    public void doLayout() {
        try {
            this.performLayout();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public Chart3dDataView findDataView(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.dataViews == null || this.dataViews.size() == 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.dataViews.size()) {
            Chart3dDataView chart3dDataView = (Chart3dDataView)this.dataViews.elementAt(n2);
            if (chart3dDataView.getName().equals(string)) {
                return chart3dDataView;
            }
            ++n2;
        }
        return null;
    }

    public void firePaint() {
        Enumeration enumeration = JCListenerList.elements(this.listeners);
        while (enumeration.hasMoreElements()) {
            ((JCChart3dListener)enumeration.nextElement()).paintChart(this);
        }
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    protected abstract JCAction getActionHandler(InputEvent var1);

    public JCActionTable getActionTable() {
        return this.actionTable;
    }

    public boolean getAllowUserChanges() {
        return this.allowUserChanges;
    }

    public boolean getChanged() {
        return this.chart3dArea.isChanged() || this.legend.isChanged() || !this.chart3dArea.isValid() || !this.legend.isValid() || this.header != null && !this.header.isValid() || this.footer != null && !this.footer.isValid();
    }

    public boolean getChanged(int n2) {
        return this.chart3dArea.isChanged(n2) || this.legend.isChanged(n2) || !this.chart3dArea.isValid() || !this.legend.isValid() || this.header != null && !this.header.isValid() || this.footer != null && !this.footer.isValid();
    }

    public JCChart3dArea getChart3dArea() {
        return this.chart3dArea;
    }

    protected int getColorIndex(int n2) {
        int n3 = 0;
        switch (n2) {
            case 1: {
                n3 = this.getFillColorIndex();
                break;
            }
            case 2: {
                n3 = this.getLineColorIndex();
                break;
            }
            case 3: {
                n3 = this.getSymbolColorIndex();
                break;
            }
        }
        return n3;
    }

    public JComponent getComponentArea() {
        return this.getChart3dArea();
    }

    public Component getComponentAt(int n2, int n3) {
        if (!this.contains(n2, n3)) {
            return null;
        }
        int n4 = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        int n5 = 0;
        while (n5 < n4) {
            Component component = componentArray[n5];
            if (component != null) {
                Point point = component.getLocation();
                if (component.isShowing() && component.contains(n2 - point.x, n3 - point.y)) {
                    return component;
                }
            }
            ++n5;
        }
        return this;
    }

    public abstract String getCustomizerName();

    public List getDataView() {
        if (this.dataViews == null || this.dataViews.size() == 0) {
            return null;
        }
        return new Vector(this.dataViews);
    }

    public Chart3dDataView getDataView(int n2) {
        Chart3dDataView chart3dDataView = null;
        try {
            chart3dDataView = (Chart3dDataView)this.dataViews.get(n2);
        }
        catch (Exception exception) {}
        return chart3dDataView;
    }

    public Rectangle getDrawingArea() {
        Rectangle rectangle = new Rectangle();
        this.getDrawingArea(rectangle);
        return rectangle;
    }

    public void getDrawingArea(Rectangle rectangle) {
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        rectangle.setBounds(insets.left, insets.top, Math.max(0, this.getSize().width - (insets.left + insets.right)), Math.max(0, this.getSize().height - (insets.top + insets.bottom)));
    }

    public int getDrawingAreaHeight() {
        Insets insets = this.getInsets();
        int n2 = 0;
        if (insets != null) {
            n2 = insets.top + insets.bottom;
        }
        return Math.max(0, this.getSize().height - n2);
    }

    public int getDrawingAreaWidth() {
        Insets insets = this.getInsets();
        int n2 = 0;
        if (insets != null) {
            n2 = insets.left + insets.right;
        }
        return Math.max(0, this.getSize().width - n2);
    }

    public int getFillColorIndex() {
        return this.fillColorIndex;
    }

    public JComponent getFooter() {
        return this.footer;
    }

    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics;
    }

    public JComponent getHeader() {
        return this.header;
    }

    public Rectangle getLayoutHints(JComponent jComponent) {
        if (jComponent == null) {
            return new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        if (jComponent == this.chart3dArea) {
            return this.chart3dAreaLayoutHints;
        }
        if (jComponent == this.legend) {
            return this.legendLayoutHints;
        }
        if (jComponent == this.header) {
            return this.headerLayoutHints;
        }
        if (jComponent == this.footer) {
            return this.footerLayoutHints;
        }
        return new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public JCLegend getLegend() {
        return this.legend;
    }

    public int getLineColorIndex() {
        return this.lineColorIndex;
    }

    public int getNumDataViews() {
        int n2 = 0;
        try {
            if (this.dataViews != null) {
                n2 = this.dataViews.size();
            }
        }
        catch (Exception exception) {}
        return n2;
    }

    protected List getOriginalDataView() {
        return this.dataViews;
    }

    public Point3d[][] getPoints() {
        Point3d[][] point3dArray = new Point3d[5][];
        int[] nArray = new int[]{3, 5, 6, 4, 2};
        int n2 = 0;
        while (n2 < point3dArray.length) {
            Point3d[] point3dArray2 = new Point3d[nArray[n2]];
            int n3 = 0;
            while (n3 < point3dArray2.length) {
                point3dArray2[n3] = new Point3d(20 + 2 * n2, 30 + n3, 10 * n2 + n3);
                ++n3;
            }
            point3dArray[n2] = point3dArray2;
            ++n2;
        }
        return point3dArray;
    }

    public Object getSource() {
        return this;
    }

    public int getSymbolColorIndex() {
        return this.symbolColorIndex;
    }

    public int getSymbolShapeIndex() {
        return this.symbolShapeIndex;
    }

    public JCChart3dUI getUI() {
        return (JCChart3dUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public double[] getXGrid() {
        double[] dArray = new double[11];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = n2;
            ++n2;
        }
        return dArray;
    }

    public double[] getYGrid() {
        double[] dArray = new double[11];
        int n2 = 0;
        while (n2 < dArray.length) {
            dArray[n2] = n2;
            ++n2;
        }
        return dArray;
    }

    public double[][] getZValues() {
        double[][] dArray = new double[11][11];
        int n2 = 0;
        while (n2 < dArray.length) {
            int n3 = 0;
            while (n3 < dArray[n2].length) {
                double d2 = n2 - 5;
                double d3 = n3 - 5;
                dArray[n2][n3] = d2 * d2 + d3 * d3;
                ++n3;
            }
            ++n2;
        }
        return dArray;
    }

    protected void init(int n2) {
        this.setOpaque(true);
        this.initializeLayout();
        this.createHeader();
        this.createFooter();
        this.createLegend();
        this.resetDefaults();
        this.initializeUI();
        this.createActionTable();
    }

    protected void initializeLayout() {
        super.setLayout(new LegendComponentLayout());
    }

    protected void initializeUI() {
        this.enableEvents(8L);
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.registerUI();
        this.updateUI();
    }

    public boolean isBatched() {
        return this.batched;
    }

    public final boolean isChanged() {
        return this.getChanged();
    }

    public final boolean isChanged(int n2) {
        return this.getChanged(n2);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isProjection() {
        Chart3dDataView chart3dDataView = (Chart3dDataView)this.dataViews.elementAt(0);
        JCElevation jCElevation = chart3dDataView.getElevation();
        return chart3dDataView.getChartType() != 1 && !jCElevation.isMeshed() && !jCElevation.isShaded();
    }

    public boolean isWarningDialog() {
        return this.warningOn;
    }

    public void keyPressed(KeyEvent keyEvent) {
        JCAction jCAction = this.getActionHandler(keyEvent);
        if (jCAction == null) {
            return;
        }
        this.chart3dArea.isInAction();
        if (!this.inKeyPress) {
            this.inKeyPress = true;
            this.chart3dArea.setActionHandler(jCAction);
            this.chart3dArea.startAction(keyEvent, 0, 0);
            this.flip = 1 - this.flip;
        }
        this.chart3dArea.setActionHandler(jCAction);
        this.chart3dArea.animateAction(keyEvent, this.flip, this.flip);
        this.flip = 1 - this.flip;
    }

    public void keyReleased(KeyEvent keyEvent) {
        JCDebug.println("jcchart3d", "keyReleased: endAction=" + this.chart3dArea.getActionHandler());
        this.chart3dArea.isInAction();
        this.inKeyPress = false;
        this.chart3dArea.endAction(keyEvent, this.flip, this.flip);
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void launchPropertyPage(Point point) {
        JCDebug.println("jcchart3d", "Launching property page");
        if (!this.allowUserChanges) {
            return;
        }
        if (this.customizer == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                Class<?> clazz = Class.forName(this.getCustomizerName());
                this.customizer = (JCChart3dCustomizer)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                this.customizer = null;
                ErrorDialog.raise(this, "Could not initialize Customizer.\n" + exception);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (this.customizer != null) {
            this.customizer.setTarget(this);
            SwingUtilities.convertPointToScreen(point, this);
            this.customizer.showCustomizer(point);
        }
    }

    public static JCChart3d makeChart3d(String string) {
        JCChart3d jCChart3d = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            jCChart3d = (JCChart3d)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            jCChart3d = null;
        }
        return jCChart3d;
    }

    protected void moreAddNotify() {
        this.doLayout();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        JCDebug.println("jcchart3d", "animateAction=" + this.chart3dArea.getActionHandler());
        this.chart3dArea.animateAction(mouseEvent, this.convertXToChartAreaX(mouseEvent.getX()), this.convertYToChartAreaY(mouseEvent.getY()));
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        JCAction jCAction;
        if (this.isFocusTraversable()) {
            this.requestFocus();
        }
        if ((jCAction = this.getActionHandler(mouseEvent)) == null) {
            return;
        }
        this.chart3dArea.setActionHandler(jCAction);
        this.chart3dArea.setInAction(true);
        this.chart3dArea.startAction(mouseEvent, this.convertXToChartAreaX(mouseEvent.getX()), this.convertYToChartAreaY(mouseEvent.getY()));
        JCDebug.println("jcchart3d", "action=" + this.chart3dArea.getActionHandler());
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        JCDebug.println("jcchart3d", "endAction=" + this.chart3dArea.getActionHandler());
        this.chart3dArea.endAction(mouseEvent, this.convertXToChartAreaX(mouseEvent.getX()), this.convertYToChartAreaY(mouseEvent.getY()));
        this.chart3dArea.setInAction(false);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.firePaint();
    }

    public void paintComponent(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Graphics graphics2 = graphics.create();
        if (this.isOpaque()) {
            if (!graphics2.getColor().equals(this.getBackground())) {
                graphics2.setColor(this.getBackground());
            }
            Rectangle rectangle = this.getBounds();
            graphics2.fillRect(0, 0, rectangle.width, rectangle.height);
        }
        if (graphics2 != null) {
            graphics2.dispose();
        }
        this.setChanged(false, 0);
    }

    private void performLayout() {
        Dimension dimension = new Dimension();
        dimension.width = this.getDrawingAreaWidth();
        dimension.height = this.getDrawingAreaHeight();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        Insets insets = this.getInsets();
        if (!this.chart3dArea.isChanged(8) && this.chart3dArea.isValid() && dimension.width == this.curSize.width && dimension.height == this.curSize.height && !this.legend.isChanged(2) && !this.legend.isChanged(8) && this.legend.isValid() && this.header != null && this.header.isValid() && this.footer != null && this.footer.isValid()) {
            if (this.chart3dArea.isChanged(2) || !this.chart3dArea.isValid()) {
                this.recalc();
            }
            this.repaint();
            return;
        }
        this.recalc();
        this.curSize = dimension;
        super.doLayout();
        this.repaint();
    }

    public JCData3dIndex pick(Point point, Chart3dDataView chart3dDataView) {
        Component component = this.getComponentAt(point.x, point.y);
        if (component == null) {
            return null;
        }
        Point point2 = new Point(point.x - component.getLocation().x, point.y - component.getLocation().y);
        if (chart3dDataView == null) {
            chart3dDataView = this.getDataView(0);
        }
        if (component instanceof JCLegend) {
            return this.pickLegend(point2, chart3dDataView);
        }
        if (component instanceof JCChart3dArea) {
            return this.chart3dArea.pick(point2, chart3dDataView);
        }
        if (component != null) {
            JCData3dIndex jCData3dIndex = new JCData3dIndex(chart3dDataView);
            jCData3dIndex.obj = component;
            return jCData3dIndex;
        }
        return null;
    }

    protected JCData3dIndex pickLegend(Point point, Chart3dDataView chart3dDataView) {
        JCLegendItem jCLegendItem = this.legend.pick(point);
        JCData3dIndex jCData3dIndex = null;
        boolean bl = chart3dDataView.getElevationData() instanceof Chart3dGridData;
        jCData3dIndex = bl ? new JCData3dContourIndex(chart3dDataView) : new JCData3dPointIndex(chart3dDataView, -1, -1);
        jCData3dIndex.setObject(this.legend);
        if (jCLegendItem == null || jCLegendItem.itemInfo == null) {
            return jCData3dIndex;
        }
        JCData3dIndex jCData3dIndex2 = null;
        if (jCLegendItem.itemInfo instanceof LegendEntry) {
            jCData3dIndex2 = ((LegendEntry)jCLegendItem.itemInfo).dataIndex;
        } else if (jCLegendItem.itemInfo instanceof JCData3dIndex) {
            jCData3dIndex2 = (JCData3dIndex)jCLegendItem.itemInfo;
        } else {
            return jCData3dIndex;
        }
        Chart3dDataView chart3dDataView2 = jCData3dIndex2.getDataView();
        if (chart3dDataView != null && chart3dDataView2 != chart3dDataView) {
            return jCData3dIndex;
        }
        jCData3dIndex.setDataView(chart3dDataView);
        if (bl) {
            JCData3dContourIndex jCData3dContourIndex = (JCData3dContourIndex)jCData3dIndex2;
            JCData3dContourIndex jCData3dContourIndex2 = (JCData3dContourIndex)jCData3dIndex;
            jCData3dContourIndex2.setContourStyleIndex(jCData3dContourIndex.getContourStyleIndex());
            jCData3dContourIndex2.setUpperContourRangeValue(jCData3dContourIndex.getUpperContourRangeValue());
            jCData3dContourIndex2.setLowerContourRangeValue(jCData3dContourIndex.getLowerContourRangeValue());
        } else {
            JCData3dPointIndex jCData3dPointIndex = (JCData3dPointIndex)jCData3dIndex2;
            JCData3dPointIndex jCData3dPointIndex2 = (JCData3dPointIndex)jCData3dIndex;
            jCData3dPointIndex2.setSeries(jCData3dPointIndex.getSeries());
            jCData3dPointIndex2.setPoint(jCData3dPointIndex.getPoint());
        }
        return jCData3dIndex;
    }

    public void printAll(Graphics graphics) {
        super.printAll(graphics);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        int n2 = keyEvent.getID();
        switch (n2) {
            case 401: {
                this.keyPressed(keyEvent);
                break;
            }
            case 402: {
                this.keyReleased(keyEvent);
                break;
            }
            case 400: {
                this.keyTyped(keyEvent);
                break;
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n2 = mouseEvent.getID();
        switch (n2) {
            case 501: {
                this.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
                break;
            }
            case 500: {
                this.mouseClicked(mouseEvent);
                break;
            }
            case 505: {
                this.mouseExited(mouseEvent);
                break;
            }
            case 504: {
                this.mouseEntered(mouseEvent);
                break;
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n2 = mouseEvent.getID();
        switch (n2) {
            case 503: {
                this.mouseMoved(mouseEvent);
                break;
            }
            case 506: {
                this.mouseDragged(mouseEvent);
                break;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.registerUI();
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void recalc() {
        if (!this.isChanged(2)) {
            return;
        }
        try {
            this.chart3dArea.recalc();
            this.legend.recalc();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        this.setChanged(false, 0);
    }

    public void registerUI() {
        UIManager.getDefaults().put(uiClassID, "com.klg.jclass.chart3d.JCChart3dUI");
    }

    public void removeChart3dListener(JCChart3dListener jCChart3dListener) {
        this.listeners = JCListenerList.remove(this.listeners, jCChart3dListener);
    }

    public void removeDataView(int n2) {
        try {
            this.dataViews.remove(n2);
            this.reorderDataViews();
            this.setChanged(true, 164);
        }
        catch (Exception exception) {}
    }

    public void removePick3dListener(JCPick3dListener jCPick3dListener) {
        this.pickListeners = JCListenerList.remove(this.pickListeners, jCPick3dListener);
    }

    void reorderDataViews() {
        int n2 = 0;
        while (n2 < this.dataViews.size()) {
            Chart3dDataView chart3dDataView = (Chart3dDataView)this.dataViews.elementAt(n2);
            chart3dDataView.setDataViewId(n2);
            ++n2;
        }
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.isFocusTraversable()) {
            this.processEvent(new FocusEvent(this, 1004));
        }
    }

    public void reset() {
        this.chart3dArea.reset();
    }

    public void resetDefaults() {
        this.lineColorIndex = 0;
        this.fillColorIndex = 0;
        this.symbolColorIndex = 0;
        this.symbolShapeIndex = 1;
    }

    public void sendEvent() {
        JCChart3dEvent jCChart3dEvent = new JCChart3dEvent(this);
        Enumeration enumeration = JCListenerList.elements(this.listeners);
        while (enumeration.hasMoreElements()) {
            ((JCChart3dListener)enumeration.nextElement()).changeChart(jCChart3dEvent);
        }
    }

    public void sendPick3dEvent(JCData3dIndex jCData3dIndex) {
        JCPick3dEvent jCPick3dEvent = new JCPick3dEvent(this, jCData3dIndex);
        Enumeration enumeration = JCListenerList.elements(this.pickListeners);
        while (enumeration.hasMoreElements()) {
            ((JCPick3dListener)enumeration.nextElement()).pick(jCPick3dEvent);
        }
    }

    public void serverPaint(Graphics graphics) {
        ServerRenderer.paintComponent(graphics, this);
    }

    public Image serverSnapshot() {
        return ServerRenderer.snapshot(this);
    }

    public void setAbout(String string) {
    }

    public void setAllowUserChanges(boolean bl) {
        this.allowUserChanges = bl;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.setChanged(true, 130);
    }

    public void setBatched(boolean bl) {
        if (this.batched == bl) {
            return;
        }
        this.batched = bl;
        if (!bl) {
            this.update();
        }
    }

    public void setChanged(boolean bl, int n2) {
        if (bl == this.changed) {
            return;
        }
        this.changed = bl;
        if (this.changed) {
            int n3 = 0;
            if ((n2 & 0x20) > 0) {
                n3 |= 2;
            }
            if ((n2 & 0x10) > 0) {
                n3 |= 1;
            }
            if (n3 != 0) {
                this.legend.setChanged(true, n3, false);
            }
            int n4 = 0;
            if ((n2 & 4) > 0) {
                n4 |= 2;
            }
            if ((n2 & 0x80) > 0) {
                n4 |= 2;
            }
            if ((n2 & 0x40) > 0) {
                n4 |= 1;
            }
            if (n4 != 0) {
                this.chart3dArea.setChanged(true, n4, false);
            }
            if (this.isBatched()) {
                this.invalidate();
            } else if ((n2 & 2) > 0 || (n2 & 4) > 0) {
                this.update();
            } else if ((n2 & 1) > 0) {
                this.repaint();
            }
        }
    }

    public void setChanged(boolean bl, int n2, boolean bl2) {
        if (bl2) {
            this.setChanged(bl, n2);
        } else {
            this.changed = bl;
        }
    }

    public void setChart3dArea(JCChart3dArea jCChart3dArea) {
        if (jCChart3dArea == null) {
            return;
        }
        if (this.chart3dArea != null) {
            this.remove(this.chart3dArea);
        }
        this.chart3dArea = jCChart3dArea;
        this.add(this.chart3dArea);
        this.chart3dArea.setChart3d(this);
        this.setChanged(true, 164);
    }

    protected void setColorIndex(int n2, int n3) {
        switch (n3) {
            case 1: {
                this.setFillColorIndex(n2);
                break;
            }
            case 2: {
                this.setLineColorIndex(n2);
                break;
            }
            case 3: {
                this.setSymbolColorIndex(n2);
                break;
            }
        }
    }

    protected abstract void setCustomizerName(String var1);

    public void setDataView(int n2, Chart3dDataView chart3dDataView) {
        if (n2 < 0 || n2 > this.dataViews.size()) {
            throw new IllegalArgumentException("Bad data or index");
        }
        if (chart3dDataView != null) {
            chart3dDataView.setChart3d(this);
        }
        if (n2 >= 0 && n2 < this.dataViews.size()) {
            this.dataViews.set(n2, chart3dDataView);
        } else {
            this.dataViews.add(n2, chart3dDataView);
        }
        this.reorderDataViews();
        this.setChanged(true, 164);
    }

    public void setDataView(List list) {
        this.dataViews = new Vector();
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Chart3dDataView chart3dDataView = (Chart3dDataView)iterator.next();
            if (chart3dDataView != null) {
                chart3dDataView.setChart3d(this);
            }
            this.dataViews.add(chart3dDataView);
        }
        this.setChanged(true, 164);
    }

    public void setFillColorIndex(int n2) {
        this.fillColorIndex = n2;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setChanged(true, 162);
    }

    public void setFooter(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        if (this.footer != null) {
            this.remove(this.footer);
        }
        this.footer = jComponent;
        this.add(this.footer);
        this.setChanged(true, 164);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.setChanged(true, 162);
    }

    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
        this.getChart3dArea().setGraphics(graphics);
        this.getLegend().setGraphics(graphics);
    }

    public void setHeader(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        if (this.header != null) {
            this.remove(this.header);
        }
        this.header = jComponent;
        this.add(this.header);
        this.setChanged(true, 164);
    }

    public void setLayout(LayoutManager layoutManager) {
        boolean bl = true;
        if (bl) {
            super.setLayout(layoutManager);
        }
    }

    public void setLayoutHints(JComponent jComponent, Rectangle rectangle) {
        if (jComponent == null) {
            return;
        }
        if (jComponent == this.chart3dArea) {
            this.chart3dAreaLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (jComponent == this.legend) {
            this.legendLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (jComponent == this.header) {
            this.headerLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (jComponent == this.footer) {
            this.footerLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        jComponent.invalidate();
        this.validate();
    }

    public void setLegend(JCLegend jCLegend) {
        if (jCLegend == null) {
            return;
        }
        if (this.legend != null) {
            this.remove(this.legend);
        }
        this.legend = jCLegend;
        if (this.legend.getLegendPopulator() == null) {
            this.legend.setLegendPopulator(this.legendManager);
        }
        if (this.legend.getLegendRenderer() == null) {
            this.legend.setLegendRenderer(this.legendManager);
        }
        this.add(this.legend);
        this.setChanged(true, 164);
    }

    public void setLineColorIndex(int n2) {
        this.lineColorIndex = n2;
    }

    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        this.setChanged(true, 1);
    }

    public void setSymbolColorIndex(int n2) {
        this.symbolColorIndex = n2;
    }

    public void setSymbolShapeIndex(int n2) {
        this.symbolShapeIndex = n2;
    }

    public void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
    }

    public void setWarningDialog(boolean bl) {
        if (this.warningOn == bl) {
            return;
        }
        this.warningOn = bl;
    }

    public Image snapshot() {
        return this.snapshot(2);
    }

    public Image snapshot(int n2) {
        Image image;
        try {
            image = new BufferedImage(this.getSize().width, this.getSize().height, n2);
        }
        catch (Exception exception) {
            image = this.createImage(this.getSize().width, this.getSize().height);
        }
        this.snapshot(image);
        return image;
    }

    public void snapshot(Image image) {
        if (image != null) {
            Graphics graphics = image.getGraphics();
            graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
            this.paint(graphics);
        }
    }

    public Point unpick(Chart3dDataView chart3dDataView, JCData3dIndex jCData3dIndex) {
        if (jCData3dIndex == null) {
            return null;
        }
        if (chart3dDataView == null) {
            chart3dDataView = this.getDataView(0);
        }
        chart3dDataView.createDraw();
        Point point = chart3dDataView.getDraw().getMapping().unpick(jCData3dIndex);
        if (point != null) {
            Point point2 = this.chart3dArea.getLocation();
            point.x += point2.x;
            point.y += point2.y;
            Rectangle rectangle = this.chart3dArea.getDrawingArea();
            point.x += rectangle.x;
            point.y += rectangle.y;
        }
        return point;
    }

    public void update() {
        this.invalidate();
        if (!this.isShowing()) {
            return;
        }
        this.validate();
    }

    public void updateUI() {
        this.setUI((JCChart3dUI)UIManager.getUI(this));
    }
}

