/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dAnnoHandler;
import com.klg.jclass.chart3d.DerivedDouble;
import com.klg.jclass.chart3d.JCGridLines;
import com.klg.jclass.chart3d.JCLabelGenerator;
import com.klg.jclass.chart3d.JCValueLabel;
import com.klg.jclass.chart3d.ParentFormatter;
import java.awt.Font;
import java.util.ArrayList;

public class JCAxis
extends ParentFormatter {
    static final long serialVersionUID = -5542417106751358122L;
    public static final int MAX_AXIS_FONT_CUBE_SIZE = 1000;
    public static final int AXIS_NONE = 0;
    public static final int AXIS_X = 1;
    public static final int AXIS_Y = 2;
    public static final int AXIS_Z = 3;
    public static final int AXIS_EYE = 4;
    public static final int NUM_AXES = 3;
    public static final int ANNOTATION_VALUES = 1;
    public static final int ANNOTATION_DATA_LABELS = 2;
    public static final int ANNOTATION_VALUE_LABELS = 3;
    protected boolean showing = true;
    protected int annotationMethod = 1;
    protected double origin = 0.0;
    protected String title = null;
    protected DerivedDouble min = new DerivedDouble(Double.MAX_VALUE, true);
    protected DerivedDouble max = new DerivedDouble(Double.MAX_VALUE, true);
    protected JCGridLines gridLines = null;
    protected Font annoFont = null;
    protected int annoFontCubeSize = 80;
    protected Font titleFont = null;
    protected int titleFontCubeSize = 80;
    protected double annoMin = Double.MAX_VALUE;
    protected double annoMax = Double.MAX_VALUE;
    protected double annoStep = Double.MAX_VALUE;
    protected double annoEaseway = 0.0;
    protected int maxAnnoLength = 0;
    protected double dataportMin = Double.MAX_VALUE;
    protected double dataportMax = Double.MAX_VALUE;
    protected Chart3dAnnoHandler annoHandler = new Chart3dAnnoHandler(this);
    protected JCLabelGenerator labelGenerator = null;
    protected int axisId = -1;

    public JCAxis() {
    }

    public JCAxis(int n2, Font font) {
        this.axisId = n2;
        this.annoFont = font;
        this.titleFont = font;
    }

    public void addValueLabel(JCValueLabel jCValueLabel) {
        int n2 = -1;
        int n3 = -1;
        ArrayList arrayList = this.annoHandler.getUserValueLabels();
        int n4 = 0;
        while (n4 < arrayList.size()) {
            JCValueLabel jCValueLabel2 = (JCValueLabel)arrayList.get(n4);
            if (jCValueLabel2.value > jCValueLabel.value && n3 < 0) {
                n3 = n4;
                break;
            }
            if (jCValueLabel2.value == jCValueLabel.value) {
                n2 = n4;
                break;
            }
            ++n4;
        }
        if (n2 >= 0) {
            arrayList.set(n2, jCValueLabel);
        } else if (n3 >= 0) {
            arrayList.add(n3, jCValueLabel);
        } else {
            arrayList.add(jCValueLabel);
        }
        this.annoHandler.sortValueLabels();
        this.callParentSetChanged(true, 2);
    }

    protected void calcMaxAnnoLength() {
        ArrayList arrayList = this.annoHandler.getValueLabels();
        this.maxAnnoLength = 0;
        int n2 = 0;
        while (n2 < arrayList.size()) {
            int n3;
            String string;
            JCValueLabel jCValueLabel = (JCValueLabel)arrayList.get(n2);
            double d2 = jCValueLabel.getValue();
            if (!(d2 < this.annoMin) && !(d2 > this.annoMax) && (string = jCValueLabel.getLabel()) != null && (n3 = string.length()) > this.maxAnnoLength) {
                this.maxAnnoLength = n3;
            }
            ++n2;
        }
    }

    protected void checkLimits(double d2, double d3) {
        if (this.max.value <= this.min.value && !this.max.isDefault) {
            this.max.isDefault = true;
            this.max.value = d3;
        }
        if (this.max.value <= this.min.value && !this.min.isDefault) {
            this.min.isDefault = true;
            this.min.value = d2;
        }
        if (this.max.value <= this.min.value) {
            double d4 = 0.0;
            while (d3 <= d2) {
                d3 = d2 + Math.pow(10.0, d4);
                d2 -= d3 - d2;
                d4 += 1.0;
            }
            this.min.value = d2;
            this.max.value = d3;
        }
    }

    public double getAnnoEaseway() {
        return this.annoEaseway;
    }

    public Font getAnnoFont() {
        return this.annoFont;
    }

    public int getAnnoFontCubeSize() {
        return this.annoFontCubeSize;
    }

    public Chart3dAnnoHandler getAnnoHandler() {
        return this.annoHandler;
    }

    public double getAnnoMax() {
        return this.annoMax;
    }

    public double getAnnoMin() {
        return this.annoMin;
    }

    public double getAnnoStep() {
        return this.annoStep;
    }

    public int getAnnotationMethod() {
        return this.annotationMethod;
    }

    public int getAxisId() {
        return this.axisId;
    }

    public double getDataportMax() {
        return this.dataportMax;
    }

    public double getDataportMin() {
        return this.dataportMin;
    }

    public JCValueLabel getGeneratedValueLabel(double d2) {
        JCValueLabel jCValueLabel = null;
        ArrayList arrayList = this.annoHandler.getValueLabels();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            JCValueLabel jCValueLabel2 = (JCValueLabel)arrayList.get(n2);
            if (d2 == jCValueLabel2.value) {
                jCValueLabel = jCValueLabel2;
                break;
            }
            ++n2;
        }
        return jCValueLabel;
    }

    public JCValueLabel[] getGeneratedValueLabels() {
        ArrayList arrayList = this.annoHandler.getValueLabels();
        JCValueLabel[] jCValueLabelArray = null;
        if (arrayList.size() == 0) {
            return jCValueLabelArray;
        }
        jCValueLabelArray = new JCValueLabel[arrayList.size()];
        int n2 = 0;
        while (n2 < jCValueLabelArray.length) {
            jCValueLabelArray[n2] = (JCValueLabel)arrayList.get(n2);
            ++n2;
        }
        return jCValueLabelArray;
    }

    public JCValueLabel getGeneratedValueLabels(int n2) {
        ArrayList arrayList = this.annoHandler.getValueLabels();
        if (arrayList.size() == 0) {
            return null;
        }
        JCValueLabel jCValueLabel = null;
        try {
            jCValueLabel = (JCValueLabel)arrayList.get(n2);
        }
        catch (Exception exception) {}
        return jCValueLabel;
    }

    public JCGridLines getGridLines() {
        return this.gridLines;
    }

    public JCLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public double getMax() {
        return this.max.value;
    }

    protected int getMaxAnnoLength() {
        return this.maxAnnoLength;
    }

    public boolean getMaxIsDefault() {
        return this.max.isDefault;
    }

    public double getMin() {
        return this.min.value;
    }

    public boolean getMinIsDefault() {
        return this.min.isDefault;
    }

    public double getOrigin() {
        return this.origin;
    }

    public String getTitle() {
        return this.title;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public int getTitleFontCubeSize() {
        return this.titleFontCubeSize;
    }

    public JCValueLabel getValueLabel(double d2) {
        JCValueLabel jCValueLabel = null;
        ArrayList arrayList = this.annoHandler.getUserValueLabels();
        int n2 = 0;
        while (n2 < arrayList.size()) {
            JCValueLabel jCValueLabel2 = (JCValueLabel)arrayList.get(n2);
            if (d2 == jCValueLabel2.value) {
                jCValueLabel = jCValueLabel2;
                break;
            }
            ++n2;
        }
        return jCValueLabel;
    }

    public JCValueLabel[] getValueLabels() {
        ArrayList arrayList = this.annoHandler.getUserValueLabels();
        JCValueLabel[] jCValueLabelArray = null;
        if (arrayList.size() == 0) {
            return jCValueLabelArray;
        }
        jCValueLabelArray = new JCValueLabel[arrayList.size()];
        int n2 = 0;
        while (n2 < jCValueLabelArray.length) {
            jCValueLabelArray[n2] = (JCValueLabel)arrayList.get(n2);
            ++n2;
        }
        return jCValueLabelArray;
    }

    public JCValueLabel getValueLabels(int n2) {
        ArrayList arrayList = this.annoHandler.getUserValueLabels();
        if (arrayList.size() == 0) {
            return null;
        }
        JCValueLabel jCValueLabel = null;
        try {
            jCValueLabel = (JCValueLabel)arrayList.get(n2);
        }
        catch (Exception exception) {}
        return jCValueLabel;
    }

    public boolean isShowing() {
        return this.showing;
    }

    protected void setAnnoEaseway(double d2) {
        this.annoEaseway = d2;
    }

    public void setAnnoFont(Font font) {
        if (this.annoFont == font) {
            return;
        }
        this.annoFont = font;
        this.callParentSetChanged(true, 1);
    }

    public void setAnnoFontCubeSize(int n2) {
        if (this.annoFontCubeSize == n2) {
            return;
        }
        if (n2 < 0 || n2 > 1000) {
            throw new IllegalArgumentException("Invalid value. Must be between 0 and 1000.");
        }
        this.annoFontCubeSize = n2;
        this.callParentSetChanged(true, 2);
    }

    protected void setAnnoMax(double d2) {
        this.annoMax = d2;
    }

    protected void setAnnoMin(double d2) {
        this.annoMin = d2;
    }

    protected void setAnnoStep(double d2) {
        this.annoStep = d2;
    }

    public void setAnnotationMethod(int n2) {
        if (this.annotationMethod == n2) {
            return;
        }
        if (n2 < 1 || n2 > 3) {
            throw new IllegalArgumentException("Invalid value. ");
        }
        this.annotationMethod = n2;
        this.callParentSetChanged(true, 2);
    }

    protected void setDataportMax(double d2) {
        this.dataportMax = d2;
    }

    protected void setDataportMin(double d2) {
        this.dataportMin = d2;
    }

    protected void setExtents(double d2, double d3) {
        this.min.setValue(d2);
        this.max.setValue(d3);
        this.checkLimits(d2, d3);
    }

    public void setGridLines(JCGridLines jCGridLines) {
        if (this.gridLines == jCGridLines) {
            return;
        }
        this.gridLines = jCGridLines;
        if (this.gridLines == null) {
            throw new IllegalArgumentException("Invalid value. Cannot be null.");
        }
        this.gridLines.setAxis(this);
    }

    public void setLabelGenerator(JCLabelGenerator jCLabelGenerator) {
        if (this.labelGenerator == jCLabelGenerator) {
            return;
        }
        this.labelGenerator = jCLabelGenerator;
        this.callParentSetChanged(true, 2);
    }

    public void setMax(double d2) {
        if (!this.max.isDefault && this.max.value == d2) {
            return;
        }
        this.max.value = d2;
        this.max.isDefault = false;
        this.callParentSetChanged(true, 290);
    }

    public void setMaxIsDefault(boolean bl) {
        if (this.max.isDefault == bl) {
            return;
        }
        this.max.isDefault = bl;
        this.callParentSetChanged(true, 290);
    }

    public void setMin(double d2) {
        if (!this.min.isDefault && this.min.value == d2) {
            return;
        }
        this.min.value = d2;
        this.min.isDefault = false;
        this.callParentSetChanged(true, 290);
    }

    public void setMinIsDefault(boolean bl) {
        if (this.min.isDefault == bl) {
            return;
        }
        this.min.isDefault = bl;
        this.callParentSetChanged(true, 290);
    }

    public void setOrigin(double d2) {
        if (this.origin == d2) {
            return;
        }
        this.origin = d2;
        this.callParentSetChanged(true, 2);
    }

    public void setShowing(boolean bl) {
        if (this.showing == bl) {
            return;
        }
        this.showing = bl;
        this.callParentSetChanged(true, 2);
    }

    public void setTitle(String string) {
        if (this.title == string) {
            return;
        }
        this.title = string;
        this.callParentSetChanged(true, 2);
    }

    public void setTitleFont(Font font) {
        if (this.titleFont == font) {
            return;
        }
        this.titleFont = font;
        this.callParentSetChanged(true, 1);
    }

    public void setTitleFontCubeSize(int n2) {
        if (this.titleFontCubeSize == n2) {
            return;
        }
        if (n2 < 0 || n2 > 1000) {
            throw new IllegalArgumentException("Invalid value. Must be between 0 and 1000.");
        }
        this.titleFontCubeSize = n2;
        this.callParentSetChanged(true, 2);
    }

    public void setValueLabels(int n2, JCValueLabel jCValueLabel) {
        ArrayList arrayList = this.annoHandler.getUserValueLabels();
        if (n2 < 0 || n2 > arrayList.size()) {
            throw new IllegalArgumentException("Bad data or index");
        }
        if (n2 < arrayList.size()) {
            arrayList.set(n2, jCValueLabel);
        } else {
            arrayList.add(jCValueLabel);
        }
        this.annoHandler.sortValueLabels();
        this.callParentSetChanged(true, 2);
    }

    public void setValueLabels(JCValueLabel[] jCValueLabelArray) {
        ArrayList<JCValueLabel> arrayList = new ArrayList<JCValueLabel>();
        if (jCValueLabelArray != null) {
            int n2 = 0;
            while (n2 < jCValueLabelArray.length) {
                arrayList.add(jCValueLabelArray[n2]);
                ++n2;
            }
        }
        this.annoHandler.setUserValueLabels(arrayList);
        this.callParentSetChanged(true, 2);
    }
}

