/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.ActionInitiator;
import com.klg.jclass.chart3d.JCAction;
import com.klg.jclass.chart3d.KeyActionInitiator;
import com.klg.jclass.chart3d.MouseActionInitiator;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.Set;
import java.util.TreeMap;

public abstract class JCActionTable
implements Serializable {
    protected TreeMap mouseActions = new TreeMap();
    protected TreeMap keyActions = new TreeMap();
    protected TreeMap handlerInstances = new TreeMap();
    public static final MouseActionInitiator DEFAULT_MOUSE_CUSTOMIZE_ACTION = new MouseActionInitiator(4, 0);
    public static final KeyActionInitiator DEFAULT_KEY_CUSTOMIZE_ACTION = new KeyActionInitiator(10, 8);
    public static final MouseActionInitiator DEFAULT_MOUSE_EDIT_ACTION = new MouseActionInitiator(16, 0);
    public static final MouseActionInitiator DEFAULT_MOUSE_PICK_ACTION = new MouseActionInitiator(16, 0);
    public static final MouseActionInitiator DEFAULT_MOUSE_ROTATE_ANY_ACTION = new MouseActionInitiator(16, 2);
    public static final MouseActionInitiator DEFAULT_MOUSE_ROTATE_EYE_ACTION = new MouseActionInitiator(16, 2);
    public static final MouseActionInitiator DEFAULT_MOUSE_ROTATE_X_ACTION = new MouseActionInitiator(16, 2);
    public static final MouseActionInitiator DEFAULT_MOUSE_ROTATE_Y_ACTION = new MouseActionInitiator(16, 2);
    public static final MouseActionInitiator DEFAULT_MOUSE_ROTATE_Z_ACTION = new MouseActionInitiator(16, 2);
    public static final KeyActionInitiator DEFAULT_KEY_SWITCH_ROTATE_ANY_ACTION = new KeyActionInitiator(78, 0);
    public static final KeyActionInitiator DEFAULT_KEY_SWITCH_ROTATE_EYE_ACTION = new KeyActionInitiator(69, 0);
    public static final KeyActionInitiator DEFAULT_KEY_SWITCH_ROTATE_X_ACTION = new KeyActionInitiator(88, 0);
    public static final KeyActionInitiator DEFAULT_KEY_SWITCH_ROTATE_Y_ACTION = new KeyActionInitiator(89, 0);
    public static final KeyActionInitiator DEFAULT_KEY_SWITCH_ROTATE_Z_ACTION = new KeyActionInitiator(90, 0);
    public static final KeyActionInitiator DEFAULT_KEY_SPIN_CCW_ACTION = new KeyActionInitiator(37, 0);
    public static final KeyActionInitiator DEFAULT_KEY_SPIN_CW_ACTION = new KeyActionInitiator(39, 0);
    public static final KeyActionInitiator DEFAULT_KEY_TILT_CCW_ACTION = new KeyActionInitiator(38, 0);
    public static final KeyActionInitiator DEFAULT_KEY_TILT_CW_ACTION = new KeyActionInitiator(40, 0);
    public static final MouseActionInitiator DEFAULT_MOUSE_SCALE_ACTION = new MouseActionInitiator(16, 8);
    public static final KeyActionInitiator DEFAULT_KEY_SCALE_UP_ACTION = new KeyActionInitiator(33, 0);
    public static final KeyActionInitiator DEFAULT_KEY_SCALE_DOWN_ACTION = new KeyActionInitiator(34, 0);
    public static final MouseActionInitiator DEFAULT_MOUSE_TRANSLATE_ACTION = new MouseActionInitiator(16, 1);
    public static final KeyActionInitiator DEFAULT_KEY_TRANSLATE_LEFT_ACTION = new KeyActionInitiator(37, 1);
    public static final KeyActionInitiator DEFAULT_KEY_TRANSLATE_RIGHT_ACTION = new KeyActionInitiator(39, 1);
    public static final KeyActionInitiator DEFAULT_KEY_TRANSLATE_UP_ACTION = new KeyActionInitiator(38, 1);
    public static final KeyActionInitiator DEFAULT_KEY_TRANSLATE_DOWN_ACTION = new KeyActionInitiator(40, 1);
    public static final MouseActionInitiator DEFAULT_MOUSE_ZOOM_ACTION = new MouseActionInitiator(16, 3);
    public static final KeyActionInitiator DEFAULT_KEY_RESET_ACTION = new KeyActionInitiator(82, -1);
    public static final KeyActionInitiator DEFAULT_KEY_CANCEL_ACTION = new KeyActionInitiator(67, -1);

    public void addAction(ActionInitiator actionInitiator, String string) {
        if (actionInitiator instanceof MouseActionInitiator) {
            this.mouseActions.put(actionInitiator, string);
        } else if (actionInitiator instanceof KeyActionInitiator) {
            this.keyActions.put(actionInitiator, string);
        }
    }

    public void addAllDefaultActions() {
        this.addAllDefaultKeyActions();
        this.addAllDefaultMouseActions();
    }

    public void addAllDefaultKeyActions() {
        this.addAction(DEFAULT_KEY_CANCEL_ACTION, this.getDefaultCancelActionClass());
        this.addAction(DEFAULT_KEY_CUSTOMIZE_ACTION, this.getDefaultCustomizeActionClass());
        this.addAction(DEFAULT_KEY_RESET_ACTION, this.getDefaultResetActionClass());
        this.addAction(DEFAULT_KEY_SPIN_CCW_ACTION, this.getDefaultRotateActionClass());
        this.addAction(DEFAULT_KEY_SPIN_CW_ACTION, this.getDefaultRotateActionClass());
        this.addAction(DEFAULT_KEY_TILT_CCW_ACTION, this.getDefaultRotateActionClass());
        this.addAction(DEFAULT_KEY_TILT_CW_ACTION, this.getDefaultRotateActionClass());
        this.addAction(DEFAULT_KEY_SCALE_UP_ACTION, this.getDefaultScaleActionClass());
        this.addAction(DEFAULT_KEY_SCALE_DOWN_ACTION, this.getDefaultScaleActionClass());
        this.addAction(DEFAULT_KEY_TRANSLATE_LEFT_ACTION, this.getDefaultTranslateActionClass());
        this.addAction(DEFAULT_KEY_TRANSLATE_RIGHT_ACTION, this.getDefaultTranslateActionClass());
        this.addAction(DEFAULT_KEY_TRANSLATE_UP_ACTION, this.getDefaultTranslateActionClass());
        this.addAction(DEFAULT_KEY_TRANSLATE_DOWN_ACTION, this.getDefaultTranslateActionClass());
        this.addAction(DEFAULT_KEY_SWITCH_ROTATE_ANY_ACTION, this.getDefaultSwitchRotateAnyActionClass());
        this.addAction(DEFAULT_KEY_SWITCH_ROTATE_EYE_ACTION, this.getDefaultSwitchRotateEyeActionClass());
        this.addAction(DEFAULT_KEY_SWITCH_ROTATE_X_ACTION, this.getDefaultSwitchRotateXActionClass());
        this.addAction(DEFAULT_KEY_SWITCH_ROTATE_Y_ACTION, this.getDefaultSwitchRotateYActionClass());
        this.addAction(DEFAULT_KEY_SWITCH_ROTATE_Z_ACTION, this.getDefaultSwitchRotateZActionClass());
    }

    public void addAllDefaultMouseActions() {
        this.addAction(DEFAULT_MOUSE_CUSTOMIZE_ACTION, this.getDefaultCustomizeActionClass());
        this.addAction(DEFAULT_MOUSE_PICK_ACTION, this.getDefaultPickActionClass());
        this.addAction(DEFAULT_MOUSE_ROTATE_ANY_ACTION, this.getDefaultRotateActionClass());
        this.addAction(DEFAULT_MOUSE_SCALE_ACTION, this.getDefaultScaleActionClass());
        this.addAction(DEFAULT_MOUSE_TRANSLATE_ACTION, this.getDefaultTranslateActionClass());
        this.addAction(DEFAULT_MOUSE_ZOOM_ACTION, this.getDefaultZoomActionClass());
    }

    public String getAction(InputEvent inputEvent) {
        MouseEvent mouseEvent;
        MouseActionInitiator mouseActionInitiator;
        Object var2_2 = null;
        if (inputEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)inputEvent;
            KeyActionInitiator keyActionInitiator = new KeyActionInitiator(keyEvent.getKeyCode(), keyEvent.getModifiers());
            var2_2 = this.keyActions.get(keyActionInitiator);
            if (var2_2 == null) {
                keyActionInitiator.modifiers = 0;
                var2_2 = this.keyActions.get(keyActionInitiator);
                if (var2_2 == null) {
                    keyActionInitiator.modifiers = -1;
                    var2_2 = this.keyActions.get(keyActionInitiator);
                }
            }
        } else if (inputEvent instanceof MouseEvent && (var2_2 = this.mouseActions.get(mouseActionInitiator = new MouseActionInitiator(this.getMouseButtonMask((mouseEvent = (MouseEvent)inputEvent).getModifiers()), mouseEvent.getModifiers() & 0xB))) == null) {
            mouseActionInitiator.modifiers = 0;
            var2_2 = this.mouseActions.get(mouseActionInitiator);
            if (var2_2 == null) {
                mouseActionInitiator.modifiers = -1;
                var2_2 = this.mouseActions.get(mouseActionInitiator);
            }
        }
        return var2_2;
    }

    public abstract JCAction getActionHandlerInstance(InputEvent var1, Object var2);

    public Set getAllKeyActions() {
        return this.keyActions.keySet();
    }

    public Set getAllMouseActions() {
        return this.mouseActions.keySet();
    }

    public abstract String getDefaultCancelActionClass();

    public abstract String getDefaultCustomizeActionClass();

    public abstract String getDefaultEditActionClass();

    public abstract String getDefaultPickActionClass();

    public abstract String getDefaultResetActionClass();

    public abstract String getDefaultRotateActionClass();

    public abstract String getDefaultRotateEyeActionClass();

    public abstract String getDefaultRotateXActionClass();

    public abstract String getDefaultRotateYActionClass();

    public abstract String getDefaultRotateZActionClass();

    public abstract String getDefaultScaleActionClass();

    public abstract String getDefaultSwitchRotateAnyActionClass();

    public abstract String getDefaultSwitchRotateEyeActionClass();

    public abstract String getDefaultSwitchRotateXActionClass();

    public abstract String getDefaultSwitchRotateYActionClass();

    public abstract String getDefaultSwitchRotateZActionClass();

    public abstract String getDefaultTranslateActionClass();

    public abstract String getDefaultZoomActionClass();

    private int getMouseButtonMask(int n2) {
        if ((n2 & 0x10) == 16) {
            return 16;
        }
        if ((n2 & 8) == 8) {
            return 8;
        }
        if ((n2 & 4) == 4) {
            return 4;
        }
        return 0;
    }

    public void removeAction(ActionInitiator actionInitiator) {
        if (actionInitiator instanceof KeyActionInitiator) {
            this.removeKeyAction((KeyActionInitiator)actionInitiator);
        } else if (actionInitiator instanceof MouseActionInitiator) {
            this.removeMouseAction((MouseActionInitiator)actionInitiator);
        }
    }

    public void removeAllActions() {
        this.removeAllKeyActions();
        this.removeAllMouseActions();
    }

    public void removeAllKeyActions() {
        this.keyActions.clear();
    }

    public void removeAllMouseActions() {
        this.mouseActions.clear();
    }

    public void removeKeyAction(KeyActionInitiator keyActionInitiator) {
        this.keyActions.remove(keyActionInitiator);
    }

    public void removeMouseAction(MouseActionInitiator mouseActionInitiator) {
        this.mouseActions.remove(mouseActionInitiator);
    }
}

