/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.DrawGrid;
import com.klg.jclass.chart3d.Facet;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.chart3d.Transform;
import javax.vecmath.Point4d;

public abstract class FacetAbstract
implements Facet {
    protected int[] xPoints = null;
    protected int[] yPoints = null;
    protected DrawGrid drawGrid = null;
    protected Chart3dGridData data = null;

    FacetAbstract() {
    }

    FacetAbstract(DrawGrid drawGrid) {
        this.drawGrid = drawGrid;
        if (drawGrid != null) {
            this.data = drawGrid.getGridData();
        }
    }

    protected void fillPointArrays(ScreenPoint[] screenPointArray, int n2) {
        if (this.xPoints == null || this.xPoints.length < n2) {
            this.xPoints = new int[n2];
            this.yPoints = new int[n2];
        }
        int n3 = 0;
        while (n3 < n2) {
            this.xPoints[n3] = screenPointArray[n3].getXPixel();
            this.yPoints[n3] = screenPointArray[n3].getYPixel();
            ++n3;
        }
    }

    protected DrawGrid getDrawGrid() {
        return this.drawGrid;
    }

    protected ScreenPoint getScreenPoint(double d2, double d3, double d4) {
        JCChart3dArea jCChart3dArea = this.data.getDataView().getChart3d().getChart3dArea();
        Transform transform = jCChart3dArea.getTransform();
        Point4d point4d = new Point4d(d2, d3, d4, 1.0);
        Transform.transformPoint(transform.getView(), point4d);
        ScreenPoint screenPoint = new ScreenPoint((int)Math.round(point4d.x), (int)Math.round(point4d.y));
        return screenPoint;
    }

    public abstract void processFacet(int var1, int var2, int var3);

    protected void setDrawGrid(DrawGrid drawGrid) {
        this.drawGrid = drawGrid;
        this.data = null;
        if (drawGrid != null) {
            this.data = drawGrid.getGridData();
        }
    }
}

