/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.Chart3dPointSeries;
import com.klg.jclass.chart3d.Draw;
import com.klg.jclass.chart3d.JCChart3dStyle;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.chart3d.SortPoint;
import com.klg.jclass.util.JCDebug;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.ArrayList;
import javax.vecmath.Point3d;

public class DrawPoint
extends Draw
implements Serializable {
    public DrawPoint() {
    }

    public DrawPoint(Chart3dDataView chart3dDataView) {
        super(chart3dDataView);
    }

    protected void draw(Graphics graphics) {
        Chart3dPointData chart3dPointData = this.getPointData();
        ScreenPoint[][] screenPointArray = chart3dPointData.getScreenPoints();
        if (!chart3dPointData.isDataOK()) {
            return;
        }
        chart3dPointData.sortPoints();
        ArrayList arrayList = chart3dPointData.getSortPoints();
        if (arrayList == null) {
            JCDebug.println("drawPoint", "draw: sortPoints are null!");
            return;
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            SortPoint sortPoint = (SortPoint)arrayList.get(n2);
            int n3 = sortPoint.getSeries();
            int n4 = sortPoint.getPoint();
            Chart3dPointSeries chart3dPointSeries = chart3dPointData.getSeries(n3);
            JCChart3dStyle jCChart3dStyle = chart3dPointSeries.getChartStyle();
            Point3d point3d = chart3dPointSeries.getPoint(n4);
            ScreenPoint screenPoint = screenPointArray[n3][n4];
            if (!(screenPoint.isDrawn() || screenPoint.isHoleValue() || screenPoint.isHidden())) {
                this.renderPoint(graphics, jCChart3dStyle.getSymbolStyle(), jCChart3dStyle.getLineStyle(), screenPoint, point3d.x, point3d.y);
            }
            ++n2;
        }
    }

    protected void draw2dPoints(Graphics graphics) {
        Chart3dPointData chart3dPointData = this.getPointData();
        ScreenPoint[][] screenPointArray = chart3dPointData.getScreenPoints();
        if (!chart3dPointData.isDataOK()) {
            return;
        }
        int n2 = 0;
        while (n2 < chart3dPointData.getNumSeries()) {
            Chart3dPointSeries chart3dPointSeries = chart3dPointData.getSeries(n2);
            JCChart3dStyle jCChart3dStyle = chart3dPointSeries.getChartStyle();
            int n3 = 0;
            while (n3 < chart3dPointSeries.getNumPoints()) {
                Point3d point3d = chart3dPointSeries.getPoint(n3);
                ScreenPoint screenPoint = screenPointArray[n2][n3];
                if (!(screenPoint.isDrawn() || screenPoint.isHoleValue() || screenPoint.isHidden())) {
                    this.renderPoint(graphics, jCChart3dStyle.getSymbolStyle(), jCChart3dStyle.getLineStyle(), screenPoint, point3d.x, point3d.y);
                }
                ++n3;
            }
            ++n2;
        }
    }

    protected Chart3dPointData getPointData() {
        if (this.dataView != null) {
            return (Chart3dPointData)this.dataView.getElevationData();
        }
        return null;
    }
}

