/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.BarFacet;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Draw;
import com.klg.jclass.chart3d.DrawFacetFactory;
import com.klg.jclass.chart3d.FacetAbstract;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.GridRegion;
import com.klg.jclass.chart3d.JCBar;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dStyle;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCContour;
import com.klg.jclass.chart3d.JCContourLevels;
import com.klg.jclass.chart3d.JCContourStyle;
import com.klg.jclass.chart3d.JCData3dGridIndex;
import com.klg.jclass.chart3d.JCElevation;
import com.klg.jclass.chart3d.JCLineStyle;
import com.klg.jclass.chart3d.JCSurface;
import com.klg.jclass.chart3d.JCSymbolStyle;
import com.klg.jclass.chart3d.ProcessGrid;
import com.klg.jclass.chart3d.ScatterFacet;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.chart3d.SurfaceFacet;
import com.klg.jclass.chart3d.Transform;
import java.awt.Graphics;
import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;

public class DrawGrid
extends Draw
implements Serializable {
    public static final double AB_EPSILON = 1.0E-12;
    protected GridRegion gridRegion = new GridRegion(this);
    protected ProcessGrid processGrid = new ProcessGrid(this);
    protected DrawFacetFactory drawFacetFactory = null;
    protected Vector3d N = null;
    protected Vector3d V0V1 = null;
    protected Vector3d V0V2 = null;
    protected Vector3d V0 = null;
    protected Vector3d V1 = null;
    protected Vector3d V2 = null;

    public DrawGrid() {
    }

    public DrawGrid(Chart3dDataView chart3dDataView) {
        super(chart3dDataView);
    }

    protected double cubeSpace(Matrix4d matrix4d, Chart3dGridData chart3dGridData, int n2, boolean bl) {
        double d2 = Double.MAX_VALUE;
        d2 = bl ? matrix4d.m00 * chart3dGridData.getX(n2) + matrix4d.m03 : matrix4d.m11 * chart3dGridData.getY(n2) + matrix4d.m13;
        return d2;
    }

    protected void draw(Graphics graphics) {
        int n2 = this.dataView.getChartType();
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        JCElevation jCElevation = this.dataView.getElevation();
        JCSurface jCSurface = jCChart3dArea.getSurface();
        JCBar jCBar = jCChart3dArea.getBar();
        Chart3dGridData chart3dGridData = this.getGridData();
        int n3 = chart3dGridData.getNumX();
        int n4 = chart3dGridData.getNumY();
        if (n2 == 0 ? n3 < 2 || n4 < 2 : (n2 == 1 ? jCBar.getXFormat() == 2 && n3 < 2 || jCBar.getYFormat() == 2 && n4 < 2 : n3 < 1 || n4 < 1)) {
            return;
        }
        if (n2 == 0) {
            int n5 = this.dataView.getDrawCode();
            if ((n5 & 0xFFFFFFFB) == 1 && !jCSurface.isXMeshShowing() && !jCSurface.isYMeshShowing()) {
                return;
            }
            if (n5 == 1 && !jCSurface.isSolid() && jCElevation.isTransparent() && jCElevation.getMeshTopColor().equals(jCElevation.getMeshBottomColor())) {
                this.processGrid.drawFastMesh(graphics);
                return;
            }
        }
        FacetAbstract facetAbstract = null;
        switch (this.dataView.getChartType()) {
            case 0: {
                if (this.drawFacetFactory == null) {
                    this.drawFacetFactory = new DrawFacetFactory();
                }
                facetAbstract = new SurfaceFacet(this, this.drawFacetFactory.createDrawFacet(this, graphics));
                break;
            }
            case 1: {
                facetAbstract = new BarFacet(this, graphics);
                this.drawFacetFactory = null;
                break;
            }
            case 2: {
                facetAbstract = new ScatterFacet(this, graphics);
                this.drawFacetFactory = null;
                break;
            }
            default: {
                return;
            }
        }
        this.processGrid.setFacet(facetAbstract);
        this.processGrid.processGridRegion(this.gridRegion);
        if (this.dataView.getChartType() == 0 && jCChart3dArea.getSurface().isSolid()) {
            SurfaceFacet surfaceFacet = (SurfaceFacet)facetAbstract;
            surfaceFacet.drawSolid(this.gridRegion);
        }
    }

    protected void draw2dPoints(Graphics graphics) {
        Chart3dGridData chart3dGridData = this.getGridData();
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        ScreenPoint[][] screenPointArray = chart3dGridData.getScreenPoints();
        Chart3dDataView chart3dDataView = chart3dGridData.getDataView();
        Chart3dGridData chart3dGridData2 = chart3dDataView.getZoneData();
        JCContour jCContour = chart3dDataView.getContour();
        JCContourLevels jCContourLevels = jCContour.getContourLevels();
        JCContourStyle jCContourStyle = null;
        JCLineStyle jCLineStyle = null;
        JCSymbolStyle jCSymbolStyle = null;
        if (!chart3dGridData.isDataOK()) {
            return;
        }
        JCChart3dStyle jCChart3dStyle = chart3dGridData.getChartStyle();
        int n2 = gridLimits.getXOffset();
        while (n2 <= gridLimits.getXLast()) {
            int n3 = gridLimits.getYOffset();
            while (n3 <= gridLimits.getYLast()) {
                block5: {
                    ScreenPoint screenPoint;
                    block7: {
                        block6: {
                            int n4;
                            screenPoint = screenPointArray[n2][n3];
                            if (screenPoint.isDrawn() || screenPoint.isHoleValue()) break block5;
                            if (!jCContour.isContoured() && !jCContour.isZoned()) break block6;
                            double d2 = chart3dGridData.getZValue(n2, n3);
                            if (chart3dGridData2.isDataOK()) {
                                d2 = chart3dGridData2.getZValue(n2, n3);
                            }
                            if ((jCContourStyle = jCContour.getContourStyleFromLevel(n4 = jCContourLevels.getLevelFromValue(d2))) == null) break block5;
                            jCSymbolStyle = jCContourStyle.getSymbolStyle();
                            jCLineStyle = jCContourStyle.getLineStyle();
                            break block7;
                        }
                        if (jCChart3dStyle == null) {
                            return;
                        }
                        jCSymbolStyle = jCChart3dStyle.getSymbolStyle();
                        jCLineStyle = jCChart3dStyle.getLineStyle();
                    }
                    this.renderPoint(graphics, jCSymbolStyle, jCLineStyle, screenPoint, chart3dGridData.getX(n2), chart3dGridData.getY(n3));
                }
                ++n3;
            }
            ++n2;
        }
    }

    public Point4d findAbsolutePoint(Chart3dGridData chart3dGridData, Matrix4d matrix4d, int n2, int n3) {
        Point4d point4d = new Point4d();
        point4d.x = this.cubeSpace(matrix4d, chart3dGridData, n2, true);
        point4d.y = this.cubeSpace(matrix4d, chart3dGridData, n3, false);
        point4d.z = chart3dGridData.getZValue(n2, n3) * matrix4d.m22 + matrix4d.m23;
        point4d.w = 1.0;
        return point4d;
    }

    protected Chart3dGridData getGridData() {
        if (this.dataView != null) {
            return (Chart3dGridData)this.dataView.getElevationData();
        }
        return null;
    }

    protected GridRegion getGridRegion() {
        return this.gridRegion;
    }

    protected ProcessGrid getProcessGrid() {
        return this.processGrid;
    }

    public boolean gridSurfaceIntersect(Point4d point4d, Point4d point4d2, Point4d point4d3, JCData3dGridIndex jCData3dGridIndex) {
        Chart3dGridData chart3dGridData = this.getGridData();
        Chart3dDataView chart3dDataView = chart3dGridData.getDataView();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        JCBar jCBar = jCChart3dArea.getBar();
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        Matrix4d matrix4d = jCChart3dArea.getTransform().getAbsolute();
        Point3d point3d = new Point3d();
        Vector3d vector3d = new Vector3d();
        Point3d point3d2 = new Point3d();
        Point3d point3d3 = new Point3d();
        Point3d point3d4 = new Point3d();
        int n2 = gridLimits.getXOffset();
        int n3 = gridLimits.getYOffset();
        int n4 = gridLimits.getXLast();
        int n5 = gridLimits.getYLast();
        int n6 = 1;
        int n7 = 1;
        double d2 = 0.0;
        double d3 = 0.0;
        if (chart3dDataView.getChartType() == 1) {
            if (jCBar.getXFormat() == 1) {
                d2 = matrix4d.m00 * chart3dGridData.getMinXStep() / 2.0;
                n6 = 0;
            }
            if (jCBar.getYFormat() == 1) {
                d3 = matrix4d.m11 * chart3dGridData.getMinYStep() / 2.0;
                n7 = 0;
            }
        }
        point3d.project(point4d);
        vector3d.set(0.0, 0.0, 0.0);
        point3d2.set(point3d);
        point3d3.project(point4d2);
        Point3d point3d5 = new Point3d();
        Point3d point3d6 = new Point3d();
        Point3d point3d7 = new Point3d();
        Point3d point3d8 = new Point3d();
        boolean bl = true;
        int n8 = 0;
        int n9 = 0;
        do {
            point3d5.x = this.cubeSpace(matrix4d, chart3dGridData, n2, true);
            point3d6.x = this.cubeSpace(matrix4d, chart3dGridData, n4, true);
            point3d7.y = this.cubeSpace(matrix4d, chart3dGridData, n3, false);
            point3d8.y = this.cubeSpace(matrix4d, chart3dGridData, n5, false);
            if (n6 == 0) {
                if (n2 <= gridLimits.getXOffset()) {
                    point3d5.x -= d2;
                } else {
                    point3d5.x += this.cubeSpace(matrix4d, chart3dGridData, n2 - 1, true);
                    point3d5.x /= 2.0;
                }
                if (n4 >= gridLimits.getXLast()) {
                    point3d6.x += d2;
                } else {
                    point3d6.x += this.cubeSpace(matrix4d, chart3dGridData, n4 + 1, true);
                    point3d6.x /= 2.0;
                }
            }
            if (n7 == 0) {
                if (n3 <= gridLimits.getYOffset()) {
                    point3d7.y -= d3;
                } else {
                    point3d7.y += this.cubeSpace(matrix4d, chart3dGridData, n3 - 1, false);
                    point3d7.y /= 2.0;
                }
                if (n5 >= gridLimits.getYLast()) {
                    point3d8.y += d3;
                } else {
                    point3d8.y += this.cubeSpace(matrix4d, chart3dGridData, n5 + 1, false);
                    point3d8.y /= 2.0;
                }
            }
            double d4 = Double.MAX_VALUE;
            double d5 = 0.0;
            int n10 = 0;
            if (vector3d.x <= 0.0) {
                point3d7.x = point3d8.x = point3d5.x;
                d5 = this.lineIntersect2D(point3d2, point3d3, point3d7, point3d8);
                if (d4 > d5) {
                    d4 = d5;
                    n10 = 1;
                }
            }
            if (vector3d.x >= 0.0) {
                point3d7.x = point3d8.x = point3d6.x;
                d5 = this.lineIntersect2D(point3d2, point3d3, point3d7, point3d8);
                if (d4 > d5) {
                    d4 = d5;
                    n10 = 2;
                }
            }
            if (vector3d.y <= 0.0) {
                point3d5.y = point3d6.y = point3d7.y;
                d5 = this.lineIntersect2D(point3d2, point3d3, point3d5, point3d6);
                if (d4 > d5) {
                    d4 = d5;
                    n10 = 3;
                }
            }
            if (vector3d.y >= 0.0) {
                point3d5.y = point3d6.y = point3d8.y;
                d5 = this.lineIntersect2D(point3d2, point3d3, point3d5, point3d6);
                if (d4 > d5) {
                    d4 = d5;
                    n10 = 4;
                }
            }
            if (bl) {
                bl = false;
                vector3d.sub(point3d3, point3d2);
                if (!(n10 == 0 || point3d5.x < point3d2.x && point3d2.x < point3d6.x && point3d7.y < point3d2.y && point3d2.y < point3d8.y)) {
                    point3d2.x += d4 * vector3d.x;
                    point3d2.y += d4 * vector3d.y;
                }
                n2 = n8 = chart3dGridData.getGridIndex(point3d2.x, true, true);
                n3 = n9 = chart3dGridData.getGridIndex(point3d2.y, false, true);
            } else {
                switch (n10) {
                    case 1: {
                        --n8;
                        break;
                    }
                    case 2: {
                        ++n8;
                        break;
                    }
                    case 3: {
                        --n9;
                        break;
                    }
                    case 4: {
                        ++n9;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            if (this.testFacet(chart3dGridData, point3d, vector3d, n2, n3, point3d4, jCData3dGridIndex)) {
                point4d3.set(point3d4);
                point4d3.w = 1.0;
                jCData3dGridIndex.setX(n2);
                jCData3dGridIndex.setY(n3);
                return true;
            }
            n2 = n8;
            n3 = n9;
            n4 = n8 + n6;
            n5 = n9 + n7;
        } while (n2 >= gridLimits.getXOffset() && n4 <= gridLimits.getXLast() && n3 >= gridLimits.getYOffset() && n5 <= gridLimits.getYLast());
        return false;
    }

    protected double lineIntersect2D(Point3d point3d, Point3d point3d2, Point3d point3d3, Point3d point3d4) {
        double d2 = point3d2.y - point3d.y;
        double d3 = point3d3.x - point3d4.x;
        double d4 = point3d2.x - point3d.x;
        double d5 = point3d3.y - point3d4.y;
        double d6 = d2 * d3 - d4 * d5;
        if (1.0 + d6 == 1.0) {
            return Double.MAX_VALUE;
        }
        double d7 = point3d.y - point3d3.y;
        double d8 = point3d.x - point3d3.x;
        double d9 = (d4 * d7 - d2 * d8) / d6;
        if (d9 < -0.01 || d9 > 1.01) {
            return Double.MAX_VALUE;
        }
        d6 = (d5 * d8 - d3 * d7) / d6;
        return d6;
    }

    protected boolean rayIntersectTriangle(Point3d point3d, Vector3d vector3d, Point4d point4d, Point4d point4d2, Point4d point4d3, Point3d point3d2, JCData3dGridIndex jCData3dGridIndex) {
        boolean bl;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        if (this.N == null) {
            this.N = new Vector3d();
            this.V0V1 = new Vector3d();
            this.V0V2 = new Vector3d();
            this.V0 = new Vector3d();
            this.V1 = new Vector3d();
            this.V2 = new Vector3d();
        }
        this.V0.set(point4d.x, point4d.y, point4d.z);
        this.V1.set(point4d2.x, point4d2.y, point4d2.z);
        this.V2.set(point4d3.x, point4d3.y, point4d3.z);
        this.V0V1.sub(this.V1, this.V0);
        this.V0V2.sub(this.V2, this.V0);
        this.N.cross(this.V0V1, this.V0V2);
        double d8 = this.N.dot(vector3d);
        if (d8 == 0.0) {
            return false;
        }
        Vector3d vector3d2 = new Vector3d(point3d);
        double d9 = (this.N.dot(this.V0) - this.N.dot(vector3d2)) / d8;
        if (d9 <= 0.0) {
            return false;
        }
        point3d2.scaleAdd(d9, vector3d, point3d);
        this.N.absolute();
        if (this.N.z > this.N.x && this.N.z > this.N.y) {
            d7 = point3d2.y - this.V0.y;
            d6 = this.V1.y - this.V0.y;
            d5 = this.V2.y - this.V0.y;
            d4 = point3d2.x - this.V0.x;
            d3 = this.V1.x - this.V0.x;
            d2 = this.V2.x - this.V0.x;
        } else if (this.N.y > this.N.x) {
            d7 = point3d2.x - this.V0.x;
            d6 = this.V1.x - this.V0.x;
            d5 = this.V2.x - this.V0.x;
            d4 = point3d2.z - this.V0.z;
            d3 = this.V1.z - this.V0.z;
            d2 = this.V2.z - this.V0.z;
        } else {
            d7 = point3d2.y - this.V0.y;
            d6 = this.V1.y - this.V0.y;
            d5 = this.V2.y - this.V0.y;
            d4 = point3d2.z - this.V0.z;
            d3 = this.V1.z - this.V0.z;
            d2 = this.V2.z - this.V0.z;
        }
        double d10 = (d7 * d2 - d4 * d5) / (d6 * d2 - d3 * d5);
        double d11 = (d6 * d4 - d3 * d7) / (d6 * d2 - d3 * d5);
        boolean bl2 = bl = d10 >= -1.0E-12 && d11 >= -1.0E-12 && d10 + d11 <= 1.000000000001;
        if (bl && jCData3dGridIndex.getDistance() > d9) {
            jCData3dGridIndex.setDistance(d9);
            return true;
        }
        return false;
    }

    protected boolean rayTestBar(Chart3dGridData chart3dGridData, Point3d point3d, Vector3d vector3d, int n2, int n3, Point3d point3d2, JCData3dGridIndex jCData3dGridIndex) {
        Point4d[] point4dArray = new Point4d[4];
        boolean bl = false;
        JCChart3dArea jCChart3dArea = chart3dGridData.getDataView().getChart3d().getChart3dArea();
        Transform transform = jCChart3dArea.getTransform();
        Matrix4d matrix4d = transform.getAbsolute();
        Point4d[] point4dArray2 = JCChart3dUtil.constructBarPlane(chart3dGridData, n2, n3);
        point4dArray2[2].z = point4dArray2[3].z = chart3dGridData.getZValue(n2, n3);
        point4dArray2[1].z = point4dArray2[3].z;
        point4dArray2[0].z = point4dArray2[3].z;
        Transform.transformPoint(matrix4d, point4dArray2[0]);
        Transform.transformPoint(matrix4d, point4dArray2[1]);
        Transform.transformPoint(matrix4d, point4dArray2[2]);
        Transform.transformPoint(matrix4d, point4dArray2[3]);
        point4dArray[0] = new Point4d(point4dArray2[0]);
        point4dArray[1] = new Point4d(point4dArray2[1]);
        point4dArray[2] = new Point4d(point4dArray2[2]);
        point4dArray[3] = new Point4d(point4dArray2[3]);
        double d2 = jCChart3dArea.getAxis(3).getOrigin();
        point4dArray[2].z = point4dArray[3].z = d2 * matrix4d.m22 + matrix4d.m23;
        point4dArray[1].z = point4dArray[3].z;
        point4dArray[0].z = point4dArray[3].z;
        bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray2[0], point4dArray2[1], point4dArray2[2], point3d2, jCData3dGridIndex);
        bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray2[0], point4dArray2[3], point4dArray2[2], point3d2, jCData3dGridIndex);
        bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray[0], point4dArray[1], point4dArray[2], point3d2, jCData3dGridIndex);
        bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray[0], point4dArray[2], point4dArray[3], point3d2, jCData3dGridIndex);
        bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray[0], point4dArray[1], point4dArray2[1], point3d2, jCData3dGridIndex);
        bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray[0], point4dArray2[0], point4dArray2[1], point3d2, jCData3dGridIndex);
        bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray[1], point4dArray[2], point4dArray2[2], point3d2, jCData3dGridIndex);
        bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray[1], point4dArray2[1], point4dArray2[2], point3d2, jCData3dGridIndex);
        bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray[2], point4dArray[3], point4dArray2[3], point3d2, jCData3dGridIndex);
        bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray[2], point4dArray2[2], point4dArray2[3], point3d2, jCData3dGridIndex);
        bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray[3], point4dArray[0], point4dArray2[0], point3d2, jCData3dGridIndex);
        return bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray[3], point4dArray2[3], point4dArray2[0], point3d2, jCData3dGridIndex);
    }

    protected boolean rayTestFacet(Chart3dGridData chart3dGridData, Point3d point3d, Vector3d vector3d, int n2, int n3, Point3d point3d2, JCData3dGridIndex jCData3dGridIndex) {
        JCChart3dArea jCChart3dArea = chart3dGridData.getDataView().getChart3d().getChart3dArea();
        Transform transform = jCChart3dArea.getTransform();
        Matrix4d matrix4d = transform.getAbsolute();
        Point4d[] point4dArray = new Point4d[5];
        boolean bl = false;
        point4dArray[1] = this.findAbsolutePoint(chart3dGridData, matrix4d, n2, n3);
        point4dArray[2] = this.findAbsolutePoint(chart3dGridData, matrix4d, n2, n3 + 1);
        point4dArray[3] = this.findAbsolutePoint(chart3dGridData, matrix4d, n2 + 1, n3 + 1);
        point4dArray[0] = this.findAbsolutePoint(chart3dGridData, matrix4d, n2 + 1, n3);
        point4dArray[4] = new Point4d();
        point4dArray[4].x = (point4dArray[1].x + point4dArray[3].x) / 2.0;
        point4dArray[4].y = (point4dArray[1].y + point4dArray[3].y) / 2.0;
        point4dArray[4].z = (point4dArray[0].z + point4dArray[1].z + point4dArray[2].z + point4dArray[3].z) / 4.0;
        point4dArray[4].w = 1.0;
        bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray[0], point4dArray[1], point4dArray[4], point3d2, jCData3dGridIndex);
        bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray[1], point4dArray[2], point4dArray[4], point3d2, jCData3dGridIndex);
        bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray[2], point4dArray[3], point4dArray[4], point3d2, jCData3dGridIndex);
        bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray[3], point4dArray[0], point4dArray[4], point3d2, jCData3dGridIndex);
        if (this.dataView.getChartType() == 0 && jCChart3dArea.getSurface().isSolid()) {
            double d2;
            Point4d[] point4dArray2 = JCChart3dUtil.constructBarPlane(chart3dGridData, n2, n3);
            point4dArray2[3].z = 0.0;
            point4dArray2[2].z = 0.0;
            point4dArray2[1].z = 0.0;
            point4dArray2[0].z = 0.0;
            Transform.transformPoint(matrix4d, point4dArray2[0]);
            Transform.transformPoint(matrix4d, point4dArray2[1]);
            Transform.transformPoint(matrix4d, point4dArray2[2]);
            Transform.transformPoint(matrix4d, point4dArray2[3]);
            point4dArray2[2].z = point4dArray2[3].z = (d2 = -jCChart3dArea.getPlotCube().getZNormalizedScale());
            point4dArray2[1].z = point4dArray2[3].z;
            point4dArray2[0].z = point4dArray2[3].z;
            bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray2[0], point4dArray2[1], point4dArray2[2], point3d2, jCData3dGridIndex);
            bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray2[0], point4dArray2[2], point4dArray2[3], point3d2, jCData3dGridIndex);
            bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray2[0], point4dArray2[1], point4dArray[1], point3d2, jCData3dGridIndex);
            bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray2[0], point4dArray[0], point4dArray[1], point3d2, jCData3dGridIndex);
            bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray2[1], point4dArray2[2], point4dArray[2], point3d2, jCData3dGridIndex);
            bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray2[1], point4dArray[1], point4dArray[2], point3d2, jCData3dGridIndex);
            bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray2[2], point4dArray2[3], point4dArray[3], point3d2, jCData3dGridIndex);
            bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray2[2], point4dArray[2], point4dArray[3], point3d2, jCData3dGridIndex);
            bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray2[3], point4dArray2[0], point4dArray[0], point3d2, jCData3dGridIndex);
            bl |= this.rayIntersectTriangle(point3d, vector3d, point4dArray2[3], point4dArray[3], point4dArray[0], point3d2, jCData3dGridIndex);
        }
        return bl;
    }

    protected boolean testFacet(Chart3dGridData chart3dGridData, Point3d point3d, Vector3d vector3d, int n2, int n3, Point3d point3d2, JCData3dGridIndex jCData3dGridIndex) {
        Chart3dDataView chart3dDataView = chart3dGridData.getDataView();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        int n4 = chart3dDataView.getChartType();
        if (n4 == 1 || n4 == 2 && jCChart3dArea.getScatter().hasDropLines() ? chart3dGridData.getZValue(n2, n3) == chart3dGridData.getHoleValue() || !this.rayTestBar(chart3dGridData, point3d, vector3d, n2, n3, point3d2, jCData3dGridIndex) : (n4 == 0 || n4 == 2 && !jCChart3dArea.getScatter().hasDropLines()) && (JCChart3dUtil.holeInFacet(chart3dGridData, n2, n3) || !this.rayTestFacet(chart3dGridData, point3d, vector3d, n2, n3, point3d2, jCData3dGridIndex))) {
            return false;
        }
        point3d2.scaleAdd(jCData3dGridIndex.getDistance(), vector3d, point3d);
        return true;
    }
}

