/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.DrawFacet;
import com.klg.jclass.chart3d.DrawGrid;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCContour;
import com.klg.jclass.chart3d.JCElevation;
import com.klg.jclass.chart3d.JCFillStyle;
import com.klg.jclass.chart3d.JCPlotCube;
import com.klg.jclass.chart3d.JCSurface;
import java.awt.Graphics;
import java.io.Serializable;

public abstract class DrawFacetAbstract
implements DrawFacet,
Serializable {
    protected DrawGrid drawGrid = null;
    protected Graphics gc = null;
    protected boolean drawMeshLine = false;

    DrawFacetAbstract() {
    }

    DrawFacetAbstract(DrawGrid drawGrid, Graphics graphics) {
        this.drawGrid = drawGrid;
        this.gc = graphics;
    }

    public abstract void draw(int[] var1, int[] var2, int var3, int var4, int var5, int var6);

    public DrawGrid getDrawGrid() {
        return this.drawGrid;
    }

    public boolean getDrawMeshLine() {
        return this.drawMeshLine;
    }

    public Graphics getGC() {
        return this.gc;
    }

    public void polyContours(int n2, int n3) {
        Chart3dGridData chart3dGridData = this.drawGrid.getGridData();
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        JCContour jCContour = chart3dGridData.getDataView().getContour();
        jCContour.drawCellContours(this.gc, n2 - gridLimits.getXOffset(), n3 - gridLimits.getYOffset());
    }

    public void polyErase(int[] nArray, int[] nArray2, int n2, int n3) {
        JCChart3dArea jCChart3dArea = this.drawGrid.getDataView().getChart3d().getChart3dArea();
        JCPlotCube jCPlotCube = jCChart3dArea.getPlotCube();
        JCFillStyle jCFillStyle = new JCFillStyle(jCPlotCube.getDrawBackground(), 1);
        if (n3 == 0) {
            jCFillStyle.updateGraphics(this.gc);
            this.gc.fillPolygon(nArray, nArray2, n2);
        }
    }

    public void polyFilled(int[] nArray, int[] nArray2, int n2, int n3) {
        JCElevation jCElevation = this.drawGrid.getDataView().getElevation();
        if (n3 == 0) {
            if (JCChart3dUtil.backfacing(nArray, nArray2)) {
                this.gc.setColor(jCElevation.getShadedBottomColor());
            } else {
                this.gc.setColor(jCElevation.getShadedTopColor());
            }
            this.gc.fillPolygon(nArray, nArray2, n2);
        }
    }

    public boolean polyFilledZones(int n2, int n3) {
        Chart3dGridData chart3dGridData = this.drawGrid.getGridData();
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        JCContour jCContour = chart3dGridData.getDataView().getContour();
        return jCContour.fillCell(this.gc, n2 - gridLimits.getXOffset(), n3 - gridLimits.getYOffset());
    }

    public void polyOutline(int[] nArray, int[] nArray2, int n2, int n3, int n4, int n5) {
        Chart3dDataView chart3dDataView = this.drawGrid.getDataView();
        JCElevation jCElevation = chart3dDataView.getElevation();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        JCSurface jCSurface = jCChart3dArea.getSurface();
        if (n3 == 0) {
            if (n2 == 3) {
                if (this.drawMeshLine) {
                    if (JCChart3dUtil.backfacing(nArray, nArray2)) {
                        this.gc.setColor(jCElevation.getMeshBottomColor());
                    } else {
                        this.gc.setColor(jCElevation.getMeshTopColor());
                    }
                    this.gc.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
                }
            } else {
                if (JCChart3dUtil.backfacing(nArray, nArray2)) {
                    this.gc.setColor(jCElevation.getMeshBottomColor());
                } else {
                    this.gc.setColor(jCElevation.getMeshTopColor());
                }
                boolean[] blArray = jCSurface.getXMesh();
                boolean[] blArray2 = jCSurface.getYMesh();
                if (blArray[n5 + 1]) {
                    this.gc.drawLine(nArray[1], nArray2[1], nArray[2], nArray2[2]);
                }
                if (blArray[n5]) {
                    this.gc.drawLine(nArray[3], nArray2[3], nArray[0], nArray2[0]);
                }
                if (blArray2[n4]) {
                    this.gc.drawLine(nArray[0], nArray2[0], nArray[1], nArray2[1]);
                }
                if (blArray2[n4 + 1]) {
                    this.gc.drawLine(nArray[2], nArray2[2], nArray[3], nArray2[3]);
                }
            }
        }
    }

    public boolean polyOutlineZones(int n2, int n3) {
        Chart3dGridData chart3dGridData = this.drawGrid.getGridData();
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        JCContour jCContour = chart3dGridData.getDataView().getContour();
        return jCContour.zoneMeshCell(this.gc, n2 - gridLimits.getXOffset(), n3 - gridLimits.getYOffset());
    }

    public void setDrawGrid(DrawGrid drawGrid) {
        this.drawGrid = drawGrid;
    }

    public void setDrawMeshLine(boolean bl) {
        this.drawMeshLine = bl;
    }

    public void setGC(Graphics graphics) {
        this.gc = graphics;
    }
}

