/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCLineStyle;
import com.klg.jclass.chart3d.JCScatter;
import com.klg.jclass.chart3d.JCSymbolStyle;
import com.klg.jclass.chart3d.Mapping;
import com.klg.jclass.chart3d.ScreenPoint;
import java.awt.Graphics;
import java.io.Serializable;

public abstract class Draw
implements Serializable {
    protected ScreenPoint originPoint = null;
    protected Chart3dDataView dataView = null;
    protected Mapping mapping = null;

    Draw() {
    }

    Draw(Chart3dDataView chart3dDataView) {
        this.dataView = chart3dDataView;
    }

    protected abstract void draw(Graphics var1);

    protected abstract void draw2dPoints(Graphics var1);

    public Chart3dDataView getDataView() {
        return this.dataView;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    protected void renderDropLine(Graphics graphics, ScreenPoint screenPoint, JCLineStyle jCLineStyle, double d2, double d3) {
        JCChart3d jCChart3d = this.dataView.getChart3d();
        JCChart3dArea jCChart3dArea = jCChart3d.getChart3dArea();
        JCAxis jCAxis = jCChart3dArea.getAxis(3);
        JCScatter jCScatter = jCChart3dArea.getScatter();
        if (!jCChart3d.isProjection() && jCScatter.hasDropLines() && jCLineStyle.getWidth() > 0 && jCLineStyle.getPattern() != 0) {
            if (this.originPoint == null) {
                this.originPoint = new ScreenPoint();
            } else {
                this.originPoint.reset();
            }
            jCLineStyle.updateGraphics(graphics);
            JCChart3dUtil.getScreenPoint(jCChart3d, d2, d3, jCAxis.getOrigin(), jCAxis.getOrigin(), this.originPoint);
            graphics.drawLine(screenPoint.getXPixel(), screenPoint.getYPixel(), this.originPoint.getXPixel(), this.originPoint.getYPixel());
            jCLineStyle.resetGraphics(graphics);
        }
    }

    protected void renderPoint(Graphics graphics, JCSymbolStyle jCSymbolStyle, JCLineStyle jCLineStyle, ScreenPoint screenPoint, double d2, double d3) {
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        if (screenPoint == null || jCLineStyle == null || jCSymbolStyle == null) {
            return;
        }
        boolean bl = false;
        int n2 = jCChart3dArea.getTransform().getProcessingOrder();
        if ((n2 & 0x20) != 0) {
            switch (n2 & 0xF) {
                case 0: 
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                    break;
                }
            }
        }
        if (!bl) {
            this.renderDropLine(graphics, screenPoint, jCLineStyle, d2, d3);
        }
        if (jCSymbolStyle.getSize() > 0 && jCSymbolStyle.getShape() != null) {
            jCSymbolStyle.draw(graphics, screenPoint.getXPixel(), screenPoint.getYPixel());
        }
        screenPoint.setDrawn(true);
        if (bl) {
            this.renderDropLine(graphics, screenPoint, jCLineStyle, d2, d3);
        }
    }

    public void setMapping(Mapping mapping) {
        this.mapping = mapping;
    }
}

