/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCPlotCube;
import com.klg.jclass.chart3d.Transform;
import java.io.Serializable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point4d;

public class Cube
implements Serializable {
    static final long serialVersionUID = -5542417106751358122L;
    public static final int YNEG_ZNEG = 0;
    public static final int YNEG_ZPOS = 1;
    public static final int YPOS_ZNEG = 2;
    public static final int YPOS_ZPOS = 3;
    public static final int XNEG_ZNEG = 4;
    public static final int XNEG_ZPOS = 5;
    public static final int XPOS_ZNEG = 6;
    public static final int XPOS_ZPOS = 7;
    public static final int XNEG_YNEG = 8;
    public static final int XNEG_YPOS = 9;
    public static final int XPOS_YNEG = 10;
    public static final int XPOS_YPOS = 11;
    public static final int FACE_LEFT = 0;
    public static final int FACE_RIGHT = 1;
    public static final int FACE_BOTTOM = 2;
    public static final int FACE_TOP = 3;
    public static final int FACE_FAR = 4;
    public static final int FACE_NEAR = 5;
    public static final int NUM_POINTS = 8;
    public static final int NUM_EDGES = 12;
    public static final int NUM_FACES = 6;
    public static final int NUM_POINTS_IN_FACE = 4;
    public static final int VP_XMAX = 1;
    public static final int VP_XMIN = 2;
    public static final int VP_YMAX = 4;
    public static final int VP_YMIN = 8;
    public static final int VP_ZMAX = 16;
    public static final int VP_ZMIN = 32;
    public static final int VP_XMASK = 3;
    public static final int VP_YMASK = 12;
    public static final int VP_ZMASK = 48;
    protected static final double[][] points = new double[][]{{-1.0, -1.0, -1.0}, {-1.0, -1.0, 1.0}, {-1.0, 1.0, 1.0}, {-1.0, 1.0, -1.0}, {1.0, 1.0, -1.0}, {1.0, 1.0, 1.0}, {1.0, -1.0, 1.0}, {1.0, -1.0, -1.0}};
    protected static final int[][] faces;
    protected static final int[][] edges;
    protected static final int[][] pointEdges;
    protected boolean[] faceVisible = new boolean[6];
    protected boolean[] annotateEdge = new boolean[12];
    protected boolean[] drawEdge = new boolean[12];
    protected Point4d[] cubePoints = new Point4d[8];
    protected JCChart3dArea area = null;

    static {
        int[][] nArrayArray = new int[6][];
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        nArrayArray[0] = nArray;
        nArrayArray[1] = new int[]{4, 5, 6, 7};
        int[] nArray2 = new int[4];
        nArray2[1] = 7;
        nArray2[2] = 6;
        nArray2[3] = 1;
        nArrayArray[2] = nArray2;
        nArrayArray[3] = new int[]{2, 5, 4, 3};
        int[] nArray3 = new int[4];
        nArray3[1] = 3;
        nArray3[2] = 4;
        nArray3[3] = 7;
        nArrayArray[4] = nArray3;
        nArrayArray[5] = new int[]{1, 6, 5, 2};
        faces = nArrayArray;
        int[][] nArrayArray2 = new int[12][];
        int[] nArray4 = new int[2];
        nArray4[1] = 7;
        nArrayArray2[0] = nArray4;
        nArrayArray2[1] = new int[]{1, 6};
        nArrayArray2[2] = new int[]{3, 4};
        nArrayArray2[3] = new int[]{2, 5};
        int[] nArray5 = new int[2];
        nArray5[1] = 3;
        nArrayArray2[4] = nArray5;
        nArrayArray2[5] = new int[]{1, 2};
        nArrayArray2[6] = new int[]{7, 4};
        nArrayArray2[7] = new int[]{6, 5};
        int[] nArray6 = new int[2];
        nArray6[1] = 1;
        nArrayArray2[8] = nArray6;
        nArrayArray2[9] = new int[]{3, 2};
        nArrayArray2[10] = new int[]{7, 6};
        nArrayArray2[11] = new int[]{4, 5};
        edges = nArrayArray2;
        int[][] nArrayArray3 = new int[8][];
        int[] nArray7 = new int[3];
        nArray7[1] = 2;
        nArray7[2] = 8;
        nArrayArray3[0] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[1] = 3;
        nArray8[2] = 9;
        nArrayArray3[1] = nArray8;
        nArrayArray3[2] = new int[]{4, 7, 9};
        nArrayArray3[3] = new int[]{4, 6, 8};
        nArrayArray3[4] = new int[]{5, 6, 10};
        nArrayArray3[5] = new int[]{5, 7, 11};
        nArrayArray3[6] = new int[]{1, 3, 11};
        nArrayArray3[7] = new int[]{1, 2, 10};
        pointEdges = nArrayArray3;
    }

    public Cube() {
        int n2 = 0;
        while (n2 < 8) {
            this.cubePoints[n2] = new Point4d(points[n2][0], points[n2][1], points[n2][2], 1.0);
            ++n2;
        }
    }

    public Cube(JCChart3dArea jCChart3dArea) {
        this();
        this.area = jCChart3dArea;
    }

    protected void calc2DAnnoEdges() {
        int n2 = 0;
        while (n2 <= 5) {
            this.faceVisible[n2] = n2 == 5;
            ++n2;
        }
    }

    protected void calc3DAnnoEdges() {
        int n2;
        Transform transform = this.area.getTransform();
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        matrix4d.m11 = -1.0;
        matrix4d.mul(transform.getPerspective());
        matrix4d.mul(transform.getRotation());
        JCPlotCube jCPlotCube = this.area.getPlotCube();
        Transform.scaleMatrix(matrix4d, jCPlotCube.getXNormalizedScale(), jCPlotCube.getYNormalizedScale(), jCPlotCube.getZNormalizedScale());
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        while (n5 < 8) {
            this.cubePoints[n5].set(points[n5][0], points[n5][1], points[n5][2], 1.0);
            Transform.transformPoint(matrix4d, this.cubePoints[n5]);
            if (d2 > this.cubePoints[n5].z) {
                d2 = this.cubePoints[n5].z;
                n4 = n5;
            }
            if (d3 < this.cubePoints[n5].z) {
                d3 = this.cubePoints[n5].z;
                n3 = n5;
            }
            ++n5;
        }
        int n6 = this.findViewPosition();
        int n7 = 0;
        if ((n6 & 3) != 0) {
            ++n7;
        }
        if ((n6 & 0xC) != 0) {
            n7 += 2;
        }
        if ((n6 & 0x30) != 0) {
            n7 += 4;
        }
        switch (n7) {
            case 1: {
                this.calcFace(n6);
                break;
            }
            case 2: {
                this.calcFace(n6);
                break;
            }
            case 3: {
                this.calcEdge(n6);
                break;
            }
            case 4: {
                this.calcFace(n6);
                break;
            }
            case 5: {
                this.calcEdge(n6);
                break;
            }
            case 6: {
                this.calcEdge(n6);
                break;
            }
            case 7: {
                this.calcCorner(n4, n3);
                break;
            }
        }
        if (!this.area.getAxis(1).isShowing()) {
            n2 = 0;
            while (n2 <= 3) {
                this.annotateEdge[n2] = false;
                this.drawEdge[n2] = false;
                ++n2;
            }
        }
        if (!this.area.getAxis(2).isShowing()) {
            n2 = 4;
            while (n2 <= 7) {
                this.annotateEdge[n2] = false;
                this.drawEdge[n2] = false;
                ++n2;
            }
        }
        if (!this.area.getAxis(3).isShowing()) {
            n2 = 8;
            while (n2 <= 11) {
                this.annotateEdge[n2] = false;
                this.drawEdge[n2] = false;
                ++n2;
            }
        }
    }

    protected void calcCorner(int n2, int n3) {
        int n4 = 0;
        while (n4 <= 11) {
            this.annotateEdge[n4] = edges[n4][0] != n2 && edges[n4][1] != n2 && edges[n4][0] != n3 && edges[n4][1] != n3;
            this.drawEdge[n4] = edges[n4][0] != n3 && edges[n4][1] != n3;
            ++n4;
        }
        int n5 = 0;
        while (n5 <= 5) {
            this.faceVisible[n5] = faces[n5][0] != n3 && faces[n5][1] != n3 && faces[n5][2] != n3 && faces[n5][3] != n3;
            ++n5;
        }
    }

    protected void calcEdge(int n2) {
        int n3;
        int n4;
        int n5 = -1;
        int n6 = 0;
        if ((n2 & 3) == 0) {
            n6 |= (n2 & 4) >> 1;
            n4 = ~(n6 |= (n2 & 0x10) >> 4) & 3;
            n3 = 0;
            while (n3 <= 3) {
                this.annotateEdge[n3] = (n3 & 3) != n6 && (n3 & 3) != n4;
                boolean bl = this.drawEdge[n3] = (n3 & 3) != n6;
                if ((n3 & 3) == n6) {
                    n5 = n3;
                }
                ++n3;
            }
            n3 = 4;
            while (n3 <= 7) {
                this.annotateEdge[n3] = (n3 & 1) == (n6 & 1);
                this.drawEdge[n3] = true;
                ++n3;
            }
            n3 = 8;
            while (n3 <= 11) {
                this.annotateEdge[n3] = (n3 & 1) == n6 >> 1;
                this.drawEdge[n3] = true;
                ++n3;
            }
        } else if ((n2 & 0xC) == 0) {
            n6 |= (n2 & 1) << 1;
            n4 = ~(n6 |= (n2 & 0x10) >> 4) & 3;
            n3 = 4;
            while (n3 <= 7) {
                this.annotateEdge[n3] = (n3 & 3) != n6 && (n3 & 3) != n4;
                boolean bl = this.drawEdge[n3] = (n3 & 3) != n6;
                if ((n3 & 3) == n6) {
                    n5 = n3;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 <= 3) {
                this.annotateEdge[n3] = (n3 & 1) == (n6 & 1);
                this.drawEdge[n3] = true;
                ++n3;
            }
            n3 = 8;
            while (n3 <= 11) {
                this.annotateEdge[n3] = (n3 & 2) == (n6 & 2);
                this.drawEdge[n3] = true;
                ++n3;
            }
        } else if ((n2 & 0x30) == 0) {
            n6 |= (n2 & 1) << 1;
            n4 = ~(n6 |= (n2 & 4) >> 2) & 3;
            n3 = 8;
            while (n3 <= 11) {
                this.annotateEdge[n3] = (n3 & 3) != n6 && (n3 & 3) != n4;
                boolean bl = this.drawEdge[n3] = (n3 & 3) != n6;
                if ((n3 & 3) == n6) {
                    n5 = n3;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 <= 3) {
                this.annotateEdge[n3] = (n3 & 2) == (n6 & 1) << 1;
                this.drawEdge[n3] = true;
                ++n3;
            }
            n3 = 4;
            while (n3 <= 7) {
                this.annotateEdge[n3] = (n3 & 2) == (n6 & 2);
                this.drawEdge[n3] = true;
                ++n3;
            }
        }
        n3 = 0;
        while (n3 <= 5) {
            this.faceVisible[n3] = !this.edgeInFace(n3, n5);
            ++n3;
        }
    }

    protected void calcFace(int n2) {
        int n3 = 0;
        while (n3 <= 11) {
            this.annotateEdge[n3] = false;
            this.drawEdge[n3] = true;
            ++n3;
        }
        n3 = 0;
        while (n3 <= 5) {
            this.faceVisible[n3] = true;
            ++n3;
        }
        switch (n2) {
            case 1: {
                this.annotateEdge[6] = true;
                this.annotateEdge[7] = true;
                this.annotateEdge[10] = true;
                this.annotateEdge[11] = true;
                this.faceVisible[1] = false;
                break;
            }
            case 2: {
                this.annotateEdge[4] = true;
                this.annotateEdge[5] = true;
                this.annotateEdge[8] = true;
                this.annotateEdge[9] = true;
                this.faceVisible[0] = false;
                break;
            }
            case 4: {
                this.annotateEdge[2] = true;
                this.annotateEdge[3] = true;
                this.annotateEdge[9] = true;
                this.annotateEdge[11] = true;
                this.faceVisible[3] = false;
                break;
            }
            case 8: {
                this.annotateEdge[0] = true;
                this.annotateEdge[1] = true;
                this.annotateEdge[8] = true;
                this.annotateEdge[10] = true;
                this.faceVisible[2] = false;
                break;
            }
            case 16: {
                this.annotateEdge[1] = true;
                this.annotateEdge[3] = true;
                this.annotateEdge[5] = true;
                this.annotateEdge[7] = true;
                this.faceVisible[5] = false;
                break;
            }
            case 32: {
                this.annotateEdge[0] = true;
                this.annotateEdge[2] = true;
                this.annotateEdge[4] = true;
                this.annotateEdge[6] = true;
                this.faceVisible[4] = false;
                break;
            }
        }
    }

    protected boolean edgeInFace(int n2, int n3) {
        boolean bl = false;
        boolean bl2 = false;
        int n4 = 0;
        while (n4 < 4) {
            bl = bl || faces[n2][n4] == edges[n3][0];
            bl2 = bl2 || faces[n2][n4] == edges[n3][1];
            ++n4;
        }
        return bl && bl2;
    }

    protected boolean faceBackfacing(int n2) {
        Point4d point4d = new Point4d();
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        Transform transform = this.area.getTransform();
        Matrix4d matrix4d = new Matrix4d(transform.getTextView());
        JCPlotCube jCPlotCube = this.area.getPlotCube();
        Transform.scaleMatrix(matrix4d, jCPlotCube.getXNormalizedScale(), jCPlotCube.getYNormalizedScale(), jCPlotCube.getZNormalizedScale());
        int n3 = 0;
        while (n3 < 4) {
            int n4 = faces[n2][n3];
            point4d.set(points[n4][0], points[n4][1], points[n4][2], 1.0);
            Transform.transformPoint(matrix4d, point4d);
            int n5 = 4 - n3 - 1;
            nArray[n5] = (int)Math.round(point4d.x);
            nArray2[n5] = (int)Math.round(point4d.y);
            ++n3;
        }
        return JCChart3dUtil.backfacing(nArray, nArray2);
    }

    protected int findViewPosition() {
        Point4d point4d = this.area.getTransform().getEyePosition();
        JCPlotCube jCPlotCube = this.area.getPlotCube();
        double d2 = point4d.x / jCPlotCube.getXNormalizedScale();
        double d3 = point4d.y / jCPlotCube.getYNormalizedScale();
        double d4 = point4d.z / jCPlotCube.getZNormalizedScale();
        int n2 = 0;
        if (d2 >= 1.0) {
            n2 |= 1;
        }
        if (d2 <= -1.0) {
            n2 |= 2;
        }
        if (d3 >= 1.0) {
            n2 |= 4;
        }
        if (d3 <= -1.0) {
            n2 |= 8;
        }
        if (d4 >= 1.0) {
            n2 |= 0x10;
        }
        if (d4 <= -1.0) {
            n2 |= 0x20;
        }
        return n2;
    }

    public boolean[] getAnnotateEdge() {
        return this.annotateEdge;
    }

    public JCChart3dArea getChart3dArea() {
        return this.area;
    }

    protected Point4d[] getCubePoints() {
        return this.cubePoints;
    }

    protected boolean[] getDrawEdge() {
        return this.drawEdge;
    }

    protected boolean[] getFaceVisible() {
        return this.faceVisible;
    }

    public void setChart3dArea(JCChart3dArea jCChart3dArea) {
        this.area = jCChart3dArea;
    }
}

