/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Intersection;
import com.klg.jclass.util.JCDebug;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.vecmath.Point3d;

public class ContourCell
implements Comparator,
Serializable {
    public static final int SIDE = 4;
    protected boolean hole = false;
    protected int nIntersections = 0;
    protected ArrayList[] corners = new ArrayList[4];
    protected ArrayList side = null;
    protected Intersection newIntersection = null;

    ContourCell() {
    }

    protected void addIntersection(Intersection intersection, int n2) {
        if (n2 < 0 || n2 > 4) {
            JCDebug.println("contourCell", "addIntersection: Bad side/corner!");
            return;
        }
        if (n2 == 4) {
            if (this.side == null) {
                this.side = new ArrayList();
            }
            this.side.add(intersection);
        } else {
            if (this.corners[n2] == null) {
                this.corners[n2] = new ArrayList();
            }
            this.corners[n2].add(intersection);
        }
        ++this.nIntersections;
    }

    public int compare(Object object, Object object2) {
        Intersection intersection = (Intersection)object;
        Intersection intersection2 = (Intersection)object2;
        Point3d point3d = intersection.getSegment2().getPoint();
        Point3d point3d2 = intersection2.getSegment2().getPoint();
        int n2 = 0;
        switch (intersection2.side2) {
            case 0: {
                n2 = point3d.y < point3d2.y ? -1 : (point3d.y > point3d2.y ? 1 : 0);
                break;
            }
            case 1: {
                n2 = point3d.x > point3d2.x ? -1 : (point3d.x < point3d2.x ? 1 : 0);
                break;
            }
            case 2: {
                n2 = point3d.y > point3d2.y ? -1 : (point3d.y < point3d2.y ? 1 : 0);
                break;
            }
            case 3: {
                n2 = point3d.x < point3d2.x ? -1 : (point3d.x > point3d2.x ? 1 : 0);
                break;
            }
        }
        return n2;
    }

    public ArrayList getIntersectionList(int n2) {
        if (n2 < 0 || n2 > 4) {
            JCDebug.println("contourCell", "getIntersectionList: Bad side/corner!");
            return null;
        }
        if (n2 == 4) {
            return this.side;
        }
        return this.corners[n2];
    }

    public int getNIntersections() {
        return this.nIntersections;
    }

    protected Intersection getNewIntersection() {
        return this.newIntersection;
    }

    protected boolean isHole() {
        return this.hole;
    }

    protected void setHole(boolean bl) {
        this.hole = bl;
    }

    protected void setNewIntersection(Intersection intersection) {
        this.newIntersection = intersection;
    }

    protected void sortIntersectionLists() {
        int n2 = 0;
        while (n2 < this.corners.length) {
            if (this.corners[n2] != null && this.corners[n2].size() > 1) {
                Collections.sort(this.corners[n2], this);
            }
            ++n2;
        }
        if (this.side != null && this.side.size() > 1) {
            Collections.sort(this.side, this);
        }
    }
}

