/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.JCChart3dStyle;
import java.io.Serializable;
import javax.vecmath.Point3d;

public class Chart3dPointSeries
implements Serializable {
    protected Point3d[] points = null;
    protected int numPoints = 0;
    protected Chart3dPointData data = null;
    protected JCChart3dStyle chartStyle = null;
    protected String label = null;

    public Chart3dPointSeries() {
    }

    public Chart3dPointSeries(Chart3dPointData chart3dPointData, Point3d[] point3dArray) {
        this.data = chart3dPointData;
        this.points = point3dArray;
        int n2 = this.numPoints = point3dArray == null ? 0 : point3dArray.length;
        if (chart3dPointData != null) {
            Chart3dDataView chart3dDataView = chart3dPointData.getDataView();
            this.chartStyle = JCChart3dStyle.makeDefault(chart3dDataView.getChart3d(), chart3dDataView);
        } else {
            this.chartStyle = JCChart3dStyle.makeDefault(null);
        }
    }

    public JCChart3dStyle getChartStyle() {
        if (this.chartStyle == null) {
            if (this.data != null) {
                Chart3dDataView chart3dDataView = this.data.getDataView();
                this.chartStyle = JCChart3dStyle.makeDefault(chart3dDataView.getChart3d(), chart3dDataView);
            } else {
                this.chartStyle = JCChart3dStyle.makeDefault(null);
            }
        }
        return this.chartStyle;
    }

    public Chart3dPointData getData() {
        return this.data;
    }

    public String getLabel() {
        return this.label;
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    public Point3d getPoint(int n2) {
        return this.points[n2];
    }

    public Point3d[] getPoints() {
        return this.points;
    }

    public void setChartStyle(JCChart3dStyle jCChart3dStyle) {
        if (this.chartStyle == jCChart3dStyle) {
            return;
        }
        this.chartStyle = jCChart3dStyle;
        if (this.data != null) {
            if (this.chartStyle != null) {
                this.chartStyle.addParent(this.data.getDataView());
            }
            this.data.setChanged(true, 33);
        }
    }

    public void setData(Chart3dPointData chart3dPointData) {
        this.data = chart3dPointData;
        if (this.data != null) {
            this.data.setChanged(true, 34);
        }
    }

    public void setLabel(String string) {
        if (this.label == string) {
            return;
        }
        this.label = string;
        if (this.data != null) {
            this.data.setChanged(true, 34);
        }
    }

    protected void setPoints(Point3d[] point3dArray) {
        this.points = point3dArray;
        this.numPoints = point3dArray == null ? 0 : point3dArray.length;
    }
}

