/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataHandler;
import com.klg.jclass.chart3d.Chart3dDataModel;
import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.Chart3dPointDataModel;
import com.klg.jclass.chart3d.Chart3dPointSeries;
import com.klg.jclass.chart3d.EditableChart3dDataModel;
import com.klg.jclass.chart3d.JCData3dIndex;
import com.klg.jclass.chart3d.JCData3dPointIndex;
import com.klg.jclass.chart3d.LabelledChart3dPointDataModel;
import com.klg.jclass.chart3d.event.Chart3dDataEvent;
import com.klg.jclass.chart3d.event.Chart3dPointDataEvent;
import java.util.ArrayList;
import javax.vecmath.Point3d;

public class Chart3dPointDataHandler
extends Chart3dDataHandler {
    public Chart3dPointDataHandler(Chart3dPointData chart3dPointData) {
        super(chart3dPointData);
    }

    public boolean addSeries(Chart3dPointDataModel chart3dPointDataModel) {
        if (chart3dPointDataModel == null) {
            return false;
        }
        Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
        int n2 = chart3dPointData.getNumSeries();
        Point3d[][] point3dArray = chart3dPointDataModel.getPoints();
        if (point3dArray == null || n2 >= point3dArray.length) {
            return false;
        }
        chart3dPointData.addSeries(point3dArray[n2]);
        return true;
    }

    public boolean editZValue(JCData3dIndex jCData3dIndex, double d2) {
        if (jCData3dIndex == null || !(jCData3dIndex instanceof JCData3dPointIndex)) {
            return false;
        }
        JCData3dPointIndex jCData3dPointIndex = (JCData3dPointIndex)jCData3dIndex;
        Chart3dDataModel chart3dDataModel = this.data.getDataSource();
        if (chart3dDataModel == null || !(chart3dDataModel instanceof EditableChart3dDataModel)) {
            return false;
        }
        EditableChart3dDataModel editableChart3dDataModel = (EditableChart3dDataModel)((Object)chart3dDataModel);
        return editableChart3dDataModel.setZValue(jCData3dPointIndex, d2);
    }

    public boolean handleEvent(Chart3dDataModel chart3dDataModel, Chart3dDataEvent chart3dDataEvent) {
        boolean bl = false;
        if (chart3dDataModel == null || chart3dDataEvent == null) {
            return bl;
        }
        Chart3dPointDataModel chart3dPointDataModel = (Chart3dPointDataModel)chart3dDataModel;
        Chart3dPointDataEvent chart3dPointDataEvent = null;
        if (chart3dDataEvent instanceof Chart3dPointDataEvent) {
            chart3dPointDataEvent = (Chart3dPointDataEvent)chart3dDataEvent;
        }
        if (chart3dPointDataEvent == null && chart3dDataEvent.getType() > 4) {
            return bl;
        }
        switch (chart3dPointDataEvent.getType()) {
            case 1: {
                bl = this.reloadDataSourceName(chart3dDataModel);
                break;
            }
            case 2: {
                bl = this.reset(chart3dDataModel);
                break;
            }
            case 3: {
                bl = this.reload(chart3dDataModel);
                break;
            }
            case 4: {
                bl = this.reloadHoleValue(chart3dDataModel);
                break;
            }
            case 5: {
                bl = this.reloadPoint(chart3dPointDataModel, chart3dPointDataEvent.getSeries(), chart3dPointDataEvent.getPoint());
                break;
            }
            case 6: {
                bl = this.reloadSeries(chart3dPointDataModel, chart3dPointDataEvent.getSeries());
                break;
            }
            case 7: {
                bl = this.addSeries(chart3dPointDataModel);
                break;
            }
            case 8: {
                bl = this.insertSeries(chart3dPointDataModel, chart3dPointDataEvent.getSeries());
                break;
            }
            case 9: {
                bl = this.removeSeries(chart3dPointDataModel, chart3dPointDataEvent.getSeries());
                break;
            }
            case 10: {
                bl = this.reloadSeriesLabel(chart3dPointDataModel, chart3dPointDataEvent.getSeries());
                break;
            }
            case 11: {
                bl = this.reloadAllSeriesLabels(chart3dPointDataModel);
                break;
            }
            default: {
                throw new RuntimeException("Unknown event type: " + chart3dPointDataEvent.getType());
            }
        }
        return bl;
    }

    public boolean insertSeries(Chart3dPointDataModel chart3dPointDataModel, int n2) {
        if (chart3dPointDataModel == null) {
            return false;
        }
        Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
        if (n2 < 0 || n2 >= chart3dPointData.getNumSeries()) {
            return false;
        }
        Point3d[][] point3dArray = chart3dPointDataModel.getPoints();
        if (point3dArray == null || n2 >= point3dArray.length) {
            return false;
        }
        chart3dPointData.addSeries(point3dArray[n2], n2);
        return true;
    }

    public boolean reload(Chart3dDataModel chart3dDataModel) {
        if (chart3dDataModel == null) {
            return false;
        }
        Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
        Chart3dPointDataModel chart3dPointDataModel = (Chart3dPointDataModel)chart3dDataModel;
        chart3dPointData.refreshPointSeriesList(chart3dPointDataModel.getPoints());
        this.reloadAllSeriesLabels(chart3dPointDataModel);
        this.reloadHoleValue(chart3dDataModel);
        return true;
    }

    public boolean reloadAllSeriesLabels(Chart3dPointDataModel chart3dPointDataModel) {
        if (chart3dPointDataModel == null || !(chart3dPointDataModel instanceof LabelledChart3dPointDataModel)) {
            return false;
        }
        Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
        LabelledChart3dPointDataModel labelledChart3dPointDataModel = (LabelledChart3dPointDataModel)((Object)chart3dPointDataModel);
        String[] stringArray = labelledChart3dPointDataModel.getSeriesLabels();
        if (stringArray == null || chart3dPointData.getNumSeries() == 0) {
            return false;
        }
        ArrayList arrayList = chart3dPointData.getSeries();
        if (arrayList == null) {
            return false;
        }
        int n2 = 0;
        while (n2 < chart3dPointData.getNumSeries() && n2 < stringArray.length) {
            Chart3dPointSeries chart3dPointSeries = (Chart3dPointSeries)arrayList.get(n2);
            chart3dPointSeries.label = stringArray[n2];
            ++n2;
        }
        return true;
    }

    public boolean reloadPoint(Chart3dPointDataModel chart3dPointDataModel, int n2, int n3) {
        if (chart3dPointDataModel == null) {
            return false;
        }
        Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
        if (n2 < 0 || n2 >= chart3dPointData.getNumSeries()) {
            return false;
        }
        ArrayList arrayList = chart3dPointData.getSeries();
        Chart3dPointSeries chart3dPointSeries = (Chart3dPointSeries)arrayList.get(n2);
        if (n3 < 0 || n3 >= chart3dPointSeries.getNumPoints()) {
            return false;
        }
        Point3d[][] point3dArray = chart3dPointDataModel.getPoints();
        if (point3dArray == null || n2 >= point3dArray.length) {
            return false;
        }
        chart3dPointSeries.setPoints(point3dArray[n2]);
        return true;
    }

    public boolean reloadSeries(Chart3dPointDataModel chart3dPointDataModel, int n2) {
        if (chart3dPointDataModel == null) {
            return false;
        }
        Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
        if (n2 < 0 || n2 >= chart3dPointData.getNumSeries()) {
            return false;
        }
        ArrayList arrayList = chart3dPointData.getSeries();
        Chart3dPointSeries chart3dPointSeries = (Chart3dPointSeries)arrayList.get(n2);
        Point3d[][] point3dArray = chart3dPointDataModel.getPoints();
        if (point3dArray == null || n2 >= point3dArray.length) {
            return false;
        }
        chart3dPointSeries.setPoints(point3dArray[n2]);
        return true;
    }

    public boolean reloadSeriesLabel(Chart3dPointDataModel chart3dPointDataModel, int n2) {
        if (chart3dPointDataModel == null || !(chart3dPointDataModel instanceof LabelledChart3dPointDataModel)) {
            return false;
        }
        Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
        LabelledChart3dPointDataModel labelledChart3dPointDataModel = (LabelledChart3dPointDataModel)((Object)chart3dPointDataModel);
        String[] stringArray = labelledChart3dPointDataModel.getSeriesLabels();
        if (stringArray == null || n2 < 0 || n2 >= chart3dPointData.getNumSeries() || n2 >= stringArray.length) {
            return false;
        }
        ArrayList arrayList = chart3dPointData.getSeries();
        if (arrayList == null) {
            return false;
        }
        Chart3dPointSeries chart3dPointSeries = (Chart3dPointSeries)arrayList.get(n2);
        chart3dPointSeries.label = stringArray[n2];
        return true;
    }

    public boolean removeSeries(Chart3dPointDataModel chart3dPointDataModel, int n2) {
        if (chart3dPointDataModel == null) {
            return false;
        }
        Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
        if (n2 < 0 || n2 >= chart3dPointData.getNumSeries()) {
            return false;
        }
        chart3dPointData.removeSeries(n2);
        return true;
    }

    public boolean reset(Chart3dDataModel chart3dDataModel) {
        if (chart3dDataModel == null) {
            return false;
        }
        Chart3dPointData chart3dPointData = (Chart3dPointData)this.data;
        Chart3dPointDataModel chart3dPointDataModel = (Chart3dPointDataModel)chart3dDataModel;
        chart3dPointData.makePointSeriesList(chart3dPointDataModel.getPoints());
        this.reloadAllSeriesLabels(chart3dPointDataModel);
        this.reloadHoleValue(chart3dDataModel);
        this.reloadDataSourceName(chart3dDataModel);
        return true;
    }
}

