/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dPointDataHandler;
import com.klg.jclass.chart3d.Chart3dPointDataModel;
import com.klg.jclass.chart3d.Chart3dPointSeries;
import com.klg.jclass.chart3d.Extents;
import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.chart3d.SortPoint;
import com.klg.jclass.util.JCDebug;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.vecmath.Point3d;

public class Chart3dPointData
extends Chart3dData
implements Comparator {
    protected ArrayList series = null;
    protected int numSeries;
    protected ArrayList sortPoints = null;
    protected boolean sorted = false;

    public Chart3dPointData() {
        this.dataHandler = new Chart3dPointDataHandler(this);
        this.setDataSource(null);
    }

    public Chart3dPointData(Chart3dDataView chart3dDataView, Chart3dPointDataModel chart3dPointDataModel) {
        super(chart3dDataView);
        this.dataHandler = new Chart3dPointDataHandler(this);
        this.setDataSource(chart3dPointDataModel);
    }

    protected void addSeries(Point3d[] point3dArray) {
        if (point3dArray == null) {
            return;
        }
        if (this.series == null) {
            this.series = new ArrayList();
        }
        this.series.add(new Chart3dPointSeries(this, point3dArray));
        this.numSeries = this.series.size();
        this.processData();
    }

    protected void addSeries(Point3d[] point3dArray, int n2) {
        if (this.series == null) {
            this.series = new ArrayList();
        }
        if (n2 < 0 || n2 > this.series.size() || point3dArray == null) {
            return;
        }
        this.series.add(n2, new Chart3dPointSeries(this, point3dArray));
        this.numSeries = this.series.size();
        this.processData();
    }

    protected void calcAnnoLimits() {
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        JCAxis jCAxis = jCChart3dArea.getAxis(1);
        JCAxis jCAxis2 = jCChart3dArea.getAxis(2);
        JCAxis jCAxis3 = jCChart3dArea.getAxis(3);
        jCAxis.setAnnoMin(jCAxis.getMin());
        jCAxis.setAnnoMax(jCAxis.getMax());
        jCAxis.setAnnoStep(0.0);
        jCAxis2.setAnnoMin(jCAxis2.getMin());
        jCAxis2.setAnnoMax(jCAxis2.getMax());
        jCAxis2.setAnnoStep(0.0);
        double d2 = jCAxis3.getMin();
        double d3 = jCAxis3.getMax();
        if (!jCChart3dArea.getChart3d().isProjection() && jCChart3dArea.getScatter().hasDropLines()) {
            d2 = Math.min(d2, jCAxis3.getOrigin());
            d3 = Math.max(d3, jCAxis3.getOrigin());
        }
        jCAxis3.setAnnoMin(d2);
        jCAxis3.setAnnoMax(d3);
        jCAxis3.setAnnoStep(0.0);
    }

    protected void calcLimits() {
        if (!this.dataOK) {
            return;
        }
        this.computePointLimits();
        this.checkValidZExtents();
    }

    public int compare(Object object, Object object2) {
        SortPoint sortPoint = (SortPoint)object;
        SortPoint sortPoint2 = (SortPoint)object2;
        int n2 = 0;
        if (sortPoint.getDistanceToEye() > sortPoint2.getDistanceToEye()) {
            n2 = -1;
        } else if (sortPoint.getDistanceToEye() < sortPoint2.getDistanceToEye()) {
            n2 = 1;
        }
        return n2;
    }

    protected void computePointLimits() {
        Serializable serializable;
        Extents extents = new Extents();
        int n2 = 0;
        while (n2 < this.numSeries) {
            serializable = (Chart3dPointSeries)this.series.get(n2);
            int n3 = 0;
            while (n3 < ((Chart3dPointSeries)serializable).getNumPoints()) {
                Point3d point3d = ((Chart3dPointSeries)serializable).getPoint(n3);
                if (point3d.z != this.getHoleValue()) {
                    extents.checkXYZExtents(point3d.x, point3d.y, point3d.z);
                }
                ++n3;
            }
            ++n2;
        }
        if (extents.getXMin() == Double.MAX_VALUE) {
            JCDebug.println("pointdata", "Data is all holes");
            extents.setXMin(0.0);
            extents.setXMax(1.0);
            extents.setYMin(0.0);
            extents.setYMax(1.0);
            extents.setZMin(0.0);
            extents.setZMax(1.0);
        }
        serializable = this.dataView.getChart3d().getChart3dArea();
        JCAxis jCAxis = ((JCChart3dArea)serializable).getAxis(1);
        jCAxis.setExtents(extents.getXMin(), extents.getXMax());
        jCAxis = ((JCChart3dArea)serializable).getAxis(2);
        jCAxis.setExtents(extents.getYMin(), extents.getYMax());
        jCAxis = ((JCChart3dArea)serializable).getAxis(3);
        jCAxis.setExtents(extents.getZMin(), extents.getZMax());
        this.dataMin = extents.getZMin();
        this.dataMax = extents.getZMax();
    }

    public int getNumSeries() {
        return this.numSeries;
    }

    public Point3d getPoint(int n2, int n3) {
        if (n2 < 0 || n2 > this.numSeries - 1) {
            throw new IllegalArgumentException("Series number out of range.");
        }
        Chart3dPointSeries chart3dPointSeries = (Chart3dPointSeries)this.series.get(n2);
        return chart3dPointSeries.getPoint(n3);
    }

    public ArrayList getSeries() {
        return this.series;
    }

    public Chart3dPointSeries getSeries(int n2) {
        if (n2 < 0 || n2 > this.numSeries - 1) {
            throw new IllegalArgumentException("Series number out of range.");
        }
        Chart3dPointSeries chart3dPointSeries = (Chart3dPointSeries)this.series.get(n2);
        return chart3dPointSeries;
    }

    public ArrayList getSortPoints() {
        return this.sortPoints;
    }

    protected void makePointSeriesList(Point3d[][] point3dArray) {
        this.series = null;
        this.numSeries = 0;
        if (point3dArray != null) {
            this.numSeries = point3dArray.length;
            this.series = new ArrayList();
            int n2 = 0;
            while (n2 < this.numSeries) {
                this.series.add(new Chart3dPointSeries(this, point3dArray[n2]));
                ++n2;
            }
        }
        this.processData();
    }

    public void precomputePoints() {
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        boolean bl = false;
        if (this.screenPoints == null || this.screenPoints.length != this.numSeries) {
            this.screenPoints = new ScreenPoint[this.numSeries][];
            bl = true;
        }
        int n2 = 0;
        while (n2 < this.numSeries) {
            Chart3dPointSeries chart3dPointSeries = (Chart3dPointSeries)this.series.get(n2);
            int n3 = chart3dPointSeries.getNumPoints();
            boolean bl2 = false;
            if (bl || this.screenPoints[n2].length != n3) {
                this.screenPoints[n2] = new ScreenPoint[n3];
                bl2 = true;
            }
            int n4 = 0;
            while (n4 < n3) {
                Point3d point3d = chart3dPointSeries.getPoint(n4);
                ScreenPoint screenPoint = null;
                if (bl2) {
                    screenPoint = new ScreenPoint();
                } else {
                    screenPoint = this.screenPoints[n2][n4];
                    screenPoint.reset();
                }
                if (point3d.x == this.holeValue || point3d.y == this.holeValue || point3d.z == this.holeValue) {
                    screenPoint.setHoleValue(true);
                }
                JCAxis jCAxis = jCChart3dArea.getAxis(1);
                JCAxis jCAxis2 = jCChart3dArea.getAxis(2);
                JCAxis jCAxis3 = jCChart3dArea.getAxis(3);
                if (point3d.x > jCAxis.getMax() || point3d.x < jCAxis.getMin() || point3d.y > jCAxis2.getMax() || point3d.y < jCAxis2.getMin() || point3d.z > jCAxis3.getMax() || point3d.z < jCAxis3.getMin()) {
                    screenPoint.setHidden(true);
                }
                JCChart3dUtil.getScreenPoint(this.dataView.getChart3d(), point3d.x, point3d.y, point3d.z, jCAxis3.getMin(), screenPoint);
                this.screenPoints[n2][n4] = screenPoint;
                ++n4;
            }
            ++n2;
        }
        this.sorted = false;
    }

    protected void processData() {
        this.dataOK = true;
        if (this.numSeries < 1) {
            this.dataOK = false;
        }
        int n2 = 0;
        while (n2 < this.numSeries) {
            Chart3dPointSeries chart3dPointSeries = (Chart3dPointSeries)this.series.get(n2);
            if (chart3dPointSeries == null || chart3dPointSeries.getNumPoints() < 1) {
                this.dataOK = false;
            }
            ++n2;
        }
    }

    protected void refreshPointSeriesList(Point3d[][] point3dArray) {
        if (point3dArray == null || this.series == null || point3dArray.length != this.numSeries) {
            return;
        }
        int n2 = 0;
        while (n2 < this.numSeries) {
            Chart3dPointSeries chart3dPointSeries = (Chart3dPointSeries)this.series.get(n2);
            Point3d[] point3dArray2 = point3dArray[n2];
            chart3dPointSeries.setPoints(point3dArray2);
            ++n2;
        }
        this.processData();
    }

    protected void removeSeries(int n2) {
        if (this.series == null || n2 < 0 || n2 > this.series.size()) {
            return;
        }
        this.series.remove(n2);
        this.numSeries = this.series.size();
        this.processData();
    }

    protected void setDataSource(Chart3dPointDataModel chart3dPointDataModel) {
        this.dataSource = chart3dPointDataModel;
        if (chart3dPointDataModel == null) {
            this.makePointSeriesList(null);
            return;
        }
        if (this.dataHandler == null) {
            JCDebug.println("pointdata", "No data handler!!!");
            return;
        }
        this.dataHandler.reset(chart3dPointDataModel);
    }

    public void sortPoints() {
        if (this.sorted) {
            return;
        }
        if (!this.isDataOK()) {
            return;
        }
        if (this.sortPoints == null) {
            this.sortPoints = new ArrayList();
        } else {
            this.sortPoints.clear();
        }
        int n2 = 0;
        while (n2 < this.numSeries) {
            Chart3dPointSeries chart3dPointSeries = (Chart3dPointSeries)this.series.get(n2);
            int n3 = 0;
            while (n3 < chart3dPointSeries.getNumPoints()) {
                Point3d point3d = chart3dPointSeries.getPoint(n3);
                double d2 = JCChart3dUtil.distanceToEye(this.dataView.getChart3d(), point3d.x, point3d.y, point3d.z);
                SortPoint sortPoint = new SortPoint(n2, n3, d2);
                this.sortPoints.add(sortPoint);
                ++n3;
            }
            ++n2;
        }
        Collections.sort(this.sortPoints, this);
        this.sorted = true;
    }
}

