/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridDataHandler;
import com.klg.jclass.chart3d.Chart3dGridDataModel;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCBar;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dStyle;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCLineStyle;
import com.klg.jclass.chart3d.JCSymbolStyle;
import com.klg.jclass.chart3d.LabelledChart3dGridDataModel;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.util.JCDebug;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Color;
import javax.vecmath.Matrix4d;

public class Chart3dGridData
extends Chart3dData {
    protected double[] xGrid = null;
    protected double[] yGrid = null;
    protected double[][] zValues = null;
    protected int numX = 0;
    protected int numY = 0;
    protected JCChart3dStyle chartStyle = null;
    protected String[] xLabels = null;
    protected String[] yLabels = null;
    protected GridLimits gridLimits = new GridLimits(this, false);
    protected double minXStep = 0.0;
    protected double minYStep = 0.0;

    public Chart3dGridData() {
        this.dataHandler = new Chart3dGridDataHandler(this);
        this.chartStyle = new JCChart3dStyle(new JCLineStyle(1, Color.blue, 1), new JCSymbolStyle(JCSymbolStyle.getDefaultShape(null), Color.orange, 6));
        this.processData();
    }

    public Chart3dGridData(Chart3dDataView chart3dDataView, Chart3dGridDataModel chart3dGridDataModel) {
        super(chart3dDataView);
        this.dataHandler = new Chart3dGridDataHandler(this);
        this.chartStyle = new JCChart3dStyle(new JCLineStyle(1, Color.blue, 1), new JCSymbolStyle(JCSymbolStyle.getDefaultShape(null), Color.orange, 6));
        this.chartStyle.addParent(chart3dDataView);
        this.setDataSource(chart3dGridDataModel);
    }

    protected void calcAnnoLimits() {
        if (!this.dataOK) {
            return;
        }
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        JCAxis jCAxis = jCChart3dArea.getAxis(1);
        JCAxis jCAxis2 = jCChart3dArea.getAxis(2);
        JCAxis jCAxis3 = jCChart3dArea.getAxis(3);
        double d2 = this.xGrid[this.gridLimits.getXOffset()];
        double d3 = this.yGrid[this.gridLimits.getYOffset()];
        double d4 = this.xGrid[this.gridLimits.getXLast()];
        double d5 = this.yGrid[this.gridLimits.getYLast()];
        double d6 = jCAxis3.getMin();
        double d7 = jCAxis3.getMax();
        if (!jCChart3dArea.getChart3d().isProjection()) {
            JCBar jCBar = jCChart3dArea.getBar();
            if (this.dataView.getChartType() == 1) {
                double d8 = (d4 - d2) * 0.05;
                if (jCBar.getXFormat() == 1) {
                    d8 += this.minXStep / 2.0;
                }
                d2 -= d8;
                d4 += d8;
                d8 = (d5 - d3) * 0.05;
                if (jCBar.getYFormat() == 1) {
                    d8 += this.minYStep / 2.0;
                }
                d3 -= d8;
                d5 += d8;
                d6 = Math.min(d6, jCAxis3.getOrigin());
                d7 = Math.max(d7, jCAxis3.getOrigin());
            } else if (this.dataView.getChartType() == 2 && jCChart3dArea.getScatter().hasDropLines()) {
                d6 = Math.min(d6, jCAxis3.getOrigin());
                d7 = Math.max(d7, jCAxis3.getOrigin());
            }
        }
        d2 = Math.min(jCAxis.getMin(), d2);
        d3 = Math.min(jCAxis2.getMin(), d3);
        d4 = Math.max(jCAxis.getMax(), d4);
        d5 = Math.max(jCAxis2.getMax(), d5);
        jCAxis.setAnnoMin(d2);
        jCAxis.setAnnoMax(d4);
        jCAxis.setAnnoStep(0.0);
        jCAxis2.setAnnoMin(d3);
        jCAxis2.setAnnoMax(d5);
        jCAxis2.setAnnoStep(0.0);
        jCAxis3.setAnnoMin(d6);
        jCAxis3.setAnnoMax(d7);
        jCAxis3.setAnnoStep(0.0);
    }

    protected void calcLimits(Chart3dGridData chart3dGridData) {
        if (!this.dataOK || chart3dGridData == null) {
            return;
        }
        if (chart3dGridData.isDataOK() && !this.matchData(chart3dGridData)) {
            chart3dGridData.setDataOK(false);
            throw new IllegalArgumentException("Elevation data and Zone data do not match!");
        }
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        JCAxis jCAxis = jCChart3dArea.getAxis(1);
        jCAxis.min.setValue(this.xGrid[0]);
        jCAxis.max.setValue(this.xGrid[this.numX - 1]);
        JCDebug.println("griddata", "X Axis Min:" + jCAxis.getMin());
        JCDebug.println("griddata", "X Axis Max:" + jCAxis.getMax());
        jCAxis = jCChart3dArea.getAxis(2);
        jCAxis.min.setValue(this.yGrid[0]);
        jCAxis.max.setValue(this.yGrid[this.numY - 1]);
        JCDebug.println("griddata", "Y Axis Min:" + jCAxis.getMin());
        JCDebug.println("griddata", "Y Axis Max:" + jCAxis.getMax());
        this.gridLimits.assignGridValues(this);
        if (chart3dGridData.isDataOK()) {
            GridLimits gridLimits = chart3dGridData.getGridLimits();
            gridLimits.setXOffset(this.gridLimits.getXOffset());
            gridLimits.setYOffset(this.gridLimits.getYOffset());
            gridLimits.setXLast(this.gridLimits.getXLast());
            gridLimits.setYLast(this.gridLimits.getYLast());
        }
        jCAxis = jCChart3dArea.getAxis(3);
        this.computeZLimits(null, jCAxis.getMin(), jCAxis.getMax());
        this.checkValidZExtents();
        jCAxis.checkLimits(this.dataMin, this.dataMax);
        JCDebug.println("griddata", "Z Axis Min:" + jCAxis.getMin());
        JCDebug.println("griddata", "Z Axis Max:" + jCAxis.getMax());
        this.dataView.getContour().getContourLevels().calcLimits(this.dataView, this, chart3dGridData);
    }

    protected void computeZLimits(Chart3dGridData chart3dGridData, double d2, double d3) {
        if (!this.dataOK || chart3dGridData != null && !chart3dGridData.isDataOK()) {
            this.dataMin = Double.MAX_VALUE;
            this.dataMax = Double.MAX_VALUE;
            return;
        }
        int n2 = this.gridLimits.xOffset;
        int n3 = this.gridLimits.xLast;
        int n4 = this.gridLimits.yOffset;
        int n5 = this.gridLimits.yLast;
        double d4 = Double.MAX_VALUE;
        double d5 = Double.MAX_VALUE;
        int n6 = n2;
        while (n6 <= n3) {
            int n7 = n4;
            while (n7 <= n5) {
                boolean bl;
                boolean bl2 = bl = this.zValues[n6][n7] != this.getHoleValue();
                if (bl && chart3dGridData != null) {
                    boolean bl3 = bl = chart3dGridData.zValues[n6][n7] != chart3dGridData.getHoleValue();
                }
                if (bl) {
                    if (d4 == Double.MAX_VALUE) {
                        d4 = d5 = this.zValues[n6][n7];
                    } else if (this.zValues[n6][n7] > d5) {
                        d5 = this.zValues[n6][n7];
                    } else if (this.zValues[n6][n7] < d4) {
                        d4 = this.zValues[n6][n7];
                    }
                }
                ++n7;
            }
            ++n6;
        }
        if (d4 == Double.MAX_VALUE) {
            JCDebug.println("griddata", "Data is all holes");
            if (d2 == Double.MAX_VALUE) {
                d4 = 0.0;
                d5 = 1.0;
            } else {
                d4 = d2;
                d5 = d3;
            }
        }
        this.dataMin = d4;
        this.dataMax = d5;
    }

    public JCChart3dStyle getChartStyle() {
        return this.chartStyle;
    }

    public int getGridIndex(double d2, boolean bl, boolean bl2) {
        int n2;
        int n3 = this.dataView.getChartType();
        int n4 = bl ? this.numX : this.numY;
        double[] dArray = bl ? this.xGrid : this.yGrid;
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        JCBar jCBar = jCChart3dArea.getBar();
        if (bl2) {
            Matrix4d matrix4d = jCChart3dArea.getTransform().getAbsolute();
            d2 = bl ? (d2 - matrix4d.m03) / matrix4d.m00 : (d2 - matrix4d.m13) / matrix4d.m11;
        }
        int n5 = this.getPointIndex(d2, dArray, n4);
        int n6 = bl ? this.gridLimits.getXOffset() : this.gridLimits.getYOffset();
        int n7 = bl ? this.gridLimits.getXLast() : this.gridLimits.getYLast();
        int n8 = n2 = bl ? jCBar.getXFormat() : jCBar.getYFormat();
        if (n3 == 2 || n3 == 1 && n2 == 1) {
            if (n5 > n4 - 2) {
                n5 = n4 - 1;
            } else if (d2 + d2 > dArray[n5] + dArray[n5 + 1]) {
                ++n5;
            }
            n5 = JCNumberUtil.clamp(n5, n6, n7);
        } else {
            n5 = !bl2 && n3 != 1 ? JCNumberUtil.clamp(n5, n6, n7) : JCNumberUtil.clamp(n5, n6, n7 - 1);
        }
        return n5;
    }

    public GridLimits getGridLimits() {
        return this.gridLimits;
    }

    public double getMinXStep() {
        return this.minXStep;
    }

    public double getMinYStep() {
        return this.minYStep;
    }

    public int getNumX() {
        return this.numX;
    }

    public int getNumY() {
        return this.numY;
    }

    public double getX(int n2) {
        if (this.xGrid == null) {
            return Double.MAX_VALUE;
        }
        return this.xGrid[n2];
    }

    public int getXClosest(double d2) {
        return this.getClosestPoint(d2, this.xGrid, this.numX);
    }

    public double[] getXGrid() {
        return this.xGrid;
    }

    public String[] getXLabels() {
        return this.xLabels;
    }

    public double getY(int n2) {
        if (this.yGrid == null) {
            return Double.MAX_VALUE;
        }
        return this.yGrid[n2];
    }

    public int getYClosest(double d2) {
        return this.getClosestPoint(d2, this.yGrid, this.numY);
    }

    public double[] getYGrid() {
        return this.yGrid;
    }

    public String[] getYLabels() {
        return this.yLabels;
    }

    public double getZValue(int n2, int n3) {
        if (this.zValues == null || this.zValues[n2] == null) {
            return Double.MAX_VALUE;
        }
        return this.zValues[n2][n3];
    }

    public double[][] getZValues() {
        return this.zValues;
    }

    protected boolean matchData(Chart3dGridData chart3dGridData) {
        if (!this.dataOK || chart3dGridData == null || !chart3dGridData.isDataOK()) {
            return false;
        }
        if (this.numX != chart3dGridData.getNumX() || this.numY != chart3dGridData.getNumY()) {
            return false;
        }
        int n2 = 0;
        while (n2 < this.numX) {
            if (this.xGrid[n2] != chart3dGridData.getX(n2)) {
                return false;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.numY) {
            if (this.yGrid[n3] != chart3dGridData.getY(n3)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public void precomputePoints() {
        JCChart3dArea jCChart3dArea = this.dataView.getChart3d().getChart3dArea();
        boolean bl = false;
        if (this.screenPoints == null || this.screenPoints.length != this.numX || this.screenPoints[0].length != this.numY) {
            this.screenPoints = new ScreenPoint[this.numX][this.numY];
            bl = true;
        }
        int n2 = this.gridLimits.getXOffset();
        while (n2 <= this.gridLimits.getXLast()) {
            int n3 = this.gridLimits.getYOffset();
            while (n3 <= this.gridLimits.getYLast()) {
                double d2 = this.xGrid[n2];
                double d3 = this.yGrid[n3];
                double d4 = this.zValues[n2][n3];
                ScreenPoint screenPoint = null;
                if (bl) {
                    screenPoint = new ScreenPoint();
                } else {
                    screenPoint = this.screenPoints[n2][n3];
                    screenPoint.reset();
                }
                screenPoint.setHoleValue(d4 == this.getHoleValue());
                JCChart3dUtil.getScreenPoint(this.dataView.getChart3d(), d2, d3, d4, this.dataMin, screenPoint);
                this.screenPoints[n2][n3] = screenPoint;
                ++n3;
            }
            ++n2;
        }
        jCChart3dArea.getSurface().computeMeshFiltering(this.dataView);
    }

    protected void processData() {
        int n2;
        this.numY = 0;
        this.numX = 0;
        if (this.zValues != null) {
            if (this.xGrid != null) {
                this.numX = this.xGrid.length;
            }
            if (this.yGrid != null) {
                this.numY = this.yGrid.length;
            }
            this.numX = Math.min(this.numX, this.zValues.length);
            n2 = 0;
            while (n2 < this.numX) {
                this.numY = Math.min(this.numY, this.zValues[n2].length);
                ++n2;
            }
        }
        this.dataOK = true;
        if (this.numX < 1 || this.numY < 1) {
            this.dataOK = false;
        }
        n2 = 1;
        while (this.dataOK && n2 < this.numX) {
            if (this.xGrid[n2 - 1] >= this.xGrid[n2]) {
                this.dataOK = false;
            }
            ++n2;
        }
        int n3 = 1;
        while (this.dataOK && n3 < this.numY) {
            if (this.yGrid[n3 - 1] >= this.yGrid[n3]) {
                this.dataOK = false;
            }
            ++n3;
        }
        this.minXStep = this.getMinStep(this.xGrid, this.numX);
        this.minYStep = this.getMinStep(this.yGrid, this.numY);
    }

    protected void setAllXYZValues(double[] dArray, double[] dArray2, double[][] dArray3) {
        this.xGrid = dArray;
        this.yGrid = dArray2;
        this.zValues = dArray3;
        this.processData();
    }

    public void setChartStyle(JCChart3dStyle jCChart3dStyle) {
        if (this.chartStyle == jCChart3dStyle) {
            return;
        }
        this.chartStyle = jCChart3dStyle;
        if (this.chartStyle != null) {
            this.chartStyle.addParent(this.dataView);
        }
        this.setChanged(true, 33);
    }

    protected void setDataSource(Chart3dGridDataModel chart3dGridDataModel) {
        this.dataSource = chart3dGridDataModel;
        if (chart3dGridDataModel == null) {
            this.xGrid = null;
            this.yGrid = null;
            this.zValues = null;
            this.holeValue = Double.MAX_VALUE;
            this.name = null;
            this.processData();
            return;
        }
        if (this.dataHandler == null) {
            JCDebug.println("griddata", "No data handler!!!");
            return;
        }
        this.dataHandler.reset(chart3dGridDataModel);
        if (chart3dGridDataModel instanceof LabelledChart3dGridDataModel) {
            LabelledChart3dGridDataModel labelledChart3dGridDataModel = (LabelledChart3dGridDataModel)((Object)chart3dGridDataModel);
            this.xLabels = labelledChart3dGridDataModel.getXLabels();
            this.yLabels = labelledChart3dGridDataModel.getYLabels();
        }
    }

    protected void setXGrid(double[] dArray) {
        this.xGrid = dArray;
        this.processData();
    }

    public void setXLabels(String[] stringArray) {
        this.xLabels = stringArray;
        this.setChanged(true, 2);
    }

    protected void setYGrid(double[] dArray) {
        this.yGrid = dArray;
        this.processData();
    }

    public void setYLabels(String[] stringArray) {
        this.yLabels = stringArray;
        this.setChanged(true, 2);
    }

    protected void setZValues(double[][] dArray) {
        this.zValues = dArray;
        this.processData();
    }
}

