/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Anno;
import com.klg.jclass.chart3d.Changeable;
import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataHandler;
import com.klg.jclass.chart3d.Chart3dDataModel;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.Chart3dGridDataModel;
import com.klg.jclass.chart3d.Chart3dPointData;
import com.klg.jclass.chart3d.Chart3dPointDataModel;
import com.klg.jclass.chart3d.Cube;
import com.klg.jclass.chart3d.Draw;
import com.klg.jclass.chart3d.DrawGrid;
import com.klg.jclass.chart3d.DrawPoint;
import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCChart3d;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCContour;
import com.klg.jclass.chart3d.JCData3dGridIndex;
import com.klg.jclass.chart3d.JCData3dIndex;
import com.klg.jclass.chart3d.JCData3dPointIndex;
import com.klg.jclass.chart3d.JCElevation;
import com.klg.jclass.chart3d.JCGridColor;
import com.klg.jclass.chart3d.JCPlotCube;
import com.klg.jclass.chart3d.Mapping;
import com.klg.jclass.chart3d.TrackChange;
import com.klg.jclass.chart3d.Transform;
import com.klg.jclass.chart3d.event.Chart3dDataEvent;
import com.klg.jclass.chart3d.event.Chart3dDataListener;
import com.klg.jclass.chart3d.event.Chart3dDataManager;
import com.klg.jclass.chart3d.event.Chart3dGridDataEvent;
import com.klg.jclass.chart3d.event.Chart3dPointDataEvent;
import com.klg.jclass.util.JCDebug;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ArrayList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector2d;

public class Chart3dDataView
extends TrackChange
implements Chart3dDataListener {
    static final long serialVersionUID = -5542417106751358122L;
    public static final int MESHED = 1;
    public static final int SHADED = 2;
    public static final int ZONED = 4;
    public static final int CONTOURED = 8;
    protected JCChart3d chart3d = null;
    protected Chart3dDataModel elevationDataSource = null;
    protected Chart3dData elevationData = new Chart3dGridData(this, null);
    protected Chart3dGridDataModel zoneDataSource = null;
    protected Chart3dGridData zoneData = new Chart3dGridData(this, null);
    protected int chartType = 0;
    protected JCElevation elevation = null;
    protected JCContour contour = null;
    protected String name = null;
    protected ArrayList gridColors = null;
    protected Draw draw = null;
    protected Mapping mapping = null;
    protected Chart3dDataHandler dataHandler = null;
    protected boolean dataDrawn = false;
    protected int drawCode = 0;
    protected boolean defaultsCalculated = false;
    protected int dataViewId = -1;
    protected boolean batched = false;

    public Chart3dDataView() {
    }

    public Chart3dDataView(JCChart3d jCChart3d, int n2) {
        this.chart3d = jCChart3d;
        this.dataViewId = n2;
    }

    public Chart3dDataView(JCChart3d jCChart3d, int n2, int n3) {
        this.chart3d = jCChart3d;
        this.dataViewId = n2;
        this.chartType = n3;
    }

    public void addGridColor(int n2, int n3, Color color) {
        this.addGridColor(new JCGridColor(n2, n3, color));
    }

    public void addGridColor(JCGridColor jCGridColor) {
        if (jCGridColor == null) {
            return;
        }
        int n2 = jCGridColor.getX();
        int n3 = jCGridColor.getY();
        if (n2 < 0 && n2 != -100 || n3 < 0 && n3 != -100) {
            throw new IllegalArgumentException("Invalid x or y index");
        }
        if (this.gridColors == null) {
            this.gridColors = new ArrayList();
        }
        this.removeGridColor(jCGridColor.getX(), jCGridColor.getY(), this.gridColors.size(), false);
        if (jCGridColor.getColor() != null) {
            this.gridColors.add(jCGridColor);
            jCGridColor.parent = this;
        }
        this.setChanged(true, 1);
    }

    public void calcDefaults() {
        this.computeDataLimits();
        this.computeDataDrawn();
        if (this.elevationData.isDataOK() && this.isDataDrawn() && this.elevationData instanceof Chart3dGridData) {
            this.contour.getContourLevels().calcLevels();
        }
    }

    public void chart3dDataChange(Chart3dDataEvent chart3dDataEvent) {
        Object object;
        if (chart3dDataEvent == null) {
            return;
        }
        Object object2 = chart3dDataEvent.getSource();
        if (object2 == null) {
            return;
        }
        Chart3dData chart3dData = null;
        Chart3dData chart3dData2 = null;
        if (object2 instanceof Chart3dGridDataModel) {
            object = (Chart3dGridDataModel)object2;
            if (object == this.elevationDataSource && this.elevationData instanceof Chart3dGridData) {
                chart3dData = (Chart3dGridData)this.elevationData;
            } else if (object == this.zoneDataSource) {
                chart3dData = this.zoneData;
            }
        } else if (object2 instanceof Chart3dPointDataModel && (object = (Chart3dPointDataModel)object2) == this.elevationDataSource && this.elevationData instanceof Chart3dPointData) {
            chart3dData2 = (Chart3dPointData)this.elevationData;
        }
        object = null;
        if (chart3dData != null) {
            if (chart3dDataEvent instanceof Chart3dPointDataEvent) {
                return;
            }
            object = chart3dData.getDataHandler();
        }
        if (chart3dData2 != null) {
            if (chart3dDataEvent instanceof Chart3dGridDataEvent) {
                return;
            }
            object = chart3dData2.getDataHandler();
        }
        if (object != null && ((Chart3dDataHandler)object).handleEvent((Chart3dDataModel)object2, chart3dDataEvent)) {
            this.setChanged(true, 290);
        }
    }

    protected void computeDataDrawn() {
        this.drawCode = 0;
        if (this.elevation.isMeshed()) {
            this.drawCode |= 1;
        }
        if (this.elevation.isShaded()) {
            this.drawCode |= 2;
        }
        if (this.contour != null) {
            if (this.contour.isZoned()) {
                this.drawCode |= 4;
            }
            if (this.contour.isContoured()) {
                this.drawCode |= 8;
            }
        }
        JCChart3dArea jCChart3dArea = this.chart3d.getChart3dArea();
        this.dataDrawn = this.chart3d.isProjection() ? this.drawCode >= 4 : this.drawCode != 0;
        this.dataDrawn = this.dataDrawn && (this.chartType == 2 || this.elevationData instanceof Chart3dGridData);
    }

    protected void computeDataLimits() {
        if (this.elevationDataSource != null && !this.elevationData.isDataOK()) {
            JCDebug.println("dataview", "Bad elevation data!");
            return;
        }
        if (this.zoneDataSource != null && !this.zoneData.isDataOK()) {
            JCDebug.println("dataview", "Bad zone data!");
            return;
        }
        this.defaultsCalculated = false;
        if (this.elevationData instanceof Chart3dPointData) {
            Chart3dPointData chart3dPointData = (Chart3dPointData)this.elevationData;
            chart3dPointData.calcLimits();
        } else {
            Chart3dGridData chart3dGridData = (Chart3dGridData)this.elevationData;
            chart3dGridData.calcLimits(this.zoneData);
        }
    }

    public Point3d coordToDataCoord(int n2, int n3) {
        return this.map(n2, n3);
    }

    public JCData3dIndex coordToDataIndex(int n2, int n3) {
        Point point = this.chart3d.getChart3dArea().getLocation();
        return this.chart3d.getChart3dArea().pick(new Point(n2 - point.x, n3 - point.y), this);
    }

    public void createDraw() {
        boolean bl = this.elevationData instanceof Chart3dGridData;
        if (this.draw == null) {
            this.draw = bl ? new DrawGrid(this) : new DrawPoint(this);
        } else {
            if (bl && this.draw instanceof DrawPoint) {
                this.draw = new DrawGrid(this);
            }
            if (!bl && this.draw instanceof DrawGrid) {
                this.draw = new DrawPoint(this);
            }
        }
        if (this.draw.getMapping() == null || this.draw.getMapping().getData() != this.elevationData) {
            if (this.mapping == null) {
                JCDebug.println("dataview", "The mapping object is null!");
                return;
            }
            this.draw.setMapping(this.mapping.createMapping(this.elevationData));
        }
    }

    public Point dataCoordToCoord(Point3d point3d) {
        return this.unmap(point3d);
    }

    public Point dataIndexToCoord(JCData3dIndex jCData3dIndex) {
        return this.chart3d.unpick(this, jCData3dIndex);
    }

    protected void doPreprocessing() {
        if (!this.isDataDrawn()) {
            return;
        }
        this.createDraw();
        if (!this.chart3d.isProjection()) {
            this.chart3d.getChart3dArea().getTransform().calcProcessingOrder();
            if (this.elevationData instanceof Chart3dGridData) {
                DrawGrid drawGrid = (DrawGrid)this.draw;
                drawGrid.getGridRegion().calcRegions();
            }
        }
        if (this.chartType != 0 || this.drawCode != 8) {
            this.elevationData.precomputePoints();
        }
        if (this.chartType != 2 && this.drawCode >= 4) {
            this.contour.precompContours();
        }
    }

    public double dragZValue(Chart3dData chart3dData, JCData3dIndex jCData3dIndex, int n2, int n3) {
        double d2;
        Serializable serializable;
        int n4;
        int n5;
        Serializable serializable2;
        Changeable changeable;
        if (chart3dData == null || !chart3dData.isDataOK() || jCData3dIndex == null) {
            throw new IllegalArgumentException("Bad data or index");
        }
        boolean bl = chart3dData instanceof Chart3dGridData;
        if (bl && !(jCData3dIndex instanceof JCData3dGridIndex) || !bl && jCData3dIndex instanceof JCData3dGridIndex) {
            throw new IllegalArgumentException("Data and index do not match");
        }
        Point point = this.chart3d.getChart3dArea().getLocation();
        n2 -= point.x;
        n3 -= point.y;
        double d3 = Double.MAX_VALUE;
        double d4 = Double.MAX_VALUE;
        double d5 = chart3dData.getHoleValue();
        if (bl) {
            changeable = (Chart3dGridData)chart3dData;
            serializable2 = (JCData3dGridIndex)jCData3dIndex;
            n5 = ((JCData3dGridIndex)serializable2).getX();
            n4 = ((JCData3dGridIndex)serializable2).getY();
            if (n5 < 0 || n5 >= ((Chart3dGridData)changeable).getNumX() || n4 < 0 || n4 >= ((Chart3dGridData)changeable).getNumY()) {
                throw new IllegalArgumentException("Invalid x or y index");
            }
            d3 = ((Chart3dGridData)changeable).getX(n5);
            d4 = ((Chart3dGridData)changeable).getY(n4);
            d5 = ((Chart3dGridData)changeable).getZValue(n5, n4);
        } else {
            changeable = (Chart3dPointData)chart3dData;
            serializable2 = (JCData3dPointIndex)jCData3dIndex;
            n5 = ((JCData3dPointIndex)serializable2).getSeries();
            n4 = ((JCData3dPointIndex)serializable2).getPoint();
            if (n5 < 0 || n5 >= ((Chart3dPointData)changeable).getNumSeries() || n4 < 0 || n4 >= ((Chart3dPointData)changeable).getSeries(n5).getNumPoints()) {
                throw new IllegalArgumentException("Bad series or point value.");
            }
            serializable = ((Chart3dPointData)changeable).getSeries(n5).getPoint(n4);
            d3 = serializable.x;
            d4 = serializable.y;
            d5 = serializable.z;
        }
        if (d5 == chart3dData.getHoleValue()) {
            return d5;
        }
        changeable = chart3dData.getDataView().getChart3d().getChart3dArea();
        serializable2 = ((JCChart3dArea)changeable).getAxis(3);
        Transform transform = ((JCChart3dArea)changeable).getTransform();
        Point4d point4d = new Point4d(d3, d4, ((JCAxis)serializable2).getMin(), 1.0);
        Transform.transformPoint(transform.getView(), point4d);
        serializable = new Point((int)Math.round(point4d.x), (int)Math.round(point4d.y));
        point4d.set(d3, d4, ((JCAxis)serializable2).getMax(), 1.0);
        Transform.transformPoint(transform.getView(), point4d);
        Point point2 = new Point((int)Math.round(point4d.x), (int)Math.round(point4d.y));
        Point point3 = new Point(n2, n3);
        Vector2d vector2d = new Vector2d(point2.x - ((Point)serializable).x, point2.y - ((Point)serializable).y);
        Vector2d vector2d2 = new Vector2d(point3.x - ((Point)serializable).x, point3.y - ((Point)serializable).y);
        double d6 = vector2d.dot(vector2d2);
        double d7 = vector2d.x * vector2d.x + vector2d.y * vector2d.y;
        if (1.0 + d7 == 1.0) {
            return d5;
        }
        double d8 = d6 / d7;
        double[] dArray = new double[]{d8 * vector2d.x + (double)((Point)serializable).x, d8 * vector2d.y + (double)((Point)serializable).y};
        Matrix4d matrix4d = transform.getView();
        double d9 = 0.0;
        int n6 = -1;
        int n7 = 0;
        while (n7 < 2) {
            d2 = Math.abs(dArray[n7] * matrix4d.m32 - matrix4d.getElement(n7, 2));
            if (d9 < d2) {
                d9 = d2;
                n6 = n7;
            }
            ++n7;
        }
        if (n6 < 0 || d9 + 1.0 == 1.0) {
            return d5;
        }
        d2 = dArray[n6];
        double d10 = d2 * matrix4d.m30 - matrix4d.getElement(n6, 0);
        double d11 = d2 * matrix4d.m31 - matrix4d.getElement(n6, 1);
        double d12 = d2 * matrix4d.m32 - matrix4d.getElement(n6, 2);
        double d13 = d2 * matrix4d.m33 - matrix4d.getElement(n6, 3);
        d5 = -(d10 * d3 + d11 * d4 + d13) / d12;
        return d5;
    }

    protected void drawGraph(Graphics graphics) {
        boolean bl = false;
        boolean bl2 = false;
        JCChart3dArea jCChart3dArea = this.getChart3d().getChart3dArea();
        Anno anno = jCChart3dArea.getAnno();
        Cube cube = jCChart3dArea.getCube();
        JCPlotCube jCPlotCube = jCChart3dArea.getPlotCube();
        boolean bl3 = this.elevationData instanceof Chart3dGridData;
        if (this.chart3d.isProjection()) {
            if (this.isDataDrawn() && (this.elevationData.isDataOK() || this.zoneData.isDataOK())) {
                boolean bl4;
                this.doPreprocessing();
                jCPlotCube.drawBoundingBox(graphics, true);
                boolean bl5 = bl4 = !bl3 || this.chartType == 2;
                if (!bl4) {
                    JCContour jCContour = this.getContour();
                    jCContour.draw2dZones(graphics);
                    jCContour.drawContours(graphics);
                }
                anno.draw2dAnno(graphics);
                jCPlotCube.drawGridLines(graphics);
                jCPlotCube.drawBoundingBox(graphics, false);
                if (bl4) {
                    this.draw.draw2dPoints(graphics);
                }
            }
        } else if (this.elevationData.isDataOK()) {
            if (this.chartType == 0 && jCPlotCube.hasProjections()) {
                bl = cube.faceBackfacing(4);
                bl2 = cube.faceBackfacing(5);
            }
            this.doPreprocessing();
            anno.draw3dAnno(graphics);
            jCPlotCube.drawBoundingBox(graphics, true);
            if (this.chartType == 0 && bl3) {
                if (jCPlotCube.hasFloorProjection() && bl) {
                    jCPlotCube.drawProjection(graphics, true);
                }
                if (jCPlotCube.hasCeilingProjection() && bl2) {
                    jCPlotCube.drawProjection(graphics, false);
                }
            }
            jCPlotCube.drawGridLines(graphics);
            if (this.isDataDrawn()) {
                this.draw.draw(graphics);
            }
            if (this.chartType == 0 && bl3) {
                if (jCPlotCube.hasCeilingProjection() && !bl2) {
                    jCPlotCube.drawProjection(graphics, false);
                    jCPlotCube.finishEdges(graphics);
                }
                if (jCPlotCube.hasFloorProjection() && !bl) {
                    jCPlotCube.drawProjection(graphics, true);
                    jCPlotCube.finishEdges(graphics);
                }
            }
        }
    }

    protected void filterGridColors() {
        Object object;
        if (this.gridColors == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.gridColors.size()) {
            JCGridColor jCGridColor = (JCGridColor)this.gridColors.get(n2);
            object = jCGridColor.getDataIndex();
            if (n2 == 0) {
                if (jCGridColor.getColor() == null) {
                    this.gridColors.remove(n2);
                    continue;
                }
                ++n2;
                continue;
            }
            if (this.removeGridColor(((JCData3dGridIndex)object).getX(), ((JCData3dGridIndex)object).getY(), n2, false)) {
                if (jCGridColor.getColor() != null) continue;
                this.gridColors.remove(--n2);
                continue;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.gridColors.size()) {
            object = (JCGridColor)this.gridColors.get(n3);
            ((JCGridColor)object).parent = this;
            ++n3;
        }
    }

    public JCGridColor findGridColor(int n2, int n3) {
        if (this.gridColors == null || this.gridColors.size() == 0) {
            return null;
        }
        JCGridColor jCGridColor = null;
        int n4 = this.gridColors.size() - 1;
        while (jCGridColor == null && n4 >= 0) {
            JCGridColor jCGridColor2 = (JCGridColor)this.gridColors.get(n4);
            int n5 = jCGridColor2.dataIndex.getX();
            int n6 = jCGridColor2.dataIndex.getY();
            if (!(n5 != -100 && n5 != n2 || n6 != -100 && n6 != n3)) {
                jCGridColor = jCGridColor2;
                break;
            }
            --n4;
        }
        return jCGridColor;
    }

    public JCChart3d getChart3d() {
        return this.chart3d;
    }

    public int getChartType() {
        return this.chartType;
    }

    public JCContour getContour() {
        return this.contour;
    }

    public int getDataViewId() {
        return this.dataViewId;
    }

    public Draw getDraw() {
        return this.draw;
    }

    public int getDrawCode() {
        return this.drawCode;
    }

    public JCElevation getElevation() {
        return this.elevation;
    }

    public Chart3dData getElevationData() {
        return this.elevationData;
    }

    public Chart3dDataModel getElevationDataSource() {
        return this.elevationDataSource;
    }

    public ArrayList getGridColors() {
        return this.gridColors;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public String getName() {
        return this.name;
    }

    public Chart3dGridData getZoneData() {
        return this.zoneData;
    }

    public Chart3dGridDataModel getZoneDataSource() {
        return this.zoneDataSource;
    }

    public double gridValue(Chart3dGridData chart3dGridData, double d2, double d3) {
        if (chart3dGridData == null || !chart3dGridData.isDataOK()) {
            throw new IllegalArgumentException("Bad data or index");
        }
        int n2 = chart3dGridData.getNumX();
        int n3 = chart3dGridData.getNumY();
        double d4 = chart3dGridData.getHoleValue();
        if (d2 < chart3dGridData.getX(0) || d2 > chart3dGridData.getX(n2 - 1) || d3 < chart3dGridData.getY(0) || d3 > chart3dGridData.getY(n3 - 1)) {
            return d4;
        }
        int n4 = chart3dGridData.getPointIndex(d2, chart3dGridData.getXGrid(), n2);
        int n5 = chart3dGridData.getPointIndex(d3, chart3dGridData.getYGrid(), n3);
        if (n4 + 1 == n2) {
            --n4;
        }
        if (n5 + 1 == n3) {
            --n5;
        }
        if (!JCChart3dUtil.holeInFacet(chart3dGridData, n4, n5)) {
            d4 = JCChart3dUtil.biLinearInterp(chart3dGridData, n4, n5, d2, d3);
        }
        return d4;
    }

    public boolean isBatched() {
        return this.batched;
    }

    public boolean isDataDrawn() {
        return this.dataDrawn;
    }

    public Point3d map(int n2, int n3) {
        Rectangle rectangle = this.chart3d.getChart3dArea().getDrawingArea();
        Point point = this.chart3d.getChart3dArea().getLocation();
        this.createDraw();
        return this.draw.getMapping().map(n2 -= rectangle.x + point.x, n3 -= rectangle.y + point.y);
    }

    private void markAsChanged(int n2) {
        if (this.chart3d != null && this.chart3d.getChart3dArea() != null) {
            this.chart3d.getChart3dArea().setChanged(true, n2 & 3, false);
        }
        if ((n2 & 0x100) > 0 && this.contour != null) {
            this.contour.destroyContours();
        }
        int n3 = 0;
        if ((n2 & 0x20) > 0) {
            n3 |= 2;
        } else if ((n2 & 0x10) > 0) {
            n3 |= 1;
        }
        if (n3 != 0 && this.chart3d != null && this.chart3d.getLegend() != null) {
            this.chart3d.getLegend().setChanged(true, n3, false);
        }
    }

    private void propagateChange() {
        if (!this.changed) {
            return;
        }
        if (this.isBatched()) {
            return;
        }
        if (this.chart3d == null || this.chart3d.isBatched()) {
            return;
        }
        this.chart3d.update();
        this.setChanged(false, 0);
    }

    public boolean removeGridColor(int n2, int n3) {
        if (this.gridColors == null) {
            return false;
        }
        return this.removeGridColor(n2, n3, this.gridColors.size(), true);
    }

    protected boolean removeGridColor(int n2, int n3, int n4, boolean bl) {
        if (this.gridColors == null || this.gridColors.size() == 0) {
            return false;
        }
        n4 = Math.min(n4, this.gridColors.size());
        int n5 = n4 - 1;
        while (n5 >= 0) {
            JCGridColor jCGridColor = (JCGridColor)this.gridColors.get(n5);
            JCData3dGridIndex jCData3dGridIndex = jCGridColor.getDataIndex();
            if (jCData3dGridIndex.getX() == n2 && jCData3dGridIndex.getY() == n3) {
                this.gridColors.remove(n5);
                if (bl) {
                    this.setChanged(true, 1);
                }
                return true;
            }
            --n5;
        }
        return false;
    }

    public void setBatched(boolean bl) {
        if (this.batched == bl) {
            return;
        }
        this.batched = bl;
        if (!this.batched) {
            this.propagateChange();
        }
    }

    public void setChanged(boolean bl, int n2) {
        this.changed = bl;
        if (!this.changed) {
            this.changedFlag = n2;
            return;
        }
        this.changedFlag |= n2;
        this.markAsChanged(n2);
        this.propagateChange();
    }

    public void setChanged(boolean bl, int n2, boolean bl2) {
        if (this.changed == bl && (this.changedFlag & n2) == n2) {
            return;
        }
        if (bl2) {
            this.setChanged(bl, n2);
        } else {
            this.changed = bl;
            if (this.changed) {
                this.changedFlag |= n2;
                this.markAsChanged(n2);
            } else {
                this.changedFlag = n2;
            }
        }
    }

    public void setChart3d(JCChart3d jCChart3d) {
        if (this.chart3d == jCChart3d) {
            return;
        }
        this.chart3d = jCChart3d;
        this.setChanged(true, 290);
    }

    public void setChartType(int n2) {
        if (this.chartType == n2) {
            return;
        }
        if (n2 < 0 || n2 >= 3) {
            throw new IllegalArgumentException("Invalid value.  It must be one of JCChart3d.SURFACE, JCChart3d.BAR, or JCChart3d.SCATTER.");
        }
        this.chartType = n2;
        this.setChanged(true, 34);
    }

    public void setContour(JCContour jCContour) {
        if (this.contour == jCContour) {
            return;
        }
        this.contour = jCContour;
        if (this.contour == null) {
            throw new IllegalArgumentException("Invalid value. Cannot be null.");
        }
        this.contour.setDataView(this);
    }

    public void setDataViewId(int n2) {
        if (this.dataViewId == n2) {
            return;
        }
        this.dataViewId = n2;
        this.setChanged(true, 33);
    }

    public void setElevation(JCElevation jCElevation) {
        if (this.elevation == jCElevation) {
            return;
        }
        this.elevation = jCElevation;
        if (this.elevation == null) {
            throw new IllegalArgumentException("Invalid value. Cannot be null.");
        }
        this.elevation.addParent(this);
        this.setChanged(true, 34);
    }

    public void setElevationDataSource(Chart3dDataModel chart3dDataModel) {
        if (this.elevationDataSource instanceof Chart3dDataManager) {
            ((Chart3dDataManager)((Object)this.elevationDataSource)).removeChart3dDataListener(this);
        }
        boolean bl = this.isBatched();
        this.setBatched(true);
        this.elevationDataSource = chart3dDataModel;
        if (chart3dDataModel == null) {
            this.elevationData = new Chart3dGridData(this, null);
        } else {
            if (chart3dDataModel instanceof Chart3dGridDataModel) {
                Chart3dGridDataModel chart3dGridDataModel = (Chart3dGridDataModel)chart3dDataModel;
                if (this.elevationData == null || this.elevationData instanceof Chart3dPointData) {
                    this.elevationData = new Chart3dGridData(this, chart3dGridDataModel);
                } else {
                    Chart3dGridData chart3dGridData = (Chart3dGridData)this.elevationData;
                    chart3dGridData.setDataSource(chart3dGridDataModel);
                }
            } else if (chart3dDataModel instanceof Chart3dPointDataModel) {
                Chart3dPointDataModel chart3dPointDataModel = (Chart3dPointDataModel)chart3dDataModel;
                if (this.elevationData == null || this.elevationData instanceof Chart3dGridData) {
                    this.elevationData = new Chart3dPointData(this, chart3dPointDataModel);
                } else {
                    Chart3dPointData chart3dPointData = (Chart3dPointData)this.elevationData;
                    chart3dPointData.setDataSource(chart3dPointDataModel);
                }
            } else {
                throw new IllegalArgumentException("Invalid value for elevationDataSource in Chart3dDataView. Unrecognized data model.");
            }
            if (chart3dDataModel instanceof Chart3dDataManager) {
                ((Chart3dDataManager)((Object)chart3dDataModel)).addChart3dDataListener(this);
            }
        }
        this.setChanged(true, 290, false);
        this.setBatched(bl);
    }

    public void setGridColors(ArrayList arrayList) {
        this.gridColors = arrayList;
        this.filterGridColors();
        this.setChanged(true, 1);
    }

    public void setMapping(Mapping mapping) {
        this.mapping = mapping;
    }

    public void setName(String string) {
        if (this.name == string) {
            return;
        }
        this.name = string;
        this.setChanged(true, 32);
    }

    public void setZoneDataSource(Chart3dGridDataModel chart3dGridDataModel) {
        if (this.zoneDataSource instanceof Chart3dDataManager) {
            ((Chart3dDataManager)((Object)this.zoneDataSource)).removeChart3dDataListener(this);
        }
        boolean bl = this.isBatched();
        this.setBatched(true);
        this.zoneDataSource = chart3dGridDataModel;
        if (chart3dGridDataModel == null) {
            this.zoneData = new Chart3dGridData(this, null);
        } else {
            if (this.zoneData == null) {
                this.zoneData = new Chart3dGridData(this, chart3dGridDataModel);
            } else {
                this.zoneData.setDataSource(chart3dGridDataModel);
            }
            if (chart3dGridDataModel instanceof Chart3dDataManager) {
                ((Chart3dDataManager)((Object)chart3dGridDataModel)).addChart3dDataListener(this);
            }
        }
        this.setChanged(true, 290, false);
        this.setBatched(bl);
    }

    public Point unmap(Point3d point3d) {
        Rectangle rectangle = this.chart3d.getChart3dArea().getDrawingArea();
        Point point = this.chart3d.getChart3dArea().getLocation();
        this.createDraw();
        Point point2 = this.draw.getMapping().unmap(point3d);
        if (point2 != null) {
            point2.x += rectangle.x + point.x;
            point2.y += rectangle.y + point.y;
        }
        return point2;
    }
}

