/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Anno;
import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dNumberFormat;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCLabelGenerator;
import com.klg.jclass.chart3d.JCValueLabel;
import com.klg.jclass.util.JCDebug;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class Chart3dAnnoHandler
implements Comparator,
Serializable {
    protected ArrayList valueLabels = new ArrayList();
    protected ArrayList userValueLabels = new ArrayList();
    protected double annoHeight = 0.0;
    protected double annoShift = 0.0;
    protected JCAxis axis = null;

    public Chart3dAnnoHandler(JCAxis jCAxis) {
        this.axis = jCAxis;
    }

    protected void calcAnnoHeight(Graphics graphics) {
        this.annoHeight = 0.0;
        this.annoShift = 0.0;
        Font font = this.axis.getAnnoFont();
        if (graphics == null || this.valueLabels == null || this.valueLabels.size() == 0 || font == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        int n2 = 0;
        while (n2 < this.valueLabels.size()) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.valueLabels.get(n2);
            if (jCValueLabel.getLabel() != null && !jCValueLabel.isTickOnly()) {
                TextLayout textLayout = new TextLayout(jCValueLabel.getLabel(), font, fontRenderContext);
                Rectangle2D rectangle2D = textLayout.getBounds();
                d2 = Math.min(d2, rectangle2D.getY());
                d3 = Math.max(d3, rectangle2D.getY() + rectangle2D.getHeight());
            }
            ++n2;
        }
        this.annoHeight = d3 - d2;
        this.annoShift = this.annoHeight / 2.0 - d3;
        JCDebug.println("annoHandler", "annoHeight:" + this.annoHeight + " annoStart:" + d2 + " maxExtent:" + d3 + " annoShift:" + this.annoShift);
    }

    public int compare(Object object, Object object2) {
        JCValueLabel jCValueLabel = (JCValueLabel)object;
        JCValueLabel jCValueLabel2 = (JCValueLabel)object2;
        int n2 = 0;
        if (jCValueLabel.getValue() < jCValueLabel2.getValue()) {
            n2 = -1;
        } else if (jCValueLabel.getValue() > jCValueLabel2.getValue()) {
            n2 = 1;
        }
        return n2;
    }

    public double getAnnoHeight() {
        return this.annoHeight;
    }

    public double getAnnoShift() {
        return this.annoShift;
    }

    protected JCAxis getAxis() {
        return this.axis;
    }

    protected JCValueLabel getLabelFromValue(double d2, boolean bl) {
        String string = JCNumberUtil.format(d2, this.axis.getNFrac());
        JCChart3dNumberFormat jCChart3dNumberFormat = this.axis.getNumberFormatter();
        String string2 = jCChart3dNumberFormat.localize(string);
        JCValueLabel jCValueLabel = new JCValueLabel(d2, string2, bl);
        JCLabelGenerator jCLabelGenerator = this.axis.getLabelGenerator();
        if (jCLabelGenerator != null) {
            jCLabelGenerator.makeLabel(jCValueLabel);
            jCValueLabel.setValue(d2);
        }
        return jCValueLabel;
    }

    protected ArrayList getUserValueLabels() {
        return this.userValueLabels;
    }

    public ArrayList getValueLabels() {
        return this.valueLabels;
    }

    protected void makeAnnotations(Graphics graphics, Anno anno) {
        switch (this.axis.getAnnotationMethod()) {
            case 3: {
                this.makeValueLabels();
                break;
            }
            case 2: {
                this.makeDataLabels(anno);
                break;
            }
            case 1: {
                this.makeValues(anno);
                break;
            }
        }
        this.calcAnnoHeight(graphics);
    }

    private void makeDataLabels(Anno anno) {
        this.valueLabels = new ArrayList();
        if (anno == null) {
            return;
        }
        JCChart3dArea jCChart3dArea = anno.getChart3dArea();
        Chart3dDataView chart3dDataView = jCChart3dArea.getChart3d().getDataView(0);
        Chart3dData chart3dData = chart3dDataView.getElevationData();
        if (!(chart3dData instanceof Chart3dGridData)) {
            return;
        }
        Chart3dGridData chart3dGridData = (Chart3dGridData)chart3dData;
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        String[] stringArray = null;
        double[] dArray = null;
        int n2 = 0;
        int n3 = 1;
        int n4 = 0;
        int n5 = 0;
        switch (this.axis.getAxisId()) {
            case 1: {
                stringArray = chart3dGridData.getXLabels();
                dArray = chart3dGridData.getXGrid();
                n2 = chart3dGridData.getNumX();
                n3 = jCChart3dArea.getBar().getXFormat();
                n4 = gridLimits.getXOffset();
                n5 = gridLimits.getXLast();
                break;
            }
            case 2: {
                stringArray = chart3dGridData.getYLabels();
                dArray = chart3dGridData.getYGrid();
                n2 = chart3dGridData.getNumY();
                n3 = jCChart3dArea.getBar().getYFormat();
                n4 = gridLimits.getYOffset();
                n5 = gridLimits.getYLast();
                break;
            }
            default: {
                return;
            }
        }
        if (stringArray == null) {
            return;
        }
        int n6 = n4;
        while (n6 <= n5 && n6 < stringArray.length) {
            block12: {
                double d2;
                block11: {
                    d2 = dArray[n6];
                    if (chart3dDataView.getChartType() != 1 || n3 != 2) break block11;
                    if (n6 >= n2 - 1) break block12;
                    d2 = (d2 + dArray[n6 + 1]) / 2.0;
                }
                JCValueLabel jCValueLabel = new JCValueLabel(d2, stringArray[n6]);
                this.valueLabels.add(jCValueLabel);
            }
            ++n6;
        }
    }

    private void makeValueLabels() {
        this.valueLabels = new ArrayList();
        if (this.userValueLabels == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.userValueLabels.size()) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.userValueLabels.get(n2);
            this.valueLabels.add(jCValueLabel);
            ++n2;
        }
    }

    private void makeValues(Anno anno) {
        this.valueLabels = new ArrayList();
        if (anno == null) {
            return;
        }
        switch (this.axis.getAxisId()) {
            default: {
                return;
            }
            case 1: 
            case 2: 
            case 3: 
        }
        JCLabelGenerator jCLabelGenerator = this.axis.getLabelGenerator();
        double d2 = this.axis.getAnnoMin();
        double d3 = this.axis.getAnnoMax();
        double d4 = this.axis.getAnnoStep();
        double d5 = d4 / 2.0;
        double d6 = d5 * JCChart3dUtil.ceil(d2 / d5);
        double d7 = d4 * JCChart3dUtil.ceil(d2 / d4);
        boolean bl = d7 - d6 > d5 / 2.0;
        int n2 = (int)(JCChart3dUtil.floor(d3 / d5) - d6 / d5 + 0.5);
        int n3 = 0;
        while (n3 <= n2) {
            JCValueLabel jCValueLabel = this.getLabelFromValue(d6 == -0.0 ? 0.0 : d6, bl);
            JCDebug.print("annoHandler", "index:" + n3);
            JCDebug.print("annoHandler", " value:" + jCValueLabel.getValue());
            JCDebug.print("annoHandler", " label:" + jCValueLabel.getLabel());
            JCDebug.println("annoHandler", " tickOnly:" + bl);
            this.valueLabels.add(jCValueLabel);
            d6 += d5;
            bl ^= true;
            ++n3;
        }
    }

    protected void setUserValueLabels(ArrayList arrayList) {
        this.userValueLabels = arrayList;
        this.sortValueLabels();
    }

    protected void sortValueLabels() {
        if (this.userValueLabels.size() <= 1) {
            return;
        }
        Collections.sort(this.userValueLabels, this);
    }
}

