/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Chart3dGridData;
import com.klg.jclass.chart3d.DrawGrid;
import com.klg.jclass.chart3d.FacetAbstract;
import com.klg.jclass.chart3d.GridLimits;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCContour;
import com.klg.jclass.chart3d.JCContourLevels;
import com.klg.jclass.chart3d.JCElevation;
import com.klg.jclass.chart3d.JCFillStyle;
import com.klg.jclass.chart3d.JCGridColor;
import com.klg.jclass.chart3d.JCLineStyle;
import com.klg.jclass.chart3d.JCPlotCube;
import com.klg.jclass.chart3d.ScreenPoint;
import com.klg.jclass.util.JCDebug;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.vecmath.Point4d;

public class BarFacet
extends FacetAbstract {
    public static final int FACE_A = 0;
    public static final int FACE_B = 1;
    public static final int FACE_C = 2;
    public static final int FACE_D = 3;
    public static final int FACE_H = 4;
    public static final int FACE_L = 5;
    protected static final int[][] faceCorner;
    public static final int BAR_MESH = 0;
    public static final int BAR_FILLED = 1;
    public static final int BAR_FILL_MESH = 2;
    public static final int BAR_ERASE = 3;
    public static final int BAR_ERASE_MESH = 4;
    public static final int BAR_SIDES = 5;
    public static final int BAR_CONTOUR = 6;
    protected Graphics gc = null;

    static {
        int[][] nArrayArray = new int[4][];
        nArrayArray[0] = new int[]{1, 2};
        nArrayArray[1] = new int[]{2, 3};
        int[] nArray = new int[2];
        nArray[0] = 3;
        nArrayArray[2] = nArray;
        int[] nArray2 = new int[2];
        nArray2[1] = 1;
        nArrayArray[3] = nArray2;
        faceCorner = nArrayArray;
    }

    BarFacet() {
    }

    BarFacet(DrawGrid drawGrid, Graphics graphics) {
        super(drawGrid);
        this.gc = graphics;
    }

    protected void drawBar(int n2, int n3, int n4, int n5, Point4d[] point4dArray, ScreenPoint[] screenPointArray, ScreenPoint[] screenPointArray2) {
        boolean bl;
        double d2;
        double d3;
        ScreenPoint[] screenPointArray3;
        ScreenPoint[] screenPointArray4;
        ScreenPoint[] screenPointArray5;
        ScreenPoint[] screenPointArray6;
        double d4;
        Chart3dGridData chart3dGridData = this.drawGrid.getGridData();
        Chart3dDataView chart3dDataView = chart3dGridData.getDataView();
        Chart3dGridData chart3dGridData2 = chart3dDataView.getZoneData();
        JCElevation jCElevation = chart3dDataView.getElevation();
        JCContour jCContour = chart3dDataView.getContour();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        JCPlotCube jCPlotCube = jCChart3dArea.getPlotCube();
        double d5 = chart3dGridData.getZValue(n2, n3);
        if (d5 < (d4 = jCChart3dArea.getAxis(3).getOrigin())) {
            screenPointArray6 = screenPointArray2;
            screenPointArray5 = screenPointArray2;
            screenPointArray4 = screenPointArray;
            screenPointArray3 = screenPointArray;
            d3 = d5;
            d2 = d4;
            bl = false;
        } else {
            screenPointArray6 = screenPointArray;
            screenPointArray5 = screenPointArray;
            screenPointArray4 = screenPointArray2;
            screenPointArray3 = screenPointArray2;
            d3 = d4;
            d2 = d5;
            bl = true;
        }
        Color color = bl ? jCElevation.getMeshTopColor() : jCElevation.getMeshBottomColor();
        JCLineStyle jCLineStyle = new JCLineStyle(1, jCPlotCube.getDrawForeground(), 1);
        JCFillStyle jCFillStyle = new JCFillStyle(Color.white, 1);
        boolean bl2 = chart3dGridData2.isDataOK() && jCContour.isZoned();
        int n6 = chart3dDataView.getDrawCode();
        double d6 = 0.0;
        if (bl2) {
            d6 = chart3dGridData2.getZValue(n2, n3);
            switch (chart3dDataView.getDrawCode()) {
                case 4: 
                case 6: 
                case 12: 
                case 14: {
                    n6 = 2;
                    break;
                }
                case 5: 
                case 13: {
                    n6 = 1;
                    break;
                }
                case 7: 
                case 15: {
                    n6 = 3;
                    break;
                }
                default: {
                    JCDebug.println("barFacet", "DrawBar: Bad draw code!");
                    break;
                }
            }
        }
        JCGridColor jCGridColor = null;
        if (jCElevation.isShaded() && !bl2) {
            jCGridColor = chart3dDataView.findGridColor(n2, n3);
        }
        boolean bl3 = jCElevation.isTransparent();
        JCContourLevels jCContourLevels = jCContour.getContourLevels();
        double[] dArray = jCContourLevels.getLevels();
        int n7 = jCContourLevels.getNumLevels();
        jCLineStyle.resetGraphics(this.gc);
        jCFillStyle.resetGraphics(this.gc);
        switch (n6) {
            case 1: {
                if (!bl3) {
                    this.drawBarStyle(screenPointArray6, screenPointArray4, n4, n5, 3);
                }
                if (bl2) {
                    jCContour.setZLineColor(this.gc, jCContourLevels.getLevelFromValue(d6));
                } else {
                    this.gc.setColor(color);
                }
                if (bl3) {
                    this.fillPointArrays(screenPointArray6, 4);
                    this.gc.drawPolygon(this.xPoints, this.yPoints, 4);
                    this.fillPointArrays(screenPointArray4, 4);
                    this.gc.drawPolygon(this.xPoints, this.yPoints, 4);
                    this.gc.drawLine(screenPointArray4[0].getXPixel(), screenPointArray4[0].getYPixel(), screenPointArray6[0].getXPixel(), screenPointArray6[0].getYPixel());
                    this.gc.drawLine(screenPointArray4[1].getXPixel(), screenPointArray4[1].getYPixel(), screenPointArray6[1].getXPixel(), screenPointArray6[1].getYPixel());
                    this.gc.drawLine(screenPointArray4[2].getXPixel(), screenPointArray4[2].getYPixel(), screenPointArray6[2].getXPixel(), screenPointArray6[2].getYPixel());
                    this.gc.drawLine(screenPointArray4[3].getXPixel(), screenPointArray4[3].getYPixel(), screenPointArray6[3].getXPixel(), screenPointArray6[3].getYPixel());
                    break;
                }
                this.drawBarStyle(screenPointArray6, screenPointArray4, n4, n5, 0);
                break;
            }
            case 2: {
                if (bl2) {
                    jCContour.setFillStyle(this.gc, jCContourLevels.getLevelFromValue(d6));
                    this.drawBarStyle(screenPointArray6, screenPointArray4, n4, n5, 1);
                    break;
                }
                this.drawShadedBar(screenPointArray6, screenPointArray4, n4, n5, bl, jCGridColor);
                break;
            }
            case 8: {
                jCLineStyle.updateGraphics(this.gc);
                this.gc.setColor(color);
                if (!bl3) {
                    this.drawBarStyle(screenPointArray6, screenPointArray4, n4, n5, 3);
                }
                int n8 = 0;
                while (n8 < n7) {
                    double d7 = dArray[n8];
                    if (d3 < d7 && d7 < d2) {
                        screenPointArray6 = this.planeToScreen(point4dArray, d7);
                        jCContour.setLineStyle(this.gc, n8);
                        if (bl3) {
                            this.fillPointArrays(screenPointArray6, 4);
                            this.gc.drawPolygon(this.xPoints, this.yPoints, 4);
                        } else {
                            this.drawBarContour(screenPointArray6, n4, n5);
                        }
                    }
                    ++n8;
                }
                jCLineStyle.resetGraphics(this.gc);
                break;
            }
            case 3: {
                if (bl2) {
                    jCContour.setFillStyle(this.gc, jCContourLevels.getLevelFromValue(d6));
                    this.drawBarStyle(screenPointArray6, screenPointArray4, n4, n5, 1);
                } else {
                    this.drawShadedBar(screenPointArray6, screenPointArray4, n4, n5, bl, jCGridColor);
                }
                this.gc.setColor(color);
                this.drawBarStyle(screenPointArray6, screenPointArray4, n4, n5, 0);
                break;
            }
            case 9: {
                if (!bl3) {
                    this.drawBarStyle(screenPointArray6, screenPointArray4, n4, n5, 4);
                }
                if (bl2) {
                    jCContour.setZLineColor(this.gc, jCContourLevels.getLevelFromValue(d6));
                } else {
                    this.gc.setColor(color);
                }
                this.drawBarStyle(screenPointArray6, screenPointArray4, n4, n5, 0);
                jCLineStyle.updateGraphics(this.gc);
                int n9 = 0;
                while (n9 < n7) {
                    double d8 = dArray[n9];
                    if (d3 < d8 && d8 < d2) {
                        screenPointArray6 = this.planeToScreen(point4dArray, d8);
                        jCContour.setLineStyle(this.gc, n9);
                        if (bl3) {
                            this.fillPointArrays(screenPointArray6, 4);
                            this.gc.drawPolygon(this.xPoints, this.yPoints, 4);
                        } else {
                            this.drawBarContour(screenPointArray6, n4, n5);
                        }
                    }
                    ++n9;
                }
                jCLineStyle.resetGraphics(this.gc);
                break;
            }
            case 5: {
                if (bl3) {
                    n4 = 0;
                    n5 = 2;
                } else {
                    this.drawBarStyle(screenPointArray6, screenPointArray4, n4, n5, 3);
                }
                int n10 = 0;
                while (n10 < n7 && d3 > dArray[n10]) {
                    ++n10;
                }
                jCContour.setZLineColor(this.gc, n10);
                if (bl3) {
                    this.fillPointArrays(screenPointArray4, 4);
                    this.gc.drawPolygon(this.xPoints, this.yPoints, 4);
                } else {
                    this.drawBarContour(screenPointArray3, n4, n5);
                    this.drawBarFace(screenPointArray6, screenPointArray4, 5, 0);
                }
                while (n10 < n7 && dArray[n10] < d2) {
                    screenPointArray6 = this.planeToScreen(point4dArray, dArray[n10]);
                    jCContour.setZLineColor(this.gc, n10);
                    this.drawBarFace(screenPointArray6, screenPointArray4, n4, 5);
                    this.drawBarFace(screenPointArray6, screenPointArray4, n5, 5);
                    screenPointArray4 = screenPointArray6;
                    ++n10;
                }
                jCContour.setZLineColor(this.gc, n10);
                this.drawBarFace(screenPointArray5, screenPointArray3, n4, 5);
                this.drawBarFace(screenPointArray5, screenPointArray3, n5, 5);
                if (bl3) {
                    this.fillPointArrays(screenPointArray5, 4);
                    this.gc.drawPolygon(this.xPoints, this.yPoints, 4);
                    break;
                }
                this.drawBarContour(screenPointArray5, n4, n5);
                this.drawBarFace(screenPointArray5, screenPointArray3, 4, 0);
                break;
            }
            case 10: {
                if (bl2) {
                    jCContour.setFillStyle(this.gc, jCContourLevels.getLevelFromValue(d6));
                    this.drawBarStyle(screenPointArray6, screenPointArray4, n4, n5, 1);
                } else {
                    this.drawShadedBar(screenPointArray6, screenPointArray4, n4, n5, bl, jCGridColor);
                }
                this.gc.setColor(jCElevation.getMeshTopColor());
                int n11 = 0;
                while (n11 < n7) {
                    double d9 = dArray[n11];
                    if (d3 < d9 && d9 < d2) {
                        screenPointArray6 = this.planeToScreen(point4dArray, d9);
                        jCContour.setLineStyle(this.gc, n11);
                        this.drawBarContour(screenPointArray6, n4, n5);
                    }
                    ++n11;
                }
                jCLineStyle.resetGraphics(this.gc);
                break;
            }
            case 4: 
            case 6: {
                int n12 = 0;
                while (n12 < n7 && d3 > dArray[n12]) {
                    ++n12;
                }
                jCContour.setFillStyle(this.gc, n12);
                this.drawBarFace(screenPointArray6, screenPointArray4, 5, 1);
                while (n12 < n7 && dArray[n12] < d2) {
                    screenPointArray6 = this.planeToScreen(point4dArray, dArray[n12]);
                    jCContour.setFillStyle(this.gc, n12);
                    this.drawBarFace(screenPointArray6, screenPointArray4, n4, 1);
                    this.drawBarFace(screenPointArray6, screenPointArray4, n5, 1);
                    screenPointArray4 = screenPointArray6;
                    ++n12;
                }
                jCContour.setFillStyle(this.gc, n12);
                this.drawBarFace(screenPointArray5, screenPointArray4, n4, 1);
                this.drawBarFace(screenPointArray5, screenPointArray4, n5, 1);
                this.drawBarFace(screenPointArray5, screenPointArray4, 4, 1);
                break;
            }
            case 7: {
                int n13 = 0;
                while (n13 < n7 && d3 > dArray[n13]) {
                    ++n13;
                }
                jCContour.setFillStyle(this.gc, n13);
                this.drawBarFace(screenPointArray6, screenPointArray4, n4, 1);
                this.drawBarFace(screenPointArray6, screenPointArray4, n5, 1);
                this.drawBarFace(screenPointArray6, screenPointArray4, 5, 1);
                while (n13 < n7 && dArray[n13] < d2) {
                    screenPointArray6 = this.planeToScreen(point4dArray, dArray[n13]);
                    jCContour.setFillStyle(this.gc, n13);
                    this.drawBarFace(screenPointArray6, screenPointArray4, n4, 1);
                    this.drawBarFace(screenPointArray6, screenPointArray4, n5, 1);
                    screenPointArray4 = screenPointArray6;
                    ++n13;
                }
                jCContour.setFillStyle(this.gc, n13);
                this.drawBarFace(screenPointArray5, screenPointArray4, n4, 1);
                this.drawBarFace(screenPointArray5, screenPointArray4, n5, 1);
                this.drawBarFace(screenPointArray5, screenPointArray4, 4, 1);
                this.gc.setColor(color);
                this.drawBarStyle(screenPointArray5, screenPointArray3, n4, n5, 0);
                break;
            }
            case 11: {
                if (bl2) {
                    jCContour.setFillStyle(this.gc, jCContourLevels.getLevelFromValue(d6));
                    this.drawBarStyle(screenPointArray6, screenPointArray4, n4, n5, 1);
                } else {
                    this.drawShadedBar(screenPointArray6, screenPointArray4, n4, n5, bl, jCGridColor);
                }
                int n14 = 0;
                while (n14 < n7) {
                    double d10 = dArray[n14];
                    if (d3 < d10 && d10 < d2) {
                        screenPointArray6 = this.planeToScreen(point4dArray, d10);
                        jCContour.setLineStyle(this.gc, n14);
                        this.drawBarContour(screenPointArray6, n4, n5);
                    }
                    ++n14;
                }
                jCLineStyle.resetGraphics(this.gc);
                this.gc.setColor(color);
                this.drawBarStyle(screenPointArray5, screenPointArray3, n4, n5, 0);
                break;
            }
            case 13: {
                this.drawBarStyle(screenPointArray6, screenPointArray4, n4, n5, 3);
                int n15 = 0;
                while (n15 < n7 && d3 > dArray[n15]) {
                    ++n15;
                }
                jCContour.setZLineColor(this.gc, n15);
                this.drawBarContour(screenPointArray4, n4, n5);
                this.drawBarFace(screenPointArray6, screenPointArray4, 5, 0);
                while (n15 < n7 && dArray[n15] < d2) {
                    screenPointArray6 = this.planeToScreen(point4dArray, dArray[n15]);
                    jCContour.setZLineColor(this.gc, n15);
                    this.drawBarFace(screenPointArray6, screenPointArray4, n4, 5);
                    this.drawBarFace(screenPointArray6, screenPointArray4, n5, 5);
                    jCContour.setLineStyle(this.gc, n15);
                    this.drawBarContour(screenPointArray6, n4, n5);
                    screenPointArray4 = screenPointArray6;
                    ++n15;
                }
                jCLineStyle.resetGraphics(this.gc);
                jCContour.setZLineColor(this.gc, n15);
                this.drawBarFace(screenPointArray5, screenPointArray4, n4, 5);
                this.drawBarFace(screenPointArray5, screenPointArray4, n5, 5);
                this.drawBarContour(screenPointArray5, n4, n5);
                this.drawBarFace(screenPointArray5, screenPointArray4, 4, 0);
                break;
            }
            case 12: 
            case 14: {
                int n16 = 0;
                while (n16 < n7 && d3 > dArray[n16]) {
                    ++n16;
                }
                jCContour.setZLineColor(this.gc, n16);
                this.drawBarFace(screenPointArray6, screenPointArray4, 5, 1);
                boolean bl4 = true;
                while (n16 < n7 && dArray[n16] < d2) {
                    screenPointArray6 = this.planeToScreen(point4dArray, dArray[n16]);
                    jCContour.setFillStyle(this.gc, n16);
                    this.drawBarFace(screenPointArray6, screenPointArray4, n4, 1);
                    this.drawBarFace(screenPointArray6, screenPointArray4, n5, 1);
                    if (n16 > 0 && !bl4) {
                        jCContour.setLineStyle(this.gc, n16 - 1);
                        this.drawBarContour(screenPointArray4, n4, n5);
                    }
                    bl4 = false;
                    screenPointArray4 = screenPointArray6;
                    ++n16;
                }
                jCContour.setFillStyle(this.gc, n16);
                this.drawBarFace(screenPointArray5, screenPointArray4, n4, 1);
                this.drawBarFace(screenPointArray5, screenPointArray4, n5, 1);
                this.drawBarFace(screenPointArray5, screenPointArray4, 4, 1);
                if (n16 > 0) {
                    jCContour.setLineStyle(this.gc, n16 - 1);
                    this.drawBarContour(screenPointArray4, n4, n5);
                }
                jCLineStyle.resetGraphics(this.gc);
                break;
            }
            case 15: {
                int n17 = 0;
                while (n17 < n7 && d3 > dArray[n17]) {
                    ++n17;
                }
                jCContour.setFillStyle(this.gc, n17);
                this.drawBarFace(screenPointArray6, screenPointArray4, 5, 1);
                boolean bl5 = true;
                while (n17 < n7 && dArray[n17] < d2) {
                    screenPointArray6 = this.planeToScreen(point4dArray, dArray[n17]);
                    jCContour.setFillStyle(this.gc, n17);
                    this.drawBarFace(screenPointArray6, screenPointArray4, n4, 1);
                    this.drawBarFace(screenPointArray6, screenPointArray4, n5, 1);
                    jCContour.setLineStyle(this.gc, n17);
                    this.drawBarContour(screenPointArray6, n4, n5);
                    if (n17 > 0 && !bl5) {
                        jCContour.setLineStyle(this.gc, n17 - 1);
                        this.drawBarContour(screenPointArray4, n4, n5);
                    }
                    bl5 = false;
                    screenPointArray4 = screenPointArray6;
                    ++n17;
                }
                jCContour.setFillStyle(this.gc, n17);
                this.drawBarFace(screenPointArray5, screenPointArray4, n4, 1);
                this.drawBarFace(screenPointArray5, screenPointArray4, n5, 1);
                this.drawBarFace(screenPointArray5, screenPointArray4, 4, 1);
                if (n17 > 0) {
                    jCContour.setLineStyle(this.gc, n17 - 1);
                }
                this.drawBarContour(screenPointArray4, n4, n5);
                jCLineStyle.resetGraphics(this.gc);
                this.gc.setColor(color);
                this.drawBarStyle(screenPointArray5, screenPointArray3, n4, n5, 0);
                break;
            }
        }
    }

    protected void drawBarContour(ScreenPoint[] screenPointArray, int n2, int n3) {
        if (n2 >= 0) {
            int n4 = faceCorner[n2][0];
            int n5 = faceCorner[n2][1];
            this.gc.drawLine(screenPointArray[n4].getXPixel(), screenPointArray[n4].getYPixel(), screenPointArray[n5].getXPixel(), screenPointArray[n5].getYPixel());
            if (n3 >= 0) {
                n4 = faceCorner[n3][0];
                n5 = faceCorner[n3][1];
                this.gc.drawLine(screenPointArray[n4].getXPixel(), screenPointArray[n4].getYPixel(), screenPointArray[n5].getXPixel(), screenPointArray[n5].getYPixel());
            }
        }
    }

    protected void drawBarFace(ScreenPoint[] screenPointArray, ScreenPoint[] screenPointArray2, int n2, int n3) {
        ScreenPoint[] screenPointArray3;
        Chart3dGridData chart3dGridData = this.drawGrid.getGridData();
        Chart3dDataView chart3dDataView = chart3dGridData.getDataView();
        JCElevation jCElevation = chart3dDataView.getElevation();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        JCPlotCube jCPlotCube = jCChart3dArea.getPlotCube();
        if (n2 < 0) {
            return;
        }
        int n4 = 0;
        int n5 = 0;
        if (n2 == 4) {
            screenPointArray3 = screenPointArray;
            if (JCChart3dUtil.gridBackfacing(screenPointArray3[0], screenPointArray3[1], screenPointArray3[2])) {
                return;
            }
        } else if (n2 == 5) {
            screenPointArray3 = screenPointArray2;
            if (!JCChart3dUtil.gridBackfacing(screenPointArray3[0], screenPointArray3[1], screenPointArray3[2])) {
                return;
            }
        } else {
            screenPointArray3 = new ScreenPoint[4];
            n4 = faceCorner[n2][0];
            n5 = faceCorner[n2][1];
            screenPointArray3[0] = screenPointArray2[n4];
            screenPointArray3[1] = screenPointArray2[n5];
            screenPointArray3[2] = screenPointArray[n5];
            screenPointArray3[3] = screenPointArray[n4];
        }
        JCFillStyle jCFillStyle = new JCFillStyle(jCPlotCube.getDrawBackground(), 1);
        this.fillPointArrays(screenPointArray3, 4);
        switch (n3) {
            case 0: {
                this.gc.drawPolygon(this.xPoints, this.yPoints, 4);
                break;
            }
            case 1: {
                this.gc.fillPolygon(this.xPoints, this.yPoints, 4);
                break;
            }
            case 2: {
                this.gc.fillPolygon(this.xPoints, this.yPoints, 4);
                this.gc.setColor(jCChart3dArea.getForeground());
                this.gc.drawPolygon(this.xPoints, this.yPoints, 4);
            }
            case 3: {
                jCFillStyle.updateGraphics(this.gc);
                this.gc.fillPolygon(this.xPoints, this.yPoints, 4);
                break;
            }
            case 4: {
                jCFillStyle.updateGraphics(this.gc);
                this.gc.fillPolygon(this.xPoints, this.yPoints, 4);
                this.gc.setColor(jCElevation.getMeshTopColor());
                this.gc.drawPolygon(this.xPoints, this.yPoints, 4);
                break;
            }
            case 5: {
                if (n2 == 4 || n2 == 5) {
                    JCDebug.println("barFacet", "Bad face code in drawBarFace");
                    return;
                }
                this.gc.drawLine(screenPointArray2[n5].getXPixel(), screenPointArray2[n5].getYPixel(), screenPointArray[n5].getXPixel(), screenPointArray[n5].getYPixel());
                this.gc.drawLine(screenPointArray2[n4].getXPixel(), screenPointArray2[n4].getYPixel(), screenPointArray[n4].getXPixel(), screenPointArray[n4].getYPixel());
                break;
            }
            case 6: {
                if (n2 == 4 || n2 == 5) {
                    JCDebug.println("barFacet", "Bad face code in drawBarFace");
                    return;
                }
                this.gc.drawLine(screenPointArray3[n4].getXPixel(), screenPointArray3[n4].getYPixel(), screenPointArray3[n5].getXPixel(), screenPointArray3[n5].getYPixel());
                break;
            }
        }
    }

    protected void drawBarStyle(ScreenPoint[] screenPointArray, ScreenPoint[] screenPointArray2, int n2, int n3, int n4) {
        this.drawBarFace(screenPointArray, screenPointArray2, 4, n4);
        this.drawBarFace(screenPointArray, screenPointArray2, 5, n4);
        this.drawBarFace(screenPointArray, screenPointArray2, n2, n4);
        this.drawBarFace(screenPointArray, screenPointArray2, n3, n4);
    }

    protected void drawShadedBar(ScreenPoint[] screenPointArray, ScreenPoint[] screenPointArray2, int n2, int n3, boolean bl, JCGridColor jCGridColor) {
        Color color;
        Color color2;
        Chart3dGridData chart3dGridData = this.drawGrid.getGridData();
        JCElevation jCElevation = chart3dGridData.getDataView().getElevation();
        if (jCGridColor != null && jCGridColor.getColor() != null) {
            color = color2 = jCGridColor.getColor();
        } else {
            color = jCElevation.getShadedTopColor();
            color2 = jCElevation.getShadedBottomColor();
            if (jCGridColor != null) {
                JCDebug.println("barFacet", "Tried to use a null GridColor");
            }
        }
        if (bl) {
            this.gc.setColor(color);
            this.drawBarFace(screenPointArray, screenPointArray2, 5, 1);
            this.drawBarFace(screenPointArray, screenPointArray2, 4, 1);
        } else {
            this.gc.setColor(color2);
            this.drawBarFace(screenPointArray, screenPointArray2, 4, 1);
            this.drawBarFace(screenPointArray, screenPointArray2, 5, 1);
        }
        this.drawBarFace(screenPointArray, screenPointArray2, n2, 1);
        this.drawBarFace(screenPointArray, screenPointArray2, n3, 1);
    }

    protected ScreenPoint[] planeToScreen(Point4d[] point4dArray, double d2) {
        if (point4dArray.length < 4) {
            JCDebug.println("barFacet", "Bad plane size!");
            return null;
        }
        ScreenPoint[] screenPointArray = new ScreenPoint[4];
        int n2 = 0;
        while (n2 < 4) {
            point4dArray[n2].z = d2;
            screenPointArray[n2] = this.getScreenPoint(point4dArray[n2].x, point4dArray[n2].y, point4dArray[n2].z);
            ++n2;
        }
        return screenPointArray;
    }

    public void processFacet(int n2, int n3, int n4) {
        Chart3dGridData chart3dGridData = this.drawGrid.getGridData();
        ScreenPoint[][] screenPointArray = chart3dGridData.getScreenPoints();
        GridLimits gridLimits = chart3dGridData.getGridLimits();
        Chart3dDataView chart3dDataView = this.drawGrid.getDataView();
        JCChart3dArea jCChart3dArea = chart3dDataView.getChart3d().getChart3dArea();
        if (n2 < gridLimits.getXOffset() || n2 > gridLimits.getXLast() || n3 < gridLimits.getYOffset() || n3 > gridLimits.getYLast()) {
            return;
        }
        if (screenPointArray == null) {
            return;
        }
        ScreenPoint screenPoint = screenPointArray[n2][n3];
        if (screenPoint.isDrawn() || screenPoint.isHoleValue()) {
            return;
        }
        Point4d[] point4dArray = JCChart3dUtil.constructBarPlane(chart3dGridData, n2, n3);
        ScreenPoint[] screenPointArray2 = this.planeToScreen(point4dArray, chart3dGridData.getZValue(n2, n3));
        ScreenPoint[] screenPointArray3 = this.planeToScreen(point4dArray, jCChart3dArea.getAxis(3).getOrigin());
        if (!jCChart3dArea.getViewport().isNormalized()) {
            int n5 = JCChart3dUtil.min4(screenPointArray2[0].getXPixel(), screenPointArray2[1].getXPixel(), screenPointArray2[2].getXPixel(), screenPointArray2[3].getXPixel());
            int n6 = JCChart3dUtil.min4(screenPointArray2[0].getYPixel(), screenPointArray2[1].getYPixel(), screenPointArray2[2].getYPixel(), screenPointArray2[3].getYPixel());
            int n7 = JCChart3dUtil.max4(screenPointArray2[0].getXPixel(), screenPointArray2[1].getXPixel(), screenPointArray2[2].getXPixel(), screenPointArray2[3].getXPixel());
            int n8 = JCChart3dUtil.max4(screenPointArray2[0].getYPixel(), screenPointArray2[1].getYPixel(), screenPointArray2[2].getYPixel(), screenPointArray2[3].getYPixel());
            Rectangle rectangle = new Rectangle(n5, n6, n7 - n5, n8 - n6);
            Rectangle rectangle2 = new Rectangle(n5 = JCChart3dUtil.min4(screenPointArray3[0].getXPixel(), screenPointArray3[1].getXPixel(), screenPointArray3[2].getXPixel(), screenPointArray3[3].getXPixel()), n6 = JCChart3dUtil.min4(screenPointArray3[0].getYPixel(), screenPointArray3[1].getYPixel(), screenPointArray3[2].getYPixel(), screenPointArray3[3].getYPixel()), (n7 = JCChart3dUtil.max4(screenPointArray3[0].getXPixel(), screenPointArray3[1].getXPixel(), screenPointArray3[2].getXPixel(), screenPointArray3[3].getXPixel())) - n5, (n8 = JCChart3dUtil.max4(screenPointArray3[0].getYPixel(), screenPointArray3[1].getYPixel(), screenPointArray3[2].getYPixel(), screenPointArray3[3].getYPixel())) - n6);
            Rectangle rectangle3 = JCChart3dUtil.computeBoundingRectangle(rectangle, rectangle2);
            if (!rectangle3.intersects(jCChart3dArea.getDrawingArea())) {
                return;
            }
        }
        switch (n4) {
            case 1: {
                this.drawBar(n2, n3, -1, -1, point4dArray, screenPointArray2, screenPointArray3);
                break;
            }
            case 2: {
                this.drawBar(n2, n3, 3, -1, point4dArray, screenPointArray2, screenPointArray3);
                break;
            }
            case 3: {
                this.drawBar(n2, n3, 1, -1, point4dArray, screenPointArray2, screenPointArray3);
                break;
            }
            case 4: {
                this.drawBar(n2, n3, 0, -1, point4dArray, screenPointArray2, screenPointArray3);
                break;
            }
            case 5: {
                this.drawBar(n2, n3, 2, -1, point4dArray, screenPointArray2, screenPointArray3);
                break;
            }
            case 6: {
                this.drawBar(n2, n3, 0, 3, point4dArray, screenPointArray2, screenPointArray3);
                break;
            }
            case 7: {
                this.drawBar(n2, n3, 0, 1, point4dArray, screenPointArray2, screenPointArray3);
                break;
            }
            case 8: {
                this.drawBar(n2, n3, 2, 3, point4dArray, screenPointArray2, screenPointArray3);
                break;
            }
            case 9: {
                this.drawBar(n2, n3, 1, 2, point4dArray, screenPointArray2, screenPointArray3);
                break;
            }
            default: {
                JCDebug.println("barFacet", "processFacet: Invalid Region!");
            }
        }
        screenPoint.setDrawn(true);
    }
}

