/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart3d;

import com.klg.jclass.chart3d.Chart3dAnnoHandler;
import com.klg.jclass.chart3d.Chart3dData;
import com.klg.jclass.chart3d.Chart3dDataView;
import com.klg.jclass.chart3d.Cube;
import com.klg.jclass.chart3d.Extents;
import com.klg.jclass.chart3d.JCAxis;
import com.klg.jclass.chart3d.JCBox;
import com.klg.jclass.chart3d.JCChart3dArea;
import com.klg.jclass.chart3d.JCChart3dUtil;
import com.klg.jclass.chart3d.JCPlotCube;
import com.klg.jclass.chart3d.JCValueLabel;
import com.klg.jclass.chart3d.Justify;
import com.klg.jclass.chart3d.Transform;
import com.klg.jclass.util.JCDebug;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point4d;
import javax.vecmath.Vector3d;

public class Anno
implements Serializable {
    static final long serialVersionUID = -5542417106751358122L;
    public static final double TICK_PAD_FACTOR = 0.15;
    public static final double CUBE_SCALE = 0.002;
    protected Matrix4d orientationMatrix = null;
    protected Matrix4d edgeMatrix = null;
    protected Matrix4d justifyMatrix = null;
    protected Matrix4d planeMatrixInit = null;
    protected Matrix4d unitMatrix = null;
    protected Matrix4d matrix = null;
    protected Matrix4d axisMatrix = null;
    protected Point4d u0 = null;
    protected Point4d u1 = null;
    protected Point4d u2 = null;
    protected Point4d u3 = null;
    protected Vector3d vx = null;
    protected Vector3d vy = null;
    protected Vector3d vz = null;
    protected JCChart3dArea area = null;

    public Anno() {
    }

    public Anno(JCChart3dArea jCChart3dArea) {
        this.area = jCChart3dArea;
    }

    protected void annoInit() {
        this.orientationMatrix = null;
        this.edgeMatrix = null;
        this.justifyMatrix = null;
        this.planeMatrixInit = null;
        this.unitMatrix = null;
        if (this.matrix == null || this.axisMatrix == null) {
            this.matrix = new Matrix4d();
            this.axisMatrix = new Matrix4d();
        }
    }

    protected void bound3dAxis(Graphics graphics, JCAxis jCAxis, Matrix4d matrix4d, Extents extents, JCBox jCBox) {
        JCPlotCube jCPlotCube = this.area.getPlotCube();
        boolean[] blArray = this.area.getCube().getAnnotateEdge();
        Chart3dDataView chart3dDataView = this.area.getChart3d().getDataView(0);
        Justify justify = new Justify();
        double d2 = 0.0;
        int n2 = -1;
        double d3 = 1.0;
        boolean bl = false;
        switch (jCAxis.getAxisId()) {
            case 1: {
                n2 = 0;
                d3 = jCPlotCube.getXNormalizedScale();
                break;
            }
            case 2: {
                n2 = 4;
                d3 = jCPlotCube.getYNormalizedScale();
                break;
            }
            case 3: {
                n2 = 8;
                d3 = jCPlotCube.getZNormalizedScale();
                bl = chart3dDataView.getChartType() == 1;
                break;
            }
            default: {
                return;
            }
        }
        if (blArray[n2] || blArray[n2 + 1] || blArray[n2 + 2] || blArray[n2 + 3]) {
            this.determineVertical(n2, justify);
            if (justify.isVertical()) {
                d2 = (double)jCAxis.getAnnoFontCubeSize() * 0.002;
                this.calcAxisBounds(jCAxis, d2, 2.0 * d3, 2.0, bl);
            } else {
                d2 = this.guessLongestAnnotation(graphics, jCAxis) * 0.002;
                this.calcAxisBounds(jCAxis, d2, 2.0 * d3, 1.5, bl);
            }
            jCAxis.getAnnoHandler().makeAnnotations(graphics, this);
            double d4 = jCAxis.getAnnoMin();
            double d5 = jCAxis.getAnnoMax();
            double d6 = d4;
            double d7 = d5;
            double d8 = d5 - d4;
            int n3 = n2;
            while (n3 <= n2 + 3) {
                if (blArray[n3]) {
                    this.edgeMatrix = this.getEdgeMatrix(n3);
                    this.orientationMatrix = this.getOrientationMatrix(n3, justify);
                    this.axisMatrix.mul(matrix4d, this.edgeMatrix);
                    double d9 = 0.0;
                    ArrayList arrayList = jCAxis.getAnnoHandler().getValueLabels();
                    if (arrayList != null && arrayList.size() != 0) {
                        double d10 = Double.MAX_VALUE;
                        double d11 = Double.MIN_VALUE;
                        String string = null;
                        String string2 = null;
                        int n4 = 0;
                        while (n4 < arrayList.size()) {
                            JCValueLabel jCValueLabel = (JCValueLabel)arrayList.get(n4);
                            double d12 = jCValueLabel.getValue();
                            String string3 = jCValueLabel.getLabel();
                            if (d4 <= d12 && d12 <= d5 && !jCValueLabel.isTickOnly()) {
                                double d13 = d3 * (1.0 - 2.0 * (d5 - d12) / (d5 - d4));
                                if (d13 < d10) {
                                    d10 = d13;
                                    string = string3;
                                }
                                if (d13 > d11) {
                                    d11 = d13;
                                    string2 = string3;
                                }
                                this.boundText(graphics, jCAxis, this.axisMatrix, string3, d13, extents, justify);
                                d9 = Math.max(justify.getEaseway(), d9);
                            }
                            ++n4;
                        }
                        if (jCAxis.getAnnotationMethod() == 1 && d10 != Double.MAX_VALUE && !bl) {
                            double d14;
                            d2 = this.cubeTextWidth(graphics, jCAxis, String.valueOf(string) + ".", false, true) * 0.002;
                            double d15 = d10 - d2 / 2.0;
                            if (d15 < -d3) {
                                d14 = (d15 - d3) * (d5 - d4) / (2.0 * d3) + d5;
                                d6 = Math.min(d6, d14);
                            }
                            if ((d15 = d11 + (d2 = this.cubeTextWidth(graphics, jCAxis, String.valueOf(string2) + ".", false, true) * 0.002) / 2.0) > d3) {
                                d14 = (d15 - d3) * (d5 - d4) / (2.0 * d3) + d5;
                                d7 = Math.max(d7, d14);
                            }
                            d8 = d7 - d6;
                        }
                        if (jCAxis.getTitle() != null) {
                            jCAxis.setAnnoEaseway(d9 += (double)jCAxis.getTitleFontCubeSize() * 0.002);
                            if (justify.isAbove()) {
                                d9 = -d9;
                            }
                            this.matrix.mul(this.axisMatrix, this.orientationMatrix);
                            Transform.scaleMatrix(this.matrix, 1.0, -1.0, 1.0);
                            Transform.translateMatrix(this.matrix, 0.0, d9, 0.0);
                            this.boundTitle(graphics, jCAxis, this.matrix, jCAxis.getTitle(), extents, justify);
                        }
                    }
                }
                ++n3;
            }
            switch (jCAxis.getAxisId()) {
                case 1: {
                    jCBox.x = d6;
                    jCBox.width = d8;
                    break;
                }
                case 2: {
                    jCBox.y = d6;
                    jCBox.height = d8;
                    break;
                }
                case 3: {
                    jCBox.z = d6;
                    jCBox.depth = d8;
                    break;
                }
            }
        }
    }

    protected void boundBox(Matrix4d matrix4d, double d2, double d3, Extents extents) {
        if (this.u0 == null) {
            this.u0 = new Point4d();
            this.u1 = new Point4d();
            this.u2 = new Point4d();
            this.u3 = new Point4d();
        }
        this.u0.set(0.0, -d2 / 2.0, 0.0, 1.0);
        this.u1.set(0.0, d2 / 2.0, 0.0, 1.0);
        this.u2.set(d3, d2 / 2.0, 0.0, 1.0);
        this.u3.set(d3, -d2 / 2.0, 0.0, 1.0);
        Transform.transformPoint(matrix4d, this.u0);
        Transform.transformPoint(matrix4d, this.u1);
        Transform.transformPoint(matrix4d, this.u2);
        Transform.transformPoint(matrix4d, this.u3);
        extents.checkXYExtents(this.u0.x, this.u0.y);
        extents.checkXYExtents(this.u1.x, this.u1.y);
        extents.checkXYExtents(this.u2.x, this.u2.y);
        extents.checkXYExtents(this.u3.x, this.u3.y);
    }

    protected void boundText(Graphics graphics, JCAxis jCAxis, Matrix4d matrix4d, String string, double d2, Extents extents, Justify justify) {
        double d3 = this.cubeTextWidth(graphics, jCAxis, string, false, true);
        double d4 = d3 * 0.002;
        double d5 = (double)jCAxis.getAnnoFontCubeSize() * 0.002;
        this.justifyMatrix = this.getJustifyMatrix(d5, d4, justify);
        this.matrix.set(matrix4d);
        Transform.translateMatrix(this.matrix, d2, 0.0, 0.0);
        this.matrix.mul(this.orientationMatrix);
        Transform.scaleMatrix(this.matrix, 1.0, -1.0, 1.0);
        this.matrix.mul(this.justifyMatrix);
        this.boundBox(this.matrix, d5, d4, extents);
    }

    protected void boundTitle(Graphics graphics, JCAxis jCAxis, Matrix4d matrix4d, String string, Extents extents, Justify justify) {
        double d2 = this.cubeTextWidth(graphics, jCAxis, string, true, true);
        double d3 = d2 * 0.002;
        double d4 = (double)jCAxis.getTitleFontCubeSize() * 0.002;
        Transform.translateMatrix(matrix4d, -d3 / 2.0, 0.0, 0.0);
        if (justify.doFlipY()) {
            Transform.translateMatrix(matrix4d, d3, 0.0, 0.0);
            Transform.rotateMatrix(matrix4d, 3, 2);
        }
        if (justify.doFlipX()) {
            Transform.rotateMatrix(matrix4d, 3, 1);
        }
        this.boundBox(matrix4d, d4, d3, extents);
    }

    protected void calc2dAnno(Graphics graphics, JCBox jCBox, JCBox jCBox2) {
        double d2;
        double d3;
        double d4;
        double d5;
        String string;
        double d6;
        JCValueLabel jCValueLabel;
        int n2;
        ArrayList arrayList;
        double d7;
        double d8;
        double d9;
        double d10;
        Cube cube = this.area.getCube();
        cube.calc2DAnnoEdges();
        JCPlotCube jCPlotCube = this.area.getPlotCube();
        double d11 = jCPlotCube.getXNormalizedScale();
        double d12 = jCPlotCube.getYNormalizedScale();
        Extents extents = new Extents(-d11, d11, -d12, d12);
        Chart3dDataView chart3dDataView = this.area.getChart3d().getDataView(0);
        Chart3dData chart3dData = chart3dDataView.getElevationData();
        chart3dData.calcAnnoLimits();
        JCAxis jCAxis = this.area.getAxis(1);
        JCAxis jCAxis2 = this.area.getAxis(2);
        JCAxis jCAxis3 = this.area.getAxis(3);
        jCBox2.x = jCAxis.getAnnoMin();
        jCBox2.y = jCAxis2.getAnnoMin();
        jCBox2.z = 0.0;
        jCBox2.width = jCAxis.getAnnoMax() - jCAxis.getAnnoMin();
        jCBox2.height = jCAxis2.getAnnoMax() - jCAxis2.getAnnoMin();
        jCBox2.depth = 0.0;
        Justify justify = new Justify();
        double d13 = (double)jCAxis.getAnnoFontCubeSize() * 0.002;
        double d14 = (double)jCAxis.getTitleFontCubeSize() * 0.002;
        if (jCAxis.isShowing()) {
            d10 = this.guessLongestAnnotation(graphics, jCAxis) * 0.002;
            this.calcAxisBounds(jCAxis, d10, 2.0 * d11, 1.5, false);
            jCAxis.getAnnoHandler().makeAnnotations(graphics, this);
            d9 = jCAxis.getAnnoMin();
            d8 = jCAxis.getAnnoMax();
            jCBox2.x = d9;
            jCBox2.width = d8 - d9;
            d7 = 0.0;
            arrayList = jCAxis.getAnnoHandler().getValueLabels();
            if (arrayList != null && arrayList.size() > 0) {
                n2 = 0;
                while (n2 < arrayList.size()) {
                    jCValueLabel = (JCValueLabel)arrayList.get(n2);
                    d6 = jCValueLabel.getValue();
                    string = jCValueLabel.getLabel();
                    if (d9 <= d6 && d6 <= d8) {
                        d5 = this.cubeTextWidth(graphics, jCAxis, string, false, true);
                        double d15 = d11 * (1.0 - 2.0 * (d8 - d6) / (d8 - d9));
                        d4 = d15 - d5 * 0.002 / 2.0;
                        extents.checkXExtents(d4);
                        d3 = d15 + d5 * 0.002 / 2.0;
                        extents.checkXExtents(d3);
                        d7 = Math.max(d5, d7);
                    }
                    ++n2;
                }
            }
            d10 = d7 * 0.002;
            justify.setRotate(1);
            justify.setAbove(false);
            this.justifyMatrix = this.getJustifyMatrix(d13, d10, justify);
            d2 = 0.0;
            if (d7 > 0.0) {
                d2 = justify.getEaseway();
                d4 = -d12 - d2;
                extents.checkYExtents(d4);
            }
            if (jCAxis.getTitle() != null) {
                d5 = this.cubeTextWidth(graphics, jCAxis, jCAxis.getTitle(), true, true);
                d4 = -d5 * 0.002 / 2.0;
                extents.checkXExtents(d4);
                d3 = -d4;
                extents.checkXExtents(d3);
                d4 = -d12 - d2 - d14 - d13 / 4.0;
                extents.checkYExtents(d4);
                jCAxis.setAnnoEaseway(d2 + d13 / 4.0);
            }
        }
        d13 = (double)jCAxis2.getAnnoFontCubeSize() * 0.002;
        d14 = (double)jCAxis2.getTitleFontCubeSize() * 0.002;
        if (jCAxis2.isShowing()) {
            this.calcAxisBounds(jCAxis2, d13, 2.0 * d12, 2.0, false);
            jCAxis2.getAnnoHandler().makeAnnotations(graphics, this);
            d9 = jCAxis2.getAnnoMin();
            d8 = jCAxis2.getAnnoMax();
            jCBox2.y = d9;
            jCBox2.height = d8 - d9;
            d7 = 0.0;
            arrayList = jCAxis2.getAnnoHandler().getValueLabels();
            if (arrayList != null && arrayList.size() > 0) {
                n2 = 0;
                while (n2 < arrayList.size()) {
                    jCValueLabel = (JCValueLabel)arrayList.get(n2);
                    d6 = jCValueLabel.getValue();
                    string = jCValueLabel.getLabel();
                    if (d9 <= d6 && d6 <= d8) {
                        d5 = this.cubeTextWidth(graphics, jCAxis2, string, false, true);
                        d7 = Math.max(d5, d7);
                    }
                    ++n2;
                }
            }
            d10 = d7 * 0.002;
            justify.setRotate(2);
            justify.setAbove(true);
            this.justifyMatrix = this.getJustifyMatrix(d13, d10, justify);
            d2 = 0.0;
            if (d7 > 0.0) {
                d2 = justify.getEaseway();
                d4 = -d11 - d2;
                extents.checkXExtents(d4);
                d4 = -d12 - d13 / 2.0;
                extents.checkYExtents(d4);
                d3 = d12 + d13 / 2.0;
                extents.checkYExtents(d3);
            }
            if (jCAxis2.getTitle() != null) {
                d5 = this.cubeTextWidth(graphics, jCAxis2, jCAxis2.getTitle(), true, true);
                d4 = -d5 * 0.002 / 2.0;
                extents.checkYExtents(d4);
                d3 = -d4;
                extents.checkYExtents(d3);
                d4 = -d11 - d2 - d14 - d13 / 4.0;
                extents.checkXExtents(d4);
                jCAxis2.setAnnoEaseway(d2 + d13 / 4.0);
            }
        }
        jCAxis.setDataportMin(jCBox2.x);
        jCAxis2.setDataportMin(jCBox2.y);
        jCAxis3.setDataportMin(jCBox2.z);
        jCAxis.setDataportMax(jCBox2.x + jCBox2.width);
        jCAxis2.setDataportMax(jCBox2.y + jCBox2.height);
        jCAxis3.setDataportMax(jCBox2.z + jCBox2.depth);
        jCBox.x = extents.getXMin();
        jCBox.y = extents.getYMin();
        jCBox.width = extents.getXMax() - extents.getXMin();
        jCBox.height = extents.getYMax() - extents.getYMin();
    }

    protected void calc3dAnno(Graphics graphics, JCBox jCBox, JCBox jCBox2) {
        Cube cube = this.area.getCube();
        cube.calc3DAnnoEdges();
        Point4d[] point4dArray = cube.getCubePoints();
        Extents extents = new Extents();
        int n2 = 0;
        while (n2 < 8) {
            extents.checkXYExtents(point4dArray[n2].x, point4dArray[n2].y);
            ++n2;
        }
        Chart3dDataView chart3dDataView = this.area.getChart3d().getDataView(0);
        Chart3dData chart3dData = chart3dDataView.getElevationData();
        chart3dData.calcAnnoLimits();
        JCAxis jCAxis = this.area.getAxis(1);
        JCAxis jCAxis2 = this.area.getAxis(2);
        JCAxis jCAxis3 = this.area.getAxis(3);
        jCAxis.calcMaxAnnoLength();
        jCAxis2.calcMaxAnnoLength();
        jCAxis3.calcMaxAnnoLength();
        jCBox2.x = jCAxis.getAnnoMin();
        jCBox2.y = jCAxis2.getAnnoMin();
        jCBox2.z = jCAxis3.getAnnoMin();
        jCBox2.width = jCAxis.getAnnoMax() - jCAxis.getAnnoMin();
        jCBox2.height = jCAxis2.getAnnoMax() - jCAxis2.getAnnoMin();
        jCBox2.depth = jCAxis3.getAnnoMax() - jCAxis3.getAnnoMin();
        Transform transform = this.area.getTransform();
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        Transform.scaleMatrix(matrix4d, 1.0, -1.0, 1.0);
        matrix4d.mul(transform.getPerspective());
        matrix4d.mul(transform.getRotation());
        this.bound3dAxis(graphics, jCAxis3, matrix4d, extents, jCBox2);
        this.bound3dAxis(graphics, jCAxis, matrix4d, extents, jCBox2);
        this.bound3dAxis(graphics, jCAxis2, matrix4d, extents, jCBox2);
        jCAxis.setDataportMin(jCBox2.x);
        jCAxis2.setDataportMin(jCBox2.y);
        jCAxis3.setDataportMin(jCBox2.z);
        jCAxis.setDataportMax(jCBox2.x + jCBox2.width);
        jCAxis2.setDataportMax(jCBox2.y + jCBox2.height);
        jCAxis3.setDataportMax(jCBox2.z + jCBox2.depth);
        jCBox.x = extents.getXMin();
        jCBox.y = -extents.getYMax();
        jCBox.width = extents.getXMax() - extents.getXMin();
        jCBox.height = extents.getYMax() - extents.getYMin();
    }

    protected void calcAnno(Graphics graphics, JCBox jCBox, JCBox jCBox2) {
        this.annoInit();
        if (this.area.getChart3d().isProjection()) {
            this.calc2dAnno(graphics, jCBox, jCBox2);
        } else {
            this.calc3dAnno(graphics, jCBox, jCBox2);
        }
    }

    protected void calcAxisBounds(JCAxis jCAxis, double d2, double d3, double d4, boolean bl) {
        int n2 = 2;
        if (1.0 + d4 * d2 != 1.0 && (n2 = (int)Math.round(JCChart3dUtil.ceil((d3 + d2) / (d4 * d2)))) < 2) {
            n2 = 2;
        }
        double d5 = jCAxis.getAnnoMin();
        double d6 = jCAxis.getAnnoMax();
        double d7 = d6 - d5;
        double d8 = d7 / 2000.0;
        double d9 = Double.MAX_VALUE;
        int n3 = 0;
        if (1.0 + d7 == 1.0) {
            d9 = 2.0;
            d5 -= 1.0;
            d6 += 1.0;
        } else {
            double d10 = JCChart3dUtil.niceNum(d7 / (double)(n2 - 1), true);
            if (d10 > d7) {
                d10 = JCChart3dUtil.niceNum(d7 / 2.0, true);
            }
            double d11 = d10 / 2.0;
            d9 = d10;
            double d12 = d5;
            double d13 = d6;
            if (!bl) {
                d12 = d11 * JCChart3dUtil.floor((d5 + d8) / d11);
                d13 = d11 * JCChart3dUtil.ceil((d6 - d8) / d11);
            }
            if (d5 - d12 >= d11 / 2.0) {
                d12 = d5;
            }
            if (d13 - d6 >= d11 / 2.0) {
                d13 = d6;
            }
            d5 = d12;
            d6 = d13;
            n3 = JCChart3dUtil.nDigits(d10);
        }
        jCAxis.setAnnoMin(d5);
        jCAxis.setAnnoMax(d6);
        jCAxis.setAnnoStep(d9);
        jCAxis.setNFrac(n3);
    }

    protected void cubeDrawString(Graphics graphics, JCAxis jCAxis, Matrix4d matrix4d, String string, boolean bl) {
        Font font;
        if (graphics == null || jCAxis == null || string == null || string.length() == 0) {
            return;
        }
        Font font2 = font = bl ? jCAxis.getTitleFont() : jCAxis.getAnnoFont();
        if (font == null) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Chart3dAnnoHandler chart3dAnnoHandler = jCAxis.getAnnoHandler();
        Rectangle2D rectangle2D = textLayout.getBounds();
        int n2 = 0;
        double d2 = 0.0;
        if (bl) {
            n2 = jCAxis.getTitleFontCubeSize();
            d2 = rectangle2D.getHeight();
        } else {
            n2 = jCAxis.getAnnoFontCubeSize();
            d2 = chart3dAnnoHandler.getAnnoHeight();
        }
        double d3 = bl ? -rectangle2D.getY() - d2 / 2.0 : chart3dAnnoHandler.getAnnoShift();
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(-rectangle2D.getX(), d3);
        Shape shape = textLayout.getOutline(affineTransform);
        PathIterator pathIterator = shape.getPathIterator(null);
        double d4 = (double)n2 * 0.002 / d2;
        GeneralPath generalPath = new GeneralPath(pathIterator.getWindingRule());
        while (!pathIterator.isDone()) {
            double[] dArray = new double[6];
            int n3 = pathIterator.currentSegment(dArray);
            switch (n3) {
                case 0: {
                    double d5 = dArray[0] * d4;
                    double d6 = dArray[1] * d4;
                    double d7 = 1.0 / (matrix4d.m30 * d5 + matrix4d.m31 * d6 + matrix4d.m33);
                    double d8 = d7 * (matrix4d.m00 * d5 + matrix4d.m01 * d6 + matrix4d.m03);
                    double d9 = d7 * (matrix4d.m10 * d5 + matrix4d.m11 * d6 + matrix4d.m13);
                    generalPath.moveTo((float)d8, (float)d9);
                    break;
                }
                case 1: {
                    double d5 = dArray[0] * d4;
                    double d6 = dArray[1] * d4;
                    double d7 = 1.0 / (matrix4d.m30 * d5 + matrix4d.m31 * d6 + matrix4d.m33);
                    double d8 = d7 * (matrix4d.m00 * d5 + matrix4d.m01 * d6 + matrix4d.m03);
                    double d9 = d7 * (matrix4d.m10 * d5 + matrix4d.m11 * d6 + matrix4d.m13);
                    generalPath.lineTo((float)d8, (float)d9);
                    break;
                }
                case 2: {
                    double d5 = dArray[0] * d4;
                    double d6 = dArray[1] * d4;
                    double d7 = 1.0 / (matrix4d.m30 * d5 + matrix4d.m31 * d6 + matrix4d.m33);
                    double d8 = d7 * (matrix4d.m00 * d5 + matrix4d.m01 * d6 + matrix4d.m03);
                    double d9 = d7 * (matrix4d.m10 * d5 + matrix4d.m11 * d6 + matrix4d.m13);
                    d5 = dArray[2] * d4;
                    d6 = dArray[3] * d4;
                    d7 = 1.0 / (matrix4d.m30 * d5 + matrix4d.m31 * d6 + matrix4d.m33);
                    double d10 = d7 * (matrix4d.m00 * d5 + matrix4d.m01 * d6 + matrix4d.m03);
                    double d11 = d7 * (matrix4d.m10 * d5 + matrix4d.m11 * d6 + matrix4d.m13);
                    generalPath.quadTo((float)d8, (float)d9, (float)d10, (float)d11);
                    break;
                }
                case 3: {
                    double d5 = dArray[0] * d4;
                    double d6 = dArray[1] * d4;
                    double d7 = 1.0 / (matrix4d.m30 * d5 + matrix4d.m31 * d6 + matrix4d.m33);
                    double d8 = d7 * (matrix4d.m00 * d5 + matrix4d.m01 * d6 + matrix4d.m03);
                    double d9 = d7 * (matrix4d.m10 * d5 + matrix4d.m11 * d6 + matrix4d.m13);
                    d5 = dArray[2] * d4;
                    d6 = dArray[3] * d4;
                    d7 = 1.0 / (matrix4d.m30 * d5 + matrix4d.m31 * d6 + matrix4d.m33);
                    double d10 = d7 * (matrix4d.m00 * d5 + matrix4d.m01 * d6 + matrix4d.m03);
                    double d11 = d7 * (matrix4d.m10 * d5 + matrix4d.m11 * d6 + matrix4d.m13);
                    d5 = dArray[4] * d4;
                    d6 = dArray[5] * d4;
                    d7 = 1.0 / (matrix4d.m30 * d5 + matrix4d.m31 * d6 + matrix4d.m33);
                    double d12 = d7 * (matrix4d.m00 * d5 + matrix4d.m01 * d6 + matrix4d.m03);
                    double d13 = d7 * (matrix4d.m10 * d5 + matrix4d.m11 * d6 + matrix4d.m13);
                    generalPath.curveTo((float)d8, (float)d9, (float)d10, (float)d11, (float)d12, (float)d13);
                    break;
                }
                case 4: {
                    generalPath.closePath();
                    break;
                }
            }
            pathIterator.next();
        }
        graphics2D.fill(generalPath);
    }

    protected double cubeTextWidth(Graphics graphics, JCAxis jCAxis, String string, boolean bl, boolean bl2) {
        Font font;
        if (graphics == null || jCAxis == null || string == null || string.length() == 0) {
            return 0.0;
        }
        Font font2 = font = bl ? jCAxis.getTitleFont() : jCAxis.getAnnoFont();
        if (font == null) {
            return 0.0;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(font);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(string, font, fontRenderContext);
        Chart3dAnnoHandler chart3dAnnoHandler = jCAxis.getAnnoHandler();
        Rectangle2D rectangle2D = textLayout.getBounds();
        int n2 = 0;
        double d2 = rectangle2D.getHeight();
        if (bl) {
            n2 = jCAxis.getTitleFontCubeSize();
        } else {
            n2 = jCAxis.getAnnoFontCubeSize();
            if (bl2) {
                d2 = chart3dAnnoHandler.getAnnoHeight();
            }
        }
        if (!bl2) {
            JCDebug.print("anno", "bounds - width:" + rectangle2D.getWidth());
            JCDebug.print("anno", " height:" + rectangle2D.getHeight());
            JCDebug.println("anno", " height used:" + d2);
        }
        return rectangle2D.getWidth() * (double)n2 / d2;
    }

    protected void determineVertical(int n2, Justify justify) {
        justify.setVertical(true);
        JCAxis jCAxis = null;
        switch (n2) {
            case 0: {
                jCAxis = this.area.getAxis(1);
                break;
            }
            case 4: {
                jCAxis = this.area.getAxis(2);
                break;
            }
            case 8: {
                jCAxis = this.area.getAxis(3);
                break;
            }
        }
        if (jCAxis != null && jCAxis.getMaxAnnoLength() > 1 && jCAxis.getAnnotationMethod() != 1) {
            return;
        }
        boolean[] blArray = this.area.getCube().getAnnotateEdge();
        int n3 = 0;
        int n4 = n2;
        while (n4 <= n2 + 3) {
            if (blArray[n4]) {
                ++n3;
            }
            ++n4;
        }
        Point2d point2d = null;
        point2d = n3 == 1 ? this.findEdgeDxDy(n2) : this.findAxisDxDy(n2);
        if (point2d != null) {
            justify.setVertical(Math.abs(point2d.y) > Math.abs(point2d.x));
        }
    }

    protected void draw2dAnno(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        graphics.setColor(this.area.getPlotCube().getDrawForeground());
        Matrix4d matrix4d = this.area.getTransform().getScreen();
        this.draw2dAxis(graphics, this.area.getAxis(1), matrix4d);
        this.draw2dAxis(graphics, this.area.getAxis(2), matrix4d);
    }

    protected void draw2dAxis(Graphics graphics, JCAxis jCAxis, Matrix4d matrix4d) {
        boolean bl;
        JCPlotCube jCPlotCube = this.area.getPlotCube();
        double d2 = jCPlotCube.getXNormalizedScale();
        double d3 = jCPlotCube.getYNormalizedScale();
        Justify justify = new Justify();
        justify.setFlipX(false);
        justify.setFlipY(false);
        switch (jCAxis.getAxisId()) {
            case 1: {
                bl = true;
                justify.setAbove(false);
                justify.setRotate(1);
                break;
            }
            case 2: {
                bl = false;
                justify.setAbove(true);
                justify.setRotate(2);
                break;
            }
            default: {
                return;
            }
        }
        double d4 = (double)jCAxis.getAnnoFontCubeSize() * 0.002;
        double d5 = (double)jCAxis.getTitleFontCubeSize() * 0.002;
        if (jCAxis.isShowing()) {
            double d6;
            double d7;
            double d8;
            double d9 = jCAxis.getAnnoMin();
            double d10 = jCAxis.getAnnoMax();
            ArrayList arrayList = jCAxis.getAnnoHandler().getValueLabels();
            if (arrayList != null && arrayList.size() > 0) {
                int n2 = 0;
                while (n2 < arrayList.size()) {
                    JCValueLabel jCValueLabel = (JCValueLabel)arrayList.get(n2);
                    double d11 = jCValueLabel.getValue();
                    String string = jCValueLabel.getLabel();
                    if (d9 <= d11 && d11 <= d10) {
                        d8 = this.cubeTextWidth(graphics, jCAxis, string, false, true);
                        double d12 = d8 * 0.002;
                        this.axisMatrix.set(matrix4d);
                        double d13 = 2.0 * (d11 - d9) / (d10 - d9) - 1.0;
                        if (bl) {
                            d7 = d13 * d2;
                            d6 = -d3;
                        } else {
                            d7 = -d2;
                            d6 = d13 * d3;
                        }
                        Transform.translateMatrix(this.axisMatrix, d7, d6, 0.0);
                        Transform.scaleMatrix(this.axisMatrix, 1.0, -1.0, 1.0);
                        if (!bl) {
                            Transform.rotateMatrix(this.axisMatrix, 4, 3);
                        }
                        this.drawAnnotation(graphics, jCAxis, this.axisMatrix, string, justify, d4, d12, jCValueLabel.isTickOnly());
                    }
                    ++n2;
                }
            }
            if (jCAxis.getTitle() != null) {
                d8 = this.cubeTextWidth(graphics, jCAxis, jCAxis.getTitle(), true, true);
                double d14 = d8 * 0.002;
                this.axisMatrix.set(matrix4d);
                Transform.scaleMatrix(this.axisMatrix, 1.0, -1.0, 1.0);
                if (bl) {
                    d7 = -d14 / 2.0;
                    d6 = d3 + jCAxis.getAnnoEaseway() + d5 / 2.0;
                } else {
                    d7 = -d2 - jCAxis.getAnnoEaseway() - d5 / 2.0;
                    d6 = d14 / 2.0;
                }
                Transform.translateMatrix(this.axisMatrix, d7, d6, 0.0);
                if (!bl) {
                    Transform.rotateMatrix(this.axisMatrix, 4, 3);
                }
                this.cubeDrawString(graphics, jCAxis, this.axisMatrix, jCAxis.getTitle(), true);
            }
        }
    }

    public void draw3dAnno(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        graphics.setColor(this.area.getPlotCube().getDrawForeground());
        Matrix4d matrix4d = this.area.getTransform().getTextView();
        this.draw3dAxis(graphics, this.area.getAxis(3), matrix4d);
        this.draw3dAxis(graphics, this.area.getAxis(1), matrix4d);
        this.draw3dAxis(graphics, this.area.getAxis(2), matrix4d);
    }

    protected void draw3dAxis(Graphics graphics, JCAxis jCAxis, Matrix4d matrix4d) {
        JCPlotCube jCPlotCube = this.area.getPlotCube();
        boolean[] blArray = this.area.getCube().getAnnotateEdge();
        Chart3dDataView chart3dDataView = this.area.getChart3d().getDataView(0);
        Justify justify = new Justify();
        int n2 = -1;
        double d2 = 1.0;
        switch (jCAxis.getAxisId()) {
            case 1: {
                n2 = 0;
                d2 = jCPlotCube.getXNormalizedScale();
                break;
            }
            case 2: {
                n2 = 4;
                d2 = jCPlotCube.getYNormalizedScale();
                break;
            }
            case 3: {
                n2 = 8;
                d2 = jCPlotCube.getZNormalizedScale();
                break;
            }
            default: {
                return;
            }
        }
        double d3 = (double)jCAxis.getAnnoFontCubeSize() * 0.002;
        double d4 = (double)jCAxis.getTitleFontCubeSize() * 0.002;
        this.determineVertical(n2, justify);
        int n3 = n2;
        while (n3 <= n2 + 3) {
            if (blArray[n3]) {
                double d5 = jCAxis.getAnnoMin();
                double d6 = jCAxis.getAnnoMax();
                double d7 = jCAxis.getAnnoStep() / 2.0;
                double d8 = jCAxis.getDataportMin();
                double d9 = jCAxis.getDataportMax();
                this.edgeMatrix = this.getEdgeMatrix(n3);
                this.orientationMatrix = this.getOrientationMatrix(n3, justify);
                this.axisMatrix.mul(matrix4d, this.edgeMatrix);
                ArrayList arrayList = jCAxis.getAnnoHandler().getValueLabels();
                if (arrayList != null && arrayList.size() != 0) {
                    double d10;
                    int n4 = 0;
                    while (n4 < arrayList.size()) {
                        JCValueLabel jCValueLabel = (JCValueLabel)arrayList.get(n4);
                        double d11 = jCValueLabel.getValue();
                        if (d5 <= d11 && d11 <= d6) {
                            String string = jCValueLabel.getLabel();
                            this.matrix.set(this.axisMatrix);
                            d10 = (2.0 * (d11 - d8) / (d9 - d8) - 1.0) * d2;
                            Transform.translateMatrix(this.matrix, d10, 0.0, 0.0);
                            this.matrix.mul(this.orientationMatrix);
                            Transform.scaleMatrix(this.matrix, 1.0, -1.0, 1.0);
                            double d12 = this.cubeTextWidth(graphics, jCAxis, string, false, true);
                            double d13 = d12 * 0.002;
                            this.drawAnnotation(graphics, jCAxis, this.matrix, string, justify, d3, d13, jCValueLabel.isTickOnly());
                        }
                        ++n4;
                    }
                    if (jCAxis.getTitle() != null) {
                        this.matrix.mul(this.axisMatrix, this.orientationMatrix);
                        Transform.scaleMatrix(this.matrix, 1.0, -1.0, 1.0);
                        double d14 = this.cubeTextWidth(graphics, jCAxis, jCAxis.getTitle(), true, true);
                        double d15 = d14 * 0.002;
                        d10 = jCAxis.getAnnoEaseway();
                        if (justify.above) {
                            d10 = -d10;
                        }
                        Transform.translateMatrix(this.matrix, -d15 / 2.0, d10, 0.0);
                        if (justify.doSpinTitle()) {
                            Transform.translateMatrix(this.matrix, d15, 0.0, 0.0);
                            Transform.rotateMatrix(this.matrix, 3, 3);
                        }
                        if (justify.doFlipY()) {
                            Transform.translateMatrix(this.matrix, d15, 0.0, 0.0);
                            Transform.rotateMatrix(this.matrix, 3, 2);
                        }
                        if (justify.doFlipX()) {
                            Transform.rotateMatrix(this.matrix, 3, 1);
                        }
                        this.cubeDrawString(graphics, jCAxis, this.matrix, jCAxis.getTitle(), true);
                    }
                }
            }
            ++n3;
        }
    }

    protected void drawAnnotation(Graphics graphics, JCAxis jCAxis, Matrix4d matrix4d, String string, Justify justify, double d2, double d3, boolean bl) {
        if (this.u0 == null) {
            this.u0 = new Point4d();
            this.u1 = new Point4d();
            this.u2 = new Point4d();
            this.u3 = new Point4d();
        }
        this.u0.set(0.0, 0.0, 0.0, 1.0);
        Transform.transformPoint(matrix4d, this.u0);
        this.u1.set(0.0, justify.isAbove() ? -d2 / 2.0 : d2 / 2.0, 0.0, 1.0);
        if (bl) {
            this.u1.y *= 0.6;
        }
        Transform.transformPoint(matrix4d, this.u1);
        graphics.drawLine((int)Math.round(this.u0.x), (int)Math.round(this.u0.y), (int)Math.round(this.u1.x), (int)Math.round(this.u1.y));
        if (bl || string == null || string.length() == 0) {
            return;
        }
        this.justifyMatrix = this.getJustifyMatrix(d2, d3, justify);
        this.matrix.mul(matrix4d, this.justifyMatrix);
        this.cubeDrawString(graphics, jCAxis, this.matrix, string, false);
    }

    protected Point2d findAxisDxDy(int n2) {
        if (this.unitMatrix == null) {
            Transform transform = this.area.getTransform();
            this.unitMatrix = new Matrix4d(transform.getPerspective());
            this.unitMatrix.mul(transform.getRotation());
        }
        double d2 = 0.0;
        double d3 = 0.0;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                d2 = this.unitMatrix.m00;
                d3 = -this.unitMatrix.m10;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                d2 = this.unitMatrix.m01;
                d3 = -this.unitMatrix.m11;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                d2 = this.unitMatrix.m02;
                d3 = -this.unitMatrix.m12;
                break;
            }
        }
        return new Point2d(d2, d3);
    }

    protected Point2d findEdgeDxDy(int n2) {
        Point4d[] point4dArray = this.area.getCube().getCubePoints();
        double d2 = point4dArray[Cube.edges[n2][1]].x - point4dArray[Cube.edges[n2][0]].x;
        double d3 = point4dArray[Cube.edges[n2][1]].y - point4dArray[Cube.edges[n2][0]].y;
        return new Point2d(d2, d3);
    }

    protected String formatAnno(double d2, int n2) {
        String string = JCNumberUtil.format(d2, Math.max(0, n2));
        return string;
    }

    public JCChart3dArea getChart3dArea() {
        return this.area;
    }

    protected Matrix4d getEdgeMatrix(int n2) {
        if (this.edgeMatrix == null) {
            this.edgeMatrix = new Matrix4d();
        }
        this.edgeMatrix.setIdentity();
        JCPlotCube jCPlotCube = this.area.getPlotCube();
        double d2 = jCPlotCube.getXNormalizedScale();
        double d3 = jCPlotCube.getYNormalizedScale();
        double d4 = jCPlotCube.getZNormalizedScale();
        switch (n2) {
            case 0: {
                Transform.translateMatrix(this.edgeMatrix, 0.0, -d3, -d4);
                break;
            }
            case 1: {
                Transform.translateMatrix(this.edgeMatrix, 0.0, -d3, d4);
                break;
            }
            case 2: {
                Transform.translateMatrix(this.edgeMatrix, 0.0, d3, -d4);
                break;
            }
            case 3: {
                Transform.translateMatrix(this.edgeMatrix, 0.0, d3, d4);
                break;
            }
            case 4: {
                Transform.translateMatrix(this.edgeMatrix, -d2, 0.0, -d4);
                Transform.rotateMatrix(this.edgeMatrix, 2, 3);
                break;
            }
            case 5: {
                Transform.translateMatrix(this.edgeMatrix, -d2, 0.0, d4);
                Transform.rotateMatrix(this.edgeMatrix, 2, 3);
                break;
            }
            case 6: {
                Transform.translateMatrix(this.edgeMatrix, d2, 0.0, -d4);
                Transform.rotateMatrix(this.edgeMatrix, 2, 3);
                break;
            }
            case 7: {
                Transform.translateMatrix(this.edgeMatrix, d2, 0.0, d4);
                Transform.rotateMatrix(this.edgeMatrix, 2, 3);
                break;
            }
            case 8: {
                Transform.translateMatrix(this.edgeMatrix, -d2, -d3, 0.0);
                Transform.rotateMatrix(this.edgeMatrix, 4, 2);
                break;
            }
            case 9: {
                Transform.translateMatrix(this.edgeMatrix, -d2, d3, 0.0);
                Transform.rotateMatrix(this.edgeMatrix, 4, 2);
                break;
            }
            case 10: {
                Transform.translateMatrix(this.edgeMatrix, d2, -d3, 0.0);
                Transform.rotateMatrix(this.edgeMatrix, 4, 2);
                break;
            }
            case 11: {
                Transform.translateMatrix(this.edgeMatrix, d2, d3, 0.0);
                Transform.rotateMatrix(this.edgeMatrix, 4, 2);
                break;
            }
        }
        return this.edgeMatrix;
    }

    protected Matrix4d getJustifyMatrix(double d2, double d3, Justify justify) {
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        switch (justify.getRotate()) {
            case 1: {
                d4 = -d3 / 2.0;
                d5 = d2 * 1.15;
                if (justify.isAbove()) {
                    d5 = -d5;
                }
                d6 = d2 * 1.65;
                break;
            }
            case 2: {
                d5 = d2 * 0.65;
                if (justify.isAbove()) {
                    d5 = -d3 - d5;
                }
                d6 = d3 + d2 * 0.65;
                break;
            }
            case 3: {
                d4 = d3 / 2.0;
                d5 = d2 * 1.15;
                if (justify.isAbove()) {
                    d5 = -d5;
                }
                d6 = d2 * 1.65;
                break;
            }
            case 4: {
                d5 = -d2 * 0.65;
                if (!justify.isAbove()) {
                    d5 = d3 - d5;
                }
                d6 = d3 + d2 * 0.65;
                break;
            }
        }
        justify.setEaseway(d6);
        if (this.justifyMatrix == null) {
            this.justifyMatrix = new Matrix4d();
        }
        this.justifyMatrix.setIdentity();
        Transform.translateMatrix(this.justifyMatrix, d4, d5, 0.0);
        Transform.rotateMatrix(this.justifyMatrix, justify.getRotate(), 3);
        if (justify.doFlipY()) {
            Transform.translateMatrix(this.justifyMatrix, d3, 0.0, 0.0);
            Transform.rotateMatrix(this.justifyMatrix, 3, 2);
        }
        return this.justifyMatrix;
    }

    protected Matrix4d getOrientationMatrix(int n2, Justify justify) {
        Transform transform = this.area.getTransform();
        Matrix4d matrix4d = transform.getRotation();
        if (this.orientationMatrix == null) {
            this.orientationMatrix = new Matrix4d();
        }
        this.orientationMatrix.setIdentity();
        justify.setFlipX(false);
        justify.setFlipY(false);
        justify.setSpinTitle(false);
        if (this.planeMatrixInit == null) {
            this.planeMatrixInit = new Matrix4d();
            this.planeMatrixInit.setIdentity();
            Transform.scaleMatrix(this.planeMatrixInit, 1.0, -1.0, 1.0);
            this.planeMatrixInit.mul(transform.getPerspective());
            this.planeMatrixInit.mul(matrix4d);
        }
        this.matrix.mul(this.planeMatrixInit, this.edgeMatrix);
        if (this.u0 == null) {
            this.u0 = new Point4d();
            this.u1 = new Point4d();
            this.u2 = new Point4d();
            this.u3 = new Point4d();
        }
        this.u0.set(0.0, 0.0, 0.0, 1.0);
        this.u1.set(1.0, 0.0, 0.0, 1.0);
        this.u2.set(0.0, 1.0, 0.0, 1.0);
        this.u3.set(0.0, 0.0, 1.0, 1.0);
        Transform.transformPoint(this.matrix, this.u0);
        Transform.transformPoint(this.matrix, this.u1);
        Transform.transformPoint(this.matrix, this.u2);
        Transform.transformPoint(this.matrix, this.u3);
        if (this.vx == null) {
            this.vx = new Vector3d();
            this.vy = new Vector3d();
            this.vz = new Vector3d();
        }
        this.vx.set(this.u1.x - this.u0.x, this.u1.y - this.u0.y, this.u1.z - this.u0.z);
        this.vy.set(this.u2.x - this.u0.x, this.u2.y - this.u0.y, this.u2.z - this.u0.z);
        this.vz.set(this.u3.x - this.u0.x, this.u3.y - this.u0.y, this.u3.z - this.u0.z);
        this.vx.normalize();
        this.vy.normalize();
        this.vz.normalize();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = this.vy.z;
        double d5 = this.vz.z;
        switch (n2) {
            case 0: {
                justify.setAbove(false);
                d2 = matrix4d.m00;
                d3 = matrix4d.m10;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 2, 1);
                    if (!(-d4 < 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 < 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 1: {
                justify.setAbove(false);
                d2 = matrix4d.m00;
                d3 = matrix4d.m10;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 4, 1);
                    if (!(d4 < 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 < 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 2: {
                justify.setAbove(true);
                d2 = matrix4d.m00;
                d3 = matrix4d.m10;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 4, 1);
                    if (!(d4 < 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 < 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 3: {
                justify.setAbove(true);
                d2 = matrix4d.m00;
                d3 = matrix4d.m10;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 2, 1);
                    if (!(-d4 < 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 < 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 4: {
                justify.setAbove(true);
                d2 = matrix4d.m01;
                d3 = matrix4d.m11;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 4, 1);
                    if (!(d4 < 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 < 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 5: {
                justify.setAbove(true);
                d2 = matrix4d.m01;
                d3 = matrix4d.m11;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 2, 1);
                    if (!(-d4 < 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 < 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 6: {
                justify.setAbove(false);
                d2 = matrix4d.m01;
                d3 = matrix4d.m11;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 2, 1);
                    if (!(-d4 < 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 < 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 7: {
                justify.setAbove(false);
                d2 = matrix4d.m01;
                d3 = matrix4d.m11;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 4, 1);
                    if (!(d4 < 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 < 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 8: {
                justify.setAbove(false);
                d2 = matrix4d.m02;
                d3 = matrix4d.m12;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 4, 1);
                    if (!(d4 < 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 < 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 9: {
                justify.setAbove(true);
                d2 = matrix4d.m02;
                d3 = matrix4d.m12;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 2, 1);
                    if (!(-d4 < 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 < 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 10: {
                justify.setAbove(false);
                d2 = matrix4d.m02;
                d3 = matrix4d.m12;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 2, 1);
                    if (!(-d4 < 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 < 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
            case 11: {
                justify.setAbove(true);
                d2 = matrix4d.m02;
                d3 = matrix4d.m12;
                if (Math.abs(d5) < Math.abs(d4)) {
                    Transform.rotateMatrix(this.orientationMatrix, 4, 1);
                    if (!(d4 < 0.0)) break;
                    justify.setFlipY(true);
                    d2 = -d2;
                    break;
                }
                if (!(d5 < 0.0)) break;
                justify.setFlipY(true);
                d2 = -d2;
                break;
            }
        }
        int n3 = 1;
        n3 = justify.isVertical() ? (d3 >= 0.0 ? 2 : 4) : (d2 >= 0.0 ? 1 : 3);
        justify.setRotate(n3);
        Point2d point2d = this.findEdgeDxDy(n2);
        if (justify.doFlipY()) {
            point2d.x = -point2d.x;
        }
        if (point2d.x < 0.0) {
            justify.setSpinTitle(true);
        } else {
            justify.setSpinTitle(false);
        }
        return this.orientationMatrix;
    }

    protected double guessLongestAnnotation(Graphics graphics, JCAxis jCAxis) {
        double d2 = jCAxis.getAnnoMin();
        double d3 = jCAxis.getAnnoMax();
        jCAxis.setNFrac(JCNumberUtil.nicePrecision(d3 - d2));
        Chart3dAnnoHandler chart3dAnnoHandler = jCAxis.getAnnoHandler();
        double d4 = JCChart3dUtil.niceNum(d2, false) + JCChart3dUtil.niceNum(d3 - d2, false) / 10.0;
        JCValueLabel jCValueLabel = chart3dAnnoHandler.getLabelFromValue(d4, false);
        String string = "00" + jCValueLabel.getLabel();
        double d5 = this.cubeTextWidth(graphics, jCAxis, string, false, false);
        d4 = JCChart3dUtil.niceNum(d3, true) - JCChart3dUtil.niceNum(d3 - d2, false) / 10.0;
        jCValueLabel = chart3dAnnoHandler.getLabelFromValue(d4, false);
        string = "00" + jCValueLabel.getLabel();
        double d6 = this.cubeTextWidth(graphics, jCAxis, string, false, false);
        return Math.max(d5, d6);
    }

    public void setChart3dArea(JCChart3dArea jCChart3dArea) {
        this.area = jCChart3dArea;
    }
}

