/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.data;

import com.klg.jclass.chart.data.BaseDataSource;
import com.klg.jclass.chart.data.JCDataInterpreter;
import com.klg.jclass.util.xml.JCXMLDTDResolver;
import com.klg.jclass.util.xml.JCXMLErrorPrinter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JCXMLDataInterpreter
extends JCDataInterpreter
implements Serializable {
    public static final String XML_DS = "JCChartData";
    public static final String XML_DS_ATT_NAME = "Name";
    public static final String XML_DS_ATT_HOLE = "Hole";
    public static final String XML_DS_SERIES = "Series";
    public static final String XML_DS_SERIESLABEL = "SeriesLabel";
    public static final String XML_DS_POINT = "Point";
    public static final String XML_DS_POINTLABEL = "PointLabel";
    public static final String XML_DS_XDATA = "XData";
    public static final String XML_DS_YDATA = "YData";
    static final String ERRMSG_FILE_FORMAT = "Error in data file format - ";

    public JCXMLDataInterpreter() {
    }

    public JCXMLDataInterpreter(BaseDataSource baseDataSource) throws IOException {
        super(baseDataSource);
    }

    protected void ctor(Reader reader) throws IOException {
        this.interpret(new InputSource(reader));
    }

    private void displayErrorMessage(int n2, String string) {
        String string2 = "";
        switch (n2) {
            case 1: {
                string2 = String.valueOf(string2) + "Data must start with ARRAY or GENERAL and not";
                break;
            }
            case 2: {
                string2 = String.valueOf(string2) + "Expect either a hole or numeric value and not ";
                break;
            }
            case 3: {
                string2 = String.valueOf(string2) + "Expect a point label and not ";
                break;
            }
            default: {
                return;
            }
        }
        if (string != null && string.length() > 0) {
            string2 = String.valueOf(string2) + "'";
            string2 = String.valueOf(string2) + string;
            string2 = String.valueOf(string2) + "'";
        }
        System.err.println(string2);
    }

    private double getNextDouble(String string) throws IOException {
        if (string == null || string.equalsIgnoreCase("HOLE")) {
            return this.baseDS.holeValue;
        }
        if (string.equalsIgnoreCase("MAX")) {
            return Double.MAX_VALUE;
        }
        if (string.equalsIgnoreCase("MIN")) {
            return Double.MIN_VALUE;
        }
        double d2 = 0.0;
        try {
            d2 = Double.valueOf(string);
        }
        catch (Exception exception) {
            this.displayErrorMessage(2, string);
            throw new IOException(ERRMSG_FILE_FORMAT);
        }
        return d2;
    }

    private synchronized void interpret(InputSource inputSource) throws IOException {
        Node node;
        Object object;
        Object object2;
        Document document = null;
        try {
            object2 = DocumentBuilderFactory.newInstance();
            ((DocumentBuilderFactory)object2).setValidating(true);
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            inputSource.setSystemId("file:/template.xml");
            ((DocumentBuilder)object).setErrorHandler(new JCXMLErrorPrinter());
            ((DocumentBuilder)object).setEntityResolver(new JCXMLDTDResolver("JCChartData.dtd"));
            document = ((DocumentBuilder)object).parse(inputSource);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace(System.err);
            throw new IOException("XML Parser Configuration Error");
        }
        catch (SAXParseException sAXParseException) {
            sAXParseException.printStackTrace(System.err);
            throw new IOException("XML Parsing Error");
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace(System.err);
            throw new IOException("XML Error");
        }
        catch (IOException iOException) {
            iOException.printStackTrace(System.err);
            throw iOException;
        }
        if (document == null) {
            return;
        }
        object2 = document.getElementsByTagName(XML_DS);
        object = object2.item(0);
        object.normalize();
        NamedNodeMap namedNodeMap = object.getAttributes();
        Node node2 = namedNodeMap.getNamedItem(XML_DS_ATT_NAME);
        if (node2 != null) {
            this.baseDS.name = new String(node2.getNodeValue());
        }
        if ((node = namedNodeMap.getNamedItem(XML_DS_ATT_HOLE)) != null) {
            this.baseDS.holeValue = this.getNextDouble(node.getNodeValue());
        }
        Node node3 = null;
        NodeList nodeList = ((Element)object).getElementsByTagName(XML_DS_SERIES);
        if (nodeList.getLength() > 0) {
            node3 = nodeList.item(0);
            this.interpretSeries((Node)object, node3);
            return;
        }
        NodeList nodeList2 = ((Element)object).getElementsByTagName(XML_DS_POINT);
        if (nodeList2.getLength() > 0) {
            node3 = nodeList2.item(0);
            this.interpretPoint((Node)object, node3);
            return;
        }
    }

    private void interpretPoint(Node node, Node node2) throws IOException {
        NodeList nodeList;
        Object object;
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        NodeList nodeList2 = ((Element)node).getElementsByTagName(XML_DS_POINT);
        n3 = nodeList2.getLength();
        int n4 = 0;
        while (n4 < n3) {
            Node node3 = nodeList2.item(n4);
            object = ((Element)node3).getElementsByTagName(XML_DS_XDATA);
            if (object.getLength() > 0) {
                bl = true;
            }
            nodeList = ((Element)node3).getElementsByTagName(XML_DS_YDATA);
            int n5 = nodeList.getLength();
            n2 = Math.max(n2, n5);
            ++n4;
        }
        this.baseDS.xvalues = new double[1][n3];
        this.baseDS.yvalues = new double[n2][n3];
        this.baseDS.seriesLabels = new String[n2];
        this.baseDS.pointLabels = new String[n3];
        int n6 = 0;
        while (n6 < n3) {
            object = nodeList2.item(n6);
            nodeList = ((Element)object).getElementsByTagName(XML_DS_POINTLABEL);
            if (nodeList.getLength() > 0) {
                Node node4 = nodeList.item(0);
                this.baseDS.pointLabels[n6] = (node4 = node4.getFirstChild()) != null && node4 instanceof Text ? node4.getNodeValue() : "";
            } else {
                this.baseDS.pointLabels[n6] = null;
            }
            if (bl) {
                double d2 = this.baseDS.holeValue;
                NodeList nodeList3 = ((Element)object).getElementsByTagName(XML_DS_XDATA);
                if (nodeList3.getLength() > 0) {
                    Node node5 = nodeList3.item(0);
                    if ((node5 = node5.getFirstChild()) != null && node5 instanceof Text) {
                        d2 = this.getNextDouble(node5.getNodeValue());
                    }
                }
                this.baseDS.xvalues[0][n6] = d2;
            } else {
                this.baseDS.xvalues[0][n6] = n6 + 1;
            }
            NodeList nodeList4 = ((Element)object).getElementsByTagName(XML_DS_YDATA);
            int n7 = 0;
            while (n7 < this.baseDS.yvalues.length) {
                double d3 = this.baseDS.holeValue;
                if (nodeList4.getLength() > n7) {
                    Node node6 = nodeList4.item(n7);
                    if ((node6 = node6.getFirstChild()) != null && node6 instanceof Text) {
                        d3 = this.getNextDouble(node6.getNodeValue());
                    }
                }
                this.baseDS.yvalues[n7][n6] = d3;
                ++n7;
            }
            ++n6;
        }
        object = ((Element)node).getElementsByTagName(XML_DS_SERIESLABEL);
        int n8 = 0;
        while (n8 < this.baseDS.seriesLabels.length) {
            Node node7;
            Node node8;
            this.baseDS.seriesLabels[n8] = object.getLength() > n8 ? ((node8 = (node7 = object.item(n8)).getFirstChild()) != null && node8 instanceof Text ? node8.getNodeValue() : "") : null;
            ++n8;
        }
    }

    private void interpretSeries(Node node, Node node2) throws IOException {
        int n2;
        Object object;
        NodeList nodeList;
        int n3;
        Object object2;
        int n4 = 0;
        int n5 = 0;
        NodeList nodeList2 = ((Element)node).getElementsByTagName(XML_DS_SERIES);
        n5 = nodeList2.getLength();
        int n6 = 0;
        while (n6 < n5) {
            Node node3 = nodeList2.item(n6);
            object2 = ((Element)node3).getElementsByTagName(XML_DS_XDATA);
            if (object2.getLength() > 0) {
                ++n4;
            }
            ++n6;
        }
        if (n4 > 1) {
            this.baseDS.xvalues = new double[n5][];
            this.baseDS.yvalues = new double[n5][];
        }
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            object2 = nodeList2.item(n8);
            n3 = 0;
            int n9 = 0;
            nodeList = ((Element)object2).getElementsByTagName(XML_DS_XDATA);
            n3 = nodeList.getLength();
            object = ((Element)object2).getElementsByTagName(XML_DS_YDATA);
            n9 = object.getLength();
            n2 = Math.max(n3, n9);
            if (n4 > 1) {
                this.baseDS.xvalues[n8] = new double[n2];
                this.baseDS.yvalues[n8] = new double[n2];
            }
            n7 = Math.max(n7, n2);
            ++n8;
        }
        if (n4 == 0 || n4 == 1) {
            this.baseDS.xvalues = new double[1][n7];
            this.baseDS.yvalues = new double[n5][n7];
        }
        this.baseDS.seriesLabels = new String[n5];
        this.baseDS.pointLabels = new String[n7];
        boolean bl = false;
        n3 = 0;
        while (n3 < n5) {
            Node node4 = nodeList2.item(n3);
            nodeList = ((Element)node4).getElementsByTagName(XML_DS_SERIESLABEL);
            if (nodeList.getLength() > 0) {
                object = nodeList.item(0);
                this.baseDS.seriesLabels[n3] = (object = object.getFirstChild()) != null && object instanceof Text ? object.getNodeValue() : "";
            } else {
                this.baseDS.seriesLabels[n3] = null;
            }
            object = n4 == 0 || n4 == 1 ? (bl ? null : (Object)this.baseDS.xvalues[0]) : (Object)this.baseDS.xvalues[n3];
            n2 = 0;
            while (object != null && n2 < ((Object)object).length) {
                if (n4 > 0) {
                    NodeList nodeList3 = ((Element)node4).getElementsByTagName(XML_DS_XDATA);
                    double d2 = this.baseDS.holeValue;
                    if (nodeList3.getLength() > n2) {
                        Node node5 = nodeList3.item(n2);
                        if ((node5 = node5.getFirstChild()) != null && node5 instanceof Text) {
                            d2 = this.getNextDouble(node5.getNodeValue());
                        }
                        bl = true;
                    }
                    object[n2] = n4 == 1 ? (Object)d2 : (Object)d2;
                } else {
                    if (n3 == 0) {
                        object[n2] = (double)(n2 + 1);
                    }
                    bl = true;
                }
                ++n2;
            }
            int n10 = 0;
            while (n10 < this.baseDS.yvalues[n3].length) {
                NodeList nodeList4 = ((Element)node4).getElementsByTagName(XML_DS_YDATA);
                double d3 = this.baseDS.holeValue;
                if (nodeList4.getLength() > n10) {
                    Node node6 = nodeList4.item(n10);
                    if ((node6 = node6.getFirstChild()) != null && node6 instanceof Text) {
                        d3 = this.getNextDouble(node6.getNodeValue());
                    }
                }
                this.baseDS.yvalues[n3][n10] = d3;
                ++n10;
            }
            ++n3;
        }
        NodeList nodeList5 = ((Element)node).getElementsByTagName(XML_DS_POINTLABEL);
        int n11 = 0;
        while (n11 < this.baseDS.pointLabels.length) {
            Node node7;
            this.baseDS.pointLabels[n11] = nodeList5.getLength() > n11 ? ((node7 = (object = nodeList5.item(n11)).getFirstChild()) != null && node7 instanceof Text ? node7.getNodeValue() : "") : null;
            ++n11;
        }
    }
}

