/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.data;

import com.klg.jclass.chart.ChartDataEvent;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.data.BaseDataSource;
import com.klg.jclass.chart.data.ChartDataSourceUtil;

public class JCDefaultDataSource
extends BaseDataSource {
    protected boolean suppressMultipleGeneration = false;
    private static final String QUOTE = "'";
    private static final String NL = "\n";
    private static final String BLANK = " ";
    private static final String COMMENT = "#";
    private static final String commentLine1 = "# " + JCChartBundle.string("com.klg.jclass.chart.Key167") + "\n";
    private static final String commentLine2 = "# " + JCChartBundle.string("com.klg.jclass.chart.Key168") + "\n";
    private static final String commentLine3 = "# " + JCChartBundle.string("com.klg.jclass.chart.Key169") + "\n";
    private static final String commentLine4 = "# " + JCChartBundle.string("com.klg.jclass.chart.Key170") + "\n";
    protected static double[][] defaultY = new double[][]{{20.0, 22.0, 19.0, 24.0, 25.0}, {8.0, 12.0, 10.0, 12.0, 15.0}, {10.0, 16.0, 17.0, 15.0, 23.0}, {16.0, 19.0, 15.0, 22.0, 18.0}};

    public JCDefaultDataSource() {
        this(null, defaultY, null, null, null);
        this.generateLabels();
    }

    public JCDefaultDataSource(double[][] dArray, double[][] dArray2, String[] stringArray, String[] stringArray2, String string) {
        this.xvalues = dArray;
        this.yvalues = dArray2;
        this.pointLabels = stringArray;
        this.seriesLabels = stringArray2;
        this.name = string;
        this.check();
    }

    public String buildDataSourceString() {
        return ChartDataSourceUtil.buildDataSourceString(this);
    }

    protected void check() {
        if (this.yvalues == null || this.yvalues.length <= 0) {
            return;
        }
        if (this.xvalues == null) {
            if (this.suppressMultipleGeneration) {
                this.xvalues = (double[][])(this.yvalues != null && this.yvalues.length > 0 ? ChartDataSourceUtil.generateSingleXSeries(this.yvalues[0].length) : null);
                return;
            }
            boolean bl = false;
            int n2 = this.yvalues[0].length;
            int n3 = 1;
            while (n3 < this.yvalues.length) {
                if (this.yvalues[n3].length != n2) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            this.xvalues = bl ? ChartDataSourceUtil.generateMultipleXSeries(this.yvalues) : (double[][])(this.yvalues != null && this.yvalues.length > 0 ? ChartDataSourceUtil.generateSingleXSeries(this.yvalues[0].length) : null);
        }
    }

    protected void generateLabels() {
        this.name = new String(JCChartBundle.string("com.klg.jclass.chart.Key165"));
        if (this.yvalues == null) {
            return;
        }
        this.seriesLabels = new String[this.getNumSeries()];
        int n2 = 0;
        while (n2 < this.seriesLabels.length) {
            this.seriesLabels[n2] = String.valueOf(JCChartBundle.string("com.klg.jclass.chart.Key127")) + (n2 + 1);
            ++n2;
        }
        this.pointLabels = new String[this.getXSeries(0).length];
        int n3 = 0;
        while (n3 < this.pointLabels.length) {
            this.pointLabels[n3] = String.valueOf(JCChartBundle.string("com.klg.jclass.chart.Key166")) + n3;
            ++n3;
        }
    }

    public void setData(double[][] dArray, double[][] dArray2) {
        this.xvalues = dArray;
        this.yvalues = dArray2;
        this.check();
        this.updateChart(12, 0, 0);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPointLabels(String[] stringArray) {
        this.pointLabels = stringArray;
        this.updateChart(6, 0, 0);
    }

    public void setSeriesLabels(String[] stringArray) {
        this.seriesLabels = stringArray;
        this.updateChart(8, 0, 0);
    }

    public void setXSeries(int n2, double[] dArray) {
        if (n2 >= this.xvalues.length) {
            double[][] dArray2 = new double[n2 + 1][];
            System.arraycopy(this.xvalues, 0, dArray2, 0, this.xvalues.length);
            int n3 = this.xvalues.length;
            while (n3 <= n2) {
                dArray2[n3] = null;
                ++n3;
            }
            this.xvalues = dArray2;
            this.xvalues[n2] = dArray;
            this.updateChart(12, 0, 0);
        } else {
            this.xvalues[n2] = dArray;
            this.updateChart(1, n2, 0);
        }
    }

    public void setYSeries(int n2, double[] dArray) {
        if (n2 >= this.yvalues.length) {
            double[][] dArray2 = new double[n2 + 1][];
            System.arraycopy(this.yvalues, 0, dArray2, 0, this.yvalues.length);
            int n3 = this.yvalues.length;
            while (n3 <= n2) {
                dArray2[n3] = null;
                ++n3;
            }
            this.yvalues = dArray2;
            this.yvalues[n2] = dArray;
            this.updateChart(12, 0, 0);
        } else {
            this.yvalues[n2] = dArray;
            this.updateChart(1, n2, 0);
        }
    }

    protected void updateChart(int n2, int n3, int n4) {
        try {
            ChartDataEvent chartDataEvent = new ChartDataEvent(this, n2, n3, n4);
            this.fireChartDataEvent(chartDataEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }
}

