/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.data;

import com.klg.jclass.chart.data.BaseDataSource;
import com.klg.jclass.chart.data.JCDataInterpreter;
import com.klg.jclass.util.JCDebug;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StreamTokenizer;

public class JCDefaultDataInterpreter
extends JCDataInterpreter
implements Serializable {
    private StreamTokenizer tokenizer;
    private final char QUOTE = (char)39;

    public JCDefaultDataInterpreter() {
    }

    public JCDefaultDataInterpreter(BaseDataSource baseDataSource) {
        super(baseDataSource);
    }

    protected void ctor(Reader reader) throws IOException {
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.commentChar(35);
        this.tokenizer.quoteChar(39);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.lowerCaseMode(true);
        this.tokenizer.parseNumbers();
        this.tokenizer.whitespaceChars(43, 43);
        this.init();
        this.tokenizer = null;
    }

    private void displayErrorMessage(int n2) {
        boolean bl = true;
        String string = "Error reading data: line " + this.tokenizer.lineno() + ": ";
        switch (n2) {
            case 1: {
                string = String.valueOf(string) + "Data must start with ARRAY or GENERAL and not";
                break;
            }
            case 2: {
                string = String.valueOf(string) + "Expect either a hole or numeric value and not ";
                break;
            }
            case 3: {
                string = String.valueOf(string) + "Expect a point label and not ";
                break;
            }
            default: {
                return;
            }
        }
        if (bl) {
            string = this.tokenizer.ttype == 39 ? String.valueOf(string) + "'" + this.tokenizer.sval + "'" : (this.tokenizer.ttype == -3 ? String.valueOf(string) + this.tokenizer.sval : (this.tokenizer.ttype == -2 ? String.valueOf(string) + this.tokenizer.nval : String.valueOf(string) + this.tokenizer.toString()));
        }
        System.err.println(string);
    }

    private double getNextDouble() throws IOException {
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype != -2) {
            String string;
            if (this.tokenizer.ttype == -3 && (string = this.tokenizer.sval).equalsIgnoreCase("HOLE")) {
                return this.baseDS.holeValue;
            }
            this.displayErrorMessage(2);
            throw new IOException("Error in data file format - " + this.tokenizer);
        }
        double d2 = this.tokenizer.nval;
        this.tokenizer.nextToken();
        if (this.tokenizer.ttype == -3 && this.tokenizer.sval != null && (this.tokenizer.sval.charAt(0) == 'e' || this.tokenizer.sval.charAt(0) == 'E')) {
            if (this.tokenizer.sval.length() == 1) {
                this.tokenizer.nextToken();
                if (this.tokenizer.ttype == -2) {
                    d2 *= Math.pow(10.0, this.tokenizer.nval);
                }
            } else {
                String string = this.tokenizer.sval;
                int n2 = Integer.valueOf(this.tokenizer.sval.substring(1));
                d2 *= Math.pow(10.0, n2);
            }
        } else {
            this.tokenizer.pushBack();
        }
        return d2;
    }

    private synchronized void init() throws IOException {
        boolean bl;
        boolean bl2 = false;
        if (this.tokenizer.nextToken() != -3) {
            bl2 = true;
        } else if (this.tokenizer.sval.equals("debug")) {
            JCDebug.setEnabled(true);
            JCDebug.setTag("data");
            if (this.tokenizer.nextToken() != -3) {
                bl2 = true;
            }
        }
        if (bl2 || !this.tokenizer.sval.equals("array") && !this.tokenizer.sval.equals("general")) {
            this.displayErrorMessage(1);
            throw new IOException("Data must start with ARRAY or GENERAL");
        }
        boolean bl3 = false;
        bl3 = this.tokenizer.sval.equals("array");
        if (this.tokenizer.nextToken() == 39) {
            this.baseDS.name = new String(this.tokenizer.sval);
        } else {
            this.tokenizer.pushBack();
        }
        int n2 = (int)this.getNextDouble();
        int n3 = (int)this.getNextDouble();
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equals("t")) {
            bl = true;
        } else {
            bl = false;
            this.tokenizer.pushBack();
        }
        JCDebug.println("data", "Reading in " + (bl3 ? "ARRAY" : "GENERAL") + " data with " + n2 + " series and " + n3 + " points. Data " + (bl ? "is" : "is not") + " transposed");
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equals("hole")) {
            this.baseDS.holeValue = this.getNextDouble();
            JCDebug.println("data", "Hole value is " + this.baseDS.holeValue);
        } else {
            this.tokenizer.pushBack();
        }
        if (bl3) {
            this.readArrayData(n2, n3, bl);
        } else {
            this.readGeneralData(n2, n3, bl);
        }
    }

    private void readArrayData(int n2, int n3, boolean bl) throws IOException {
        this.baseDS.xvalues = new double[1][n3];
        this.baseDS.yvalues = new double[n2][n3];
        this.baseDS.seriesLabels = new String[n2];
        this.baseDS.pointLabels = new String[n3];
        if (bl) {
            int n4 = 0;
            while (n4 < n2 + 1) {
                if (this.tokenizer.nextToken() == 39) {
                    if (n4 > 0) {
                        this.baseDS.seriesLabels[n4 - 1] = new String(this.tokenizer.sval);
                        JCDebug.println("data", "Series Name " + (n4 - 1) + "-" + this.baseDS.seriesLabels[n4 - 1]);
                    }
                } else {
                    this.tokenizer.pushBack();
                    break;
                }
                ++n4;
            }
            n4 = 0;
            while (n4 < n3) {
                if (this.tokenizer.nextToken() == 39) {
                    this.baseDS.pointLabels[n4] = new String(this.tokenizer.sval);
                    JCDebug.println("data", "Point Label " + n4 + "-" + this.baseDS.pointLabels[n4]);
                } else {
                    this.tokenizer.pushBack();
                }
                this.baseDS.xvalues[0][n4] = this.getNextDouble();
                int n5 = 0;
                while (n5 < n2) {
                    this.baseDS.yvalues[n5][n4] = this.getNextDouble();
                    JCDebug.println("data", "Value (" + n5 + "," + n4 + ") is (" + this.baseDS.xvalues[0][n4] + "," + this.baseDS.yvalues[n5][n4] + ")");
                    ++n5;
                }
                ++n4;
            }
        } else {
            Object var6_8 = null;
            int n6 = 0;
            while (n6 < n3) {
                if (this.tokenizer.nextToken() == 39) {
                    this.baseDS.pointLabels[n6] = new String(this.tokenizer.sval);
                    JCDebug.println("data", "Point Label " + n6 + "-" + this.baseDS.pointLabels[n6]);
                } else {
                    this.tokenizer.pushBack();
                }
                ++n6;
            }
            int n7 = 0;
            while (n7 < n2 + 1) {
                if (this.tokenizer.nextToken() == 39) {
                    if (n7 > 0) {
                        this.baseDS.seriesLabels[n7 - 1] = new String(this.tokenizer.sval);
                        JCDebug.println("data", "Series Name " + (n7 - 1) + "-" + this.baseDS.seriesLabels[n7 - 1]);
                    }
                } else {
                    this.tokenizer.pushBack();
                }
                n6 = 0;
                while (n6 < n3) {
                    double d2 = this.getNextDouble();
                    if (n7 == 0) {
                        this.baseDS.xvalues[0][n6] = d2;
                    } else {
                        this.baseDS.yvalues[n7 - 1][n6] = d2;
                        JCDebug.println("data", "Value (" + n7 + "," + n6 + ") is (" + this.baseDS.xvalues[0][n6] + "," + this.baseDS.yvalues[n7 - 1][n6] + ")");
                    }
                    ++n6;
                }
                ++n7;
            }
        }
    }

    private void readGeneralData(int n2, int n3, boolean bl) throws IOException {
        int n4;
        this.baseDS.xvalues = new double[n2][];
        this.baseDS.yvalues = new double[n2][];
        this.baseDS.seriesLabels = new String[n2];
        this.baseDS.pointLabels = new String[n3];
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equals("labels")) {
            n4 = 0;
            while (n4 < n3) {
                if (this.tokenizer.nextToken() != 39) {
                    this.displayErrorMessage(3);
                    throw new IOException("Error in reading point labels - " + this.tokenizer);
                }
                this.baseDS.pointLabels[n4] = new String(this.tokenizer.sval);
                JCDebug.println("data", "Point Label " + n4 + "-" + this.baseDS.pointLabels[n4]);
                ++n4;
            }
        } else {
            this.tokenizer.pushBack();
            this.baseDS.pointLabels = null;
        }
        if (bl) {
            int n5 = 0;
            while (n5 < n2) {
                if (this.tokenizer.nextToken() == 39) {
                    this.baseDS.seriesLabels[n5] = new String(this.tokenizer.sval);
                    JCDebug.println("data", "Series Name " + n5 + "-" + this.baseDS.seriesLabels[n5]);
                } else {
                    this.tokenizer.pushBack();
                }
                n3 = (int)this.getNextDouble();
                JCDebug.println("data", "Number of points: " + n3);
                this.baseDS.xvalues[n5] = new double[n3];
                this.baseDS.yvalues[n5] = new double[n3];
                int n6 = 0;
                while (n6 < n3) {
                    this.baseDS.xvalues[n5][n6] = this.getNextDouble();
                    this.baseDS.yvalues[n5][n6] = this.getNextDouble();
                    JCDebug.println("data", "Value (" + n5 + "," + n6 + ") is (" + this.baseDS.xvalues[n5][n6] + "," + this.baseDS.yvalues[n5][n6] + ")");
                    ++n6;
                }
                ++n5;
            }
        } else {
            int n7 = 0;
            while (n7 < n2) {
                if (this.tokenizer.nextToken() == 39) {
                    this.baseDS.seriesLabels[n7] = new String(this.tokenizer.sval);
                    JCDebug.println("data", "Series Name " + n7 + "-" + this.baseDS.seriesLabels[n7]);
                } else {
                    this.tokenizer.pushBack();
                }
                n3 = (int)this.getNextDouble();
                JCDebug.println("data", "Number of points: " + n3);
                this.baseDS.xvalues[n7] = new double[n3];
                this.baseDS.yvalues[n7] = new double[n3];
                n4 = 0;
                while (n4 < 2) {
                    int n8 = 0;
                    while (n8 < n3) {
                        double d2 = this.getNextDouble();
                        if (n4 == 0) {
                            this.baseDS.xvalues[n7][n8] = d2;
                        } else {
                            this.baseDS.yvalues[n7][n8] = d2;
                            JCDebug.println("data", "Value (" + n7 + "," + n8 + ") is (" + this.baseDS.xvalues[n7][n8] + "," + this.baseDS.yvalues[n7][n8] + ")");
                        }
                        ++n8;
                    }
                    ++n4;
                }
                ++n7;
            }
        }
    }
}

