/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.customizer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JTextField;

public class JSpinBox
extends JPanel {
    private JTextField textField = null;
    private JScrollBar scrollBar = null;
    private int minValue = 0;
    private int maxValue = Integer.MAX_VALUE;
    private int value = 0;
    private int extent = 1;
    private String[] strings = null;
    private boolean isStringsSpin = false;

    public JSpinBox() {
        this(0);
    }

    public JSpinBox(int n2) {
        this.setLayout(new FlowLayout(0, 2, 2));
        this.setBorder(BorderFactory.createBevelBorder(1));
        this.value = n2;
        this.textField = new JTextField("", 5);
        this.textField.setText(String.valueOf(n2));
        this.add(this.textField);
        this.scrollBar = new JScrollBar(1, n2, this.extent, this.minValue, this.maxValue);
        this.scrollBar.setPreferredSize(new Dimension(20, 25));
        this.scrollBar.setUnitIncrement(-1);
        this.add(this.scrollBar);
    }

    public JSpinBox(String[] stringArray) {
        this.strings = stringArray;
        this.setLayout(new FlowLayout(0, 2, 2));
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.value = 0;
        this.textField = new JTextField("", 10);
        this.textField.setText(this.strings[this.value]);
        this.add(this.textField);
        this.scrollBar = new JScrollBar(1, 0, 1, 0, this.strings.length);
        this.minValue = 0;
        this.maxValue = this.strings.length;
        this.scrollBar.setPreferredSize(new Dimension(20, 25));
        this.scrollBar.setUnitIncrement(-1);
        this.add(this.scrollBar);
        this.isStringsSpin = true;
    }

    public int getIntValue() {
        return this.value;
    }

    public int getMaximum() {
        return this.maxValue;
    }

    public int getMinimum() {
        return this.minValue;
    }

    public JScrollBar getScrollBar() {
        return this.scrollBar;
    }

    private int getStringIndex(String string) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.strings.length) {
            if (string.compareTo(this.strings[n3]) == 0) {
                n2 = n3;
                break;
            }
            ++n3;
        }
        return n2;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public String getTextValue() {
        return this.textField.getText();
    }

    public void setBackground(Color color) {
        if (this.textField != null) {
            this.textField.setBackground(color);
        }
    }

    public void setIntValue(int n2) {
        this.setValue(n2);
    }

    public void setMaximum(int n2) {
        this.maxValue = n2;
        if (n2 != Integer.MAX_VALUE) {
            this.scrollBar.setMaximum(n2 + this.extent);
        } else {
            this.scrollBar.setMaximum(n2);
        }
        if (this.maxValue < this.value) {
            this.value = this.maxValue;
            this.setIntValue(this.value);
        }
    }

    public void setMinimum(int n2) {
        this.minValue = n2;
        this.scrollBar.setMinimum(n2);
        if (this.value < this.minValue) {
            this.value = this.minValue;
            this.setIntValue(this.value);
        }
    }

    public void setTextValue(String string) {
        try {
            int n2;
            int n3 = n2 = this.isStringsSpin ? this.getStringIndex(string) : Integer.valueOf(string).intValue();
            if (this.isStringsSpin && n2 == -1) {
                throw new NumberFormatException();
            }
            this.setValue(n2);
        }
        catch (NumberFormatException numberFormatException) {
            if (!this.isStringsSpin) {
                this.textField.setText(String.valueOf(this.value));
            } else {
                this.textField.setText(this.strings[this.value]);
            }
            this.scrollBar.setValue(this.value);
        }
    }

    private void setValue(int n2) {
        if (n2 >= this.minValue && n2 <= this.maxValue) {
            this.value = n2;
            this.scrollBar.setValue(this.value);
            if (!this.isStringsSpin) {
                this.textField.setText(String.valueOf(this.value));
            } else {
                this.textField.setText(this.strings[this.value]);
            }
        } else if (n2 < this.minValue) {
            this.scrollBar.setValue(this.minValue);
            if (!this.isStringsSpin) {
                this.textField.setText(String.valueOf(this.minValue));
            } else {
                this.textField.setText(this.strings[this.minValue]);
            }
        } else {
            this.scrollBar.setValue(this.maxValue);
            if (!this.isStringsSpin) {
                this.textField.setText(String.valueOf(this.maxValue));
            } else {
                this.textField.setText(this.strings[this.maxValue]);
            }
        }
    }
}

