/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.customizer;

import com.klg.jclass.chart.customizer.JCustomizerBundle;
import com.klg.jclass.chart.customizer.JPropertyPage;
import com.klg.jclass.chart.customizer.JSpinBox;
import com.klg.jclass.util.JCTypeConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;

public class JFontEditor
extends JPropertyPage
implements ActionListener,
ItemListener,
AdjustmentListener,
PropertyEditor {
    protected JComboBox fontNameCombo = null;
    protected JComboBox fontStyleCombo = null;
    protected JSpinBox fontSizeSpin = null;
    protected JTextField fontSizeField = null;
    protected JButton useFontButton = null;
    static int[] font_style_values;
    static String[] font_style_names;
    String long_label = "      " + JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key129") + "       ";
    String short_label = " " + JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key129") + " ";
    protected PropertyChangeSupport listeners = null;

    static {
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        font_style_values = nArray;
        font_style_names = new String[]{"Plain", "Bold", "Italic", "BoldItalic"};
    }

    public JFontEditor() {
        this.setToolTipText(JFontEditor.getPageTitle());
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JTextField) {
            try {
                this.fontSizeSpin.setTextValue(actionEvent.getActionCommand());
                this.textChanged(actionEvent);
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key130")) + ": " + exception.getMessage());
            }
        } else if (actionEvent.getSource() instanceof JButton && this.listeners != null) {
            this.listeners.firePropertyChange("", null, this.getValue());
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            this.listeners = new PropertyChangeSupport(this);
        }
        this.listeners.addPropertyChangeListener(propertyChangeListener);
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent != null && adjustmentEvent.getSource() == this.fontSizeSpin.getScrollBar()) {
            this.fontSizeSpin.setIntValue(adjustmentEvent.getValue());
            this.fontChanged();
        }
    }

    private void comboChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        JComboBox jComboBox = (JComboBox)itemEvent.getSource();
        if (jComboBox == this.fontNameCombo || jComboBox == this.fontStyleCombo) {
            this.fontChanged();
        }
    }

    private void fontChanged() {
        try {
            String string = (String)this.fontNameCombo.getSelectedItem();
            String string2 = (String)this.fontStyleCombo.getSelectedItem();
            String string3 = this.fontSizeField.getText();
            if (string != "" && string2 != "" && string3 != "") {
                int n2 = JCTypeConverter.toEnum(string2, font_style_names, font_style_values, 0);
                Integer n3 = new Integer(string3);
                int n4 = n3;
                Font font = new Font(string, n2, n4);
                if (n4 > 14) {
                    this.useFontButton.setText(this.short_label);
                } else {
                    this.useFontButton.setText(this.long_label);
                }
                this.useFontButton.setFont(font);
            }
        }
        catch (Exception exception) {
            System.out.println(String.valueOf(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key130")) + JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key112") + ":" + exception.getMessage());
        }
    }

    public String getAsText() {
        Font font = this.getEditFont();
        return font.toString();
    }

    public Component getCustomEditor() {
        return null;
    }

    public Font getEditFont() {
        Font font = null;
        try {
            String string = (String)this.fontNameCombo.getSelectedItem();
            int n2 = this.fontStyleCombo.getSelectedIndex();
            int n3 = font_style_values[n2];
            String string2 = this.fontSizeField.getText();
            int n4 = Integer.parseInt(string2);
            font = new Font(string, n3, n4);
        }
        catch (Exception exception) {}
        return font;
    }

    public String getJavaInitializationString() {
        String string;
        Font font = this.getEditFont();
        switch (font.getStyle()) {
            case 1: {
                string = "Font.BOLD";
                break;
            }
            case 2: {
                string = "Font.ITALIC";
                break;
            }
            case 3: {
                string = "Font.BOLD + Font.ITALIC";
                break;
            }
            default: {
                string = "Font.PLAIN";
            }
        }
        return "new Font(" + font.getName() + ", " + string + ", " + font.getSize() + ")";
    }

    public static String getPageName() {
        return "JFontEditor";
    }

    public static String getPageTitle() {
        return JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key131");
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return this.getEditFont();
    }

    public void init() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        int n2 = 0;
        int n3 = 0;
        while (n3 < stringArray.length) {
            if (stringArray[n3].indexOf(46) < 0) {
                ++n2;
            }
            ++n3;
        }
        String[] stringArray2 = new String[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 < stringArray.length) {
            if (stringArray[n5].indexOf(46) < 0) {
                stringArray2[n4] = new String(stringArray[n5]);
                ++n4;
            }
            ++n5;
        }
        this.fontNameCombo = new JComboBox<String>(stringArray2);
        this.fontNameCombo.addItemListener(this);
        gridBagLayout.setConstraints(this.fontNameCombo, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add(this.fontNameCombo);
        this.fontStyleCombo = new JComboBox<String>(font_style_names);
        this.fontStyleCombo.addItemListener(this);
        gridBagLayout.setConstraints(this.fontStyleCombo, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add(this.fontStyleCombo);
        this.fontSizeSpin = new JSpinBox();
        this.fontSizeSpin.setMinimum(8);
        this.fontSizeSpin.setMaximum(36);
        this.fontSizeField = this.fontSizeSpin.getTextField();
        this.fontSizeField.addActionListener(this);
        this.fontSizeSpin.getScrollBar().addAdjustmentListener(this);
        gridBagLayout.setConstraints(this.fontSizeSpin, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add(this.fontSizeSpin);
        this.useFontButton = new JButton(this.long_label);
        this.useFontButton.addActionListener(this);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 10;
        gridBagLayout.setConstraints(this.useFontButton, gridBagConstraints);
        this.add(this.useFontButton);
    }

    public boolean isPaintable() {
        return false;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() instanceof JComboBox) {
            this.comboChanged(itemEvent);
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame;
        Serializable serializable;
        try {
            serializable = Class.forName("com.klg.jclass.chart.customizer.JCustomizerCustomFrame");
            jFrame = (JFrame)((Class)serializable).newInstance();
        }
        catch (Exception exception) {
            System.out.println(exception);
            jFrame = new JFrame();
        }
        jFrame.setTitle(JFontEditor.getPageTitle());
        serializable = new JFontEditor();
        ((JFontEditor)serializable).setBackground(Color.lightGray);
        jFrame.getContentPane().add((Component)serializable);
        ((JFontEditor)serializable).setValue(new Font("Dialog", 1, 12));
        jFrame.pack();
        Dimension dimension = ((JComponent)serializable).getPreferredSize();
        ((Component)jFrame).setSize(dimension.width + 200, dimension.height + 100);
        jFrame.show();
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(string);
    }

    public void setBackground(Color color) {
        if (this.fontNameCombo != null) {
            this.fontNameCombo.setBackground(color);
        }
        if (this.fontStyleCombo != null) {
            this.fontStyleCombo.setBackground(color);
        }
        if (this.fontSizeField != null) {
            this.fontSizeField.setBackground(color);
        }
    }

    public void setEditFont(Font font) {
        String string = font.getName();
        int n2 = this.fontNameCombo.getItemCount();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n2) {
            if (string.equalsIgnoreCase((String)this.fontNameCombo.getItemAt(n3))) {
                if (this.fontNameCombo.getSelectedIndex() != n3) {
                    this.fontNameCombo.setSelectedIndex(n3);
                }
                bl = true;
            }
            ++n3;
        }
        if (!bl) {
            try {
                this.fontNameCombo.addItem(string);
                this.fontNameCombo.setSelectedItem(string);
            }
            catch (Exception exception) {
                System.out.println(String.valueOf(JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key24")) + " " + JCustomizerBundle.string("com.klg.jclass.chart.customizer.Key112") + " " + string);
            }
        }
        int n4 = font.getStyle();
        int n5 = 0;
        while (n5 < font_style_values.length) {
            if (n4 == font_style_values[n5]) {
                if (this.fontStyleCombo.getSelectedIndex() == n5) break;
                this.fontStyleCombo.setSelectedIndex(n5);
                break;
            }
            ++n5;
        }
        int n6 = font.getSize();
        this.fontSizeSpin.setIntValue(n6);
        this.fontChanged();
    }

    public void setValue(Object object) {
        if (object instanceof Font) {
            this.setEditFont((Font)object);
        }
    }

    public boolean supportsCustomEditor() {
        return false;
    }

    private void textChanged(ActionEvent actionEvent) {
        JTextField jTextField = (JTextField)actionEvent.getSource();
        if (jTextField == this.fontSizeField) {
            this.fontChanged();
        }
    }
}

