/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart.beans;

import com.klg.jclass.chart.beans.JCChartBeanBundle;
import com.klg.jclass.chart.beans.View3DCube;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class View3DEditor
extends JPanel
implements PropertyEditor,
ActionListener {
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected JTextField textDepth;
    protected JTextField textElevation;
    protected JTextField textRotation;
    protected JCheckBox cbDepth;
    protected View3DCube cube;
    protected String selectedView;

    public View3DEditor() {
        this.init();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JTextField) {
            JTextField jTextField = (JTextField)actionEvent.getSource();
            if (jTextField == null) {
                return;
            }
            this.setSelectedValue(false);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public String getAsText() {
        return this.selectedView;
    }

    public Component getCustomEditor() {
        return this;
    }

    public String getJavaInitializationString() {
        return "\"" + this.selectedView + "\"";
    }

    public Dimension getPreferredSize() {
        return new Dimension(400, 300);
    }

    public String[] getTags() {
        return null;
    }

    public Object getValue() {
        return this.selectedView;
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 6));
        this.textDepth = new JTextField("", 5);
        this.textElevation = new JTextField("", 5);
        this.textRotation = new JTextField("", 5);
        this.textDepth.addActionListener(this);
        this.textElevation.addActionListener(this);
        this.textRotation.addActionListener(this);
        jPanel.add(new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key158")));
        jPanel.add(this.textDepth);
        jPanel.add(new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key159")));
        jPanel.add(this.textElevation);
        jPanel.add(new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key160")));
        jPanel.add(this.textRotation);
        this.add("North", jPanel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 1));
        this.cbDepth = new JCheckBox(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key161"), false);
        if (this.cbDepth != null) {
            jPanel2.add(this.cbDepth);
        }
        jPanel2.add(new JLabel(JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key162")));
        this.add("South", jPanel2);
        this.cube = new View3DCube(this);
        this.add("Center", this.cube);
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
        String string = JCChartBeanBundle.string("com.klg.jclass.chart.beans.Key163");
        if (string == null) {
            string = new String("");
        }
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n2 = (rectangle.height - fontMetrics.getAscent()) / 2;
        graphics.drawString(string, rectangle.x, rectangle.y + rectangle.height - n2);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public void setAsText(String string) throws IllegalArgumentException {
        this.setSelectedValue(string);
    }

    protected void setSelectedValue(String string) {
        this.selectedView = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n2 = 0;
        while (n2 < 3) {
            String string2 = null;
            if (stringTokenizer.hasMoreTokens()) {
                string2 = stringTokenizer.nextToken();
            }
            switch (n2) {
                case 0: {
                    this.textDepth.setText(string2);
                    break;
                }
                case 1: {
                    this.textElevation.setText(string2);
                    break;
                }
                case 2: {
                    this.textRotation.setText(string2);
                    break;
                }
            }
            ++n2;
        }
        this.support.firePropertyChange("", null, null);
        this.cube.repaint();
    }

    protected void setSelectedValue(boolean bl) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        try {
            n2 = JCNumberUtil.clamp(Integer.parseInt(this.textDepth.getText()), 0, 500);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 0;
        }
        try {
            n3 = JCNumberUtil.clamp(Integer.parseInt(this.textElevation.getText()), -45, 45);
        }
        catch (NumberFormatException numberFormatException) {
            n3 = 0;
        }
        try {
            n4 = JCNumberUtil.clamp(Integer.parseInt(this.textRotation.getText()), -45, 45);
        }
        catch (NumberFormatException numberFormatException) {
            n4 = 0;
        }
        if (bl) {
            if (n2 > 0 && n3 == 0 && n4 == 0) {
                n3 = 5;
                n4 = 5;
            }
            if (n2 == 0 && (n3 != 0 || n4 != 0)) {
                n2 = 5;
            }
        }
        String string = Integer.toString(n2) + "," + Integer.toString(n3) + "," + Integer.toString(n4);
        this.setSelectedValue(string);
    }

    public void setValue(Object object) {
        this.setSelectedValue((String)object);
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

