/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AreaChartDraw;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDrawUtil;
import com.klg.jclass.chart.JCAreaChartFormat;
import com.klg.jclass.chart.JCDataIndex;
import java.awt.Graphics;
import java.awt.Point;

public class SAreaChartDraw
extends AreaChartDraw {
    double[] ytotal;
    double[] ysum;
    double[] ysum_neg;
    double[][] ywork;
    JCAreaChartFormat areaFormat;
    boolean editInverted = false;

    public void draw(Graphics graphics, int n2, int n3, boolean bl) {
        super.draw(graphics, n2, n3, false);
    }

    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        int n4 = this.yaxis.toPixel(jCDataIndex.series.getY(jCDataIndex.point), this.drawFront);
        int n5 = this.yaxis.toPixel(this.ywork[jCDataIndex.series.getDrawingOrder()][jCDataIndex.point - this.firstLast.x], this.drawFront);
        int n6 = this.editInverted ? n2 - this.r.x - n5 : n5 - (n3 - this.r.y);
        int n7 = this.editInverted ? n4 + n6 : n4 - n6;
        return n7;
    }

    protected double[] getYVals(ChartDataViewSeries chartDataViewSeries) {
        return this.ywork[chartDataViewSeries.getParent().getSeriesIndex(chartDataViewSeries)];
    }

    public JCDataIndex pick(Point point, int n2) {
        return this.pick(point, n2, true);
    }

    public void recalc(int n2, int n3, int n4) {
        this.areaFormat = (JCAreaChartFormat)this.dataObject.getChartFormat();
        this.holeValue = this.dataObject.getHoleValue();
        this.firstLast = this.dataObject.getFirstLast();
        this.yaxis = this.dataObject.getYAxis();
        if (n4 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        int n5 = this.seriesList.size();
        if (n5 == 0 || this.firstLast == null) {
            return;
        }
        int n6 = this.firstLast.y - this.firstLast.x + 1;
        this.ytotal = new double[n6];
        this.ysum = new double[n6];
        this.ysum_neg = new double[n6];
        this.ywork = new double[n5][n6];
        ChartDrawUtil.calcStackingInfo(this.ysum, this.ysum_neg, this.ytotal, this.ywork, this.firstLast.x, this.firstLast.y, this.seriesList, this.areaFormat.is100Percent(), this.holeValue, this.yaxis.dataLimits, this.yaxis);
        super.recalc(n2, n3, n4);
    }

    void startEdit(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        this.editInverted = jCDataIndex.dataView.getXAxis().vertical;
        super.startEdit(jCDataIndex);
    }
}

