/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.JCChartBundle;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.util.Hashtable;

public class RotateFilter
extends ImageFilter {
    private byte[][] byte_bits;
    private int[][] int_bits;
    private boolean use_byte;
    private int newWidth;
    private int newHeight;
    private boolean got_part = false;
    private ColorModel model;
    private int angle;
    public static final int DEG_90 = 3;
    public static final int DEG_180 = 2;
    public static final int DEG_270 = 1;

    public RotateFilter(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 3: {
                this.angle = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException(JCChartBundle.string("com.klg.jclass.chart.Key125"));
            }
        }
    }

    private void allocateArray() {
        if (this.got_part) {
            if (this.use_byte) {
                this.byte_bits = new byte[this.newHeight][this.newWidth];
            } else {
                this.int_bits = new int[this.newHeight][this.newWidth];
            }
        }
        this.got_part = true;
    }

    public void imageComplete(int n2) {
        int n3 = 0;
        while (n3 < this.newHeight) {
            if (this.use_byte) {
                super.setPixels(0, n3, this.newWidth, 1, this.model, this.byte_bits[n3], 0, this.newWidth);
            } else {
                super.setPixels(0, n3, this.newWidth, 1, this.model, this.int_bits[n3], 0, this.newWidth);
            }
            ++n3;
        }
        super.imageComplete(n2);
    }

    public void setColorModel(ColorModel colorModel) {
        this.use_byte = colorModel.getPixelSize() <= 8;
        this.allocateArray();
        this.model = colorModel;
        super.setColorModel(colorModel);
    }

    public void setDimensions(int n2, int n3) {
        switch (this.angle) {
            case 1: 
            case 3: {
                this.newWidth = n3;
                this.newHeight = n2;
                break;
            }
            case 2: {
                this.newWidth = n2;
                this.newHeight = n3;
                break;
            }
        }
        this.allocateArray();
        super.setDimensions(this.newWidth, this.newHeight);
    }

    public void setHints(int n2) {
        super.setHints(n2);
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, byte[] byArray, int n6, int n7) {
        switch (this.angle) {
            case 3: {
                int n8 = 0;
                while (n8 < n4) {
                    this.byte_bits[this.newHeight - n8 - 1][n3] = byArray[n8 + n6];
                    ++n8;
                }
                break;
            }
            case 2: {
                int n9 = 0;
                while (n9 < n4) {
                    this.byte_bits[this.newHeight - n3 - 1][this.newWidth - n9 - 1] = byArray[n9 + n6];
                    ++n9;
                }
                break;
            }
            case 1: {
                int n10 = 0;
                while (n10 < n4) {
                    this.byte_bits[n10][this.newWidth - n3 - 1] = byArray[n10 + n6];
                    ++n10;
                }
                break;
            }
        }
    }

    public void setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, int[] nArray, int n6, int n7) {
        switch (this.angle) {
            case 3: {
                int n8 = 0;
                while (n8 < n4) {
                    this.int_bits[this.newHeight - n8 - 1][n3] = nArray[n8 + n6];
                    ++n8;
                }
                break;
            }
            case 2: {
                int n9 = 0;
                while (n9 < n4) {
                    this.int_bits[this.newHeight - n3 - 1][this.newWidth - n9 - 1] = nArray[n9 + n6];
                    ++n9;
                }
                break;
            }
            case 1: {
                int n10 = 0;
                while (n10 < n4) {
                    this.int_bits[n10][this.newWidth - n3 - 1] = nArray[n10 + n6];
                    ++n10;
                }
                break;
            }
        }
    }

    public void setProperties(Hashtable hashtable) {
    }
}

