/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.ChartInteriorRegion;
import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCPieChartFormat;
import com.klg.jclass.chart.PieChartInfo;
import com.klg.jclass.chart.PieData;
import com.klg.jclass.chart.PiePercent;
import com.klg.jclass.chart.PiePosition;
import com.klg.jclass.chart.PieSortAscending;
import com.klg.jclass.chart.PieSortDescending;
import com.klg.jclass.chart.PieSortPoint;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class PieChartDraw
extends ChartDraw {
    public static final int COORD_DEFAULT_VALUE = -2;
    public static final int COORD_ZERO_SLICE = -1;
    public static final int INDEX_HOLE = -2;
    public static final int INDEX_NOT_DRAWN = -1;
    public static final int HIT_NOWHERE = 0;
    public static final int HIT_TOP = 1;
    public static final int HIT_EDGE = 2;
    public static final String ERRMSG_BIG_ERROR = "Big Error!";
    protected PieChartInfo pieInfo = null;
    JCPieChartFormat pcf = null;
    protected int delta_y = 0;
    Color outlineColor = Color.black;
    protected int num_pies = 0;
    int num_lines = 0;
    int num_pies_line = 0;
    protected int box_width = 0;
    protected int box_height = 0;
    int pie_offset = 0;
    int first_point = 0;
    int graph_left = 0;
    int graph_top = 0;
    transient ChartText[] cLabels;
    int label_height = 0;
    int explode_offset = 0;

    private void calcExplodeOffset(int n2, int n3, int n4, int n5, Point point) {
        int n6 = n4;
        int n7 = n2 - n3;
        if (n7 < 0) {
            n7 += 360;
        }
        if (n7 >= 0 && n7 <= 90) {
            point.x = (int)Math.round(Math.cos(JCNumberUtil.degToRad(n7)) * (double)n6);
            point.y = -((int)Math.round(Math.sin(JCNumberUtil.degToRad(n7)) * (double)n6));
        } else if (n7 > 90 && n7 <= 180) {
            point.x = -((int)Math.round(Math.sin(JCNumberUtil.degToRad(n7 -= 90)) * (double)n6));
            point.y = -((int)Math.round(Math.cos(JCNumberUtil.degToRad(n7)) * (double)n6));
        } else if (n7 > 180 && n7 <= 270) {
            point.x = -((int)Math.round(Math.cos(JCNumberUtil.degToRad(n7 -= 180)) * (double)n6));
            point.y = (int)Math.round(Math.sin(JCNumberUtil.degToRad(n7)) * (double)n6);
        } else if (n7 > 270 && n7 <= 360) {
            point.x = (int)Math.round(Math.sin(JCNumberUtil.degToRad(n7 -= 270)) * (double)n6);
            point.y = (int)Math.round(Math.cos(JCNumberUtil.degToRad(n7)) * (double)n6);
        }
    }

    protected void calcTransientData() {
        int n2;
        int n3;
        int n4;
        if (!this.dataObject.isChanged() && this.dataObject.getTransientData() != null) {
            return;
        }
        this.seriesList = this.dataObject.getSeries();
        this.pcf = (JCPieChartFormat)this.dataObject.getChartFormat();
        int n5 = this.dataObject.getNumSeries();
        Point point = this.dataObject.getFirstLast();
        if (point == null) {
            this.num_pies = 0;
            return;
        }
        this.num_pies = Math.max(point.y - point.x + 1, 0);
        if (this.num_pies == 0) {
            return;
        }
        PieChartInfo pieChartInfo = null;
        pieChartInfo = new PieChartInfo();
        pieChartInfo.pos = new PiePosition[this.num_pies];
        pieChartInfo.data = new PieData[this.num_pies];
        pieChartInfo.num_pies = this.num_pies;
        int n6 = 0;
        while (n6 < this.num_pies) {
            pieChartInfo.pos[n6] = new PiePosition();
            pieChartInfo.pos[n6].coord = new Point[n5 + 1];
            pieChartInfo.pos[n6].offset = new Point[n5 + 1];
            n4 = 0;
            while (n4 <= n5) {
                pieChartInfo.pos[n6].coord[n4] = new Point(-2, -2);
                pieChartInfo.pos[n6].offset[n4] = new Point(0, 0);
                ++n4;
            }
            pieChartInfo.pos[n6].order = new short[n5 + 1];
            pieChartInfo.data[n6] = new PieData();
            pieChartInfo.data[n6].sortPoints = new PieSortPoint[n5];
            n3 = 0;
            while (n3 < n5) {
                pieChartInfo.data[n6].sortPoints[n3] = new PieSortPoint();
                ++n3;
            }
            pieChartInfo.data[n6].percents = new PiePercent[n5 + 1];
            pieChartInfo.data[n6].exploded = new boolean[n5 + 1];
            n2 = 0;
            while (n2 < n5 + 1) {
                pieChartInfo.data[n6].percents[n2] = new PiePercent();
                pieChartInfo.data[n6].exploded[n2] = false;
                ++n2;
            }
            ++n6;
        }
        this.first_point = ((ChartDataViewSeries)this.seriesList.get(0)).getFirstPoint();
        pieChartInfo.other_flag = 0;
        n4 = 0;
        while (n4 < this.num_pies) {
            n3 = this.computeOtherSlice(this.seriesList, n4 + this.first_point, n5, pieChartInfo.data[n4]);
            n2 = pieChartInfo.data[n4].other_slice;
            int n7 = pieChartInfo.data[n4].num_slices_pie;
            int n8 = 0;
            while (n8 < n7) {
                pieChartInfo.pos[n4].order[n8] = (short)pieChartInfo.data[n4].percents[n8].index;
                if (pieChartInfo.data[n4].percents[n8].pct > 0.0) {
                    pieChartInfo.data[n4].lastDrawnSlice = n8;
                }
                ++n8;
            }
            while (n8 <= n5) {
                pieChartInfo.pos[n4].order[n8] = -1;
                ++n8;
            }
            if (n3 > 0) {
                pieChartInfo.pos[n4].order[pieChartInfo.data[n4].other_slice] = -10;
            }
            pieChartInfo.other_flag |= n3;
            ++n4;
        }
        this.dataObject.setTransientData(pieChartInfo);
        this.dataObject.setChanged(false, 0);
    }

    private int computeOtherSlice(List list, int n2, int n3, PieData pieData) {
        double d2;
        Point[] pointArray;
        int n4 = Math.min(n3, this.pcf.getMinSlices());
        double d3 = this.pcf.getThresholdValue() / 100.0;
        double d4 = this.dataObject.getHoleValue();
        double d5 = 0.0;
        int n5 = 0;
        while (n5 < n3) {
            pointArray = (Point[])list.get(n5);
            double d6 = pointArray.getX(n2);
            d2 = pointArray.getY(n2);
            pieData.sortPoints[n5].index = n5;
            if (d2 == d4 || d6 == d4 || !pointArray.isVisible()) {
                d2 = -1.0;
                pieData.sortPoints[n5].index = -2;
            } else if (d2 < 0.0) {
                d2 = 0.0;
            } else {
                d5 += d2;
            }
            pieData.sortPoints[n5].y = d2;
            ++n5;
        }
        pieData.zero_pie = d5 == 0.0;
        pointArray = this.pcf.getExplodeList();
        if (pointArray != null) {
            int n6 = 0;
            while (n6 < pointArray.length) {
                if (n2 == pointArray[n6].x) {
                    if (pointArray[n6].y == -10) {
                        pieData.exploded[pieData.exploded.length - 1] = true;
                    } else if (pointArray[n6].y < n3) {
                        pieData.exploded[pointArray[n6].y] = true;
                    }
                }
                ++n6;
            }
        }
        switch (this.pcf.sortOrder) {
            case 1: {
                if (pieData.sortPoints == null) break;
                Collections.sort(Arrays.asList(pieData.sortPoints), new PieSortAscending());
                break;
            }
            case 2: {
                if (pieData.sortPoints == null) break;
                Collections.sort(Arrays.asList(pieData.sortPoints), new PieSortDescending());
                break;
            }
        }
        int n7 = 0;
        while (n7 < n3) {
            pieData.percents[n7].pct = pieData.sortPoints[n7].y >= 0.0 ? (pieData.zero_pie ? 0.0 : pieData.sortPoints[n7].y / d5) : 0.0;
            pieData.percents[n7].index = pieData.sortPoints[n7].index;
            ++n7;
        }
        pieData.other_slice = -1;
        boolean bl = false;
        d2 = 0.0;
        int n8 = 0;
        int n9 = n3;
        boolean bl2 = true;
        switch (this.pcf.sortOrder) {
            case 1: {
                int n10 = 0;
                while (n10 < n3) {
                    if (n3 - n10 < n4) break;
                    if (pieData.sortPoints[n10].y >= 0.0) {
                        switch (this.pcf.thresholdMethod) {
                            case 1: {
                                bl2 = d2 + pieData.percents[n10].pct < d3;
                                break;
                            }
                            case 0: {
                                bl2 = pieData.percents[n10].pct < d3;
                                break;
                            }
                            default: {
                                System.out.println(ERRMSG_BIG_ERROR);
                                break;
                            }
                        }
                    } else {
                        bl2 = true;
                    }
                    if (bl2) {
                        pieData.percents[n10].pct += d2;
                        d2 = pieData.percents[n10].pct;
                        bl = true;
                        n8 = n10;
                    }
                    ++n10;
                }
                if (!bl) break;
                if (pieData.percents[n8].pct > 0.0) {
                    n9 = n3 - n8;
                    pieData.other_slice = n9 - 1;
                    pieData.percents[n3].pct = pieData.percents[n8].pct;
                    pieData.percents[n3].index = n3;
                } else {
                    n9 = n3 - n8 - 1;
                    bl = false;
                }
                n10 = n8 + 1;
                while (n10 <= n3) {
                    pieData.percents[n10 - n8 - 1].pct = pieData.percents[n10].pct;
                    pieData.percents[n10 - n8 - 1].index = pieData.percents[n10].index;
                    ++n10;
                }
                break;
            }
            case 2: {
                n8 = n3 - 1;
                int n11 = n3 - 1;
                while (n11 >= 0) {
                    if (n11 + 1 < n4) break;
                    if (pieData.sortPoints[n11].y >= 0.0) {
                        switch (this.pcf.thresholdMethod) {
                            case 1: {
                                bl2 = d2 + pieData.percents[n11].pct < d3;
                                break;
                            }
                            case 0: {
                                bl2 = pieData.percents[n11].pct < d3;
                                break;
                            }
                            default: {
                                System.out.println(ERRMSG_BIG_ERROR);
                                break;
                            }
                        }
                    } else {
                        bl2 = true;
                    }
                    if (!bl2) break;
                    pieData.percents[n11].pct += d2;
                    d2 = pieData.percents[n11].pct;
                    n8 = n11--;
                    bl = true;
                }
                if (!bl) break;
                if (pieData.percents[n8].pct > 0.0) {
                    pieData.percents[n8].index = n3;
                    n9 = n8 + 1;
                    pieData.other_slice = n8;
                    break;
                }
                n9 = n8;
                bl = false;
                break;
            }
            case 0: {
                if (pieData.sortPoints != null) {
                    Collections.sort(Arrays.asList(pieData.sortPoints), new PieSortAscending());
                }
                pieData.percents[n3].pct = 0.0;
                pieData.percents[n3].index = n3;
                int n12 = 0;
                while (n12 < n3) {
                    if (n9 < n4) break;
                    double d7 = 0.0;
                    if (pieData.sortPoints[n12].y >= 0.0) {
                        d7 = pieData.zero_pie ? 0.0 : pieData.sortPoints[n12].y / d5;
                        switch (this.pcf.thresholdMethod) {
                            case 1: {
                                bl2 = d2 + d7 < d3;
                                break;
                            }
                            case 0: {
                                bl2 = d7 < d3;
                                break;
                            }
                            default: {
                                System.out.println(ERRMSG_BIG_ERROR);
                                break;
                            }
                        }
                    } else {
                        bl2 = true;
                    }
                    if (bl2) {
                        pieData.percents[n9].pct += d7;
                        d2 = pieData.percents[n9].pct;
                        n8 = 0;
                        while (n8 < n9) {
                            if (pieData.percents[n8].pct == d7) {
                                ++n8;
                                break;
                            }
                            ++n8;
                        }
                        while (n8 <= n9) {
                            pieData.percents[n8 - 1].pct = pieData.percents[n8].pct;
                            pieData.percents[n8 - 1].index = pieData.percents[n8].index;
                            ++n8;
                        }
                        if (d7 > 0.0) {
                            bl = true;
                        }
                        --n9;
                    }
                    ++n12;
                }
                if (!bl) break;
                pieData.other_slice = n9++;
                break;
            }
            default: {
                System.out.println(ERRMSG_BIG_ERROR);
            }
        }
        pieData.num_slices_pie = n9;
        pieData.other_flag = bl ? 1 : 0;
        return pieData.other_flag;
    }

    public void draw(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        graphics.translate(this.chartArea.getPlotRect().x, this.chartArea.getPlotRect().y);
        if (this.pieInfo == null) {
            this.recalc();
        }
        Rectangle rectangle2 = this.chartArea.getPlotRect();
        if (this.num_pies == 0) {
            return;
        }
        this.outlineColor = this.dataObject.getOutlineColor();
        int n2 = 0;
        int n3 = this.graph_left;
        int n4 = this.graph_top;
        int n5 = 0;
        while (n5 < this.num_lines) {
            int n6 = 0;
            while (n6 < this.num_pies_line) {
                int n7 = n3 + this.pie_offset;
                int n8 = n4 + (this.box_height - this.pieInfo.height - this.delta_y - this.label_height) / 2;
                if (n2 < this.num_pies) {
                    Serializable serializable;
                    if (!this.pieInfo.data[n2].zero_pie) {
                        serializable = new Rectangle(this.pieInfo.pos[n2].cx, this.pieInfo.pos[n2].cy, this.pieInfo.width, this.pieInfo.height);
                        if (this.delta_y != 0) {
                            this.drawPiePlane(graphics, this.seriesList, this.pieInfo.data[n2], this.pieInfo, n7, n8 + this.delta_y, n2, false, (Rectangle)serializable);
                            this.drawPieEdge(graphics, this.pieInfo.data[n2], this.pieInfo, n7, n8, (Rectangle)serializable);
                        }
                        this.drawPiePlane(graphics, this.seriesList, this.pieInfo.data[n2], this.pieInfo, n7, n8, n2, true, (Rectangle)serializable);
                        this.drawPieLines(graphics, this.seriesList, this.pieInfo.data[n2], this.pieInfo, n7, n8, n2);
                    }
                    if (n2 + this.first_point < this.cLabels.length && (serializable = this.cLabels[n2 + this.first_point]) != null) {
                        int n9 = ((ChartInteriorRegion)serializable).getWidth();
                        int n10 = ((ChartInteriorRegion)serializable).getHeight();
                        ((ChartInteriorRegion)serializable).setLocation(n3 + (this.box_width - n9) / 2, n8 + this.pieInfo.height + this.delta_y + this.explode_offset);
                        ((ChartText)serializable).draw(graphics);
                    }
                    if (!this.pieInfo.data[n2].zero_pie) {
                        this.drawPieCircle(graphics, this.seriesList, this.pieInfo.data[n2], this.pieInfo, n7, n8, n2);
                    }
                }
                ++n2;
                n3 += this.box_width;
                ++n6;
            }
            n3 = this.graph_left;
            n4 += this.box_height;
            ++n5;
        }
    }

    private void drawPieCircle(Graphics graphics, List list, PieData pieData, PieChartInfo pieChartInfo, int n2, int n3, int n4) {
        double d2 = this.pcf.getStartAngle();
        double d3 = 0.0;
        int n5 = 0;
        if (graphics.getColor() != this.outlineColor) {
            graphics.setColor(this.outlineColor);
        }
        int n6 = 0;
        while (n6 < pieData.num_slices_pie) {
            JCFillStyle jCFillStyle = this.getPieSliceFillStyle(pieData, n6);
            double d4 = pieData.percents[n6].pct * 360.0;
            if (n6 == pieData.lastDrawnSlice) {
                if (!pieData.exploded[pieData.percents[n6].index]) {
                    n5 = 0;
                }
                if (d3 >= 360.0) {
                    d4 = 0.0;
                } else {
                    d4 = d2 - (double)n5 - this.pcf.getStartAngle();
                    if (d4 < 0.0 || d4 == 0.0 && d3 == 0.0) {
                        d4 += 360.0;
                    }
                }
            }
            if (d4 != 0.0) {
                int n7 = (int)Math.round(d4);
                if (pieData.exploded[pieData.percents[n6].index]) {
                    if (n5 != 0) {
                        graphics.drawArc(n2, n3, pieChartInfo.width, pieChartInfo.height, (int)Math.round(d2), -1 * n5);
                        d2 -= (double)n5;
                        d3 += (double)n5;
                        if (d2 < 0.0) {
                            d2 += 360.0;
                        }
                        n5 = 0;
                    }
                    if (n7 != 0) {
                        Point point = pieChartInfo.pos[n4].offset[n6];
                        graphics.drawArc(n2 + point.x, n3 + point.y, pieChartInfo.width, pieChartInfo.height, (int)Math.round(d2), -1 * n7);
                        d2 -= (double)Math.round(d4);
                        d3 += (double)Math.round(d4);
                        if (d2 < 0.0) {
                            d2 += 360.0;
                        }
                    }
                } else {
                    n5 += n7;
                }
            }
            ++n6;
        }
        if (n5 != 0) {
            graphics.drawArc(n2, n3, pieChartInfo.width, pieChartInfo.height, (int)Math.round(d2), -1 * n5);
        }
    }

    private void drawPieEdge(Graphics graphics, PieData pieData, PieChartInfo pieChartInfo, int n2, int n3, Rectangle rectangle) {
        int n4 = pieChartInfo.width;
        int n5 = pieChartInfo.height;
        double d2 = (double)n4 / 2.0;
        double d3 = (double)n5 / 2.0;
        int n6 = (int)((double)n2 + d2 + 0.5);
        int n7 = (int)((double)n3 + d3 + 0.5);
        Point[] pointArray = null;
        int n8 = 0;
        double d4 = this.pcf.getStartAngle();
        while (n8 < pieData.num_slices_pie && d4 > -180.0) {
            double d5;
            double d6 = pieData.percents[n8].pct * 360.0;
            if (d6 == 0.0) {
                d5 = d4;
            } else {
                double d7 = Math.round(d4);
                double d8 = Math.round(d6);
                d5 = d7 - d8;
                if (d7 < 180.0 && d5 > 0.0) {
                    pointArray = null;
                } else {
                    double d9 = d7 > 0.0 && d7 < 180.0 ? 0.0 : JCNumberUtil.degToRad(d7);
                    pointArray = new Point[4];
                    pointArray[0] = new Point((int)((double)n6 + Math.cos(d9) * d2), (int)((double)n7 - Math.sin(d9) * d3));
                    pointArray[1] = new Point(pointArray[0].x, pointArray[0].y + this.delta_y);
                    boolean bl = false;
                    if (d5 < -180.0 || d5 < 180.0 && d5 > 0.0) {
                        d9 = JCNumberUtil.degToRad(-180.0);
                        bl = true;
                    } else {
                        d9 = JCNumberUtil.degToRad(d5);
                    }
                    pointArray[3] = new Point((int)((double)n6 + Math.cos(d9) * d2), (int)((double)n7 - Math.sin(d9) * d3));
                    pointArray[2] = new Point(pointArray[3].x, pointArray[3].y + this.delta_y);
                    JCFillStyle jCFillStyle = this.getPieSliceFillStyle(pieData, n8);
                    Polygon polygon = new Polygon();
                    int n9 = 0;
                    while (n9 < pointArray.length) {
                        polygon.addPoint(pointArray[n9].x, pointArray[n9].y);
                        ++n9;
                    }
                    jCFillStyle.updateFillOrientation(rectangle, 5);
                    jCFillStyle.fillPolygonShadow(graphics, polygon);
                    jCFillStyle.resetFillOrientation();
                    if (graphics.getColor() != this.outlineColor) {
                        graphics.setColor(this.outlineColor);
                    }
                    graphics.drawLine(pointArray[0].x, pointArray[0].y, pointArray[1].x, pointArray[1].y);
                    if (bl) {
                        graphics.drawLine(pointArray[2].x, pointArray[2].y, pointArray[3].x, pointArray[3].y);
                    }
                }
            }
            ++n8;
            d4 = d5;
        }
        if (graphics.getColor() != this.outlineColor) {
            graphics.setColor(this.outlineColor);
        }
        if (pointArray != null) {
            graphics.drawLine(pointArray[2].x, pointArray[2].y, pointArray[3].x, pointArray[3].y);
        }
        graphics.drawArc(n2, n3 + this.delta_y, n4, n5, 0, -180);
    }

    private void drawPieLines(Graphics graphics, List list, PieData pieData, PieChartInfo pieChartInfo, int n2, int n3, int n4) {
        double d2 = (double)pieChartInfo.width / 2.0;
        double d3 = (double)pieChartInfo.height / 2.0;
        int n5 = 0;
        int n6 = 0;
        int n7 = pieChartInfo.pos[n4].cx = (int)((double)n2 + Math.floor(d2));
        int n8 = pieChartInfo.pos[n4].cy = (int)((double)n3 + Math.floor(d3));
        int n9 = 0;
        int n10 = 0;
        if (graphics.getColor() != this.outlineColor) {
            graphics.setColor(this.outlineColor);
        }
        int n11 = -1;
        double d4 = this.pcf.getStartAngle();
        double d5 = 0.0;
        int n12 = pieData.lastDrawnSlice;
        boolean bl = false;
        boolean bl2 = false;
        int n13 = 0;
        while (n13 < pieData.num_slices_pie) {
            int n14 = -1;
            int n15 = -1;
            bl = n13 == 0 ? false : pieData.exploded[pieData.percents[n12].index];
            double d6 = pieData.percents[n13].pct * 360.0;
            if (n13 == pieData.lastDrawnSlice) {
                if (d5 >= 360.0) {
                    d6 = 0.0;
                } else {
                    d6 = d4 - this.pcf.getStartAngle();
                    if (d6 < 0.0 || d6 == 0.0 && d5 == 0.0) {
                        d6 += 360.0;
                    }
                }
            }
            if (d6 != 0.0) {
                Point point;
                int n16 = (int)Math.round(d4);
                if (d5 == 0.0) {
                    n15 = (int)Math.round((double)n7 + Math.cos(JCNumberUtil.degToRad(n16)) * Math.floor(d2));
                    n14 = (int)Math.round((double)n8 - Math.sin(JCNumberUtil.degToRad(n16)) * Math.floor(d3));
                    n5 = n15;
                    n6 = n14;
                    bl2 = pieData.exploded[pieData.percents[n13].index];
                } else {
                    n15 = n9;
                    n14 = n10;
                }
                d4 -= (double)Math.round(d6);
                d5 += (double)Math.round(d6);
                if (d4 < 0.0) {
                    d4 += 360.0;
                }
                n16 = (int)Math.round(d4);
                n9 = (int)Math.round((double)n7 + Math.cos(JCNumberUtil.degToRad(n16)) * Math.floor(d2));
                n10 = (int)Math.round((double)n8 - Math.sin(JCNumberUtil.degToRad(n16)) * Math.floor(d3));
                if (pieData.exploded[pieData.percents[n13].index]) {
                    point = pieChartInfo.pos[n4].offset[n13];
                    graphics.drawLine(n7 + point.x, n8 + point.y, n15 + point.x, n14 + point.y);
                } else if (bl) {
                    graphics.drawLine(n7, n8, n15, n14);
                }
                if (pieData.exploded[pieData.percents[n13].index]) {
                    point = pieChartInfo.pos[n4].offset[n13];
                    graphics.drawLine(n7 + point.x, n8 + point.y, n9 + point.x, n10 + point.y);
                } else {
                    graphics.drawLine(n7, n8, n9, n10);
                }
                n12 = n13;
            }
            pieChartInfo.pos[n4].coord[n13].x = n15;
            pieChartInfo.pos[n4].coord[n13].y = n14;
            if (n15 >= 0) {
                int n17 = n13 - 1;
                while (n17 >= 0 && pieChartInfo.pos[n4].coord[n17].x == -1) {
                    pieChartInfo.pos[n4].coord[n17].x = n15;
                    pieChartInfo.pos[n4].coord[n17].y = n14;
                    --n17;
                }
                n11 = n13;
            }
            ++n13;
        }
        if (!bl2 && pieData.exploded[pieData.percents[n12].index]) {
            graphics.drawLine(n7, n8, n5, n6);
        }
        n13 = n11 + 1;
        while (n13 < pieData.num_slices_pie) {
            pieChartInfo.pos[n4].coord[n13].x = pieChartInfo.pos[n4].coord[0].x;
            pieChartInfo.pos[n4].coord[n13].y = pieChartInfo.pos[n4].coord[0].y;
            ++n13;
        }
    }

    private void drawPiePlane(Graphics graphics, List list, PieData pieData, PieChartInfo pieChartInfo, int n2, int n3, int n4, boolean bl, Rectangle rectangle) {
        double d2 = this.pcf.getStartAngle();
        double d3 = 0.0;
        int n5 = 0;
        while (n5 < pieData.num_slices_pie) {
            JCFillStyle jCFillStyle = this.getPieSliceFillStyle(pieData, n5);
            double d4 = pieData.percents[n5].pct * 360.0;
            if (n5 == pieData.lastDrawnSlice) {
                if (d3 >= 360.0) {
                    d4 = 0.0;
                } else {
                    d4 = d2 - this.pcf.getStartAngle();
                    if (d4 < 0.0 || d4 == 0.0 && d3 == 0.0) {
                        d4 += 360.0;
                    }
                }
            }
            if (d4 != 0.0) {
                int n6 = (int)Math.round(d4);
                if (n6 != 0) {
                    if (pieData.exploded[pieData.percents[n5].index]) {
                        int n7 = n6 / 2;
                        this.calcExplodeOffset((int)Math.round(d2), n7, this.explode_offset, pieChartInfo.width / 2, pieChartInfo.pos[n4].offset[n5]);
                    }
                    Point point = pieChartInfo.pos[n4].offset[n5];
                    jCFillStyle.updateFillOrientation(rectangle, 5);
                    if (bl) {
                        jCFillStyle.fillArc(graphics, n2 + point.x, n3 + point.y, pieChartInfo.width, pieChartInfo.height, (int)Math.round(d2), -1 * n6);
                    } else {
                        jCFillStyle.fillArcShadow(graphics, n2 + point.x, n3 + point.y, pieChartInfo.width, pieChartInfo.height, (int)Math.round(d2), -1 * n6);
                    }
                    jCFillStyle.resetFillOrientation();
                }
                d2 -= (double)n6;
                d3 += (double)n6;
                if (d2 < 0.0) {
                    d2 += 360.0;
                }
            }
            ++n5;
        }
    }

    private Point find_point(int n2, int n3) {
        int n4 = this.seriesList.size();
        if (n2 != -10 && !((ChartDataViewSeries)this.seriesList.get(n2)).isVisible()) {
            return null;
        }
        double d2 = 0.0;
        if (this.pcf.getExplodeList() == null) {
            d2 = JCNumberUtil.degToRad(Math.max(0, this.chartArea.getElevation()));
        }
        double d3 = Math.cos(d2);
        int n5 = -1;
        int n6 = -1;
        double d4 = 0.0;
        double d5 = 0.0;
        int n7 = 0;
        while (n7 < n4 + 1) {
            int n8 = n3 - ((ChartDataViewSeries)this.seriesList.get(0)).getFirstPoint();
            short s2 = this.pieInfo.pos[n8].order[n7];
            if (s2 == -1) {
                return null;
            }
            if (s2 != -2 && s2 == n2) {
                double d6;
                double d7;
                double d8 = this.pieInfo.pos[n8].coord[n7].x;
                double d9 = this.pieInfo.pos[n8].coord[n7].y;
                if (d8 == -2.0) {
                    return null;
                }
                if (n7 == n4 || this.pieInfo.pos[n8].order[n7 + 1] == -1) {
                    d7 = this.pieInfo.pos[n8].coord[0].x;
                    d6 = this.pieInfo.pos[n8].coord[0].y;
                } else {
                    d7 = this.pieInfo.pos[n8].coord[n7 + 1].x;
                    d6 = this.pieInfo.pos[n8].coord[n7 + 1].y;
                }
                d9 = (d9 - (double)this.pieInfo.pos[n8].cy) / d3 + (double)this.pieInfo.pos[n8].cy;
                d6 = (d6 - (double)this.pieInfo.pos[n8].cy) / d3 + (double)this.pieInfo.pos[n8].cy;
                double d10 = Math.atan2((double)this.pieInfo.pos[n8].cy - d9, d8 - (double)this.pieInfo.pos[n8].cx);
                double d11 = Math.atan2((double)this.pieInfo.pos[n8].cy - d6, d7 - (double)this.pieInfo.pos[n8].cx);
                d4 = d10 - d11;
                if (d4 < 0.0) {
                    d4 += Math.PI * 2;
                }
                if ((d4 = d10 - d4 / 2.0) <= -Math.PI) {
                    d4 += Math.PI * 2;
                }
                if (d4 == 1.5707963267948966) {
                    n5 = this.pieInfo.pos[n8].cx;
                    n6 = this.pieInfo.pos[n8].cy - this.pieInfo.height / 2;
                    break;
                }
                if (d4 == -1.5707963267948966) {
                    n5 = this.pieInfo.pos[n8].cx;
                    n6 = this.pieInfo.pos[n8].cy + this.pieInfo.height / 2;
                    break;
                }
                double d12 = (double)this.pieInfo.width / 2.0;
                double d13 = Math.tan(d4);
                d8 = Math.sqrt(d12 * d12 / (1.0 + d13 * d13));
                if (d4 > 1.5707963267948966 || d4 < -1.5707963267948966) {
                    d8 = -d8;
                }
                d9 = d8 * d13 * d3;
                n5 = (int)((double)this.pieInfo.pos[n8].cx + d8);
                n6 = (int)((double)this.pieInfo.pos[n8].cy - d9);
                break;
            }
            ++n7;
        }
        d5 = d4;
        return new Point(n5, n6);
    }

    private JCFillStyle getPieSliceFillStyle(PieData pieData, int n2) {
        JCFillStyle jCFillStyle = null;
        if (n2 == pieData.other_slice && pieData.other_flag != 0) {
            jCFillStyle = this.pcf.getOtherStyle().getFillStyle();
        } else {
            int n3 = pieData.percents[n2].index;
            if (n3 >= 0) {
                jCFillStyle = ((ChartDataViewSeries)this.seriesList.get(n3)).getStyle().getFillStyle();
            }
        }
        return jCFillStyle;
    }

    public JCDataIndex pick(Point point, int n2) {
        int n3;
        JCDataIndex jCDataIndex = null;
        PieData pieData = new PieData();
        pieData.sortPoints = null;
        pieData.percents = null;
        int n4 = 0;
        Rectangle rectangle = this.chartArea.getDrawingArea();
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        int n5 = this.seriesList.size();
        if (n5 == 0) {
            return jCDataIndex;
        }
        pieData.sortPoints = new PieSortPoint[n5];
        int n6 = 0;
        while (n6 < n5) {
            pieData.sortPoints[n6] = new PieSortPoint();
            ++n6;
        }
        pieData.percents = new PiePercent[n5 + 1];
        pieData.exploded = new boolean[n5 + 1];
        int n7 = 0;
        while (n7 < n5 + 1) {
            pieData.percents[n7] = new PiePercent();
            pieData.exploded[n7] = false;
            ++n7;
        }
        double d2 = 0.0;
        if (this.pcf.getExplodeList() == null) {
            d2 = JCNumberUtil.degToRad(Math.max(0.0, (double)this.chartArea.getElevation()));
        }
        double d3 = Math.cos(d2);
        int n8 = 0;
        int n9 = 0;
        if (this.pieInfo == null || (n8 = this.pieInfo.width) == 0 || (n9 = this.pieInfo.height) == 0) {
            return jCDataIndex;
        }
        int n10 = (this.box_width - n8) / 2;
        if (n10 < 0) {
            n10 = 0;
        }
        double d4 = (double)n8 / 2.0;
        double d5 = (double)n9 / 2.0;
        int n11 = (point.x - rectangle.x) / this.box_width;
        if (n11 >= this.num_pies_line) {
            n11 = this.num_pies_line - 1;
        }
        if ((n3 = (point.y - rectangle.y) / this.box_height) >= this.num_lines) {
            n3 = this.num_lines - 1;
        }
        int n12 = n3 * this.num_pies_line + n11 + ((ChartDataViewSeries)this.seriesList.get(0)).getFirstPoint();
        int n13 = rectangle.x;
        int n14 = rectangle.y;
        int n15 = (n13 += n11 * this.box_width) + n10;
        int n16 = (n14 += n3 * this.box_height) + (this.box_height - n9 - this.delta_y - this.label_height) / 2;
        int n17 = n15 + (int)Math.round((double)n8 / 2.0);
        int n18 = n16 + (int)Math.round((double)n9 / 2.0);
        int n19 = -1;
        int n20 = -1;
        if (n12 < this.num_pies + ((ChartDataViewSeries)this.seriesList.get(0)).getFirstPoint() && point.x >= n13 && point.x <= n13 + this.box_width && point.y >= n14 && point.y <= n14 + this.box_height) {
            double d6;
            double d7;
            int n21 = this.computeOtherSlice(this.seriesList, n12, n5, pieData);
            int[] nArray = this.pie_hit(n17, n18, d4, d5, this.delta_y, point.x, point.y);
            int n22 = nArray[0];
            double d8 = 0.0;
            switch (n22) {
                case 1: {
                    int n23 = nArray[1];
                    if (point.x == n17) {
                        d8 = point.y < n18 ? 90 : -90;
                    } else {
                        d8 = JCNumberUtil.radToDeg(Math.atan((double)(n18 - point.y) / (double)(point.x - n17)));
                        if (point.x < n17) {
                            d8 += 180.0;
                        }
                    }
                    n4 = 0;
                    break;
                }
                case 2: {
                    int n23 = nArray[1];
                    if (point.x == n17) {
                        d8 = -90.0;
                    } else {
                        d8 = JCNumberUtil.radToDeg(Math.atan((double)(-n23) / (double)(point.x - n17)));
                        if (point.x < n17) {
                            d8 += 180.0;
                        }
                    }
                    n4 = 0;
                    break;
                }
                case 0: {
                    double d9;
                    double d10;
                    if (point.y < n18) {
                        if (point.x == n17) {
                            d8 = 90.0;
                        } else {
                            d8 = JCNumberUtil.radToDeg(Math.atan((double)(n18 - point.y) / (double)(point.x - n17)));
                            if (point.x < n17) {
                                d8 += 180.0;
                            }
                        }
                        d7 = point.x - n17;
                        d10 = point.y - n18;
                        d9 = Math.cos(JCNumberUtil.degToRad(d8));
                        d6 = Math.sin(JCNumberUtil.degToRad(d8));
                        n4 = (int)Math.round(Math.sqrt(d7 * d7 + d10 * d10) - d4 * d5 / Math.sqrt(d5 * d5 * d9 * d9 + d4 * d4 * d6 * d6));
                        n4 = Math.max(n4, 0);
                        break;
                    }
                    if (point.y > n18 + this.delta_y) {
                        if (point.x == n17) {
                            d8 = -90.0;
                        } else {
                            d8 = JCNumberUtil.radToDeg(Math.atan((double)(n18 + this.delta_y - point.y) / (double)(point.x - n17)));
                            if (point.x < n17) {
                                d8 += 180.0;
                            }
                        }
                        d7 = point.x - n17;
                        d10 = point.y - (n18 + this.delta_y);
                        d9 = Math.cos(JCNumberUtil.degToRad(d8));
                        d6 = Math.sin(JCNumberUtil.degToRad(d8));
                        n4 = (int)Math.round(Math.sqrt(d7 * d7 + d10 * d10) - d4 * d5 / Math.sqrt(d5 * d5 * d9 * d9 + d4 * d4 * d6 * d6));
                        n4 = Math.max(n4, 0);
                        break;
                    }
                    if (point.x < n15) {
                        d8 = 180.0;
                        n4 = n15 - point.x;
                        break;
                    }
                    if (point.x > n15 + n8) {
                        d8 = 0.0;
                        n4 = point.x - (n15 + n8);
                        break;
                    }
                    d8 = point.x < n17 ? 180 : 0;
                    n4 = 0;
                    break;
                }
            }
            if (d3 != 0.0) {
                d7 = d8;
                d8 = JCNumberUtil.radToDeg(Math.atan(Math.tan(JCNumberUtil.degToRad(d7)) / d3));
                if (Math.cos(JCNumberUtil.degToRad(d7)) <= 0.0) {
                    d8 += 180.0;
                }
            }
            if (d8 > this.pcf.getStartAngle()) {
                d8 -= 360.0;
            }
            int n24 = 0;
            if (!pieData.zero_pie) {
                double d11 = 0.0;
                double d12 = 0.0;
                int n25 = 0;
                n25 = 0;
                d12 = this.pcf.getStartAngle();
                while (n25 < pieData.num_slices_pie) {
                    d6 = pieData.percents[n25].pct * 360.0;
                    if (d6 == 0.0) {
                        d11 = d12;
                    } else {
                        d11 = d12 - d6;
                        if (d11 <= d8 && d8 <= d12) {
                            n24 = n21 != 0 && n25 == pieData.other_slice ? -10 : pieData.percents[n25].index;
                            if (!pieData.exploded[pieData.percents[n25].index] || (n4 -= this.pcf.getExplodeOffset()) >= 0) break;
                            n4 = 0;
                            break;
                        }
                    }
                    ++n25;
                    d12 = d11;
                }
            }
            n19 = n24;
            n20 = n12;
        }
        if (n19 >= 0 && n20 >= 0) {
            jCDataIndex = new JCDataIndex(n20, (ChartDataViewSeries)this.seriesList.get(n19), n19);
            jCDataIndex.distance = n4;
        } else if (n19 == -10 && n20 >= 0) {
            jCDataIndex = new JCDataIndex(n20, null, n19);
            jCDataIndex.distance = n4;
        }
        return jCDataIndex;
    }

    private int[] pieLayout(int n2, Rectangle rectangle) {
        int n3 = rectangle.height == 0 ? n2 : (int)Math.min((double)n2, Math.sqrt(n2) * (double)rectangle.width / (double)rectangle.height);
        if (n3 < 1) {
            n3 = 1;
        }
        int n4 = (int)Math.min((double)(rectangle.width / n3), (double)rectangle.height / Math.ceil((double)n2 / (double)n3));
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        while (!bl) {
            int n5 = n3;
            n5 = bl2 ? ++n5 : --n5;
            if (n5 > n2) {
                if (bl3 || bl4) {
                    bl = true;
                    continue;
                }
                if (bl2) {
                    bl2 = false;
                    continue;
                }
                bl = true;
                continue;
            }
            if (n5 == 0) {
                bl = true;
                continue;
            }
            int n6 = (int)Math.min((double)(rectangle.width / n5), (double)rectangle.height / Math.ceil((double)n2 / (double)n5));
            if (n6 > n4) {
                n3 = n5;
                n4 = n6;
                if (bl2) {
                    bl3 = true;
                    continue;
                }
                bl4 = true;
                continue;
            }
            if (bl3 || bl4) {
                bl = true;
                continue;
            }
            if (bl2) {
                bl2 = false;
                continue;
            }
            bl = true;
        }
        int n7 = n2 / n3;
        if ((double)n7 != (double)n2 / (double)n3) {
            // empty if block
        }
        int[] nArray = new int[]{++n7, n3};
        return nArray;
    }

    private int[] pie_hit(int n2, int n3, double d2, double d3, int n4, int n5, int n6) {
        int[] nArray = new int[2];
        double d4 = d2 * d2;
        double d5 = n5 - n2;
        double d6 = d5 * d5;
        if (d4 < d6) {
            nArray[0] = 0;
            return nArray;
        }
        double d7 = d3 / d2 * Math.sqrt(d4 - d6);
        if ((double)n6 < (double)n3 - d7 || (double)n6 > (double)(n3 + n4) + d7) {
            nArray[0] = 0;
            return nArray;
        }
        nArray[1] = (int)Math.round(d7);
        nArray[0] = (double)n6 < (double)n3 + d7 ? 1 : 2;
        return nArray;
    }

    public void recalc() {
        int n2;
        super.recalc();
        this.calcTransientData();
        this.pieInfo = (PieChartInfo)this.dataObject.getTransientData();
        Rectangle rectangle = this.chartArea.getPlotRect();
        this.graph_left = rectangle.x;
        this.graph_top = rectangle.y;
        int n3 = Math.max(rectangle.width - 1, 0);
        int n4 = Math.max(rectangle.height - 1, 0);
        int n5 = this.dataObject.getNumPointLabels();
        String[] stringArray = new String[n5];
        this.cLabels = new ChartText[n5];
        this.label_height = 0;
        int n6 = 0;
        while (n6 < n5) {
            stringArray[n6] = this.dataObject.getPointLabel(n6);
            if (stringArray[n6] != null) {
                this.cLabels[n6] = new ChartText();
                this.cLabels[n6].setText(stringArray[n6]);
                this.cLabels[n6].setParentChart((JCChart)this.chartArea.getParent());
                this.cLabels[n6].setParentRegion(this.chartArea);
                n2 = this.cLabels[n6].getHeight();
                this.label_height = Math.max(this.label_height, n2);
            } else {
                this.cLabels[n6] = null;
            }
            ++n6;
        }
        n2 = this.dataObject.getNumSeries();
        if (this.num_pies == 0) {
            return;
        }
        int[] nArray = this.pieLayout(this.num_pies, rectangle);
        this.num_lines = nArray[0];
        this.num_pies_line = nArray[1];
        this.box_width = n3 / this.num_pies_line;
        this.box_height = n4 / this.num_lines;
        this.explode_offset = this.pcf.getExplodeList() == null ? 0 : this.pcf.getExplodeOffset();
        int n7 = Math.max(this.box_width - this.label_height * 2 - this.explode_offset * 2 - 2, 0);
        int n8 = Math.max(this.box_height - this.label_height * 2 - this.explode_offset * 2 - 2, 0);
        double d2 = this.pcf.getExplodeList() == null ? JCNumberUtil.degToRad(Math.max(0, this.chartArea.getElevation())) : 0.0;
        double d3 = Math.sin(d2);
        double d4 = Math.cos(d2);
        double d5 = (double)this.chartArea.getDepth() / 100.0;
        int n9 = 0;
        n9 = (double)n7 * (d4 + d5 * d3) < (double)n8 ? n7 : (int)((double)n8 / (d4 + d5 * d3));
        int n10 = (int)((double)n9 * d4);
        this.chartArea.setDeltaX(0);
        this.delta_y = (int)((double)n9 * d5 * d3);
        this.chartArea.setDeltaY(this.delta_y);
        if (n9 != (n9 | 1)) {
            n9 = (n9 | 1) - 2;
        }
        if (n10 != (n10 | 1)) {
            n10 = (n10 | 1) - 2;
        }
        this.pieInfo.width = n9;
        this.pieInfo.height = n10;
        this.pie_offset = (int)((double)(this.box_width - n9) / 2.0);
        if (this.pie_offset < 0) {
            this.pie_offset = 0;
        }
    }

    public Point unpick(int n2, int n3) {
        return this.find_point(n3, n2);
    }
}

