/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AxisHandler;
import com.klg.jclass.chart.ErrorDialog;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Dimension;
import java.awt.Graphics;

class LogAxisHandler
extends AxisHandler {
    LogAxisHandler() {
    }

    void calcParams() {
        double d2 = this.parent.dataLimits == null ? 1.0 : this.parent.dataLimits.min;
        double d3 = this.parent.dataLimits == null ? 100.0 : this.parent.dataLimits.max;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        d2 = this.parent.min.isDefault ? d2 : this.parent.min.value;
        d3 = this.parent.max.isDefault ? d3 : this.parent.max.value;
        n2 = JCNumberUtil.ifloor(JCNumberUtil.log10(d2));
        n3 = JCNumberUtil.iceil(JCNumberUtil.log10(d3));
        do {
            this.calcPrecision();
        } while (this.fixBounds());
        if (this.parent.vertical) {
            if (this.parent.origin.isDefault || this.parent.origin.value <= 0.0) {
                if (this.parent.chartType == 9 || this.parent.chartType == 10 || this.parent.chartType == 12 || this.parent.chartType == 8) {
                    --n2;
                }
            } else if (!this.parent.origin.isDefault && this.parent.origin.value > 0.0) {
                n6 = JCNumberUtil.ifloor(JCNumberUtil.log10(this.parent.origin.value));
                if (n6 < n2 && this.parent.min.isDefault) {
                    n2 = n6;
                }
                if (n6 > n3 && this.parent.max.isDefault) {
                    n3 = n6;
                }
            }
        } else if (!this.parent.origin.isDefault && this.parent.origin.value > 0.0) {
            n6 = JCNumberUtil.ifloor(JCNumberUtil.log10(this.parent.origin.value));
            if (n6 < n2 && this.parent.min.isDefault) {
                n2 = n6;
            }
            if (n6 > n3 && this.parent.max.isDefault) {
                n3 = n6;
            }
        }
        int n8 = 0;
        Dimension dimension = new Dimension();
        n7 = 1;
        while (n7 <= 5) {
            n4 = n2;
            n5 = n3;
            boolean bl = JCNumberUtil.abs(n5) > JCNumberUtil.abs(n4);
            while ((n5 - n4) % n7 != 0) {
                if (bl) {
                    ++n5;
                } else {
                    --n4;
                }
                bl ^= true;
            }
            this.getAnnoExtent(dimension, n5, this.parent.precision.value);
            this.getAnnoExtent(dimension, n4, this.parent.precision.value);
            if (this.parent.vertical) {
                n8 = this.parent.annotationRotation == 0 ? dimension.height * 2 : dimension.width + dimension.width / 2;
            } else {
                int n9 = n8 = this.parent.annotationRotation == 0 ? dimension.width + dimension.width / 2 : dimension.height * 2;
            }
            if ((n5 - n4) / n7 * n8 < this.parent.pixelLength()) break;
            ++n7;
        }
        if (n7 <= 5) {
            this.parent.logIncrement = n7;
        } else {
            n4 = n2;
            n5 = n3;
            this.parent.logIncrement = Math.max(n5 - n4, 1);
        }
        if (this.parent.min.isDefault) {
            this.parent.min.value = JCNumberUtil.pow10(n4);
        }
        if (this.parent.max.isDefault) {
            this.parent.max.value = JCNumberUtil.pow10(n5);
        }
        if (this.parent.vertical && (this.parent.chartType == 2 || this.parent.chartType == 3 || this.parent.chartType == 4)) {
            this.parent.origin.value = this.parent.max.value;
        } else if (this.parent.origin.isDefault || this.parent.origin.value <= 0.0) {
            switch (this.parent.originPlacement.value) {
                case 2: {
                    this.parent.origin.value = this.parent.max.value;
                    break;
                }
                case 0: 
                case 1: 
                case 3: {
                    this.parent.origin.value = this.parent.min.value;
                    break;
                }
            }
        }
        if (this.parent.vertical) {
            this.parent.setSize(n8 + 1 + this.parent.tickLength / 2, this.parent.getHeight());
        } else {
            this.parent.setSize(this.parent.getWidth(), dimension.height + 1 + this.parent.tickLength / 2);
        }
    }

    void calcPrecision() {
        if (this.parent.precision.isDefault) {
            if (this.parent.annotationMethod == 2 || this.parent.dataLimits == null) {
                this.parent.precision.value = 0;
            } else {
                double d2;
                double d3 = JCNumberUtil.log10(this.parent.min.isDefault ? this.parent.dataLimits.min : this.parent.min.value);
                if (d3 == Double.NEGATIVE_INFINITY) {
                    d3 = 0.0;
                }
                if ((d2 = JCNumberUtil.log10(this.parent.max.isDefault ? this.parent.dataLimits.max : this.parent.max.value)) == Double.NEGATIVE_INFINITY) {
                    d2 = 0.0;
                }
                this.parent.precision.value = d2 <= d3 ? JCNumberUtil.nicePrecision(Math.abs(d2)) : JCNumberUtil.nicePrecision(d2 - d3);
            }
        }
        this.parent.precision.value = JCNumberUtil.clamp(this.parent.precision.value, -this.parent.getMaxPrecision(), this.parent.getMaxPrecision());
    }

    void calcTransformation() {
        int n2 = this.parent.pixelLength();
        int n3 = this.parent.pixelStart();
        double d2 = JCNumberUtil.log10(this.parent.min.value);
        double d3 = JCNumberUtil.log10(this.parent.max.value);
        double d4 = JCNumberUtil.calcError(this.parent.precision.value);
        if (this.parent.reversed) {
            n2 = -n2;
        }
        if (Math.abs(d3 - d2) < d4) {
            this.scale = 1.0;
            this.shift = 0.0;
            return;
        }
        this.scale = (double)n2 / (d3 - d2);
        this.shift = n2 < 0 ? (double)n3 - d3 * this.scale : (double)n3 - d2 * this.scale;
    }

    void drawTicks(Graphics graphics) {
        if (this.parent.annotationMethod != 0 && this.parent.tickSpacing.isDefault) {
            super.drawTicks(graphics);
            return;
        }
        int n2 = this.parent.linePosition();
        double d2 = this.parent.max.value;
        double d3 = this.parent.min.value;
        if (d2 <= 0.0) {
            d2 = 1.0;
            d3 = 0.1;
        } else {
            d3 = this.parent.min.value > 0.0 ? this.parent.min.value : d2 / 10.0;
        }
        int n3 = JCNumberUtil.ifloor(JCNumberUtil.log10(d3));
        int n4 = JCNumberUtil.iceil(JCNumberUtil.log10(d2));
        int n5 = n3;
        while (n5 <= n4) {
            double d4 = JCNumberUtil.pow10(n5);
            int n6 = 1;
            while (n6 < 10) {
                double d5 = (double)n6 * d4;
                if (!(d5 < this.parent.min.value) && !(d5 > this.parent.max.value)) {
                    int n7 = this.parent.toPixel(d5);
                    this.drawTick(graphics, n2, n7);
                }
                ++n6;
            }
            ++n5;
        }
    }

    boolean fixBounds() {
        String string;
        boolean bl = super.fixBounds();
        if (!this.parent.max.isDefault && this.parent.max.value <= 0.0) {
            string = JCChartBundle.string("com.klg.jclass.chart.Key104");
            string = String.valueOf(string) + JCChartBundle.string("com.klg.jclass.chart.Key130");
            ErrorDialog.raise(this.parent, string);
            this.parent.max.isDefault = true;
            bl = true;
        }
        if (!this.parent.min.isDefault && this.parent.min.value <= 0.0) {
            string = JCChartBundle.string("com.klg.jclass.chart.Key106");
            string = String.valueOf(string) + JCChartBundle.string("com.klg.jclass.chart.Key132");
            ErrorDialog.raise(this.parent, string);
            this.parent.min.isDefault = true;
            bl = true;
        }
        if (!this.parent.min.isDefault && !this.parent.max.isDefault) {
            double d2 = JCNumberUtil.log10(this.parent.min.value);
            double d3 = JCNumberUtil.log10(this.parent.max.value);
            if (d3 - d2 < Double.MIN_VALUE) {
                string = JCChartBundle.string("com.klg.jclass.chart.Key7");
                string = String.valueOf(string) + JCChartBundle.string("com.klg.jclass.chart.Key130");
                ErrorDialog.raise(this.parent, string);
                this.parent.max.isDefault = true;
                bl = true;
            }
        }
        return bl;
    }

    String format(double d2, int n2) {
        return JCNumberUtil.logFormat((int)d2);
    }

    double range() {
        int n2 = JCNumberUtil.ifloor(JCNumberUtil.log10(this.parent.min.value));
        int n3 = JCNumberUtil.iceil(JCNumberUtil.log10(this.parent.max.value));
        return n3 - n2;
    }

    double toData(int n2) {
        if (this.parent.vertical) {
            n2 = this.parent.getHeight() - n2;
        }
        return Math.pow(10.0, ((double)n2 - this.shift) / this.scale);
    }

    int toPixel(double d2) {
        if (d2 <= 0.0) {
            d2 = this.parent.min.value;
        }
        int n2 = JCNumberUtil.ifloor(this.scale * JCNumberUtil.log10(d2) + this.shift + 0.5);
        return this.parent.vertical ? this.parent.getHeight() - n2 : n2;
    }

    void translate(double d2) {
        double d3 = JCNumberUtil.log10(this.parent.min.value);
        double d4 = JCNumberUtil.log10(this.parent.max.value);
        if (this.parent.reversed) {
            d2 = -d2;
        }
        this.parent.min.value = Math.pow(10.0, d3 + d2);
        this.parent.max.value = Math.pow(10.0, d4 + d2);
    }
}

