/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AxisHandler;
import com.klg.jclass.chart.DoubleCoord;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Dimension;
import java.awt.Graphics;

class LinearAxisHandler
extends AxisHandler {
    LinearAxisHandler() {
    }

    private int calcMaxAnnoSize(double d2, double d3) {
        Dimension dimension = new Dimension();
        this.getAnnoExtent(dimension, d3, this.parent.precision.value);
        this.getAnnoExtent(dimension, d2, this.parent.precision.value);
        if (this.parent.vertical) {
            this.parent.setSize(dimension.width + 1 + this.parent.tickLength / 2, this.parent.getHeight());
        } else {
            this.parent.setSize(this.parent.getWidth(), dimension.height + 1 + this.parent.tickLength / 2);
        }
        return this.parent.vertical ? dimension.height : dimension.width;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double calcOrigin(double d2, double d3) {
        double d4 = 0.0;
        if (!this.parent.origin.isDefault) return this.parent.origin.value;
        switch (this.parent.originPlacement.value) {
            case 3: {
                return 0.0;
            }
            case 1: {
                return d2;
            }
            case 2: {
                return d3;
            }
            case 0: {
                if (!(d2 <= 0.0)) return d2;
                if (!(d3 >= 0.0)) return d2;
                return 0.0;
            }
            default: {
                return d4;
            }
        }
    }

    void calcParams() {
        double d2;
        double d3;
        boolean bl;
        double d4;
        double d5 = this.parent.dataLimits == null ? 0.0 : this.parent.dataLimits.min;
        double d6 = d4 = this.parent.dataLimits == null ? 100.0 : this.parent.dataLimits.max;
        double d7 = d5;
        double d8 = 0.0;
        double d9 = this.parent.numSpacing.value;
        double d10 = this.parent.tickSpacing.value;
        boolean bl2 = this.parent.chartType == 9 || this.parent.chartType == 10;
        boolean bl3 = this.parent.chartType == 5 || this.parent.chartType == 6;
        boolean bl4 = this.parent.chartType == 7;
        boolean bl5 = bl = this.parent.chartType == 2 || this.parent.chartType == 3 || this.parent.chartType == 4;
        if (bl && !this.parent.vertical) {
            this.parent.min.value = 0.0;
            this.parent.max.value = JCNumberUtil.convertAngle(1, this.parent.chartArea.getAngleUnit(), 360.0);
        }
        boolean bl6 = false;
        do {
            this.calcPrecision();
        } while (this.fixBounds());
        double d11 = d6;
        double d12 = d7;
        int n2 = this.parent.precision.value;
        d7 = JCNumberUtil.precFloor(n2, d5);
        d6 = JCNumberUtil.precCeil(n2, d4);
        if (d6 <= d7) {
            n2 = this.parent.precision.value;
            if (this.parent.max.isDefault) {
                do {
                    d6 = d7 + JCNumberUtil.pow10(-n2);
                    --n2;
                } while (d6 <= d7);
            } else {
                do {
                    d7 = d6 - JCNumberUtil.pow10(-n2);
                    --n2;
                } while (d6 <= d7);
            }
        }
        if (bl) {
            d6 = this.parent.max.value;
        }
        d7 = this.parent.min.isDefault ? d7 : this.parent.min.value;
        d6 = this.parent.max.isDefault ? d6 : this.parent.max.value;
        d8 = this.calcOrigin(d7, d6);
        double d13 = this.parent.min.isDefault ? JCNumberUtil.min(d7, d8) : d7;
        double d14 = this.parent.max.isDefault ? JCNumberUtil.max(d6, d8) : d6;
        double d15 = 0.0;
        boolean bl7 = false;
        int n3 = 0;
        while (n3 < 2 && !bl7) {
            d7 = JCNumberUtil.precFloor(this.parent.precision.value, d7);
            d6 = JCNumberUtil.precCeil(this.parent.precision.value, d6);
            if (bl) {
                d6 = this.parent.max.value;
            }
            d7 = this.parent.min.isDefault ? d7 : this.parent.min.value;
            d6 = this.parent.max.isDefault ? d6 : this.parent.max.value;
            d3 = this.parent.min.isDefault ? JCNumberUtil.min(d7, d8) : d7;
            d2 = this.parent.max.isDefault ? JCNumberUtil.max(d6, d8) : d6;
            d7 = d3;
            d6 = d2;
            d15 = 0.5 * JCNumberUtil.pow10(-this.parent.precision.value - 1);
            int n4 = this.parent.pixelLength();
            d9 = this.parent.numSpacing.value;
            d10 = this.parent.tickSpacing.value;
            int n5 = this.calcMaxAnnoSize(d7, d6);
            if (this.parent.numSpacing.isDefault && this.parent.tickSpacing.isDefault) {
                double d16;
                int n6 = n5 == 0 ? 0 : this.parent.pixelLength() / (n5 + 2);
                double d17 = JCNumberUtil.abs(d2 - d3);
                if (n6 <= 0) {
                    d9 = 0.0;
                    d10 = 0.0;
                } else if (bl) {
                    int n7;
                    if (this.parent.chartArea.getAngleUnit() == 2) {
                        while (90 % n6 != 0 && n6 > 1) {
                            --n6;
                        }
                    }
                    d16 = d17 / (double)(n6 * 4);
                    if (this.parent.chartArea.getAngleUnit() != 2) {
                        n7 = (int)d16;
                        while ((d16 - (double)n7 != 0.0 || d17 % d16 != 0.0 || n7 % 5 != 0 && n7 % 10 != 0) && n6 > 1) {
                            d16 = d17 / (double)(--n6 * 4);
                            n7 = (int)d16;
                        }
                    }
                    d10 = d16;
                    n7 = n6 < 4 ? 1 : (n6 % 2 == 1 ? (n6 % 3 == 0 ? 3 : 1) : (n6 > 4 && n6 % 4 == 0 ? 4 : 2));
                    d9 = d10 * (double)n7;
                } else {
                    d16 = d17 / (double)n6;
                    DoubleCoord doubleCoord = JCChartUtil.calcTik(d16, this.parent.precision.value);
                    d10 = doubleCoord.x;
                    d9 = doubleCoord.y;
                }
            } else if (this.parent.tickSpacing.isDefault) {
                d9 = JCNumberUtil.precCorrect(this.parent.precision.value, d9);
                d10 = this.parent.numSpacing.value / 2.0;
            } else if (this.parent.numSpacing.isDefault) {
                d9 = 2.0 * d10;
                d9 = JCNumberUtil.precCorrect(this.parent.precision.value, d9);
            }
            if (d9 != 0.0) {
                double d18 = (d7 - d8) / d9;
                d7 = d18 != Math.floor(d18) ? d8 + Math.floor(d18 - 1.0) * d9 : d8 + Math.floor(d18) * d9;
                d18 = (d6 - d8) / d9;
                if (JCNumberUtil.abs((d6 = d18 != Math.floor(d18) ? d8 + Math.floor(d18 + 1.0) * d9 : d8 + Math.floor(d18) * d9) - d7) < d15) {
                    d6 = d7 + d9;
                }
            } else if (JCNumberUtil.abs(d6 - d7) < d15) {
                d6 = d7 + 1.0;
            }
            if (JCNumberUtil.abs(d7 - d3) > d15 || JCNumberUtil.abs(d6 - d2) > d15) {
                bl7 = true;
                if (d6 - d9 >= d14) {
                    d6 -= d9;
                } else {
                    bl7 = false;
                }
                if (d7 + d9 <= d13) {
                    d7 += d9;
                } else {
                    bl7 = false;
                }
            }
            ++n3;
        }
        if (!this.parent.vertical && (this.parent.annotationMethod == 2 || bl)) {
            d6 = d4;
            d7 = d5;
            if (d6 <= d7) {
                n2 = 0;
                do {
                    d6 = d7 + JCNumberUtil.pow10(n2);
                    d7 -= d6 - d7;
                    ++n2;
                } while (d6 <= d7);
            }
            d13 = d7;
            d14 = d6;
        }
        if (this.parent.dataLimits != null && (this.parent.annotationMethod == 3 || this.parent.isPrimary && (bl2 || bl3 || bl4))) {
            d3 = d12;
            d2 = d11;
            if (this.parent.min.isDefault) {
                d3 = d5 - this.parent.step / 2.0;
            }
            if (this.parent.max.isDefault) {
                d2 = d4 + this.parent.step / 2.0;
            }
            d7 = d13 = JCNumberUtil.min(d12, d3);
            d6 = d14 = JCNumberUtil.max(d11, d2);
        }
        if (this.parent.visible) {
            if (this.parent.min.isDefault) {
                this.parent.min.value = d7;
            }
            if (this.parent.max.isDefault) {
                this.parent.max.value = d6;
            }
        } else {
            if (this.parent.min.isDefault) {
                this.parent.min.value = d13;
            }
            if (this.parent.max.isDefault) {
                this.parent.max.value = d14;
            }
        }
        d8 = this.calcOrigin(this.parent.min.value, this.parent.max.value);
        if (this.parent.origin.isDefault) {
            this.parent.origin.value = d8;
        }
        if (this.parent.tickSpacing.isDefault) {
            this.parent.tickSpacing.value = d10;
        }
        if (this.parent.numSpacing.isDefault) {
            this.parent.numSpacing.value = d9;
        }
        if (this.parent.gridSpacing.isDefault) {
            this.parent.gridSpacing.value = this.parent.numSpacing.value;
        }
    }

    void calcPrecision() {
        if (this.parent.precision.isDefault) {
            if (this.parent.annotationMethod == 2 || this.parent.dataLimits == null) {
                this.parent.precision.value = 0;
            } else if (!this.parent.numSpacing.isDefault) {
                this.parent.precision.value = JCNumberUtil.tickBasedPrecision(this.parent.numSpacing.value);
            } else {
                double d2 = this.parent.min.isDefault ? this.parent.dataLimits.min : this.parent.min.value;
                double d3 = this.parent.max.isDefault ? this.parent.dataLimits.max : this.parent.max.value;
                this.parent.precision.value = d3 <= d2 ? JCNumberUtil.nicePrecision(d3) : JCNumberUtil.nicePrecision(d3 - d2);
            }
        }
        this.parent.precision.value = JCNumberUtil.clamp(this.parent.precision.value, -this.parent.getMaxPrecision(), this.parent.getMaxPrecision());
    }

    void calcTransformation() {
        int n2 = Math.max(this.parent.pixelLength(), 1);
        int n3 = this.parent.pixelStart();
        double d2 = this.parent.min.value;
        double d3 = this.parent.max.value;
        double d4 = JCNumberUtil.calcError(this.parent.precision.value);
        if (this.parent.reversed) {
            n2 = -n2;
        }
        if (Math.abs(d3 - d2) < Math.min(1.0E-8, d4)) {
            this.scale = 1.0;
            this.shift = 0.0;
            return;
        }
        this.scale = (double)n2 / (d3 - d2);
        this.shift = n2 < 0 ? (double)n3 - d3 * this.scale : (double)n3 - d2 * this.scale;
    }

    void drawTicks(Graphics graphics) {
        if (this.parent.annotationMethod != 0 && this.parent.tickSpacing.isDefault) {
            super.drawTicks(graphics);
            return;
        }
        double d2 = JCNumberUtil.calcError(this.parent.precision.value);
        if (this.parent.tickSpacing.value <= d2) {
            return;
        }
        int n2 = this.parent.linePosition();
        double d3 = JCNumberUtil.abs(this.parent.tickSpacing.value);
        d3 = d3 < d2 ? d2 * 2.0 : d3;
        double d4 = this.parent.firstInc(d3);
        while (d4 <= this.parent.max.value + d2) {
            int n3 = this.parent.toPixel(d4);
            this.drawTick(graphics, n2, n3);
            d4 += d3;
        }
    }

    boolean fixBounds() {
        return super.fixBounds();
    }

    String format(double d2, int n2) {
        return JCNumberUtil.format(d2, n2);
    }

    double range() {
        return this.parent.max.value - this.parent.min.value;
    }

    double toData(int n2) {
        if (this.parent.vertical) {
            return ((double)(this.parent.getHeight() - n2) - this.shift) / this.scale;
        }
        return ((double)n2 - this.shift) / this.scale;
    }

    int toPixel(double d2) {
        int n2 = (d2 = this.scale * d2 + this.shift + 0.5) >= 0.0 ? (int)d2 : (int)Math.floor(d2);
        return this.parent.vertical ? this.parent.getHeight() - n2 : n2;
    }

    void translate(double d2) {
        if (this.parent.reversed) {
            d2 = -d2;
        }
        this.parent.min.value += d2;
        this.parent.max.value += d2;
    }
}

