/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartNumberFormat;
import com.klg.jclass.chart.JCLabelGenerator;
import com.klg.jclass.util.JCNumberUtil;
import java.io.Serializable;

public class JCValueLabel
implements Serializable {
    protected double value = 0.0;
    protected ChartText label = new ChartText();

    public JCValueLabel() {
        this.value = 0.0;
    }

    public JCValueLabel(double d2, String string) {
        this.value = d2;
        this.label.updateParent = false;
        this.label.setText(string);
        this.label.updateParent = true;
    }

    public JCValueLabel(double d2, String string, JCAxis jCAxis) {
        this.value = d2;
        this.label = new ChartText(null, string, jCAxis);
    }

    JCValueLabel(JCAxis jCAxis, double d2, int n2) {
        JCChart jCChart;
        this.value = d2;
        JCChart jCChart2 = jCChart = jCAxis == null ? null : jCAxis.getParentChart();
        if (jCAxis != null && jCAxis.labelGenerator != null) {
            this.setGeneratedLabel(jCChart, d2, n2, jCAxis.labelGenerator, jCAxis);
        } else {
            String string = JCNumberUtil.format(d2, n2);
            String string2 = null;
            if (jCAxis != null) {
                JCChartNumberFormat jCChartNumberFormat = null;
                jCChartNumberFormat = jCAxis.getNumberFormatter();
                string2 = jCChartNumberFormat.localize(string);
                this.label = new ChartText(jCChart, string2, jCAxis);
            } else {
                this.label = new ChartText(jCChart, string, jCAxis);
            }
            this.label.updateParent = false;
            if (jCAxis != null) {
                this.label.setRotation(jCAxis.annotationRotation);
            }
            this.label.updateParent = true;
        }
        this.setParent(jCAxis);
    }

    JCValueLabel(JCAxis jCAxis, int n2, int n3) {
        JCChart jCChart;
        this.value = JCNumberUtil.pow10(n2);
        JCChart jCChart2 = jCChart = jCAxis == null ? null : jCAxis.getParentChart();
        if (jCAxis != null && jCAxis.labelGenerator != null) {
            this.setGeneratedLabel(jCChart, n2, n3, jCAxis.labelGenerator, jCAxis);
        } else {
            String string = JCNumberUtil.logFormat(n2);
            String string2 = null;
            if (jCAxis != null) {
                JCChartNumberFormat jCChartNumberFormat = null;
                jCChartNumberFormat = jCAxis.getNumberFormatter();
                string2 = jCChartNumberFormat.localize(string);
                this.label = new ChartText(jCChart, string2, jCAxis);
            } else {
                this.label = new ChartText(jCChart, string, jCAxis);
            }
            this.label.updateParent = false;
            if (jCAxis != null) {
                this.label.setRotation(jCAxis.annotationRotation);
            }
            this.label.updateParent = true;
        }
        this.setParent(jCAxis);
    }

    public ChartText getChartText() {
        return this.label;
    }

    public String getText() {
        return this.label.getText();
    }

    public double getValue() {
        return this.value;
    }

    private void setGeneratedLabel(JCChart jCChart, double d2, int n2, JCLabelGenerator jCLabelGenerator, JCAxis jCAxis) {
        if (jCLabelGenerator == null) {
            return;
        }
        Object object = jCLabelGenerator.makeLabel(d2, n2);
        if (object instanceof ChartText) {
            this.label = (ChartText)object;
            this.label.setParentChart(jCChart);
        } else {
            String string = object instanceof String ? (String)object : object.toString();
            this.label = new ChartText(jCChart, string, jCAxis);
            this.label.updateParent = false;
            if (jCAxis != null) {
                this.label.setRotation(jCAxis.annotationRotation);
            }
            this.label.updateParent = true;
        }
    }

    void setParent(JCAxis jCAxis) {
        if (this.label.parentChart == null) {
            this.label.setParentChart(jCAxis.getParentChart());
        }
        this.label.setParentAxis(jCAxis);
        if (this.label.getHeight() == 0) {
            this.label.setChanged(true, 2, false);
            this.label.recalc();
        }
    }

    public void setText(String string) {
        this.label.setText(string);
    }

    public void setValue(double d2) {
        if (this.value == d2) {
            return;
        }
        this.value = d2;
    }

    public String toString() {
        return this.label.getText();
    }
}

