/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Diamond;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCShape;
import com.klg.jclass.chart.JCStyle;
import com.klg.jclass.chart.Triangle;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Color;
import java.awt.Graphics;

public class JCSymbolStyle
extends JCStyle {
    protected int shape = 1;
    protected int colorIndex;
    protected int shapeIndex = 1;
    protected Color color = null;
    protected int size = 6;
    protected JCShape customShape = null;
    public static final int NONE = 0;
    public static final int DOT = 1;
    public static final int BOX = 2;
    public static final int TRIANGLE = 3;
    public static final int DIAMOND = 4;
    public static final int STAR = 5;
    public static final int VERT_LINE = 6;
    public static final int HORIZ_LINE = 7;
    public static final int CROSS = 8;
    public static final int CIRCLE = 9;
    public static final int SQUARE = 10;
    public static final int OTHER = 11;
    public static final int LAST = 10;

    public JCSymbolStyle(int n2, Color color, int n3) {
        this.setShape(n2);
        this.color = color;
        this.size = n3;
    }

    public void draw(Graphics graphics, int n2, int n3) {
        this.draw(graphics, n2, n3, this.size, null);
    }

    public void draw(Graphics graphics, int n2, int n3, int n4) {
        this.draw(graphics, n2, n3, n4, null);
    }

    public void draw(Graphics graphics, int n2, int n3, int n4, Color color) {
        Color color2 = color != null ? color : this.color;
        graphics.setColor(color2);
        if (this.customShape != null) {
            this.customShape.resize(n4);
            this.customShape.draw(graphics, n2, n3);
            return;
        }
        boolean bl = n4 % 2 == 0;
        int n5 = n4 / 2;
        if (bl) {
            n5 = (n4 - 1) / 2;
        }
        int n6 = (int)((double)n4 / 2.8284271247461903);
        switch (this.shape) {
            case 1: {
                graphics.fillOval(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                break;
            }
            case 2: {
                graphics.fillRect(n2 - n4 / 2, n3 - n4 / 2, n4, n4);
                break;
            }
            case 5: {
                graphics.drawLine(n2 - n4 / 2, n3, n2 + n5, n3);
                graphics.drawLine(n2, n3 - n4 / 2, n2, n3 + n5);
                graphics.drawLine(n2 - n6, n3 - n6, n2 + n6, n3 + n6);
                graphics.drawLine(n2 - n6, n3 + n6, n2 + n6, n3 - n6);
                break;
            }
            case 6: {
                graphics.drawLine(n2, n3 - n4 / 2, n2, n3 + n5);
                break;
            }
            case 7: {
                graphics.drawLine(n2 - n4 / 2, n3, n2 + n5, n3);
                break;
            }
            case 8: {
                graphics.drawLine(n2, n3 - n4 / 2, n2, n3 + n5);
                graphics.drawLine(n2 - n4 / 2, n3, n2 + n5, n3);
                break;
            }
            case 9: {
                graphics.drawArc(n2 - n4 / 2, n3 - n4 / 2, n4 - 1, n4 - 1, 0, 360);
                break;
            }
            case 10: {
                graphics.drawRect(n2 - n4 / 2, n3 - n4 / 2, n4 - 1, n4 - 1);
                break;
            }
        }
    }

    public void draw(Graphics graphics, int n2, int n3, Color color) {
        this.draw(graphics, n2, n3, this.size, color);
    }

    public Color getColor() {
        return this.color;
    }

    public int getColorIndex() {
        return this.colorIndex;
    }

    public JCShape getCustomShape() {
        return this.customShape;
    }

    static Color getDefaultColor(JCChart jCChart) {
        Color color;
        if (jCChart == null) {
            color = JCStyle.defaultColors[0];
        } else {
            int n2 = jCChart.getSymbolColorIndex();
            color = JCStyle.defaultColors[n2++];
            if (n2 >= JCStyle.defaultColors.length) {
                n2 = 0;
            }
            if (jCChart != null && jCChart.getChartArea() != null && JCNumberUtil.colorsNear(color, jCChart.getChartArea().getPlotArea().getBackground())) {
                color = JCStyle.defaultColors[n2++];
                if (n2 >= JCStyle.defaultColors.length) {
                    n2 = 0;
                }
            }
            jCChart.setSymbolColorIndex(n2);
        }
        return color;
    }

    static int getDefaultShape(JCChart jCChart) {
        int n2;
        if (jCChart == null) {
            n2 = 1;
        } else {
            int n3 = jCChart.getSymbolShapeIndex();
            n2 = n3++;
            if (n3 > 10) {
                n3 = 1;
            }
            jCChart.setSymbolShapeIndex(n3);
        }
        return n2;
    }

    public int getShape() {
        return this.shape;
    }

    public int getSize() {
        return this.size;
    }

    public static JCSymbolStyle makeDefault(JCChart jCChart) {
        JCSymbolStyle jCSymbolStyle = new JCSymbolStyle(JCSymbolStyle.getDefaultShape(jCChart), JCSymbolStyle.getDefaultColor(jCChart), 6);
        int n2 = 1;
        int n3 = 0;
        if (jCChart != null) {
            n3 = jCChart.getSymbolColorIndex();
            n3 = n3 == 0 ? JCStyle.defaultColors.length - 1 : --n3;
            n2 = jCChart.getSymbolShapeIndex();
            n2 = n2 == 1 ? 10 : --n2;
        }
        jCSymbolStyle.colorIndex = n3;
        jCSymbolStyle.shapeIndex = n2;
        return jCSymbolStyle;
    }

    public void setColor(Color color) {
        if (this.color == color) {
            return;
        }
        this.color = color;
        this.setChanged(true, 17);
    }

    public void setCustomShape(JCShape jCShape) {
        if (this.customShape == jCShape) {
            return;
        }
        this.shape = jCShape == null ? 0 : 11;
        this.customShape = jCShape;
        this.setChanged(true, 17);
    }

    public void setShape(int n2) {
        if (this.shape == n2) {
            return;
        }
        this.shapeIndex = n2;
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.shape = n2;
                this.customShape = null;
                break;
            }
            case 3: {
                this.shape = n2;
                this.customShape = new Triangle();
                break;
            }
            case 4: {
                this.shape = n2;
                this.customShape = new Diamond();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for Shape in JCSymbolStyle.");
            }
        }
        this.setChanged(true, 17);
    }

    public void setSize(int n2) {
        if (this.size == n2) {
            return;
        }
        this.size = n2;
        this.setChanged(true, 18);
    }
}

