/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartLabel;
import com.klg.jclass.chart.JCChartLabelManager;
import com.klg.jclass.chart.JCDataIndex;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.ToolTipManager;

public class JCDefaultChartLabelManager
implements JCChartLabelManager,
Serializable {
    public static final String ERRMSG_INVALID_LABEL_INDEX = "Invalid ChartLabel index";
    protected Vector labels = new Vector();
    protected Vector dwellLabels = null;
    protected JCChartLabel currentDwellLabel = null;
    protected Hashtable autoLabelListHashtable = new Hashtable();
    protected JCChart parentChart = null;

    public void addAutoLabels(ChartDataView chartDataView, int n2, int n3) {
        JCChartLabel[][] jCChartLabelArray = (JCChartLabel[][])this.autoLabelListHashtable.get(chartDataView);
        if (jCChartLabelArray == null) {
            return;
        }
        List list = chartDataView.getSeries();
        int n4 = list.size();
        if (n2 != -1 && n3 == -1) {
            int n5 = n2;
            JCChartLabel[][] jCChartLabelArray2 = jCChartLabelArray;
            jCChartLabelArray = new JCChartLabel[n4][];
            System.arraycopy(jCChartLabelArray2, 0, jCChartLabelArray, 0, n5);
            if (jCChartLabelArray2.length > n5) {
                System.arraycopy(jCChartLabelArray2, n5 + 1, jCChartLabelArray, n5 + 1, n4 - n5 - 1);
            }
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list.get(n5);
            int n6 = chartDataViewSeries.maxIndex() + 1;
            jCChartLabelArray[n5] = new JCChartLabel[n6];
            int n7 = 0;
            while (n7 < n6) {
                jCChartLabelArray[n5][n7] = this.createAutoLabel(this.createAutoLabelText(chartDataView, n5, n7), chartDataViewSeries, n7);
                this.appendChartLabel(jCChartLabelArray[n5][n7]);
                ++n7;
            }
            this.autoLabelListHashtable.put(chartDataView, jCChartLabelArray);
        } else if (n3 != -1) {
            int n8 = n3;
            int n9 = 0;
            if (n2 != -1) {
                n4 = n2 + 1;
                n9 = n2;
            }
            int n10 = n9;
            while (n10 < n4) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list.get(n10);
                int n11 = jCChartLabelArray[n10].length + 1;
                JCChartLabel[] jCChartLabelArray3 = jCChartLabelArray[n10];
                jCChartLabelArray[n10] = new JCChartLabel[n11];
                if (n8 != 0) {
                    System.arraycopy(jCChartLabelArray3, 0, jCChartLabelArray[n10], 0, n8);
                }
                if (n8 != n11 - 1) {
                    System.arraycopy(jCChartLabelArray3, n8, jCChartLabelArray[n10], n8 + 1, n11 - n8 - 1);
                }
                jCChartLabelArray[n10][n8] = this.createAutoLabel(this.createAutoLabelText(chartDataView, n10, n8), chartDataViewSeries, n8);
                this.appendChartLabel(jCChartLabelArray[n10][n8]);
                ++n10;
            }
            this.autoLabelListHashtable.put(chartDataView, jCChartLabelArray);
        }
    }

    public void addChartLabel(JCChartLabel jCChartLabel) {
        if (jCChartLabel == null) {
            return;
        }
        this.appendChartLabel(jCChartLabel);
        jCChartLabel.setChanged(true, 2);
    }

    public void addToDwellLabels(JCChartLabel jCChartLabel) {
        if (this.dwellLabels != null && this.dwellLabels.contains(jCChartLabel)) {
            return;
        }
        if (jCChartLabel.isDwellLabel()) {
            if (this.dwellLabels == null) {
                this.dwellLabels = new Vector();
                JCChart jCChart = this.getParentChart();
                if (jCChart != null) {
                    ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                    toolTipManager.registerComponent(jCChart);
                }
            }
            this.dwellLabels.addElement(jCChartLabel);
        }
    }

    protected void appendChartLabel(JCChartLabel jCChartLabel) {
        Changeable changeable;
        Enumeration enumeration = this.labels.elements();
        while (enumeration.hasMoreElements()) {
            changeable = (JCChartLabel)enumeration.nextElement();
            if (changeable == null || changeable != jCChartLabel) continue;
            return;
        }
        this.labels.addElement(jCChartLabel);
        changeable = this.getParentChart();
        if (!jCChartLabel.isDwellLabel() && changeable != null) {
            if (jCChartLabel.isConnected() && jCChartLabel.line != null) {
                ((Container)((Object)changeable)).add((Component)jCChartLabel.line, 0);
            }
            ((Container)((Object)changeable)).add((Component)jCChartLabel.component, 0);
        } else {
            this.addToDwellLabels(jCChartLabel);
        }
        jCChartLabel.setParentManager(this);
        JCDataIndex jCDataIndex = jCChartLabel.getDataIndex();
        if (jCDataIndex != null && jCDataIndex.getDataView() == null) {
            jCDataIndex.setDataView(((JCChart)changeable).getDataView(0));
        }
    }

    public void clearAutoLabels(ChartDataView chartDataView) {
        this.autoLabelListHashtable.remove(chartDataView);
    }

    protected JCChartLabel createAutoLabel(String string, ChartDataViewSeries chartDataViewSeries, int n2) {
        JCChartLabel jCChartLabel = new JCChartLabel(string);
        jCChartLabel.setDataIndex(new JCDataIndex(n2, chartDataViewSeries));
        jCChartLabel.setAttachMethod(3);
        jCChartLabel.setAnchor(10);
        jCChartLabel.component.setBorder(BorderFactory.createRaisedBevelBorder());
        jCChartLabel.setDataView(chartDataViewSeries.getParent());
        jCChartLabel.setOffset(new Point(0, -1));
        jCChartLabel.setDwellLabel(true);
        return jCChartLabel;
    }

    public String createAutoLabelText(ChartDataView chartDataView, int n2, int n3) {
        Object object;
        ChartDataViewSeries chartDataViewSeries = chartDataView.getSeries(n2);
        StringBuffer stringBuffer = new StringBuffer();
        double d2 = chartDataViewSeries.getX(n3);
        double d3 = chartDataViewSeries.getY(n3);
        String string = String.valueOf(d3);
        if (chartDataView.getYAxis().getLabelGenerator() != null) {
            object = chartDataView.getYAxis().getLabelGenerator().makeLabel(d3, chartDataView.getYAxis().getPrecision());
            string = object instanceof String ? (String)object : object.toString();
        }
        switch (chartDataView.getChartType()) {
            case 0: 
            case 1: {
                object = String.valueOf(d2);
                if (chartDataView.getXAxis().getLabelGenerator() != null) {
                    object = (String)chartDataView.getXAxis().getLabelGenerator().makeLabel(d2, chartDataView.getXAxis().getPrecision());
                }
                stringBuffer.append(" (");
                stringBuffer.append((String)object);
                stringBuffer.append(",");
                stringBuffer.append(string);
                stringBuffer.append(") ");
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                stringBuffer.append(" ");
                stringBuffer.append(string);
                stringBuffer.append(" ");
                break;
            }
            default: {
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    protected void deleteChartLabel(JCChartLabel jCChartLabel) {
        if (jCChartLabel == null) {
            return;
        }
        JCChart jCChart = this.getParentChart();
        if (!jCChartLabel.isDwellLabel() && jCChart != null) {
            if (jCChartLabel.isConnected() && jCChartLabel.line != null) {
                jCChart.remove(jCChartLabel.line);
            }
            jCChart.remove(jCChartLabel.component);
        } else {
            this.removeFromDwellLabels(jCChartLabel);
        }
        this.labels.removeElement(jCChartLabel);
    }

    public void generateAutoLabels(ChartDataView chartDataView) {
        JCChartLabel[][] jCChartLabelArray = (JCChartLabel[][])this.autoLabelListHashtable.get(chartDataView);
        List list = chartDataView.getSeries();
        int n2 = list.size();
        JCChartLabel[][] jCChartLabelArray2 = new JCChartLabel[n2][];
        int n3 = 0;
        while (n3 < n2) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list.get(n3);
            int n4 = chartDataViewSeries.maxIndex() + 1;
            if (chartDataViewSeries.getX() == null || chartDataViewSeries.getY() == null) {
                n4 = 0;
            }
            jCChartLabelArray2[n3] = new JCChartLabel[n4];
            int n5 = 0;
            while (n5 < n4) {
                if (jCChartLabelArray != null && n3 < jCChartLabelArray.length && jCChartLabelArray[n3] != null && n5 < jCChartLabelArray[n3].length) {
                    this.deleteChartLabel(jCChartLabelArray[n3][n5]);
                }
                jCChartLabelArray2[n3][n5] = this.createAutoLabel(this.createAutoLabelText(chartDataView, n3, n5), chartDataViewSeries, n5);
                this.appendChartLabel(jCChartLabelArray2[n3][n5]);
                ++n5;
            }
            ++n3;
        }
        this.autoLabelListHashtable.put(chartDataView, jCChartLabelArray2);
    }

    public JCChartLabel[][] getAutoLabelList(ChartDataView chartDataView) {
        if (chartDataView == null) {
            return null;
        }
        return (JCChartLabel[][])this.autoLabelListHashtable.get(chartDataView);
    }

    public List getChartLabels() {
        if (this.labels == null || this.labels.size() == 0) {
            return null;
        }
        return new Vector(this.labels);
    }

    public JCChartLabel getChartLabels(int n2) {
        if (n2 < 0 || n2 >= this.labels.size()) {
            throw new IllegalArgumentException(ERRMSG_INVALID_LABEL_INDEX);
        }
        return (JCChartLabel)this.labels.elementAt(n2);
    }

    public JCChartLabel getCurrentDwellLabel() {
        if (this.currentDwellLabel != null) {
            return this.currentDwellLabel;
        }
        return null;
    }

    public Point getCurrentDwellLabelAttachPoint() {
        if (this.currentDwellLabel != null) {
            return this.currentDwellLabel.getAttachPoint();
        }
        return null;
    }

    public JComponent getCurrentDwellLabelComponent() {
        if (this.currentDwellLabel != null) {
            return this.currentDwellLabel.getComponent();
        }
        return null;
    }

    public int getNumChartLabels() {
        int n2 = 0;
        try {
            if (this.labels != null) {
                n2 = this.labels.size();
            }
        }
        catch (Exception exception) {}
        return n2;
    }

    public JCChart getParentChart() {
        return this.parentChart;
    }

    public boolean locateCurrentDwellLabel(int n2, int n3) {
        JCChart jCChart = this.getParentChart();
        if (jCChart != null && this.dwellLabels != null && this.dwellLabels.size() != 0) {
            List list = jCChart.getDataView();
            if (list == null || list.size() <= 0) {
                this.currentDwellLabel = null;
                return false;
            }
            JCDataIndex[] jCDataIndexArray = new JCDataIndex[list.size()];
            Iterator iterator = list.iterator();
            int n4 = 0;
            while (iterator.hasNext()) {
                jCDataIndexArray[n4] = jCChart.pick(new Point(n2, n3), (ChartDataView)iterator.next());
                ++n4;
            }
            JCChartLabel jCChartLabel = null;
            int n5 = Integer.MAX_VALUE;
            Enumeration enumeration = this.dwellLabels.elements();
            while (enumeration.hasMoreElements()) {
                JCChartLabel jCChartLabel2 = (JCChartLabel)enumeration.nextElement();
                if (jCChartLabel2 == null) continue;
                JCDataIndex jCDataIndex = null;
                int n6 = list.indexOf(jCChartLabel2.getDataView());
                if (n6 >= 0) {
                    jCDataIndex = jCDataIndexArray[n6];
                }
                if (jCDataIndex == null || !jCChartLabel2.shouldPopupHere(jCDataIndex) || jCDataIndex.getDistance() > n5) continue;
                jCChartLabel = jCChartLabel2;
                n5 = jCDataIndex.getDistance();
            }
            if (jCChartLabel != null) {
                this.currentDwellLabel = jCChartLabel;
                return true;
            }
            this.currentDwellLabel = null;
            return false;
        }
        this.currentDwellLabel = null;
        return false;
    }

    public void markAllChartLabelsForRecalc() {
        Enumeration enumeration = this.labels.elements();
        while (enumeration.hasMoreElements()) {
            JCChartLabel jCChartLabel = (JCChartLabel)enumeration.nextElement();
            if (jCChartLabel == null) continue;
            jCChartLabel.setChanged(true, 2, false);
        }
    }

    public void paintConnectors(Graphics graphics) {
        Enumeration enumeration = this.labels.elements();
        while (enumeration.hasMoreElements()) {
            JCChartLabel jCChartLabel = (JCChartLabel)enumeration.nextElement();
            if (jCChartLabel == null || jCChartLabel.component == null || !jCChartLabel.component.isShowing() || !jCChartLabel.isConnected() || !jCChartLabel.isDwellLabel()) continue;
            jCChartLabel.drawConnector(graphics);
        }
    }

    public void recalcChangedChartLabels() {
        Enumeration enumeration = this.labels.elements();
        while (enumeration.hasMoreElements()) {
            JCChartLabel jCChartLabel = (JCChartLabel)enumeration.nextElement();
            if (jCChartLabel == null || !jCChartLabel.getChanged(2)) continue;
            jCChartLabel.recalc();
        }
    }

    public void removeAllChartLabels() {
        Object object;
        JCChart jCChart = this.getParentChart();
        if (jCChart != null) {
            object = this.labels.elements();
            while (object.hasMoreElements()) {
                jCChart.remove(((JCChartLabel)object.nextElement()).component);
            }
        }
        this.labels.removeAllElements();
        if (this.dwellLabels != null) {
            this.dwellLabels.removeAllElements();
            this.dwellLabels = null;
        }
        if (jCChart != null) {
            object = jCChart.getDataView();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ChartDataView chartDataView = (ChartDataView)iterator.next();
                this.autoLabelListHashtable.remove(chartDataView);
                chartDataView.setAutoLabel(false);
            }
            jCChart.setChanged(true, 1);
        }
    }

    public void removeAutoLabels(ChartDataView chartDataView) {
        JCChartLabel[][] jCChartLabelArray = (JCChartLabel[][])this.autoLabelListHashtable.get(chartDataView);
        if (jCChartLabelArray == null) {
            return;
        }
        JCChartLabel[][] jCChartLabelArray2 = jCChartLabelArray;
        this.autoLabelListHashtable.remove(chartDataView);
        int n2 = 0;
        while (n2 < jCChartLabelArray2.length) {
            if (jCChartLabelArray2[n2] != null) {
                int n3 = 0;
                while (n3 < jCChartLabelArray2[n2].length) {
                    this.deleteChartLabel(jCChartLabelArray2[n2][n3]);
                    ++n3;
                }
            }
            ++n2;
        }
    }

    public void removeAutoLabels(ChartDataView chartDataView, int n2, int n3) {
        JCChartLabel[][] jCChartLabelArray = (JCChartLabel[][])this.autoLabelListHashtable.get(chartDataView);
        if (jCChartLabelArray == null) {
            return;
        }
        List list = chartDataView.getSeries();
        int n4 = list.size();
        if (n2 != -1 && n3 == -1) {
            int n5 = n2;
            int n6 = jCChartLabelArray[n5].length;
            int n7 = 0;
            while (n7 < n6) {
                this.deleteChartLabel(jCChartLabelArray[n5][n7]);
                ++n7;
            }
            JCChartLabel[][] jCChartLabelArray2 = jCChartLabelArray;
            jCChartLabelArray = new JCChartLabel[n4][];
            System.arraycopy(jCChartLabelArray2, 0, jCChartLabelArray, 0, n5);
            if (jCChartLabelArray2.length > n5) {
                System.arraycopy(jCChartLabelArray2, n5 + 1, jCChartLabelArray, n5, n4 - n5);
            }
            this.autoLabelListHashtable.put(chartDataView, jCChartLabelArray);
        } else if (n3 != -1) {
            int n8 = n3;
            int n9 = 0;
            if (n2 != -1) {
                n4 = n2 + 1;
                n9 = n2;
            }
            int n10 = n9;
            while (n10 < n4) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list.get(n10);
                int n11 = jCChartLabelArray[n10].length;
                this.deleteChartLabel(jCChartLabelArray[n10][n8]);
                JCChartLabel[] jCChartLabelArray3 = jCChartLabelArray[n10];
                jCChartLabelArray[n10] = new JCChartLabel[n11 - 1];
                System.arraycopy(jCChartLabelArray3, 0, jCChartLabelArray[n10], 0, n8);
                System.arraycopy(jCChartLabelArray3, n8 + 1, jCChartLabelArray[n10], n8, n11 - n8 - 1);
                ++n10;
            }
            this.autoLabelListHashtable.put(chartDataView, jCChartLabelArray);
        }
    }

    public void removeChartLabel(JCChartLabel jCChartLabel) {
        if (jCChartLabel == null) {
            return;
        }
        this.deleteChartLabel(jCChartLabel);
        JCChart jCChart = this.getParentChart();
        if (jCChart != null) {
            jCChart.setChanged(true, 2);
        }
    }

    public void removeFromDwellLabels(JCChartLabel jCChartLabel) {
        if (this.dwellLabels == null || !this.dwellLabels.contains(jCChartLabel)) {
            return;
        }
        this.dwellLabels.removeElement(jCChartLabel);
        if (this.dwellLabels.size() == 0) {
            JCChart jCChart = this.getParentChart();
            if (jCChart != null) {
                ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                toolTipManager.unregisterComponent(jCChart);
            }
            this.dwellLabels = null;
        }
    }

    public void setAutoLabelText(ChartDataView chartDataView, int n2, int n3) {
        JCChartLabel[][] jCChartLabelArray = (JCChartLabel[][])this.autoLabelListHashtable.get(chartDataView);
        if (jCChartLabelArray[n2][n3] != null) {
            jCChartLabelArray[n2][n3].setText(this.createAutoLabelText(chartDataView, n2, n3));
        }
    }

    public void setChartLabels(int n2, JCChartLabel jCChartLabel) {
        if (n2 < 0 || n2 > this.labels.size()) {
            throw new IllegalArgumentException(ERRMSG_INVALID_LABEL_INDEX);
        }
        JCChart jCChart = this.getParentChart();
        if (n2 < this.labels.size()) {
            if (jCChartLabel == null) {
                this.removeChartLabel((JCChartLabel)this.labels.elementAt(n2));
            } else {
                if (!this.labels.contains(jCChartLabel)) {
                    this.removeFromDwellLabels((JCChartLabel)this.labels.elementAt(n2));
                    if (jCChart != null) {
                        jCChart.remove(((JCChartLabel)this.labels.elementAt((int)n2)).component);
                    }
                    this.labels.setElementAt(jCChartLabel, n2);
                    if (!jCChartLabel.isDwellLabel() && jCChart != null) {
                        jCChart.add((Component)jCChartLabel.component, 0);
                    } else {
                        this.addToDwellLabels(jCChartLabel);
                    }
                }
                jCChartLabel.setParentManager(this);
            }
        } else {
            this.addChartLabel(jCChartLabel);
        }
        if (jCChart != null) {
            jCChart.setChanged(true, 2);
        }
    }

    public void setChartLabels(List list) {
        JCChart jCChart = this.getParentChart();
        if (this.labels != null && jCChart != null) {
            Enumeration enumeration = this.labels.elements();
            while (enumeration.hasMoreElements()) {
                jCChart.remove(((JCChartLabel)enumeration.nextElement()).component);
            }
        }
        this.labels = new Vector();
        boolean bl = false;
        if (jCChart != null) {
            bl = jCChart.isBatched();
            jCChart.setBatched(false);
        }
        if (list != null && list.size() > 0) {
            Object object;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (JCChartLabel)iterator.next();
                this.labels.addElement(object);
                if (!((JCChartLabel)object).isDwellLabel() && jCChart != null) {
                    jCChart.add((Component)((JCChartLabel)object).component, 0);
                    continue;
                }
                this.addToDwellLabels((JCChartLabel)object);
            }
            object = list.iterator();
            while (object.hasNext()) {
                ((JCChartLabel)object.next()).setParentManager(this);
            }
        }
        if (jCChart != null) {
            jCChart.setChanged(true, 2);
            jCChart.setBatched(bl);
        }
    }

    public void setParentChart(JCChart jCChart) {
        this.parentChart = jCChart;
    }

    public void updateParent(int n2) {
        JCChart jCChart = this.getParentChart();
        if (jCChart != null) {
            if ((n2 & 2) > 0 || (n2 & 8) > 0) {
                jCChart.invalidate();
                if (!jCChart.isBatched()) {
                    jCChart.validate();
                    jCChart.repaint();
                }
            } else if ((n2 & 1) > 0 && !jCChart.isBatched()) {
                jCChart.repaint();
            }
        }
    }
}

