/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCShape;
import com.klg.jclass.chart.JCSymbolStyle;
import java.awt.Color;
import java.awt.Image;
import java.io.Serializable;
import java.util.Vector;

public class JCChartStyle
implements Serializable {
    protected JCLineStyle lineStyle = null;
    protected JCFillStyle fillStyle = null;
    protected JCSymbolStyle symbolStyle = null;
    protected Vector parents = new Vector();

    public JCChartStyle() {
        this.lineStyle = JCLineStyle.makeDefault(null);
        this.fillStyle = JCFillStyle.makeDefault(null);
        this.symbolStyle = JCSymbolStyle.makeDefault(null);
        this.fillStyle.parent = this.symbolStyle.parent = this;
        this.lineStyle.parent = this.symbolStyle.parent;
    }

    public JCChartStyle(JCLineStyle jCLineStyle, JCFillStyle jCFillStyle, JCSymbolStyle jCSymbolStyle) {
        this.lineStyle = jCLineStyle;
        this.fillStyle = jCFillStyle;
        this.symbolStyle = jCSymbolStyle;
        this.fillStyle.parent = this.symbolStyle.parent = this;
        this.lineStyle.parent = this.symbolStyle.parent;
    }

    public void addParent(Changeable changeable) {
        int n2 = 0;
        while (n2 < this.parents.size()) {
            if (this.parents.elementAt(n2) == changeable) {
                return;
            }
            ++n2;
        }
        this.parents.addElement(changeable);
    }

    void callParentSetChanged(boolean bl, int n2) {
        if (this.parents == null) {
            return;
        }
        int n3 = 0;
        while (n3 < this.parents.size()) {
            ((Changeable)this.parents.elementAt(n3)).setChanged(true, n2);
            ++n3;
        }
    }

    public void clearParents() {
        this.parents = new Vector();
    }

    public Color getFillBackground() {
        if (this.fillStyle == null) {
            return null;
        }
        return this.fillStyle.getBackground();
    }

    public Color getFillColor() {
        if (this.fillStyle == null) {
            return null;
        }
        return this.fillStyle.getColor();
    }

    public Image getFillImage() {
        if (this.fillStyle == null) {
            return null;
        }
        return this.fillStyle.getImage();
    }

    public int getFillPattern() {
        if (this.fillStyle == null) {
            return 0;
        }
        return this.fillStyle.getPattern();
    }

    public JCFillStyle getFillStyle() {
        return this.fillStyle;
    }

    public int getLineCap() {
        if (this.lineStyle == null) {
            return -1;
        }
        return this.lineStyle.getCap();
    }

    public Color getLineColor() {
        if (this.lineStyle == null) {
            return null;
        }
        return this.lineStyle.getColor();
    }

    public int getLineJoin() {
        if (this.lineStyle == null) {
            return -1;
        }
        return this.lineStyle.getJoin();
    }

    public int getLinePattern() {
        if (this.lineStyle == null) {
            return 0;
        }
        return this.lineStyle.getPattern();
    }

    public JCLineStyle getLineStyle() {
        return this.lineStyle;
    }

    public int getLineWidth() {
        if (this.lineStyle == null) {
            return 0;
        }
        return this.lineStyle.getWidth();
    }

    public Color getSymbolColor() {
        if (this.symbolStyle == null) {
            return null;
        }
        return this.symbolStyle.getColor();
    }

    public JCShape getSymbolCustomShape() {
        if (this.symbolStyle == null) {
            return null;
        }
        return this.symbolStyle.getCustomShape();
    }

    public int getSymbolShape() {
        if (this.symbolStyle == null) {
            return 0;
        }
        return this.symbolStyle.getShape();
    }

    public int getSymbolSize() {
        if (this.symbolStyle == null) {
            return 0;
        }
        return this.symbolStyle.getSize();
    }

    public JCSymbolStyle getSymbolStyle() {
        return this.symbolStyle;
    }

    public static JCChartStyle makeDefault(JCChart jCChart) {
        return JCChartStyle.makeDefault(jCChart, null, false);
    }

    public static JCChartStyle makeDefault(JCChart jCChart, Changeable changeable) {
        return JCChartStyle.makeDefault(jCChart, changeable, false);
    }

    public static JCChartStyle makeDefault(JCChart jCChart, Changeable changeable, boolean bl) {
        JCChartStyle jCChartStyle = new JCChartStyle(JCLineStyle.makeDefault(jCChart), JCFillStyle.makeDefault(jCChart, bl), JCSymbolStyle.makeDefault(jCChart));
        if (changeable != null) {
            jCChartStyle.parents.addElement(changeable);
        } else if (jCChart != null) {
            jCChartStyle.parents.addElement(jCChart.getChartArea());
        }
        return jCChartStyle;
    }

    public void removeParent(Changeable changeable) {
        int n2 = 0;
        while (n2 < this.parents.size()) {
            if (this.parents.elementAt(n2) == changeable) {
                this.parents.removeElementAt(n2);
            }
            ++n2;
        }
    }

    public void setFillBackground(Color color) {
        if (this.fillStyle == null) {
            this.fillStyle = JCFillStyle.makeDefault(null);
        }
        this.fillStyle.setBackground(color);
    }

    public void setFillColor(Color color) {
        if (this.fillStyle == null) {
            this.fillStyle = JCFillStyle.makeDefault(null);
        }
        this.fillStyle.setColor(color);
    }

    public void setFillImage(Image image) {
        if (this.fillStyle == null) {
            this.fillStyle = JCFillStyle.makeDefault(null);
        }
        this.fillStyle.setImage(image);
    }

    public void setFillPattern(int n2) {
        if (this.fillStyle == null) {
            this.fillStyle = JCFillStyle.makeDefault(null);
        }
        this.fillStyle.setPattern(n2);
    }

    public void setFillStyle(JCFillStyle jCFillStyle) {
        if (this.fillStyle == jCFillStyle) {
            return;
        }
        this.fillStyle = jCFillStyle;
        this.fillStyle.parent = this;
        this.callParentSetChanged(true, 33);
    }

    public void setLineCap(int n2) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setCap(n2);
    }

    public void setLineColor(Color color) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setColor(color);
    }

    public void setLineJoin(int n2) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setJoin(n2);
    }

    public void setLinePattern(int n2) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setPattern(n2);
    }

    public void setLineStyle(JCLineStyle jCLineStyle) {
        if (this.lineStyle == jCLineStyle) {
            return;
        }
        this.lineStyle = jCLineStyle;
        this.lineStyle.parent = this;
        this.callParentSetChanged(true, 17);
    }

    public void setLineWidth(int n2) {
        if (this.lineStyle == null) {
            this.lineStyle = JCLineStyle.makeDefault(null);
        }
        this.lineStyle.setWidth(n2);
    }

    public void setSymbolColor(Color color) {
        if (this.symbolStyle == null) {
            this.symbolStyle = JCSymbolStyle.makeDefault(null);
        }
        this.symbolStyle.setColor(color);
    }

    public void setSymbolCustomShape(JCShape jCShape) {
        if (this.symbolStyle == null) {
            this.symbolStyle = JCSymbolStyle.makeDefault(null);
        }
        this.symbolStyle.setCustomShape(jCShape);
    }

    public void setSymbolShape(int n2) {
        if (this.symbolStyle == null) {
            this.symbolStyle = JCSymbolStyle.makeDefault(null);
        }
        this.symbolStyle.setShape(n2);
    }

    public void setSymbolSize(int n2) {
        if (this.symbolStyle == null) {
            this.symbolStyle = JCSymbolStyle.makeDefault(null);
        }
        this.symbolStyle.setSize(n2);
    }

    public void setSymbolStyle(JCSymbolStyle jCSymbolStyle) {
        if (this.symbolStyle == jCSymbolStyle) {
            return;
        }
        this.symbolStyle = jCSymbolStyle;
        this.symbolStyle.parent = this;
        this.callParentSetChanged(true, 17);
    }
}

