/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.CachedSeriesProps;
import com.klg.jclass.chart.CachedViewProps;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.JCCandleChartFormat;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCHLOCChartFormat;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCPieChartFormat;
import com.klg.jclass.chart.PieChartInfo;
import com.klg.jclass.chart.PieData;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.JCLegendItem;
import com.klg.jclass.util.legend.JCLegendPopulator;
import com.klg.jclass.util.legend.JCLegendRenderer;
import com.klg.jclass.util.swing.TextRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.List;
import java.util.Vector;

public class JCChartLegendManager
implements JCLegendPopulator,
JCLegendRenderer,
Serializable {
    protected List legendItems = null;
    protected transient CachedViewProps[] cachedView = null;
    protected JCChart chart;

    public JCChartLegendManager(JCChart jCChart) {
        this.chart = jCChart;
    }

    void cacheViewProperties(CachedViewProps cachedViewProps, ChartDataView chartDataView, List list) {
        cachedViewProps.view = chartDataView;
        cachedViewProps.visible = chartDataView.isVisible();
        cachedViewProps.visibleInLegend = chartDataView.isVisibleInLegend();
        cachedViewProps.chartType = chartDataView.getChartType();
        cachedViewProps.seriesPerData = chartDataView.getNumSeriesPerData();
        cachedViewProps.inverted = chartDataView.getXAxis().vertical;
        cachedViewProps.outlineColor = chartDataView.getOutlineColor();
        if (list == null) {
            cachedViewProps.seriesList = null;
            cachedViewProps.seriesProps = null;
            return;
        }
        cachedViewProps.seriesList = list;
        cachedViewProps.seriesProps = new CachedSeriesProps[list.size()];
        int n2 = 0;
        while (n2 < list.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list.get(n2);
            cachedViewProps.seriesProps[n2] = new CachedSeriesProps();
            cachedViewProps.seriesProps[n2].series = chartDataViewSeries;
            cachedViewProps.seriesProps[n2].visible = chartDataViewSeries.isVisible();
            cachedViewProps.seriesProps[n2].visibleInLegend = chartDataViewSeries.isVisibleInLegend();
            ++n2;
        }
    }

    protected void calcSymbolSize(JCLegendItem jCLegendItem, JCChartStyle jCChartStyle, int n2) {
        Image image = null;
        JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
        if (!((n2 != 9 && n2 != 10 || jCFillStyle.getPattern() != 12 && jCFillStyle.getPattern() != 11) && (n2 != 8 && n2 != 12 && n2 != 11 || jCFillStyle.getPattern() != 11) || (image = jCFillStyle.getImage()) == null)) {
            if (jCFillStyle.getPattern() == 12) {
                jCLegendItem.drawType = 2;
            } else if (jCFillStyle.getPattern() == 11) {
                jCLegendItem.drawType = 3;
            }
            jCLegendItem.symbolDim = new Dimension(image.getWidth(null), image.getHeight(null));
        } else {
            jCLegendItem.drawType = n2 == 8 || n2 == 9 || n2 == 12 || n2 == 10 || n2 == 11 ? 1 : 4;
            JCLegend jCLegend = this.chart.getLegend();
            jCLegendItem.symbolDim = new Dimension(jCLegend.getSymbolSize(), jCLegend.getSymbolSize());
        }
        jCLegendItem.symbol = image;
    }

    public void drawLegendItem(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void drawLegendItemSymbol(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
        CachedViewProps cachedViewProps = null;
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = false;
        boolean bl5 = false;
        Color color = null;
        ChartDataView chartDataView = ((JCDataIndex)jCLegendItem.itemInfo).getDataView();
        if (chartDataView != null) {
            int n3 = 0;
            while (n3 < this.cachedView.length) {
                if (this.cachedView[n3].view == chartDataView) {
                    cachedViewProps = this.cachedView[n3];
                    bl = cachedViewProps.inverted;
                    n2 = cachedViewProps.chartType;
                    bl2 = true;
                    bl3 = true;
                    bl4 = false;
                    color = cachedViewProps.outlineColor;
                    if (n2 == 6) {
                        JCHLOCChartFormat jCHLOCChartFormat = (JCHLOCChartFormat)chartDataView.getChartFormat();
                        bl2 = jCHLOCChartFormat.isShowingOpen();
                        bl3 = jCHLOCChartFormat.isShowingClose();
                        bl4 = jCHLOCChartFormat.isOpenCloseFullWidth();
                    }
                    if (n2 != 7) break;
                    bl5 = ((JCCandleChartFormat)chartDataView.getChartFormat()).isComplex();
                    break;
                }
                ++n3;
            }
        }
        JCLegend jCLegend = this.chart.getLegend();
        if (graphics.getColor() != jCLegend.getForeground()) {
            graphics.setColor(jCLegend.getForeground());
        }
        if (graphics.getFont() != font) {
            graphics.setFont(font);
        }
        if (color == null) {
            color = this.chart.getChartArea().getForeground();
        }
        int n4 = jCLegendItem.pos.x + jCLegendItem.symbolPos.x;
        int n5 = jCLegendItem.pos.y + jCLegendItem.symbolPos.y;
        int n6 = Math.min(jCLegendItem.symbolDim.width, jCLegendItem.symbolDim.height);
        ChartDataViewSeries chartDataViewSeries = ((JCDataIndex)jCLegendItem.itemInfo).getSeries();
        if (chartDataViewSeries != null) {
            JCChartStyle jCChartStyle = chartDataViewSeries.getStyle();
            JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
            JCLineStyle jCLineStyle2 = new JCLineStyle(1, jCLineStyle.getColor(), jCLineStyle.getPattern(), jCLineStyle.getCap(), jCLineStyle.getJoin(), jCLineStyle.getCustomPatternArray(), jCLineStyle.getCustomLegendPatternArray());
            switch (chartDataView.getChartType()) {
                case 0: {
                    if (jCLineStyle2.updateGraphics(graphics, jCLegendItem.symbolDim.width - 1)) {
                        ((Graphics2D)graphics).draw(new Line2D.Double(n4, n5 + jCLegendItem.symbolDim.height / 2, n4 + jCLegendItem.symbolDim.width - 1, n5 + jCLegendItem.symbolDim.height / 2));
                        jCLineStyle2.resetGraphics(graphics);
                    }
                }
                case 1: {
                    jCChartStyle.getSymbolStyle().draw(graphics, n4 + jCLegendItem.symbolDim.width / 2, n5 + jCLegendItem.symbolDim.height / 2, jCLegendItem.symbolDim.width);
                    return;
                }
                case 5: 
                case 6: {
                    int n7;
                    int n8;
                    int n9;
                    int n10;
                    if (!jCLineStyle2.updateGraphics(graphics)) return;
                    if (bl) {
                        n10 = n4;
                        n9 = n4 + (jCLegendItem.symbolDim.width - 1);
                        n7 = n8 = n5 + n6 / 2;
                    } else {
                        n10 = n9 = n4 + jCLegendItem.symbolDim.width / 2;
                        n7 = n5;
                        n8 = n5 + n6;
                    }
                    ((Graphics2D)graphics).draw(new Line2D.Double(n10, n7, n9, n8));
                    if (n2 == 5) return;
                    if (bl2) {
                        if (bl) {
                            n10 = n9 = n4 + 2;
                            n7 = n5 + 1;
                            n8 = bl4 ? n5 + n6 - 2 : n5 + n6 / 2;
                        } else {
                            n10 = n4 + 2;
                            n9 = bl4 ? n4 - 3 + jCLegendItem.symbolDim.width : n4 + jCLegendItem.symbolDim.width / 2;
                            n7 = n8 = n5 + (int)Math.round(2.0 * (double)n6 / 3.0);
                        }
                        ((Graphics2D)graphics).draw(new Line2D.Double(n10, n7, n9, n8));
                    }
                    if (bl3) {
                        if (bl) {
                            n10 = n9 = n4 - 3 + jCLegendItem.symbolDim.width;
                            n7 = bl4 ? n5 + 1 : n5 + n6 / 2;
                            n8 = n5 + n6 - 2;
                        } else {
                            n10 = bl4 ? n4 + 2 : n4 + jCLegendItem.symbolDim.width / 2;
                            n9 = n4 - 3 + jCLegendItem.symbolDim.width;
                            n7 = n8 = n5 + n6 / 3;
                        }
                        ((Graphics2D)graphics).draw(new Line2D.Double(n10, n7, n9, n8));
                    }
                    jCLineStyle2.resetGraphics(graphics);
                    return;
                }
                case 7: {
                    JCLineStyle jCLineStyle3;
                    Serializable serializable;
                    int n11;
                    int n12;
                    int n13;
                    int n14;
                    int n15;
                    int n16 = n15 = jCLegendItem.symbolDim.width % 2 == 0 ? jCLegendItem.symbolDim.width : jCLegendItem.symbolDim.width - 1;
                    if (bl) {
                        n14 = n4;
                        n13 = n4 + 2;
                        n11 = n12 = n5 + n6 / 2;
                    } else {
                        n14 = n13 = n4 + n15 / 2;
                        n11 = n5;
                        n12 = n5 + n6 / 3;
                    }
                    if (jCLineStyle2.updateGraphics(graphics)) {
                        ((Graphics2D)graphics).draw(new Line2D.Double(n14, n11, n13, n12));
                        if (bl) {
                            n14 = n4 - 3 + n15;
                            n13 = n4 + (n15 - 1);
                            n11 = n12 = n5 + n6 / 2;
                        } else {
                            n14 = n13 = n4 + n15 / 2;
                            n11 = n5 + n6 * 2 / 3;
                            n12 = n5 + n6;
                        }
                        ((Graphics2D)graphics).draw(new Line2D.Double(n14, n11, n13, n12));
                        jCLineStyle2.resetGraphics(graphics);
                    }
                    if (bl) {
                        n14 = n4 + 3;
                        n11 = n5 + 3;
                        n13 = n15 - 7;
                        n12 = n6 - 7;
                    } else {
                        n14 = n4 + 3;
                        n11 = n5 + n6 / 3;
                        n13 = n15 - 6;
                        n12 = (int)Math.round((double)n6 / 3.0);
                    }
                    JCChartStyle jCChartStyle2 = jCChartStyle;
                    JCChartStyle jCChartStyle3 = jCChartStyle;
                    if (bl5) {
                        serializable = (JCCandleChartFormat)chartDataView.getChartFormat();
                        int n17 = ((JCDataIndex)jCLegendItem.itemInfo).getSeriesIndex();
                        jCChartStyle2 = ((JCCandleChartFormat)serializable).getRisingCandleStyle(n17 / cachedViewProps.seriesPerData);
                        jCChartStyle3 = ((JCCandleChartFormat)serializable).getCandleOutlineStyle(n17 / cachedViewProps.seriesPerData);
                        jCChartStyle2.getFillStyle().fillRect(graphics, n14, n11, n13, n12);
                    }
                    if (!(jCLineStyle3 = new JCLineStyle(1, ((JCLineStyle)(serializable = jCChartStyle3.getLineStyle())).getColor(), ((JCLineStyle)serializable).getPattern(), ((JCLineStyle)serializable).getCap(), ((JCLineStyle)serializable).getJoin(), jCLineStyle.getCustomPatternArray(), jCLineStyle.getCustomLegendPatternArray())).updateGraphics(graphics)) return;
                    ((Graphics2D)graphics).draw(new Rectangle2D.Double(n14, n11, n13, n12));
                    jCLineStyle3.resetGraphics(graphics);
                    return;
                }
                default: {
                    if (!jCLineStyle2.updateGraphics(graphics)) return;
                    ((Graphics2D)graphics).draw(new Line2D.Double(n4, n5 - jCLegendItem.symbolDim.height / 2, n4 + jCLegendItem.symbolDim.width, n5 - jCLegendItem.symbolDim.height / 2));
                    jCLineStyle2.resetGraphics(graphics);
                    return;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    return;
                }
            }
        }
        if (chartDataView == null) return;
        switch (n2) {
            case 11: {
                ((JCPieChartFormat)chartDataView.getChartFormat()).getOtherStyle().getFillStyle().fillOutlineRect(graphics, n4, n5, jCLegendItem.symbolDim.width - 1, jCLegendItem.symbolDim.height - 1, color);
            }
        }
    }

    public void drawLegendItemText(Graphics graphics, Font font, JCLegendItem jCLegendItem) {
    }

    public List getLegendItems(FontMetrics fontMetrics) {
        this.legendItems = new Vector();
        int n2 = this.chart.getOriginalDataView().size();
        int n3 = 0;
        while (n3 < n2) {
            this.legendItems.add(new Vector());
            ++n3;
        }
        JCLegend jCLegend = this.chart.getLegend();
        this.cachedView = new CachedViewProps[n2];
        int n4 = 0;
        while (n4 < n2) {
            List list = (List)this.legendItems.get(n4);
            ChartDataView chartDataView = (ChartDataView)this.chart.getOriginalDataView().get(n4);
            List list2 = chartDataView.getSeries();
            this.cachedView[n4] = new CachedViewProps();
            this.cacheViewProperties(this.cachedView[n4], chartDataView, list2);
            chartDataView.calcTransientData();
            if (list2 != null) {
                int n5 = chartDataView.getNumSeriesPerData();
                int n6 = list2.size() / n5;
                if (n6 != 0) {
                    int n7 = chartDataView.getChartType();
                    if (chartDataView.isVisibleInLegend()) {
                        Object object = chartDataView.getName();
                        JCLegendItem[] jCLegendItemArray = new JCLegendItem();
                        if (TextRenderer.isHTML((String)object)) {
                            jCLegendItemArray.textDim = jCLegend.getTextRenderer().calcHTMLTextSize((String)object);
                            jCLegendItemArray.contents = object;
                        } else if (object != null && ((String)object).length() > 0) {
                            jCLegendItemArray.textDim = new Dimension(fontMetrics.stringWidth((String)object), fontMetrics.getHeight());
                            jCLegendItemArray.contents = object;
                        } else {
                            jCLegendItemArray.textDim = new Dimension(0, 0);
                            jCLegendItemArray.contents = null;
                        }
                        jCLegendItemArray.itemInfo = new JCDataIndex(chartDataView, null, -1, -1);
                        list.add(jCLegendItemArray);
                        if (n7 == 11) {
                            object = (PieChartInfo)chartDataView.getTransientData();
                            if (object != null) {
                                jCLegendItemArray = new JCLegendItem[list2.size() + 1];
                                int n8 = 0;
                                while (n8 < ((PieChartInfo)object).num_pies) {
                                    PieData pieData = ((PieChartInfo)object).data[n8];
                                    int n9 = 0;
                                    while (n9 < pieData.num_slices_pie) {
                                        Serializable serializable;
                                        Object object2;
                                        if (n9 == pieData.other_slice) {
                                            if (jCLegendItemArray[list2.size()] == null) {
                                                JCLegendItem jCLegendItem = new JCLegendItem();
                                                jCLegendItem.itemInfo = new JCDataIndex(chartDataView, null, -10, -1);
                                                object2 = ((JCPieChartFormat)chartDataView.getChartFormat()).getOtherLabel();
                                                if (TextRenderer.isHTML((String)object2)) {
                                                    jCLegendItem.textDim = jCLegend.getTextRenderer().calcHTMLTextSize((String)object2);
                                                    jCLegendItem.contents = object2;
                                                } else {
                                                    jCLegendItem.textDim = new Dimension(fontMetrics.stringWidth((String)object2), fontMetrics.getHeight());
                                                    jCLegendItem.contents = object2;
                                                }
                                                serializable = ((JCPieChartFormat)chartDataView.getChartFormat()).getOtherStyle();
                                                this.calcSymbolSize(jCLegendItem, (JCChartStyle)serializable, n7);
                                                jCLegendItemArray[list2.size()] = jCLegendItem;
                                            }
                                        } else {
                                            int n10 = pieData.percents[n9].index;
                                            if (n10 >= 0 && jCLegendItemArray[n10] == null && ((ChartDataViewSeries)(object2 = (ChartDataViewSeries)list2.get(n10))).isVisible() && ((ChartDataViewSeries)object2).isVisibleInLegend()) {
                                                serializable = new JCLegendItem();
                                                serializable.itemInfo = new JCDataIndex(chartDataView, (ChartDataViewSeries)object2, n10, -1);
                                                String string = ((ChartDataViewSeries)object2).getLabel();
                                                if (TextRenderer.isHTML(string)) {
                                                    serializable.textDim = jCLegend.getTextRenderer().calcHTMLTextSize(string);
                                                    serializable.contents = string;
                                                } else {
                                                    serializable.textDim = new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
                                                    serializable.contents = string;
                                                }
                                                this.calcSymbolSize((JCLegendItem)serializable, ((ChartDataViewSeries)object2).getStyle(), n7);
                                                jCLegendItemArray[n10] = serializable;
                                            }
                                        }
                                        ++n9;
                                    }
                                    ++n8;
                                }
                                int n11 = 0;
                                while (n11 < jCLegendItemArray.length) {
                                    if (jCLegendItemArray[n11] != null) {
                                        list.add(jCLegendItemArray[n11]);
                                    }
                                    ++n11;
                                }
                            }
                        } else {
                            int n12 = 0;
                            while (n12 < n6) {
                                int n13 = n12 * n5;
                                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list2.get(n13);
                                JCLegendItem jCLegendItem = new JCLegendItem();
                                jCLegendItem.itemInfo = new JCDataIndex(chartDataView, chartDataViewSeries, n13, -1);
                                String string = null;
                                int n14 = 0;
                                int n15 = 0;
                                string = chartDataViewSeries.getLabel();
                                if (TextRenderer.isHTML(string)) {
                                    Dimension dimension = jCLegend.getTextRenderer().calcHTMLTextSize(string);
                                    jCLegendItem.contents = string;
                                    n15 = dimension.width;
                                    n14 = dimension.height;
                                } else {
                                    n15 = fontMetrics.stringWidth(string);
                                    n14 = fontMetrics.getHeight();
                                    jCLegendItem.contents = string;
                                }
                                boolean bl = true;
                                int n16 = n13;
                                int n17 = 0;
                                while (n17 < n5) {
                                    if (!((ChartDataViewSeries)list2.get(n16)).isVisibleInLegend()) {
                                        bl = false;
                                        break;
                                    }
                                    ++n17;
                                    ++n16;
                                }
                                if (bl && chartDataViewSeries.isVisibleInLegend()) {
                                    jCLegendItem.textDim = new Dimension(n15, n14);
                                    this.calcSymbolSize(jCLegendItem, chartDataViewSeries.getStyle(), n7);
                                    list.add(jCLegendItem);
                                }
                                ++n12;
                            }
                        }
                    }
                }
            }
            ++n4;
        }
        return this.legendItems;
    }

    public Color getOutlineColor(JCLegendItem jCLegendItem) {
        return this.chart.getChartArea().getForeground();
    }

    public boolean isTitleItem(JCLegendItem jCLegendItem) {
        JCDataIndex jCDataIndex = (JCDataIndex)jCLegendItem.itemInfo;
        return jCLegendItem.symbolDim == null && (jCDataIndex == null || jCDataIndex.getSeries() == null);
    }

    public void setFillGraphics(Graphics graphics, JCLegendItem jCLegendItem) {
        ChartDataView chartDataView = ((JCDataIndex)jCLegendItem.itemInfo).getDataView();
        ChartDataViewSeries chartDataViewSeries = ((JCDataIndex)jCLegendItem.itemInfo).getSeries();
        if (chartDataViewSeries != null) {
            JCChartStyle jCChartStyle = chartDataViewSeries.getStyle();
            jCChartStyle.getFillStyle().updateGraphics(graphics);
        } else if (chartDataView != null && chartDataView.getChartType() == 11) {
            ((JCPieChartFormat)chartDataView.getChartFormat()).getOtherStyle().getFillStyle().updateGraphics(graphics);
        }
    }
}

