/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ActionHandler;
import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.ChartRegion;
import com.klg.jclass.chart.EventTrigger;
import com.klg.jclass.chart.Extents;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.PlotArea;
import com.klg.jclass.util.JCNumberUtil;
import com.klg.jclass.util.legend.JCLegend;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class JCChartArea
extends ChartRegion {
    public static final int MAX_ELEVATION = 45;
    public static final int MAX_ROTATION = 45;
    public static final int MAX_DEPTH = 500;
    public static final String ERRMSG_INVALID_XAXIS_INDEX = "Invalid X axis index";
    public static final String ERRMSG_INVALID_YAXIS_INDEX = "Invalid Y axis index";
    protected Vector xaxes = new Vector();
    protected Vector yaxes = new Vector();
    protected int angleUnit = 1;
    protected JCAxis horizActionAxis;
    protected JCAxis vertActionAxis;
    protected boolean axisBoundingBox = false;
    protected boolean fastAction = false;
    protected boolean inAction = false;
    protected int depth = 0;
    protected int elevation = 0;
    protected int rotation = 0;
    private transient Hashtable drawables = new Hashtable();
    public transient Hashtable axisHashtable;
    private PlotArea plotArea = new PlotArea(this);
    protected Rectangle chartAreaRect = new Rectangle(0, 0, 0, 0);
    public Rectangle plotRect = new Rectangle(0, 0, 0, 0);
    public int deltaX = 0;
    public int deltaY = 0;
    public boolean draw3D = false;
    public boolean hasBar = false;
    protected boolean axisDrawOkay = false;
    public boolean pieFirst = false;
    protected Rectangle backplane;
    protected int symbolPad = 0;
    protected transient ActionHandler handler = null;
    protected transient boolean saveDBState = false;
    private Graphics prevSetGraphics = null;
    protected Graphics rbGC = null;
    protected Point last = new Point(0, 0);
    protected boolean inSuperReshape = false;

    public JCChartArea() {
        this.setOpaque(false);
        JCChart jCChart = (JCChart)this.getParent();
        JCAxis jCAxis = new JCAxis(this, false, 0);
        jCAxis.setParentChart(jCChart);
        jCAxis.setName(JCChartBundle.string("com.klg.jclass.chart.Key28"));
        JCAxis jCAxis2 = new JCAxis(this, true, 0);
        jCAxis2.setParentChart(jCChart);
        jCAxis2.setName(JCChartBundle.string("com.klg.jclass.chart.Key29"));
        this.xaxes.add(jCAxis);
        this.yaxes.add(jCAxis2);
        this.setHorizActionAxis(jCAxis);
        this.setVertActionAxis(jCAxis2);
    }

    private void addAxis(int n2, List list, JCAxis jCAxis) {
        jCAxis.setParentChart((JCChart)this.getParent());
        list.add(n2, jCAxis);
    }

    private void addDrawable(ChartDataView chartDataView) {
        if (chartDataView == null) {
            return;
        }
        if (this.hasMatchingDrawable(chartDataView)) {
            this.removeDrawable(chartDataView);
        }
        ChartDraw chartDraw = ChartDraw.makeDrawObject(chartDataView);
        this.drawables.put(chartDataView, chartDraw);
    }

    private void adjust(List list, int n2, int n3, int n4, int n5) {
        this.adjust(list, n2, n3, n4, n5, 0);
    }

    private void adjust(List list, int n2, int n3, int n4, int n5, int n6) {
        if (list == null) {
            return;
        }
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 0) {
            return;
        }
        int n7 = 0;
        while (n7 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n7);
            if (n6 == 0 || n6 == jCAxis.getAdjustedRealPlacement()) {
                int n8 = jCAxis.getLeft() + n2;
                int n9 = jCAxis.getTop() + n3;
                int n10 = jCAxis.getWidth() + n4;
                int n11 = jCAxis.getHeight() + n5;
                jCAxis.setBounds(n8, n9, n10, n11);
            }
            ++n7;
        }
    }

    private void adjustForExtents(List list, List list2) {
        Extents extents = new Extents();
        Extents extents2 = new Extents();
        this.findMaxExtents(list, extents);
        this.findMaxExtents(list2, extents2);
        int n2 = extents.minor - this.plotRect.x;
        if (n2 > 0 && this.plotArea.left.isDefault) {
            this.plotRect.width -= n2;
            this.plotRect.x += n2;
            this.adjust(list, n2, 0, -n2, 0);
            this.adjust(list2, n2, 0, 0, 0, 1);
        }
        if ((n2 = extents.major - (this.chartAreaRect.width - this.plotRect.x - this.plotRect.width)) > 0 && this.plotArea.right.isDefault) {
            this.plotRect.width -= n2;
            this.adjust(list, 0, 0, -n2, 0);
            this.adjust(list2, -n2, 0, 0, 0, 2);
        }
        if ((n2 = extents2.major - (this.chartAreaRect.height - this.plotRect.y - this.plotRect.height)) > 0 && this.plotArea.bottom.isDefault) {
            this.plotRect.height -= n2;
            this.adjust(list2, 0, -n2, 0, -n2);
            this.adjust(list, 0, -n2, 0, 0, 1);
        }
        if ((n2 = extents2.minor - this.plotRect.y) > 0 && this.plotArea.top.isDefault) {
            this.plotRect.y += n2;
            this.plotRect.height -= n2;
            this.adjust(list2, 0, n2, 0, -n2);
            this.adjust(list, 0, n2, 0, 0, 2);
        }
    }

    private void adjustForOrthoExtents(List list, List list2) {
        Rectangle rectangle = new Rectangle(this.plotRect.x, this.plotRect.y, this.plotRect.width, this.plotRect.height);
        int n2 = 0;
        while (n2 < list.size()) {
            ((JCAxis)list.get(n2)).adjustForOrthoExtent();
            ++n2;
        }
        int n3 = 0;
        while (n3 < list2.size()) {
            ((JCAxis)list2.get(n3)).adjustForOrthoExtent();
            ++n3;
        }
        if (this.plotRect.equals(rectangle)) {
            return;
        }
        this.adjust(list2, 0, this.plotRect.y - rectangle.y, 0, this.plotRect.height - rectangle.height);
        this.adjust(list, this.plotRect.x - rectangle.x, 0, this.plotRect.width - rectangle.width, 0);
        this.layoutOrigins(list);
        this.layoutOrigins(list2);
    }

    private void adjustForSymbols(List list, List list2) {
        int n2;
        if (this.getPlotArea().getLeftIsDefault() && (n2 = this.symbolPad - (this.plotRect.x - this.chartAreaRect.x)) > 0) {
            this.plotRect.x += n2;
            this.plotRect.width -= n2;
            this.adjust(list, n2, 0, -n2, 0);
            this.adjust(list2, n2, 0, 0, 0, 1);
        }
        if (this.getPlotArea().getRightIsDefault() && (n2 = this.symbolPad - (this.chartAreaRect.x + this.chartAreaRect.width - this.plotRect.x - this.plotRect.width)) > 0) {
            this.plotRect.width -= n2;
            this.adjust(list, 0, 0, -n2, 0);
            this.adjust(list2, -n2, 0, 0, 0, 2);
        }
        if (this.getPlotArea().getTopIsDefault() && (n2 = this.symbolPad - (this.plotRect.y - this.chartAreaRect.y)) > 0) {
            this.plotRect.y += n2;
            this.plotRect.height -= n2;
            this.adjust(list2, 0, n2, 0, -n2);
            this.adjust(list, 0, n2, 0, 0, 2);
        }
        if (this.getPlotArea().getBottomIsDefault() && (n2 = this.symbolPad - (this.chartAreaRect.y + this.chartAreaRect.height - this.plotRect.y - this.plotRect.height)) > 0) {
            this.plotRect.height -= n2;
            this.adjust(list2, 0, -n2, 0, -n2);
            this.adjust(list, 0, -n2, 0, 0, 1);
        }
    }

    private void adjustPlotRectForAxes(List list) {
        if (list == null) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n6);
            if (jCAxis.visible && !this.pieFirst) {
                if (jCAxis.vertical) {
                    if (jCAxis.annoHandler.extents.ortho > jCAxis.getWidth()) {
                        jCAxis.setSize(jCAxis.annoHandler.extents.ortho, jCAxis.getHeight());
                    }
                    if (jCAxis.isLeftSide()) {
                        n2 = this.draw3D ? Math.max(n2, jCAxis.getWidth()) : (n2 += jCAxis.getWidth());
                    } else if (jCAxis.isRightSide()) {
                        n3 = this.draw3D ? Math.max(n3, jCAxis.getWidth()) : (n3 += jCAxis.getWidth());
                    }
                } else {
                    if (jCAxis.annoHandler.extents.ortho > jCAxis.getHeight()) {
                        jCAxis.setSize(jCAxis.getWidth(), jCAxis.annoHandler.extents.ortho);
                    }
                    if (jCAxis.isTopSide()) {
                        n4 = this.draw3D ? Math.max(n4, jCAxis.getHeight()) : (n4 += jCAxis.getHeight());
                    } else if (jCAxis.isBottomSide()) {
                        n5 = this.draw3D ? Math.max(n5, jCAxis.getHeight()) : (n5 += jCAxis.getHeight());
                    }
                }
            }
            ++n6;
        }
        if (!this.getPlotArea().getLeftIsDefault()) {
            this.plotRect.x = this.getPlotArea().getLeft();
        }
        if (!this.getPlotArea().getTopIsDefault()) {
            this.plotRect.y = this.getPlotArea().getTop();
        }
        int n7 = this.plotRect.x;
        int n8 = this.getPlotArea().getRightIsDefault() ? this.plotRect.x + this.plotRect.width : this.chartAreaRect.width - this.getPlotArea().getRight();
        int n9 = this.plotRect.y;
        int n10 = this.getPlotArea().getBottomIsDefault() ? this.plotRect.y + this.plotRect.height : this.chartAreaRect.height - this.getPlotArea().getBottom();
        int n11 = 0;
        while (n11 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n11);
            if (jCAxis.visible && !this.pieFirst) {
                if (jCAxis.vertical) {
                    if (jCAxis.isLeftSide()) {
                        if (this.getPlotArea().getLeftIsDefault()) {
                            if (this.draw3D) {
                                jCAxis.setLocation(n7 + n2 - jCAxis.getWidth(), jCAxis.getTop());
                            } else {
                                jCAxis.setLocation(n7, jCAxis.getTop());
                                n7 += jCAxis.getWidth();
                            }
                        } else if (this.draw3D) {
                            jCAxis.setLocation(n7 - jCAxis.getWidth(), jCAxis.getTop());
                        } else {
                            jCAxis.setLocation(n7 - n2, jCAxis.getTop());
                            n7 += jCAxis.getWidth();
                        }
                    } else if (jCAxis.isRightSide()) {
                        if (this.getPlotArea().getRightIsDefault()) {
                            if (this.draw3D) {
                                jCAxis.setLocation(n8 - n3, jCAxis.getTop());
                            } else {
                                jCAxis.setLocation(n8 - n3, jCAxis.getTop());
                                n8 += jCAxis.getWidth();
                            }
                        } else if (this.draw3D) {
                            jCAxis.setLocation(n8, jCAxis.getTop());
                        } else {
                            jCAxis.setLocation(n8, jCAxis.getTop());
                            n8 += jCAxis.getWidth();
                        }
                    }
                } else if (jCAxis.isTopSide()) {
                    if (this.getPlotArea().getTopIsDefault()) {
                        if (this.draw3D) {
                            jCAxis.setLocation(jCAxis.getLeft(), n9 + n4 - jCAxis.getHeight());
                        } else {
                            jCAxis.setLocation(jCAxis.getLeft(), n9);
                            n9 += jCAxis.getHeight();
                        }
                    } else if (this.draw3D) {
                        jCAxis.setLocation(jCAxis.getLeft(), n9 - jCAxis.getHeight());
                    } else {
                        jCAxis.setLocation(jCAxis.getLeft(), n9 - n4);
                        n9 += jCAxis.getHeight();
                    }
                } else if (jCAxis.isBottomSide()) {
                    if (this.getPlotArea().getBottomIsDefault()) {
                        if (this.draw3D) {
                            jCAxis.setLocation(jCAxis.getLeft(), n10 - n5);
                        } else {
                            jCAxis.setLocation(jCAxis.getLeft(), n10 - n5);
                            n10 += jCAxis.getHeight();
                        }
                    } else if (this.draw3D) {
                        jCAxis.setLocation(jCAxis.getLeft(), n10);
                    } else {
                        jCAxis.setLocation(jCAxis.getLeft(), n10);
                        n10 += jCAxis.getHeight();
                    }
                }
            }
            ++n11;
        }
        if (this.getPlotArea().getLeftIsDefault()) {
            this.plotRect.x += n2;
            this.plotRect.width -= n2;
        }
        if (this.getPlotArea().getRightIsDefault()) {
            this.plotRect.width -= n3;
        }
        if (this.getPlotArea().getTopIsDefault()) {
            this.plotRect.y += n4;
            this.plotRect.height -= n4;
        }
        if (this.getPlotArea().getBottomIsDefault()) {
            this.plotRect.height -= n5;
        }
    }

    private void calc3D() {
        List list;
        double d2 = JCNumberUtil.degToRad(this.rotation);
        double d3 = JCNumberUtil.degToRad(this.elevation);
        double d4 = Math.sin(d2);
        double d5 = Math.sin(d3);
        double d6 = Math.cos(d3);
        double d7 = (double)this.depth / 100.0;
        double d8 = JCNumberUtil.max(1.0, this.getSize().width);
        double d9 = (d8 /= 1.0 + JCNumberUtil.abs(d4) * d6 * d7) * d7;
        this.deltaX = (int)(d9 * d4 * d6);
        this.deltaY = (int)(-d9 * d5);
        this.checkDeltaValues();
        boolean bl = true;
        boolean bl2 = true;
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart != null && (list = jCChart.getDataView()) != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ChartDataView chartDataView = (ChartDataView)iterator.next();
                if (!chartDataView.isVisible()) continue;
                int n2 = chartDataView.getChartType();
                if (n2 != 0 && n2 != 1 && n2 != 12 && n2 != 8 && n2 != 5 && n2 != 6 && n2 != 7 && (n2 != 11 || bl2)) {
                    bl = false;
                    break;
                }
                if (!bl2) continue;
                bl2 = false;
            }
        }
        boolean bl3 = this.deltaX != 0 || this.deltaY != 0;
        this.hasBar = bl ^ true;
        this.draw3D = !bl && bl3;
    }

    void calcAnchors(List list) {
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            jCAxis.calcAnchors();
            ++n2;
        }
    }

    private void calcAnnotationExtents(List list) {
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            jCAxis.calcAnnotationExtents();
            ++n2;
        }
    }

    private void calcAxisParams(List list) {
        if (list == null) {
            return;
        }
        boolean bl = false;
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            if (jCAxis.formula != null) {
                bl = true;
            }
            jCAxis.calcAxisParams(true);
            ++n2;
        }
        if (!bl) {
            return;
        }
        int n3 = 0;
        while (n3 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n3);
            if (jCAxis.formula != null) {
                jCAxis.formula.calcRelatedParams();
            }
            ++n3;
        }
    }

    private void calcGraphExtents() {
        if (this.pieFirst) {
            Enumeration enumeration = this.drawables.keys();
            while (enumeration.hasMoreElements()) {
                ChartDataView chartDataView = (ChartDataView)enumeration.nextElement();
                if (chartDataView.getChartType() != 11) continue;
                ChartDraw chartDraw = (ChartDraw)this.drawables.get(chartDataView);
                chartDraw.recalc();
                break;
            }
        } else {
            Enumeration enumeration = this.drawables.keys();
            while (enumeration.hasMoreElements()) {
                ChartDataView chartDataView = (ChartDataView)enumeration.nextElement();
                if (chartDataView.getChartType() == 11) continue;
                ChartDraw chartDraw = (ChartDraw)this.drawables.get(chartDataView);
                chartDraw.recalc();
            }
        }
    }

    void calcLimits() {
        this.clearLimits();
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        if (this.pieFirst) {
            Iterator iterator = jCChart.getOriginalDataView().iterator();
            while (iterator.hasNext()) {
                ChartDataView chartDataView = (ChartDataView)iterator.next();
                if (!chartDataView.isVisible() || chartDataView.getChartType() != 11) continue;
                chartDataView.calcLimits();
                break;
            }
        } else {
            Iterator iterator = jCChart.getOriginalDataView().iterator();
            while (iterator.hasNext()) {
                ChartDataView chartDataView = (ChartDataView)iterator.next();
                if (chartDataView.getChartType() == 11 || !chartDataView.isVisible()) continue;
                chartDataView.calcLimits();
            }
        }
    }

    private void calcTransformation(List list) {
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            jCAxis.calcTransformation();
            ++n2;
        }
    }

    void cancel() {
        this.handler = null;
        this.inAction = false;
        this.setChanged(true, 2);
    }

    void checkAnnotations(List list) {
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            jCAxis.checkAnnotations();
            ++n2;
        }
    }

    private boolean checkDeltaValues() {
        boolean bl = false;
        if (this.plotRect.width <= 0 || this.plotRect.height <= 0) {
            return bl;
        }
        int n2 = this.plotRect.width;
        if (Math.abs(this.deltaX) > n2) {
            this.deltaX = this.deltaX < 0 ? -n2 : n2;
            bl = true;
        }
        n2 = this.plotRect.height;
        if (Math.abs(this.deltaY) > n2) {
            this.deltaY = this.deltaY < 0 ? -n2 : n2;
            bl = true;
        }
        return bl;
    }

    void clearDrawables() {
        this.drawables = null;
    }

    void clearLimits() {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        Iterator iterator = jCChart.getOriginalDataView().iterator();
        while (iterator.hasNext()) {
            ChartDataView chartDataView = (ChartDataView)iterator.next();
            chartDataView.clearLimits();
        }
    }

    Rectangle clipForDrawing() {
        int n2 = this.symbolPad * 2;
        int n3 = Math.max(0, this.plotRect.x - n2 / 2);
        int n4 = Math.max(0, this.plotRect.y - n2 / 2);
        int n5 = Math.min(this.plotRect.width + 1 + n2, this.chartAreaRect.width - n3);
        int n6 = Math.min(this.plotRect.height + 1 + n2, this.chartAreaRect.height - n4);
        return new Rectangle(n3, n4, n5, n6);
    }

    private Rectangle clipToEntirePlotRect() {
        int n2;
        int n3;
        int n4;
        int n5;
        if (this.axisBoundingBox && !this.draw3D) {
            n5 = this.plotRect.x + 1;
            n4 = this.plotRect.y + 1;
            n3 = this.plotRect.width - 1;
            n2 = this.plotRect.height - 1;
        } else {
            n5 = this.plotRect.x;
            n4 = this.plotRect.y;
            n3 = this.plotRect.width + 1;
            n2 = this.plotRect.height + 1;
        }
        n5 = Math.max(0, n5);
        n4 = Math.max(0, n4);
        n3 = Math.min(n3, this.chartAreaRect.width - n5);
        n2 = Math.min(n2, this.chartAreaRect.height - n4);
        return new Rectangle(n5, n4, n3, n2);
    }

    private void drawAxes(Graphics graphics, List list) {
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            if (jCAxis.visible) {
                jCAxis.draw(graphics);
            }
            ++n2;
        }
    }

    private void drawAxisAnnotationsAndTitle(Graphics graphics, List list) {
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            if (jCAxis.visible) {
                jCAxis.drawAnnotationsAndTitle(graphics);
            }
            ++n2;
        }
    }

    private void drawBackplane(Graphics graphics) {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        if (jCChart.getOriginalDataView().size() == 1 && ((ChartDataView)jCChart.getOriginalDataView().get(0)).getChartType() == 11) {
            return;
        }
        boolean bl = false;
        if (bl) {
            throw new RuntimeException("Polar backplane not implemented");
        }
        JCFillStyle jCFillStyle = null;
        if (this.isOpaque()) {
            Color color = this.plotArea.getBackground();
            jCFillStyle = new JCFillStyle(this.plotArea.getBackground(), 1);
        }
        int n2 = this.plotRect.x;
        int n3 = this.plotRect.y;
        int n4 = this.plotRect.width;
        int n5 = this.plotRect.height;
        if ((this.draw3D || this.axisBoundingBox) && !this.pieFirst) {
            if (this.draw3D && this.deltaX > 0) {
                n2 += this.deltaX;
            }
            if (this.draw3D && this.deltaY > 0) {
                n3 += this.deltaY;
            }
            int n6 = this.draw3D ? JCNumberUtil.abs(this.deltaX) : 0;
            int n7 = this.draw3D ? JCNumberUtil.abs(this.deltaY) : 0;
            n4 = Math.max(0, n4 - n6);
            n5 = Math.max(0, n5 - n7);
            if (jCFillStyle != null) {
                jCFillStyle.fillRect(graphics, n2, n3, n4, n5);
            }
            if (this.axisBoundingBox) {
                graphics.setColor(this.plotArea.getForeground());
                graphics.drawRect(n2, n3, n4, n5);
            }
            this.backplane = new Rectangle(n2, n3, n4, n5);
        } else {
            if (jCFillStyle != null) {
                jCFillStyle.fillOutlineRect(graphics, n2, n3, n4, n5, jCFillStyle.getColor());
            }
            this.backplane = new Rectangle(n2, n3, n4, n5);
        }
    }

    private void drawBpAxes(Graphics graphics, List list) {
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            if (jCAxis.visible && !jCAxis.isBar()) {
                jCAxis.draw(graphics);
            }
            ++n2;
        }
    }

    private void drawBpAxisAnnotationsAndTitle(Graphics graphics, List list) {
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            if (jCAxis.visible && !jCAxis.isBar()) {
                jCAxis.drawAnnotationsAndTitle(graphics);
            }
            ++n2;
        }
    }

    private void drawFpAxes(Graphics graphics, List list) {
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            if (jCAxis.visible && jCAxis.isBar()) {
                jCAxis.draw(graphics);
            }
            ++n2;
        }
    }

    private void drawFpAxisAnnotationsAndTitle(Graphics graphics, List list) {
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            if (jCAxis.visible && jCAxis.isBar()) {
                jCAxis.drawAnnotationsAndTitle(graphics);
            }
            ++n2;
        }
    }

    void drawRubberBand(Point point, Point point2) {
        int n2;
        Graphics graphics;
        if (point == null) {
            return;
        }
        if (point.x == point2.x || point.y == point2.y) {
            return;
        }
        int n3 = point2.x;
        int n4 = point2.y;
        int n5 = point.x;
        int n6 = point.y;
        if (this.rbGC == null && this.getParent() == null) {
            return;
        }
        Graphics graphics2 = graphics = this.rbGC == null ? this.getGraphics().create() : this.rbGC.create();
        if (n5 - n3 < 0) {
            n2 = n5;
            n5 = n3;
            n3 = n2;
        }
        if (n6 - n4 < 0) {
            n2 = n6;
            n6 = n4;
            n4 = n2;
        }
        graphics.setXORMode(Color.white);
        graphics.drawRect(n3, n4, n5 - n3, n6 - n4);
        graphics.setXORMode(Color.black);
        graphics.drawRect(n3 + 1, n4 + 1, n5 - n3, n6 - n4);
        graphics.dispose();
    }

    void drawRubberLine(Point point, Point point2) {
        if (point == null || point2 == null) {
            return;
        }
        if (this.getParent() == null) {
            return;
        }
        Graphics graphics = this.getGraphics().create();
        graphics.setXORMode(Color.white);
        graphics.drawLine(point.x, point.y, point2.x, point2.y);
        graphics.setXORMode(Color.black);
        graphics.drawLine(point.x + 1, point.y + 1, point2.x + 1, point2.y + 1);
        graphics.dispose();
    }

    void endAction(int n2, int n3) {
        if (this.handler == null) {
            return;
        }
        ActionHandler actionHandler = this.handler;
        this.handler = null;
        actionHandler.end(n2, n3);
    }

    private void ensureDrawables() {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        if (this.drawables == null) {
            this.drawables = new Hashtable();
        }
        this.axisDrawOkay = true;
        this.pieFirst = false;
        int n2 = 0;
        Iterator iterator = jCChart.getOriginalDataView().iterator();
        while (iterator.hasNext()) {
            ChartDataView chartDataView = (ChartDataView)iterator.next();
            if (chartDataView.isVisible() && ++n2 == 1 && chartDataView.getChartType() == 11) {
                this.pieFirst = true;
                this.axisDrawOkay = false;
            }
            if (!this.hasMatchingDrawable(chartDataView) && chartDataView.isVisible()) {
                this.addDrawable(chartDataView);
                continue;
            }
            if (!this.hasMatchingDrawable(chartDataView) || chartDataView.isVisible()) continue;
            this.removeDrawable(chartDataView);
        }
    }

    public JCAxis findAxisByName(String string) {
        JCAxis jCAxis = this.findAxisByName(string, true);
        if (jCAxis == null) {
            jCAxis = this.findAxisByName(string, false);
        }
        return jCAxis;
    }

    protected JCAxis findAxisByName(String string, boolean bl) {
        Vector vector;
        Vector vector2 = vector = bl ? this.xaxes : this.yaxes;
        if (vector == null) {
            return null;
        }
        ListIterator listIterator = vector.listIterator();
        while (listIterator.hasNext()) {
            Object e2 = listIterator.next();
            if (!(e2 instanceof JCAxis) || !string.equals(((JCAxis)e2).getName())) continue;
            return (JCAxis)e2;
        }
        return null;
    }

    private void findMaxExtents(List list, Extents extents) {
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            Extents extents2 = jCAxis.getExtents();
            if (extents2 != null) {
                if (extents2.major > extents.major) {
                    extents.major = extents2.major;
                }
                if (extents2.minor > extents.minor) {
                    extents.minor = extents2.minor;
                }
                if (extents2.ortho > extents.ortho) {
                    extents.ortho = extents2.ortho;
                }
            }
            ++n2;
        }
    }

    public ActionHandler getActionHandler() {
        return this.handler;
    }

    public int getAngleUnit() {
        return this.angleUnit;
    }

    public boolean getAxisBoundingBox() {
        return this.axisBoundingBox;
    }

    protected int getBiggestSymbolSize() {
        int n2 = 0;
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart != null) {
            List list = jCChart.getDataView();
            int n3 = 0;
            while (n3 < list.size()) {
                ChartDataView chartDataView = (ChartDataView)list.get(n3);
                List list2 = chartDataView.getSeries();
                int n4 = 0;
                while (n4 < list2.size()) {
                    ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list2.get(n4);
                    JCChartStyle jCChartStyle = chartDataViewSeries.getStyle();
                    n2 = Math.max(n2, jCChartStyle.getSymbolSize());
                    ++n4;
                }
                ++n3;
            }
        }
        return n2;
    }

    public boolean getChanged() {
        return super.getChanged() || this.isDirty();
    }

    public Rectangle getChartAreaRect() {
        return this.chartAreaRect;
    }

    public int getDeltaX() {
        return this.deltaX;
    }

    public int getDeltaY() {
        return this.deltaY;
    }

    public int getDepth() {
        return this.depth;
    }

    public boolean getDraw3D() {
        return this.draw3D;
    }

    public ChartDraw getDrawable(ChartDataView chartDataView) {
        ChartDraw chartDraw = null;
        if (this.drawables != null && this.drawables.containsKey(chartDataView)) {
            ChartDraw chartDraw2 = (ChartDraw)this.drawables.get(chartDataView);
            if (chartDraw2.chartType == chartDraw2.dataObject.getChartType()) {
                chartDraw = chartDraw2;
            }
        }
        return chartDraw;
    }

    public int getElevation() {
        return this.elevation;
    }

    public boolean getFastAction() {
        return this.fastAction;
    }

    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics;
    }

    public boolean getHasBar() {
        return this.hasBar;
    }

    public JCAxis getHorizActionAxis() {
        return this.horizActionAxis;
    }

    private void getHorizVertAxes(List list, List list2) {
        int n2 = 0;
        while (n2 < this.xaxes.size()) {
            JCAxis jCAxis = (JCAxis)this.xaxes.get(n2);
            if (jCAxis.vertical) {
                list2.add(jCAxis);
            } else {
                list.add(jCAxis);
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.yaxes.size()) {
            JCAxis jCAxis = (JCAxis)this.yaxes.get(n3);
            if (jCAxis.vertical) {
                list2.add(jCAxis);
            } else {
                list.add(jCAxis);
            }
            ++n3;
        }
    }

    public boolean getInAction() {
        return this.inAction;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public PlotArea getPlotArea() {
        if (this.plotArea == null) {
            this.plotArea = new PlotArea(this);
        }
        return this.plotArea;
    }

    public Rectangle getPlotRect() {
        return this.plotRect;
    }

    public Dimension getPreferredSize() {
        JCChart jCChart = (JCChart)this.getParent();
        this.ensureDrawables();
        Dimension dimension = super.getPreferredSize();
        if (dimension == null) {
            dimension = new Dimension(0, 0);
        }
        if (dimension != null || dimension.width <= 0 || dimension.height <= 0) {
            dimension = new Dimension();
            dimension.width = 100;
            dimension.height = 100;
        }
        return dimension;
    }

    public int getRotation() {
        return this.rotation;
    }

    public JCAxis getVertActionAxis() {
        return this.vertActionAxis;
    }

    public List getXAxes() {
        return this.xaxes;
    }

    public JCAxis getXAxis(int n2) {
        if (this.xaxes == null) {
            return null;
        }
        return (JCAxis)this.xaxes.get(n2);
    }

    public List getYAxes() {
        return this.yaxes;
    }

    public JCAxis getYAxis(int n2) {
        if (this.yaxes == null) {
            return null;
        }
        return (JCAxis)this.yaxes.get(n2);
    }

    boolean hasMatchingDrawable(ChartDataView chartDataView) {
        if (this.drawables.containsKey(chartDataView)) {
            ChartDraw chartDraw = (ChartDraw)this.drawables.get(chartDataView);
            if (chartDraw.chartType == chartDraw.dataObject.getChartType()) {
                return true;
            }
        }
        return false;
    }

    private boolean is3DChartType(int n2) {
        return n2 == 9 || n2 == 10;
    }

    public boolean isDirty() {
        this.ensureDrawables();
        Enumeration enumeration = this.drawables.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            ChartDraw chartDraw = (ChartDraw)this.drawables.get(k2);
            if (!chartDraw.dataObject.isChanged()) continue;
            return true;
        }
        int n2 = 0;
        while (n2 < this.xaxes.size()) {
            if (((JCAxis)this.xaxes.get(n2)).isChanged()) {
                return true;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < this.yaxes.size()) {
            if (((JCAxis)this.yaxes.get(n3)).isChanged()) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    boolean isXAxis(JCAxis jCAxis) {
        return this.xaxes.contains(jCAxis);
    }

    void layoutAnnotations(List list) {
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            jCAxis.layoutAnnotations();
            ++n2;
        }
    }

    private void layoutAxes(List list, boolean bl) {
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            jCAxis.layoutAxis(bl);
            ++n2;
        }
    }

    public void layoutChartArea() {
        this.resetPlotArea();
        this.symbolPad = (this.getBiggestSymbolSize() + 1) / 2;
        int n2 = this.chartAreaRect.width - this.plotArea.left.value - this.plotArea.right.value;
        int n3 = this.chartAreaRect.height - this.plotArea.top.value - this.plotArea.bottom.value;
        this.plotRect = new Rectangle(this.plotArea.left.value, this.plotArea.top.value, n2, n3);
        if (!this.pieFirst) {
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            this.getHorizVertAxes(vector2, vector);
            this.adjustPlotRectForAxes(this.xaxes);
            this.adjustPlotRectForAxes(this.yaxes);
            this.layoutAxes(this.xaxes, false);
            this.layoutAxes(this.yaxes, false);
            this.adjustForExtents(vector2, vector);
            this.adjustForSymbols(vector2, vector);
            this.layoutAxes(this.xaxes, true);
            this.layoutAxes(this.yaxes, true);
            this.layoutOrigins(this.xaxes);
            this.layoutOrigins(this.yaxes);
            this.adjustForOrthoExtents(vector2, vector);
            if (!this.inAction || !this.fastAction) {
                this.layoutAnnotations(this.xaxes);
                this.layoutAnnotations(this.yaxes);
                this.checkAnnotations(this.xaxes);
                this.checkAnnotations(this.yaxes);
            }
        }
        if (this.plotArea.top.isDefault) {
            this.plotArea.top.value = this.plotRect.y;
        }
        if (this.plotArea.left.isDefault) {
            this.plotArea.left.value = this.plotRect.x;
        }
        if (this.plotArea.bottom.isDefault) {
            this.plotArea.bottom.value = this.chartAreaRect.height - this.plotRect.y - this.plotRect.height;
        }
        if (this.plotArea.right.isDefault) {
            this.plotArea.right.value = this.chartAreaRect.width - this.plotRect.x - this.plotRect.width;
        }
    }

    private void layoutOrigins(List list) {
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            jCAxis.layoutOrigin();
            ++n2;
        }
    }

    private void makeAnnotations(List list) {
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            jCAxis.makeAnnotations();
            ++n2;
        }
    }

    public void paintComponent(Graphics graphics) {
        Serializable serializable;
        if (this.getParent() == null) {
            return;
        }
        if (graphics == null) {
            return;
        }
        if (!this.isVisible()) {
            return;
        }
        super.paintComponent(graphics);
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = this.getDrawingArea();
        graphics2.translate(rectangle.x, rectangle.y);
        Rectangle rectangle2 = graphics2.getClipBounds();
        Graphics graphics3 = graphics2;
        Rectangle rectangle3 = new Rectangle(0, 0, this.chartAreaRect.width, this.chartAreaRect.height);
        JCChart jCChart = (JCChart)this.getParent();
        try {
            serializable = this.clipForDrawing();
            graphics3.clipRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
            this.drawBackplane(graphics3);
            graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            Rectangle rectangle4 = this.clipToEntirePlotRect();
            if (this.pieFirst) {
                this.ensureDrawables();
                Iterator iterator = jCChart.getOriginalDataView().iterator();
                while (iterator.hasNext()) {
                    ChartDataView chartDataView = (ChartDataView)iterator.next();
                    ChartDraw chartDraw = this.getDrawable(chartDataView);
                    if (chartDraw == null || chartDataView.getChartType() != 11) continue;
                    graphics3.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    chartDraw.draw(graphics3);
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
            } else if (this.draw3D) {
                Changeable changeable;
                Object object;
                Object object2;
                Object object3;
                this.ensureDrawables();
                JCAxis jCAxis = null;
                JCAxis jCAxis2 = null;
                Iterator iterator = jCChart.getOriginalDataView().iterator();
                while (iterator.hasNext()) {
                    object3 = (ChartDataView)iterator.next();
                    if (!this.is3DChartType(((ChartDataView)object3).getChartType())) continue;
                    jCAxis = ((ChartDataView)object3).getXAxis();
                    jCAxis2 = ((ChartDataView)object3).getYAxis();
                    break;
                }
                if (this.axisDrawOkay) {
                    graphics3.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    this.preDraw3DAxes(graphics3, jCAxis, jCAxis2);
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    if (this.axisBoundingBox) {
                        graphics3.clipRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
                        graphics3.setColor(this.plotArea.getForeground());
                        graphics3.drawRect(this.backplane.x, this.backplane.y, this.backplane.width, this.backplane.height);
                        graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    }
                    graphics3.clipRect(this.backplane.x + 1, this.backplane.y + 1, this.backplane.width - 1, this.backplane.height - 1);
                    if (!this.fastAction || !this.inAction) {
                        this.preDrawGrids(graphics3, this.xaxes);
                        this.preDrawGrids(graphics3, this.yaxes);
                    }
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                    graphics3.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    if (jCAxis != null && jCAxis.visible) {
                        jCAxis.preDrawOutlineTrough(graphics3);
                    }
                    if (jCAxis2 != null && jCAxis2.visible) {
                        jCAxis2.preDrawOutlineTrough(graphics3);
                    }
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                if (this.axisDrawOkay) {
                    graphics3.clipRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    this.drawBpAxes(graphics3, this.xaxes);
                    this.drawBpAxes(graphics3, this.yaxes);
                    if (!this.fastAction || !this.inAction) {
                        this.drawBpAxisAnnotationsAndTitle(graphics3, this.xaxes);
                        this.drawBpAxisAnnotationsAndTitle(graphics3, this.yaxes);
                    }
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                object3 = jCChart.getOriginalDataView().iterator();
                while (object3.hasNext()) {
                    object2 = (ChartDataView)object3.next();
                    object = this.getDrawable((ChartDataView)object2);
                    if (object == null || ((ChartDataView)object2).getChartType() == 11 || ((ChartDraw)object).drawFront || ((ChartDataView)object2).is3DChartType()) continue;
                    if (((ChartDataView)object2).getChartType() == 0 || ((ChartDataView)object2).getChartType() == 1) {
                        graphics3.clipRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
                        ((ChartDraw)object).draw(graphics3);
                        graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        continue;
                    }
                    graphics3.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    ((ChartDraw)object).draw(graphics3);
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                object2 = jCChart.getOriginalDataView().iterator();
                while (object2.hasNext()) {
                    object = (ChartDataView)object2.next();
                    changeable = this.getDrawable((ChartDataView)object);
                    if (changeable == null || ((ChartDataView)object).getChartType() == 11 || !((ChartDataView)object).is3DChartType()) continue;
                    if (((ChartDataView)object).getChartType() == 0 || ((ChartDataView)object).getChartType() == 1) {
                        graphics3.clipRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
                        ((ChartDraw)changeable).draw(graphics3);
                        graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        continue;
                    }
                    graphics3.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    ((ChartDraw)changeable).draw(graphics3);
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                if (this.axisDrawOkay) {
                    graphics3.clipRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    this.drawFpAxes(graphics3, this.xaxes);
                    this.drawFpAxes(graphics3, this.yaxes);
                    if (!this.fastAction || !this.inAction) {
                        this.drawFpAxisAnnotationsAndTitle(graphics3, this.xaxes);
                        this.drawFpAxisAnnotationsAndTitle(graphics3, this.yaxes);
                    }
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                object = jCChart.getOriginalDataView().iterator();
                while (object.hasNext()) {
                    changeable = (ChartDataView)object.next();
                    ChartDraw chartDraw = this.getDrawable((ChartDataView)changeable);
                    if (chartDraw == null || ((ChartDataView)changeable).getChartType() == 11 || ((ChartDataView)changeable).is3DChartType() || !chartDraw.drawFront) continue;
                    if (((ChartDataView)changeable).getChartType() == 0 || ((ChartDataView)changeable).getChartType() == 1) {
                        graphics3.clipRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
                        chartDraw.draw(graphics3);
                        graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                        continue;
                    }
                    graphics3.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    chartDraw.draw(graphics3);
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
            } else {
                Changeable changeable;
                Object object;
                if (!(!this.axisDrawOkay || this.fastAction && this.inAction)) {
                    graphics3.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                    this.preDrawGrids(graphics3, this.xaxes);
                    this.preDrawGrids(graphics3, this.yaxes);
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                this.ensureDrawables();
                graphics3.clipRect(rectangle4.x, rectangle4.y, rectangle4.width, rectangle4.height);
                Iterator iterator = jCChart.getOriginalDataView().iterator();
                while (iterator.hasNext()) {
                    object = (ChartDataView)iterator.next();
                    changeable = (ChartDraw)this.drawables.get(object);
                    if (changeable == null || ((ChartDataView)object).getChartType() == 11 || ((ChartDataView)object).getChartType() == 0 || ((ChartDataView)object).getChartType() == 1) continue;
                    ((ChartDraw)changeable).draw(graphics3);
                }
                graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                if (this.axisDrawOkay) {
                    graphics3.clipRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    this.drawAxes(graphics3, this.xaxes);
                    this.drawAxes(graphics3, this.yaxes);
                    if (!this.fastAction || !this.inAction) {
                        this.drawAxisAnnotationsAndTitle(graphics3, this.xaxes);
                        this.drawAxisAnnotationsAndTitle(graphics3, this.yaxes);
                    }
                    graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                }
                graphics3.clipRect(((Rectangle)serializable).x, ((Rectangle)serializable).y, ((Rectangle)serializable).width, ((Rectangle)serializable).height);
                object = jCChart.getOriginalDataView().iterator();
                while (object.hasNext()) {
                    changeable = (ChartDataView)object.next();
                    ChartDraw chartDraw = (ChartDraw)this.drawables.get(changeable);
                    if (chartDraw == null || ((ChartDataView)changeable).getChartType() == 11 || ((ChartDataView)changeable).getChartType() != 0 && ((ChartDataView)changeable).getChartType() != 1) continue;
                    chartDraw.draw(graphics3);
                }
                graphics3.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        if (graphics2 != null) {
            graphics2.dispose();
        }
        this.rbGC = graphics;
        if (this.handler != null) {
            this.handler.reanimate(this.last.x, this.last.y);
        }
        this.rbGC = null;
        serializable = (JCChart)this.getParent();
        if (((JCChart)serializable).hasChartLabelManager()) {
            ((JCChart)serializable).getChartLabelManager().recalcChangedChartLabels();
        }
        this.setChanged(false, 0);
    }

    JCDataIndex pick(Point point, ChartDataView chartDataView, int n2) {
        Changeable changeable;
        Object object;
        Object object2;
        JCDataIndex jCDataIndex = null;
        ChartDraw chartDraw = null;
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return null;
        }
        if (chartDataView != null) {
            chartDraw = this.getDrawable(chartDataView);
            if (chartDraw != null) {
                jCDataIndex = chartDraw.pick(point, n2 == -1 ? chartDataView.getPickFocus() : n2);
            }
            if (jCDataIndex != null) {
                jCDataIndex.obj = this;
                jCDataIndex.dataView = chartDataView;
            }
            return jCDataIndex;
        }
        List list = jCChart.getOriginalDataView();
        ListIterator listIterator = list.listIterator(list.size());
        while (listIterator.hasPrevious()) {
            object2 = (ChartDataView)listIterator.previous();
            object = this.getDrawable((ChartDataView)object2);
            if (object == null || ((ChartDataView)object2).is3DChartType() || !((ChartDraw)object).drawFront) continue;
            jCDataIndex = this.pickOne((ChartDraw)object, point, n2, jCDataIndex);
        }
        object2 = list.listIterator(list.size());
        while (object2.hasPrevious()) {
            object = (ChartDataView)object2.previous();
            changeable = this.getDrawable((ChartDataView)object);
            if (changeable == null || !((ChartDataView)object).is3DChartType()) continue;
            jCDataIndex = this.pickOne((ChartDraw)changeable, point, n2, jCDataIndex);
        }
        object = list.listIterator(list.size());
        while (object.hasPrevious()) {
            changeable = (ChartDataView)object.previous();
            ChartDraw chartDraw2 = this.getDrawable((ChartDataView)changeable);
            if (chartDraw2 == null || chartDraw2.drawFront || ((ChartDataView)changeable).is3DChartType()) continue;
            jCDataIndex = this.pickOne(chartDraw2, point, n2, jCDataIndex);
        }
        return jCDataIndex;
    }

    private JCDataIndex pickOne(ChartDraw chartDraw, Point point, int n2, JCDataIndex jCDataIndex) {
        JCDataIndex jCDataIndex2 = chartDraw.pick(point, n2 == -1 ? chartDraw.dataObject.getPickFocus() : n2);
        if (jCDataIndex2 != null) {
            jCDataIndex2.obj = this;
            jCDataIndex2.dataView = chartDraw.dataObject;
        }
        if (jCDataIndex == null) {
            jCDataIndex = jCDataIndex2;
        } else if (jCDataIndex2 != null && jCDataIndex.distance > jCDataIndex2.distance) {
            jCDataIndex = jCDataIndex2;
        }
        return jCDataIndex;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void preDraw3DAxes(Graphics graphics, JCAxis jCAxis, JCAxis jCAxis2) {
        block55: {
            block57: {
                block56: {
                    boolean bl;
                    block59: {
                        int n2;
                        block58: {
                            int n3;
                            boolean bl2;
                            block50: {
                                block52: {
                                    block51: {
                                        boolean bl3;
                                        block54: {
                                            block53: {
                                                block49: {
                                                    block48: {
                                                        block47: {
                                                            block46: {
                                                                if (jCAxis == null) return;
                                                                if (jCAxis2 == null) {
                                                                    return;
                                                                }
                                                                bl2 = jCAxis.vertical;
                                                                n2 = jCAxis.getPlacement();
                                                                n3 = jCAxis2.getPlacement();
                                                                if (n2 != 5) break block46;
                                                                if (jCAxis2.getOrigin() == jCAxis2.getMax()) {
                                                                    n2 = 2;
                                                                    break block47;
                                                                } else if (jCAxis2.getOrigin() == jCAxis2.getMin()) {
                                                                    n2 = 1;
                                                                }
                                                                break block47;
                                                            }
                                                            if (n2 == 4) {
                                                                if (jCAxis.getPlacementLocation() == jCAxis2.getMax()) {
                                                                    n2 = 2;
                                                                } else if (jCAxis.getPlacementLocation() == jCAxis2.getMin()) {
                                                                    n2 = 1;
                                                                }
                                                            }
                                                        }
                                                        if (n3 != 5) break block48;
                                                        if (jCAxis.getOrigin() == jCAxis.getMax()) {
                                                            n3 = 2;
                                                            break block49;
                                                        } else if (jCAxis.getOrigin() == jCAxis.getMin()) {
                                                            n3 = 1;
                                                        }
                                                        break block49;
                                                    }
                                                    if (n3 == 4) {
                                                        if (jCAxis2.getPlacementLocation() == jCAxis.getMax()) {
                                                            n3 = 2;
                                                        } else if (jCAxis2.getPlacementLocation() == jCAxis.getMin()) {
                                                            n3 = 1;
                                                        }
                                                    }
                                                }
                                                if (jCAxis.isReversed()) {
                                                    if (n3 == 1) {
                                                        n3 = 2;
                                                    } else if (n3 == 2) {
                                                        n3 = 1;
                                                    }
                                                }
                                                if (jCAxis2.isReversed()) {
                                                    if (n2 == 1) {
                                                        n2 = 2;
                                                    } else if (n2 == 2) {
                                                        n2 = 1;
                                                    }
                                                }
                                                if (jCAxis.visible) {
                                                    jCAxis.preDrawCalc();
                                                }
                                                if (jCAxis2.visible) {
                                                    jCAxis2.preDrawCalc();
                                                }
                                                if (this.deltaX < 0 || this.deltaY >= 0) break block50;
                                                if (n3 != 1 && n3 != 2 && n2 != 1 && n2 != 2) {
                                                    if (jCAxis2.visible) {
                                                        jCAxis2.preDraw(graphics, false, true);
                                                    }
                                                    if (jCAxis.visible) {
                                                        jCAxis.preDraw(graphics, true, false);
                                                    }
                                                    if (!jCAxis2.visible) return;
                                                    jCAxis2.preDraw(graphics, false, false);
                                                    return;
                                                }
                                                if (n3 == 2) break block51;
                                                if (n3 == 2 || n3 == 1) break block52;
                                                if (!bl2) break block53;
                                                if (n2 == 1) break block51;
                                                bl3 = false;
                                                break block54;
                                            }
                                            if (n2 != 2) break block51;
                                            bl3 = false;
                                        }
                                        if (!bl3) break block52;
                                    }
                                    if (jCAxis.visible) {
                                        jCAxis.preDraw(graphics, true, false);
                                    }
                                    if (!jCAxis2.visible) return;
                                    jCAxis2.preDraw(graphics, true, false);
                                    return;
                                }
                                if (jCAxis2.visible) {
                                    jCAxis2.preDraw(graphics, true, false);
                                }
                                if (!jCAxis.visible) return;
                                jCAxis.preDraw(graphics, true, false);
                                return;
                            }
                            if (this.deltaX >= 0 || this.deltaY < 0) break block55;
                            if (n3 != 1 && n3 != 2 && n2 != 1 && n2 != 2) {
                                if (jCAxis2.visible) {
                                    jCAxis.preDraw(graphics, false, false);
                                }
                                if (jCAxis.visible) {
                                    jCAxis2.preDraw(graphics, true, false);
                                }
                                if (!jCAxis2.visible) return;
                                jCAxis.preDraw(graphics, false, true);
                                return;
                            }
                            if (n3 == 1) break block56;
                            if (n3 == 2 || n3 == 1) break block57;
                            if (!bl2) break block58;
                            if (n2 != 1) break block56;
                            bl = false;
                            break block59;
                        }
                        if (n2 == 2) break block56;
                        bl = false;
                    }
                    if (!bl) break block57;
                }
                if (jCAxis.visible) {
                    jCAxis.preDraw(graphics, true, false);
                }
                if (!jCAxis2.visible) return;
                jCAxis2.preDraw(graphics, true, false);
                return;
            }
            if (jCAxis2.visible) {
                jCAxis2.preDraw(graphics, true, false);
            }
            if (!jCAxis.visible) return;
            jCAxis.preDraw(graphics, true, false);
            return;
        }
        if (jCAxis.visible) {
            jCAxis.preDraw(graphics, true, false);
        }
        if (!jCAxis2.visible) return;
        jCAxis2.preDraw(graphics, true, false);
    }

    private void preDrawGrids(Graphics graphics, List list) {
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            JCAxis jCAxis = (JCAxis)list.get(n2);
            if (jCAxis.visible) {
                jCAxis.drawGrid(graphics);
            }
            ++n2;
        }
    }

    public void recalc() {
        JCChart jCChart;
        if (this.getParent() == null) {
            return;
        }
        if (!this.isChanged() && this.isValid()) {
            return;
        }
        this.ensureDrawables();
        if (this.getSize().width <= 0 || this.getSize().height <= 0) {
            return;
        }
        try {
            this.resetPlotArea();
            this.calc3D();
            this.calcLimits();
            this.calcAxisParams(this.xaxes);
            this.calcAxisParams(this.yaxes);
            if (!this.inAction || !this.fastAction) {
                this.calcAnchors(this.xaxes);
                this.calcAnchors(this.yaxes);
                this.makeAnnotations(this.xaxes);
                this.makeAnnotations(this.yaxes);
                this.calcAnnotationExtents(this.xaxes);
                this.calcAnnotationExtents(this.yaxes);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        this.layoutChartArea();
        if (this.checkDeltaValues()) {
            this.layoutChartArea();
        }
        this.calcGraphExtents();
        if (!(this.inAction && this.fastAction || !(jCChart = (JCChart)this.getParent()).hasChartLabelManager())) {
            jCChart.getChartLabelManager().markAllChartLabelsForRecalc();
        }
        this.setChanged(false, 0);
    }

    private void removeAxis(int n2, List list) {
        if (n2 < list.size()) {
            list.remove(n2);
        }
    }

    void removeDrawable(ChartDataView chartDataView) {
        if (this.drawables != null) {
            this.drawables.remove(chartDataView);
        }
    }

    public void repaint() {
        if (this.getSize().width <= 0 || this.getSize().height <= 0) {
            return;
        }
        if (this.inSuperReshape) {
            return;
        }
        super.repaint();
    }

    private void replaceAxis(int n2, List list, JCAxis jCAxis) {
        list.set(n2, jCAxis);
    }

    void reset() {
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        boolean bl = jCChart.isBatched();
        jCChart.setBatched(true);
        if (this.horizActionAxis != null) {
            this.horizActionAxis.min.isDefault = true;
            this.horizActionAxis.max.isDefault = true;
            this.horizActionAxis.setChanged(true, 2, false);
            jCChart.sendEvent(this.horizActionAxis);
        }
        if (this.vertActionAxis != null) {
            this.vertActionAxis.min.isDefault = true;
            this.vertActionAxis.max.isDefault = true;
            this.vertActionAxis.setChanged(true, 2, false);
            jCChart.sendEvent(this.vertActionAxis);
        }
        this.cancel();
        jCChart.setBatched(bl);
    }

    private void resetPlotArea() {
        this.chartAreaRect = this.getDrawingArea();
        if (this.plotArea.top.isDefault) {
            this.plotArea.top.value = 0;
        }
        if (this.plotArea.left.isDefault) {
            this.plotArea.left.value = 0;
        }
        if (this.plotArea.bottom.isDefault) {
            this.plotArea.bottom.value = 0;
        }
        if (this.plotArea.right.isDefault) {
            this.plotArea.right.value = 0;
        }
    }

    public void setAngleUnit(int n2) {
        if (!JCNumberUtil.validUnit(n2)) {
            throw new IllegalArgumentException("Invalid value for AngleUnit.  Must be one of DEGREES, RADIANS or GRADS");
        }
        this.angleUnit = n2;
        this.setChanged(true, 2);
    }

    public void setAxisBoundingBox(boolean bl) {
        if (bl == this.axisBoundingBox) {
            return;
        }
        this.axisBoundingBox = bl;
        this.setChanged(true, 1);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            container.validate();
        }
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        if (n2 == this.getLocation().x && n3 == this.getLocation().y && n4 == this.getSize().width && n5 == this.getSize().height) {
            return;
        }
        this.inSuperReshape = true;
        super.setBounds(n2, n3, n4, n5);
        this.inSuperReshape = false;
        this.changed = true;
        this.changedFlag |= 2;
        this.recalc();
    }

    public void setChanged(boolean bl, int n2) {
        ChartDraw chartDraw;
        Object object;
        JCChart jCChart = (JCChart)this.getParent();
        if (jCChart == null) {
            return;
        }
        this.ensureDrawables();
        Enumeration enumeration = this.drawables.keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            chartDraw = (ChartDraw)this.drawables.get(object);
            chartDraw.setChanged(true, n2, false);
            if (bl) continue;
            chartDraw.dataObject.setChanged(false, 0, false);
        }
        this.changed = bl;
        this.changedFlag = this.changed ? (this.changedFlag |= n2) : n2;
        if (this.changed) {
            if (!jCChart.isBatched()) {
                object = jCChart.getLegend();
                if (object != null && (n2 & 0x20) > 0) {
                    ((JCLegend)object).setChanged(true, 2, false);
                    ((JCLegend)object).recalc();
                }
                if (object != null && (n2 & 0x10) > 0) {
                    ((JCLegend)object).setChanged(true, 1, false);
                }
                if ((n2 & 2) > 0) {
                    this.recalc();
                    jCChart.repaint();
                } else if ((n2 & 1) > 0) {
                    jCChart.repaint();
                }
            }
            return;
        }
        int n3 = 0;
        while (n3 < this.xaxes.size()) {
            chartDraw = this.xaxes.get(n3);
            if (chartDraw != null && chartDraw instanceof JCAxis) {
                ((JCAxis)((Object)chartDraw)).setChanged(false, 0, false);
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < this.yaxes.size()) {
            Object e2 = this.yaxes.get(n4);
            if (e2 != null && e2 instanceof JCAxis) {
                ((JCAxis)e2).setChanged(false, 0, false);
            }
            ++n4;
        }
    }

    public void setDeltaX(int n2) {
        this.deltaX = n2;
    }

    public void setDeltaY(int n2) {
        this.deltaY = n2;
    }

    public void setDepth(int n2) {
        int n3 = (int)JCNumberUtil.clamp((double)n2, 0.0, 500.0);
        if (this.depth == n3) {
            return;
        }
        this.depth = n3;
        this.setChanged(true, 2);
    }

    public void setElevation(int n2) {
        int n3 = (int)JCNumberUtil.clamp((double)n2, -45.0, 45.0);
        if (n3 == this.elevation) {
            return;
        }
        this.elevation = n3;
        this.setChanged(true, 2);
    }

    public void setFastAction(boolean bl) {
        if (bl == this.fastAction) {
            return;
        }
        this.fastAction = bl;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.setChanged(true, 33);
    }

    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
    }

    public void setHorizActionAxis(JCAxis jCAxis) {
        if (jCAxis != null && (jCAxis.vertical || !this.xaxes.contains(jCAxis) && !this.yaxes.contains(jCAxis))) {
            throw new IllegalArgumentException("Invalid horizontal action axis");
        }
        this.horizActionAxis = jCAxis;
    }

    public void setInAction(boolean bl) {
        this.inAction = bl;
    }

    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        this.invalidate();
        Container container = this.getParent();
        if (container != null) {
            container.validate();
        }
    }

    protected void setParentOnAxes(JCChart jCChart) {
        Iterator iterator = ((AbstractList)this.xaxes).iterator();
        while (iterator.hasNext()) {
            ((JCAxis)iterator.next()).setParentChart(jCChart);
        }
        Iterator iterator2 = ((AbstractList)this.yaxes).iterator();
        while (iterator2.hasNext()) {
            ((JCAxis)iterator2.next()).setParentChart(jCChart);
        }
    }

    public void setRotation(int n2) {
        int n3 = (int)JCNumberUtil.clamp((double)n2, -45.0, 45.0);
        if (n3 == this.rotation) {
            return;
        }
        this.rotation = n3;
        this.setChanged(true, 2);
    }

    public void setVertActionAxis(JCAxis jCAxis) {
        if (!(jCAxis == null || jCAxis.vertical && (this.xaxes.contains(jCAxis) || this.yaxes.contains(jCAxis)))) {
            throw new IllegalArgumentException("Invalid vertical action axis");
        }
        this.vertActionAxis = jCAxis;
    }

    public void setXAxes(List list) {
        this.xaxes = new Vector();
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            Object e2 = list.get(n2);
            if (e2 != null && e2 instanceof JCAxis) {
                if (e2 != null) {
                    ((JCAxis)e2).setParentChart((JCChart)this.getParent());
                    ((JCAxis)e2).vertical = false;
                }
                this.xaxes.add(e2);
            }
            ++n2;
        }
        this.setChanged(true, 2);
    }

    public void setXAxis(int n2, JCAxis jCAxis) {
        if (jCAxis == null) {
            if (n2 < 0 || n2 >= this.xaxes.size()) {
                throw new IllegalArgumentException(ERRMSG_INVALID_XAXIS_INDEX);
            }
            this.removeAxis(n2, this.xaxes);
        } else {
            if (n2 < 0 || n2 > this.xaxes.size()) {
                throw new IllegalArgumentException(ERRMSG_INVALID_XAXIS_INDEX);
            }
            if (n2 < this.xaxes.size()) {
                this.removeAxis(n2, this.xaxes);
            }
            jCAxis.setParentChart((JCChart)this.getParent());
            this.addAxis(n2, this.xaxes, jCAxis);
        }
        this.setChanged(true, 2);
    }

    public void setYAxes(List list) {
        this.yaxes = new Vector();
        if (list == null) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            Object e2 = list.get(n2);
            if (e2 != null && e2 instanceof JCAxis) {
                if (e2 != null) {
                    ((JCAxis)e2).setParentChart((JCChart)this.getParent());
                    ((JCAxis)e2).vertical = true;
                }
                this.yaxes.add(e2);
            }
            ++n2;
        }
        this.setChanged(true, 2);
    }

    public void setYAxis(int n2, JCAxis jCAxis) {
        if (jCAxis == null) {
            if (n2 < 0 || n2 >= this.yaxes.size()) {
                throw new IllegalArgumentException(ERRMSG_INVALID_YAXIS_INDEX);
            }
            this.removeAxis(n2, this.yaxes);
        } else {
            if (n2 < 0 || n2 > this.yaxes.size()) {
                throw new IllegalArgumentException(ERRMSG_INVALID_YAXIS_INDEX);
            }
            if (n2 < this.yaxes.size()) {
                this.removeAxis(n2, this.yaxes);
            }
            jCAxis.setParentChart((JCChart)this.getParent());
            this.addAxis(n2, this.yaxes, jCAxis);
        }
        this.setChanged(true, 2);
    }

    void showAction(int n2, int n3) {
        if (this.last.x == n2 && this.last.y == n3) {
            return;
        }
        this.last.x = n2;
        this.last.y = n3;
        this.handler.animate(n2, n3);
    }

    void startAction(EventTrigger eventTrigger, int n2, int n3) {
        this.handler = ActionHandler.makeHandler(eventTrigger.getAction(), this);
        if (this.handler != null) {
            this.handler.start(n2, n3);
        }
    }
}

