/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ErrorDialog;
import com.klg.jclass.chart.EventTrigger;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartEvent;
import com.klg.jclass.chart.JCChartLabel;
import com.klg.jclass.chart.JCChartLabelManager;
import com.klg.jclass.chart.JCChartLegendManager;
import com.klg.jclass.chart.JCChartListener;
import com.klg.jclass.chart.JCChartUI;
import com.klg.jclass.chart.JCCustomizerPage;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCPickEvent;
import com.klg.jclass.chart.JCPickListener;
import com.klg.jclass.chart.JCVersion;
import com.klg.jclass.util.JCListenerList;
import com.klg.jclass.util.JCNumberUtil;
import com.klg.jclass.util.ServerRenderable;
import com.klg.jclass.util.ServerRenderer;
import com.klg.jclass.util.legend.JCGridLegend;
import com.klg.jclass.util.legend.JCLegend;
import com.klg.jclass.util.legend.JCLegendItem;
import com.klg.jclass.util.legend.LegendComponentLayout;
import com.klg.jclass.util.legend.LegendComponentLayoutUser;
import com.klg.jclass.util.swing.JCExitFrame;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToolTip;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.ComponentUI;

public class JCChart
extends JComponent
implements Changeable,
LegendComponentLayoutUser,
ServerRenderable,
Serializable,
KeyListener,
MouseListener,
MouseMotionListener,
AncestorListener {
    private static final String uiClassID = "JCChartUI";
    protected JCChartArea chartArea = null;
    protected JCLegend legend = null;
    protected JCChartLegendManager legendManager = null;
    protected JComponent footer = null;
    protected JComponent header = null;
    protected Vector data = new Vector();
    protected Vector triggers = new Vector();
    protected JCListenerList listeners = null;
    protected JCListenerList pickListeners = null;
    protected JCChartLabelManager chartLabelManager = null;
    protected Applet chartApplet = null;
    private boolean warningOn = true;
    private boolean batched = false;
    private boolean allowUserChanges = false;
    private int dwellPointerX;
    private int dwellPointerY;
    public static final int NONE = -1;
    public static final int PLOT = 0;
    public static final int SCATTER_PLOT = 1;
    public static final int POLAR = 2;
    public static final int RADAR = 3;
    public static final int FILLED_RADAR = 4;
    public static final int HILO = 5;
    public static final int HILO_OPEN_CLOSE = 6;
    public static final int CANDLE = 7;
    public static final int AREA = 8;
    public static final int BAR = 9;
    public static final int STACKING_BAR = 10;
    public static final int PIE = 11;
    public static final int STACKING_AREA = 12;
    public static final int LAST_PREDEFINED_CHART_TYPE = 12;
    public static final String ERRMSG_INVALID_TRIGGER_INDEX = "Invalid EventTrigger index.";
    protected String customizerName = "com.klg.jclass.chart.customizer.ChartCustomizer";
    protected int lineColorIndex;
    protected int symbolColorIndex;
    protected int fillColorIndex;
    protected int symbolShapeIndex;
    private Dimension curSize = new Dimension(-1, -1);
    protected Rectangle chartAreaLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle legendLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle headerLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    protected Rectangle footerLayoutHints = new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private int offset = 5;
    protected int resetKey = 114;
    protected int cancelKey = 99;
    private boolean changed = false;
    private Graphics prevSetGraphics = null;
    public transient JCCustomizerPage customizer = null;

    public JCChart() {
        try {
            this.init();
            ((ChartDataView)this.data.elementAt(0)).setChartType(0);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public JCChart(int n2) {
        this.init();
        ((ChartDataView)this.data.elementAt(0)).setChartType(n2);
    }

    public void addChartListener(JCChartListener jCChartListener) {
        this.listeners = JCListenerList.add(this.listeners, jCChartListener);
    }

    public ChartDataView addDataView(int n2) {
        ChartDataView chartDataView = new ChartDataView();
        this.setDataView(n2, chartDataView);
        return chartDataView;
    }

    public void addNotify() {
        super.addNotify();
        this.moreAddNotify();
    }

    public void addPickListener(JCPickListener jCPickListener) {
        this.pickListeners = JCListenerList.add(this.pickListeners, jCPickListener);
    }

    public EventTrigger addTrigger() {
        EventTrigger eventTrigger = null;
        try {
            EventTrigger eventTrigger2 = new EventTrigger();
            this.triggers.addElement(eventTrigger2);
            eventTrigger = eventTrigger2;
        }
        catch (Exception exception) {}
        return eventTrigger;
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        ((JComponent)ancestorEvent.getSource()).removeAncestorListener(this);
        JCChartLabel jCChartLabel = this.chartLabelManager.getCurrentDwellLabel();
        if (jCChartLabel != null && jCChartLabel.isConnected() || jCChartLabel == null) {
            this.repaint();
        }
    }

    public void cancel() {
        this.chartArea.cancel();
    }

    protected void createChartArea() {
        this.chartArea = new JCChartArea();
        this.add(this.chartArea);
        this.chartArea.setParentOnAxes(this);
    }

    protected void createFooter() {
        this.footer = new JLabel();
        this.footer.setVisible(false);
        this.add(this.footer);
    }

    protected void createHeader() {
        this.header = new JLabel();
        this.header.setVisible(false);
        this.add(this.header);
    }

    protected void createLegend() {
        this.legend = new JCGridLegend();
        this.legendManager = new JCChartLegendManager(this);
        this.legend.setLegendPopulator(this.legendManager);
        this.legend.setLegendRenderer(this.legendManager);
        this.add(this.legend);
    }

    protected Image createLocalImage(int n2, int n3) {
        return this.createImage(n2, n3);
    }

    public JToolTip createToolTip() {
        JToolTip jToolTip = super.createToolTip();
        if (this.chartLabelManager != null) {
            JCChartLabel jCChartLabel = this.chartLabelManager.getCurrentDwellLabel();
            JComponent jComponent = this.chartLabelManager.getCurrentDwellLabelComponent();
            if (jComponent != null) {
                jToolTip.add(jComponent);
                if (jCChartLabel.isConnected()) {
                    jToolTip.addAncestorListener(this);
                    Graphics graphics = this.getGraphics();
                    if (graphics != null) {
                        graphics.setColor(this.getForeground());
                        jCChartLabel.drawConnector(graphics);
                    }
                }
                jComponent.setLocation(0, 0);
                jToolTip.setPreferredSize(jComponent.getPreferredSize());
                return jToolTip;
            }
        }
        return super.createToolTip();
    }

    public void doLayout() {
        try {
            this.performLayout();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    ChartDataView findData(JCAxis jCAxis) {
        if (jCAxis == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.data.size()) {
            ChartDataView chartDataView = (ChartDataView)this.data.elementAt(n2);
            if ((chartDataView.getXAxis() == jCAxis || chartDataView.getYAxis() == jCAxis) && chartDataView.isVisible()) {
                return chartDataView;
            }
            ++n2;
        }
        return null;
    }

    public ChartDataView findDataView(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (this.data == null || this.data.size() == 0) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.data.size()) {
            ChartDataView chartDataView = (ChartDataView)this.data.elementAt(n2);
            if (chartDataView.getName().equals(string)) {
                return chartDataView;
            }
            ++n2;
        }
        return null;
    }

    public EventTrigger findMatchingTrigger(int n2) {
        if (this.triggers == null) {
            return null;
        }
        EventTrigger eventTrigger = null;
        int n3 = 0;
        while (n3 < this.triggers.size()) {
            EventTrigger eventTrigger2 = (EventTrigger)this.triggers.elementAt(n3);
            if (eventTrigger2.modifiers == n2) {
                eventTrigger = eventTrigger2;
                break;
            }
            ++n3;
        }
        return eventTrigger;
    }

    public void firePaint() {
        Enumeration enumeration = JCListenerList.elements(this.listeners);
        while (enumeration.hasMoreElements()) {
            ((JCChartListener)enumeration.nextElement()).paintChart(this);
        }
    }

    public String getAbout() {
        return JCVersion.getVersionString();
    }

    public boolean getAllowUserChanges() {
        return this.allowUserChanges;
    }

    public int getCancelKey() {
        return this.cancelKey;
    }

    public boolean getChanged() {
        return this.chartArea.isChanged() || this.legend.isChanged() || !this.chartArea.isValid() || !this.legend.isValid() || this.header != null && !this.header.isValid() || this.footer != null && !this.footer.isValid();
    }

    public boolean getChanged(int n2) {
        return this.chartArea.isChanged(n2) || this.legend.isChanged(n2) || !this.chartArea.isValid() || !this.legend.isValid() || this.header != null && !this.header.isValid() || this.footer != null && !this.footer.isValid();
    }

    public JCChartArea getChartArea() {
        return this.chartArea;
    }

    public JCChartLabelManager getChartLabelManager() {
        block2: {
            if (this.chartLabelManager != null) break block2;
            try {
                this.chartLabelManager = (JCChartLabelManager)Class.forName("com.klg.jclass.chart.JCDefaultChartLabelManager").newInstance();
                this.chartLabelManager.setParentChart(this);
            }
            catch (Exception exception) {}
        }
        return this.chartLabelManager;
    }

    public JComponent getComponentArea() {
        return this.getChartArea();
    }

    public Component getComponentAt(int n2, int n3) {
        if (!this.contains(n2, n3)) {
            return null;
        }
        int n4 = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        int n5 = 0;
        while (n5 < n4) {
            Component component = componentArray[n5];
            if (component != null) {
                Point point = component.getLocation();
                if (component.isShowing() && component.contains(n2 - point.x, n3 - point.y)) {
                    return component;
                }
            }
            ++n5;
        }
        return this;
    }

    public String getCustomizerName() {
        return this.customizerName;
    }

    public List getDataView() {
        if (this.data == null || this.data.size() == 0) {
            return null;
        }
        return new Vector(this.data);
    }

    public ChartDataView getDataView(int n2) {
        ChartDataView chartDataView = null;
        try {
            chartDataView = (ChartDataView)this.data.get(n2);
        }
        catch (Exception exception) {}
        return chartDataView;
    }

    public Rectangle getDrawingArea() {
        Rectangle rectangle = new Rectangle();
        this.getDrawingArea(rectangle);
        return rectangle;
    }

    public void getDrawingArea(Rectangle rectangle) {
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        rectangle.setBounds(insets.left, insets.top, Math.max(0, this.getSize().width - (insets.left + insets.right)), Math.max(0, this.getSize().height - (insets.top + insets.bottom)));
    }

    public int getDrawingAreaHeight() {
        Insets insets = this.getInsets();
        int n2 = 0;
        if (insets != null) {
            n2 = insets.top + insets.bottom;
        }
        return Math.max(0, this.getSize().height - n2);
    }

    public int getDrawingAreaWidth() {
        Insets insets = this.getInsets();
        int n2 = 0;
        if (insets != null) {
            n2 = insets.left + insets.right;
        }
        return Math.max(0, this.getSize().width - n2);
    }

    public int getFillColorIndex() {
        return this.fillColorIndex;
    }

    public JComponent getFooter() {
        return this.footer;
    }

    public Graphics getGraphics() {
        if (this.prevSetGraphics == null) {
            return super.getGraphics();
        }
        return this.prevSetGraphics;
    }

    public JComponent getHeader() {
        return this.header;
    }

    public Rectangle getLayoutHints(JComponent jComponent) {
        if (jComponent == null) {
            return new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        if (jComponent == this.chartArea) {
            return this.chartAreaLayoutHints;
        }
        if (jComponent == this.legend) {
            return this.legendLayoutHints;
        }
        if (jComponent == this.header) {
            return this.headerLayoutHints;
        }
        if (jComponent == this.footer) {
            return this.footerLayoutHints;
        }
        return new Rectangle(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public JCLegend getLegend() {
        return this.legend;
    }

    public int getLineColorIndex() {
        return this.lineColorIndex;
    }

    public int getNumData() {
        int n2 = 0;
        try {
            if (this.data != null) {
                n2 = this.data.size();
            }
        }
        catch (Exception exception) {}
        return n2;
    }

    public int getNumTriggers() {
        int n2 = 0;
        try {
            if (this.triggers != null) {
                n2 = this.triggers.size();
            }
        }
        catch (Exception exception) {}
        return n2;
    }

    protected List getOriginalDataView() {
        return this.data;
    }

    public int getResetKey() {
        return this.resetKey;
    }

    public Object getSource() {
        return this;
    }

    public int getSymbolColorIndex() {
        return this.symbolColorIndex;
    }

    public int getSymbolShapeIndex() {
        return this.symbolShapeIndex;
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        Point point;
        if (this.chartLabelManager != null && (point = this.chartLabelManager.getCurrentDwellLabelAttachPoint()) != null) {
            return point;
        }
        return super.getToolTipLocation(mouseEvent);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n2;
        int n3 = mouseEvent.getX();
        Component component = this.getComponentAt(n3, n2 = mouseEvent.getY());
        if (component instanceof JCChartArea && this.chartLabelManager != null) {
            if (this.chartLabelManager.locateCurrentDwellLabel(n3, n2)) {
                return "";
            }
            return super.getToolTipText(mouseEvent);
        }
        return super.getToolTipText(mouseEvent);
    }

    public EventTrigger getTrigger(int n2) {
        EventTrigger eventTrigger = null;
        try {
            eventTrigger = (EventTrigger)this.triggers.elementAt(n2);
        }
        catch (Exception exception) {}
        return eventTrigger;
    }

    public JCChartUI getUI() {
        return (JCChartUI)this.ui;
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public boolean hasChartLabelManager() {
        return this.chartLabelManager != null;
    }

    protected void init() {
        this.setOpaque(true);
        super.setLayout(new LegendComponentLayout());
        this.createHeader();
        this.createFooter();
        this.createLegend();
        this.createChartArea();
        this.resetDefaults();
        this.addDataView(0);
        this.enableEvents(8L);
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.registerUI();
        this.updateUI();
    }

    public boolean isBatched() {
        return this.batched;
    }

    public final boolean isChanged() {
        return this.getChanged();
    }

    public final boolean isChanged(int n2) {
        return this.getChanged(n2);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isWarningDialog() {
        return this.warningOn;
    }

    public void keyPressed(KeyEvent keyEvent) {
        char c2 = keyEvent.getKeyChar();
        if (c2 == this.resetKey) {
            this.reset();
        } else if (c2 == this.cancelKey) {
            this.cancel();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    protected void launchPropertyPage(Point point) {
        if (!this.allowUserChanges) {
            return;
        }
        if (this.customizer == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                Class<?> clazz = Class.forName(this.getCustomizerName());
                JCCustomizerPage jCCustomizerPage = (JCCustomizerPage)clazz.newInstance();
                jCCustomizerPage.init();
                this.customizer = jCCustomizerPage;
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
                this.customizer = null;
                ErrorDialog.raise(this, String.valueOf(JCChartBundle.string("com.klg.jclass.chart.Key20")) + "\n" + exception);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
        if (this.customizer != null) {
            this.customizer.setObject(this);
            this.customizer.launch();
        }
    }

    public static void main(String[] stringArray) {
        JCExitFrame jCExitFrame = new JCExitFrame(JCChartBundle.string("com.klg.jclass.chart.Key5"));
        JCChart jCChart = new JCChart();
        jCChart.setAllowUserChanges(true);
        jCChart.setTrigger(0, new EventTrigger(4, 6));
        jCExitFrame.getContentPane().setLayout(new GridLayout(1, 1));
        jCExitFrame.getContentPane().add(jCChart);
        jCExitFrame.pack();
        ((Component)jCExitFrame).setSize(500, 300);
        jCExitFrame.show();
    }

    public static JCChart makeChart(String string) {
        JCChart jCChart = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            jCChart = (JCChart)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            jCChart = null;
        }
        return jCChart;
    }

    protected void moreAddNotify() {
        this.doLayout();
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (this.chartArea.getActionHandler() == null) {
            return;
        }
        this.chartArea.showAction(n2 - this.chartArea.getLocation().x, n3 - this.chartArea.getLocation().y);
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        EventTrigger eventTrigger;
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (!mouseEvent.isMetaDown() && (mouseEvent.getModifiers() & 8) == 0 && this.isFocusTraversable()) {
            this.requestFocus();
        }
        if ((eventTrigger = this.findMatchingTrigger(mouseEvent.getModifiers())) != null) {
            if (!(this.allowUserChanges || eventTrigger.action != 3 && eventTrigger.action != 6)) {
                return;
            }
            if (eventTrigger.action == 4) {
                this.sendPickEvent(this.pick(new Point(n2, n3), null));
            } else if (eventTrigger.action == 6) {
                this.launchPropertyPage(new Point(n2, n3));
            } else if (eventTrigger.action != -1 && this.getComponentAt(n2, n3) == this.chartArea) {
                this.chartArea.startAction(eventTrigger, n2 - this.chartArea.getLocation().x, n3 - this.chartArea.getLocation().y);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n2 = mouseEvent.getX();
        int n3 = mouseEvent.getY();
        if (this.chartArea.getActionHandler() != null) {
            this.chartArea.endAction(n2 - this.chartArea.getLocation().x, n3 - this.chartArea.getLocation().y);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.firePaint();
    }

    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (this.chartLabelManager != null) {
            this.chartLabelManager.paintConnectors(graphics);
        }
    }

    public void paintComponent(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Graphics graphics2 = graphics.create();
        if (this.isOpaque()) {
            if (!graphics2.getColor().equals(this.getBackground())) {
                graphics2.setColor(this.getBackground());
            }
            Rectangle rectangle = this.getBounds();
            graphics2.fillRect(0, 0, rectangle.width, rectangle.height);
        }
        if (graphics2 != null) {
            graphics2.dispose();
        }
        this.setChanged(false, 0);
    }

    private void performLayout() {
        Dimension dimension = new Dimension();
        dimension.width = this.getDrawingAreaWidth();
        dimension.height = this.getDrawingAreaHeight();
        if (dimension.width <= 0 || dimension.height <= 0) {
            return;
        }
        Insets insets = this.getInsets();
        if (!this.chartArea.isChanged(8) && this.chartArea.isValid() && dimension.width == this.curSize.width && dimension.height == this.curSize.height && !this.legend.isChanged(2) && !this.legend.isChanged(8) && this.legend.isValid() && this.header != null && this.header.isValid() && this.footer != null && this.footer.isValid()) {
            if (this.chartArea.isChanged(2) || !this.chartArea.isValid()) {
                this.recalc();
            }
            this.repaint();
            return;
        }
        this.recalc();
        if (this.chartLabelManager != null) {
            this.chartLabelManager.markAllChartLabelsForRecalc();
        }
        this.curSize = dimension;
        super.doLayout();
        this.repaint();
    }

    public JCDataIndex pick(Point point, ChartDataView chartDataView) {
        Component component = this.getComponentAt(point.x, point.y);
        if (component == null) {
            return null;
        }
        Point point2 = new Point(point.x - component.getLocation().x, point.y - component.getLocation().y);
        if (component instanceof JCLegend) {
            return this.pickLegend(point2, chartDataView);
        }
        if (component instanceof JCChartArea) {
            return this.chartArea.pick(point2, chartDataView, -1);
        }
        if (component != null) {
            JCDataIndex jCDataIndex = new JCDataIndex(-1, null, -1);
            jCDataIndex.obj = component;
            return jCDataIndex;
        }
        return null;
    }

    JCDataIndex pickLegend(Point point, ChartDataView chartDataView) {
        JCLegendItem jCLegendItem = this.legend.pick(point);
        JCDataIndex jCDataIndex = null;
        jCDataIndex = new JCDataIndex(-1, null, -1);
        jCDataIndex.obj = this.legend;
        if (jCLegendItem == null) {
            return jCDataIndex;
        }
        JCDataIndex jCDataIndex2 = (JCDataIndex)jCLegendItem.itemInfo;
        ChartDataView chartDataView2 = jCDataIndex2.getDataView();
        if (chartDataView != null && chartDataView2 != chartDataView) {
            return jCDataIndex;
        }
        jCDataIndex.dataView = chartDataView2;
        jCDataIndex.series = jCDataIndex2.getSeries();
        jCDataIndex.seriesIndex = jCDataIndex2.getSeriesIndex();
        return jCDataIndex;
    }

    public void printAll(Graphics graphics) {
        super.printAll(graphics);
    }

    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        int n2 = keyEvent.getID();
        switch (n2) {
            case 401: {
                this.keyPressed(keyEvent);
                break;
            }
            case 402: {
                this.keyReleased(keyEvent);
                break;
            }
            case 400: {
                this.keyTyped(keyEvent);
                break;
            }
        }
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        super.processMouseEvent(mouseEvent);
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n2 = mouseEvent.getID();
        switch (n2) {
            case 501: {
                this.mousePressed(mouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(mouseEvent);
                break;
            }
            case 500: {
                this.mouseClicked(mouseEvent);
                break;
            }
            case 505: {
                this.mouseExited(mouseEvent);
                break;
            }
            case 504: {
                this.mouseEntered(mouseEvent);
                break;
            }
        }
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
        if (mouseEvent.isConsumed()) {
            return;
        }
        int n2 = mouseEvent.getID();
        switch (n2) {
            case 503: {
                this.mouseMoved(mouseEvent);
                break;
            }
            case 506: {
                this.mouseDragged(mouseEvent);
                break;
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            this.registerUI();
            objectInputStream.defaultReadObject();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void recalc() {
        if (!this.isChanged(2)) {
            return;
        }
        try {
            this.chartArea.recalc();
            this.legend.recalc();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        this.setChanged(false, 0);
    }

    public void registerUI() {
        UIManager.getDefaults().put(uiClassID, "com.klg.jclass.chart.JCChartUI");
    }

    public void removeChartListener(JCChartListener jCChartListener) {
        this.listeners = JCListenerList.remove(this.listeners, jCChartListener);
    }

    public void removeDataView(int n2) {
        try {
            this.chartArea.removeDrawable((ChartDataView)this.data.elementAt(n2));
            this.data.remove(n2);
            this.reorderDataViews();
            this.setChanged(true, 548);
        }
        catch (Exception exception) {}
    }

    public void removePickListener(JCPickListener jCPickListener) {
        this.pickListeners = JCListenerList.remove(this.pickListeners, jCPickListener);
    }

    public void removeTrigger(int n2) {
        try {
            this.triggers.removeElementAt(n2);
        }
        catch (Exception exception) {}
    }

    void reorderDataViews() {
        int n2 = 0;
        while (n2 < this.data.size()) {
            ChartDataView chartDataView = (ChartDataView)this.data.elementAt(n2);
            chartDataView.setDrawingOrder(n2);
            ++n2;
        }
    }

    public void requestFocus() {
        super.requestFocus();
        if (this.isFocusTraversable()) {
            this.processEvent(new FocusEvent(this, 1004));
        }
    }

    public void reset() {
        this.chartArea.reset();
    }

    public void resetDefaults() {
        this.lineColorIndex = 0;
        this.fillColorIndex = 0;
        this.symbolColorIndex = 0;
        this.symbolShapeIndex = 1;
    }

    public void rotate() {
    }

    public void rotateEnd() {
    }

    public void rotateStart() {
    }

    public void scale(double d2, JCAxis jCAxis, boolean bl) {
        if (jCAxis == null) {
            return;
        }
        jCAxis.min.value /= d2;
        jCAxis.min.isDefault = false;
        jCAxis.max.value /= d2;
        jCAxis.max.isDefault = false;
        jCAxis.setChanged(true, 2, false);
        this.sendEvent(jCAxis);
        if (bl) {
            this.chartArea.setChanged(true, 2);
        }
    }

    void sendEvent(JCAxis jCAxis) {
        JCChartEvent jCChartEvent = new JCChartEvent(this, jCAxis);
        Enumeration enumeration = JCListenerList.elements(this.listeners);
        while (enumeration.hasMoreElements()) {
            ((JCChartListener)enumeration.nextElement()).changeChart(jCChartEvent);
        }
    }

    public void sendPickEvent(JCDataIndex jCDataIndex) {
        JCPickEvent jCPickEvent = new JCPickEvent(this, jCDataIndex);
        Enumeration enumeration = JCListenerList.elements(this.pickListeners);
        while (enumeration.hasMoreElements()) {
            ((JCPickListener)enumeration.nextElement()).pick(jCPickEvent);
        }
    }

    public void serverPaint(Graphics graphics) {
        ServerRenderer.paintComponent(graphics, this);
    }

    public Image serverSnapshot() {
        return ServerRenderer.snapshot(this);
    }

    public void setAbout(String string) {
    }

    public void setAllowUserChanges(boolean bl) {
        this.allowUserChanges = bl;
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.setChanged(true, 514);
    }

    public void setBatched(boolean bl) {
        if (this.batched == bl) {
            return;
        }
        this.batched = bl;
        if (!bl) {
            this.update();
        }
    }

    public void setCancelKey(int n2) {
        this.cancelKey = n2;
    }

    public void setChanged(boolean bl, int n2) {
        if (bl == this.changed) {
            return;
        }
        this.changed = bl;
        if (this.changed) {
            int n3 = 0;
            if ((n2 & 0x20) > 0) {
                n3 |= 2;
            }
            if ((n2 & 0x10) > 0) {
                n3 |= 1;
            }
            if (n3 != 0) {
                this.legend.setChanged(true, n3, false);
            }
            int n4 = 0;
            if ((n2 & 4) > 0) {
                n4 |= 2;
            }
            if ((n2 & 0x200) > 0) {
                n4 |= 2;
            }
            if ((n2 & 0x100) > 0) {
                n4 |= 1;
            }
            if (n4 != 0) {
                this.chartArea.setChanged(true, n4, false);
            }
            if (this.isBatched()) {
                this.invalidate();
            } else if ((n2 & 2) > 0 || (n2 & 4) > 0) {
                this.update();
            } else if ((n2 & 1) > 0) {
                this.repaint();
            }
        }
    }

    public void setChanged(boolean bl, int n2, boolean bl2) {
        if (bl2) {
            this.setChanged(bl, n2);
        } else {
            this.changed = bl;
        }
    }

    public void setChartArea(JCChartArea jCChartArea) {
        if (jCChartArea == null) {
            return;
        }
        if (this.chartArea != null) {
            this.remove(this.chartArea);
        }
        this.chartArea = jCChartArea;
        this.add(this.chartArea);
        this.setChanged(true, 548);
    }

    public void setChartLabelManager(JCChartLabelManager jCChartLabelManager) {
        if (this.chartLabelManager != jCChartLabelManager) {
            this.chartLabelManager = jCChartLabelManager;
            this.chartLabelManager.setParentChart(this);
        }
    }

    public void setCustomizerName(String string) {
        if (string == null) {
            return;
        }
        this.customizerName = string;
    }

    public void setDataView(int n2, ChartDataView chartDataView) {
        if (n2 < 0 || n2 > this.data.size()) {
            throw new IllegalArgumentException("Invalid ChartDataView index in JCChart");
        }
        if (chartDataView != null) {
            chartDataView.setParent(this);
        }
        if (n2 >= 0 && n2 < this.data.size()) {
            this.data.set(n2, chartDataView);
        } else {
            this.data.add(n2, chartDataView);
        }
        this.reorderDataViews();
        this.chartArea.clearDrawables();
        this.setChanged(true, 548);
    }

    public void setDataView(List list) {
        this.data = new Vector();
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ChartDataView chartDataView = (ChartDataView)iterator.next();
            if (chartDataView != null) {
                chartDataView.setParent(this);
            }
            this.data.add(chartDataView);
        }
        this.chartArea.clearDrawables();
        this.setChanged(true, 548);
    }

    public void setFillColorIndex(int n2) {
        this.fillColorIndex = n2;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.setChanged(true, 546);
    }

    public void setFooter(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        if (this.footer != null) {
            this.remove(this.footer);
        }
        this.footer = jComponent;
        this.add(this.footer);
        this.setChanged(true, 548);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.setChanged(true, 546);
    }

    public void setGraphics(Graphics graphics) {
        this.prevSetGraphics = graphics;
        this.getChartArea().setGraphics(graphics);
        this.getLegend().setGraphics(graphics);
    }

    public void setHeader(JComponent jComponent) {
        if (jComponent == null) {
            return;
        }
        if (this.header != null) {
            this.remove(this.header);
        }
        this.header = jComponent;
        this.add(this.header);
        this.setChanged(true, 548);
    }

    public void setLayout(LayoutManager layoutManager) {
        boolean bl = true;
        if (bl) {
            super.setLayout(layoutManager);
        }
    }

    public void setLayoutHints(JComponent jComponent, Rectangle rectangle) {
        if (jComponent == null) {
            return;
        }
        if (jComponent == this.chartArea) {
            this.chartAreaLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (jComponent == this.legend) {
            this.legendLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (jComponent == this.header) {
            this.headerLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (jComponent == this.footer) {
            this.footerLayoutHints = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        jComponent.invalidate();
        this.validate();
    }

    public void setLegend(JCLegend jCLegend) {
        if (jCLegend == null) {
            return;
        }
        if (this.legend != null) {
            this.remove(this.legend);
        }
        this.legend = jCLegend;
        if (this.legend.getLegendPopulator() == null) {
            this.legend.setLegendPopulator(this.legendManager);
        }
        if (this.legend.getLegendRenderer() == null) {
            this.legend.setLegendRenderer(this.legendManager);
        }
        this.add(this.legend);
        this.setChanged(true, 548);
    }

    public void setLineColorIndex(int n2) {
        this.lineColorIndex = n2;
    }

    public void setOpaque(boolean bl) {
        super.setOpaque(bl);
        this.setChanged(true, 1);
    }

    public void setResetKey(int n2) {
        this.resetKey = n2;
    }

    public void setSymbolColorIndex(int n2) {
        this.symbolColorIndex = n2;
    }

    public void setSymbolShapeIndex(int n2) {
        this.symbolShapeIndex = n2;
    }

    public void setTrigger(int n2, EventTrigger eventTrigger) {
        if (this.triggers == null) {
            return;
        }
        if (eventTrigger == null) {
            if (n2 < 0 || n2 >= this.triggers.size()) {
                throw new IllegalArgumentException(ERRMSG_INVALID_TRIGGER_INDEX);
            }
            this.removeTrigger(n2);
        } else {
            if (n2 < 0 || n2 > this.triggers.size()) {
                throw new IllegalArgumentException(ERRMSG_INVALID_TRIGGER_INDEX);
            }
            this.triggers.insertElementAt(eventTrigger, n2);
        }
    }

    public void setUI(ComponentUI componentUI) {
        super.setUI(componentUI);
    }

    public void setWarningDialog(boolean bl) {
        if (this.warningOn == bl) {
            return;
        }
        this.warningOn = bl;
    }

    public Image snapshot() {
        return this.snapshot(2);
    }

    public Image snapshot(int n2) {
        Image image;
        try {
            image = new BufferedImage(this.getSize().width, this.getSize().height, n2);
        }
        catch (Exception exception) {
            image = this.createImage(this.getSize().width, this.getSize().height);
        }
        this.snapshot(image);
        return image;
    }

    public void snapshot(Image image) {
        if (image != null) {
            Graphics graphics = image.getGraphics();
            graphics.setClip(0, 0, this.getSize().width, this.getSize().height);
            this.paint(graphics);
        }
    }

    public void translate(double d2, JCAxis jCAxis, boolean bl) {
        if (jCAxis == null) {
            return;
        }
        jCAxis.translate(d2);
        this.sendEvent(jCAxis);
        if (bl) {
            this.chartArea.setChanged(true, 2);
        }
    }

    public void translateStart(JCAxis jCAxis) {
        if (jCAxis == null) {
            return;
        }
        jCAxis.min.isDefault = false;
        jCAxis.max.isDefault = false;
        this.sendEvent(jCAxis);
        jCAxis.setChanged(true, 2, false);
    }

    public Point unpick(int n2, ChartDataViewSeries chartDataViewSeries) {
        if (chartDataViewSeries == null) {
            return null;
        }
        return this.unpick(chartDataViewSeries.getParent(), n2, chartDataViewSeries.getParent().getSeriesIndex(chartDataViewSeries));
    }

    public Point unpick(ChartDataView chartDataView, int n2, int n3) {
        Serializable serializable;
        if (n3 == -1) {
            return null;
        }
        if (n3 >= 0) {
            serializable = chartDataView.getSeries(n3);
            int n4 = serializable.getFirstPoint();
            int n5 = serializable.getLastPoint();
            if (n2 < n4 || n2 > n5) {
                return null;
            }
        }
        if ((serializable = this.chartArea.getDrawable(chartDataView).unpick(n2, n3)) != null) {
            Point point = this.chartArea.getLocation();
            ((Point)serializable).x += point.x;
            ((Point)serializable).y += point.y;
            Rectangle rectangle = this.chartArea.getDrawingArea();
            ((Point)serializable).x += rectangle.x;
            ((Point)serializable).y += rectangle.y;
        }
        return serializable;
    }

    public void update() {
        this.invalidate();
        if (!this.isShowing()) {
            return;
        }
        this.validate();
    }

    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    public void zoom(double d2, double d3, JCAxis jCAxis, boolean bl) {
        if (jCAxis == null) {
            return;
        }
        double d4 = JCNumberUtil.calcError(jCAxis.precision.value);
        double d5 = 0.0;
        d5 = jCAxis.logarithmic ? Math.abs(JCNumberUtil.log10(d2) - JCNumberUtil.log10(d3)) : Math.abs(d2 - d3);
        if (d5 < d4) {
            return;
        }
        if (d2 > d3) {
            double d6 = d2;
            d2 = d3;
            d3 = d6;
        }
        jCAxis.min.value = d2;
        jCAxis.min.isDefault = false;
        jCAxis.max.value = d3;
        jCAxis.max.isDefault = false;
        jCAxis.setChanged(true, 2, false);
        this.sendEvent(jCAxis);
        if (bl) {
            this.chartArea.setChanged(true, 2);
        }
    }
}

