/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.util.JCNumberUtil;
import java.io.Serializable;

public class JCAxisFormula
implements Serializable {
    private JCAxis originator = null;
    private JCAxis parent = null;
    protected double constant = 0.0;
    protected double multiplier = 1.0;

    JCAxisFormula() {
    }

    JCAxisFormula(JCAxis jCAxis) {
        this.parent = jCAxis;
    }

    void calcRelatedParams() {
        double d2;
        if (this.originator == null) {
            return;
        }
        if (this.multiplier == 0.0) {
            return;
        }
        double d3 = d2 = this.multiplier < 0.0 ? -this.multiplier : this.multiplier;
        if (this.parent.vertical != this.originator.vertical) {
            this.parent.vertical = this.originator.vertical;
            this.parent.setInitialSize();
        }
        this.parent.reversed = this.originator.reversed;
        if (this.parent.tickSpacing.isDefault && this.parent.numSpacing.isDefault) {
            this.parent.numSpacing.value = this.originator.numSpacing.value * d2;
            this.parent.numSpacing.value = JCNumberUtil.precCorrect(this.parent.precision.value, this.parent.numSpacing.value);
            if (this.parent.tickSpacing.isDefault) {
                this.parent.tickSpacing.value = this.parent.numSpacing.value / 2.0;
            }
        } else if (this.parent.tickSpacing.isDefault) {
            this.parent.tickSpacing.value = this.parent.numSpacing.value / 2.0;
        } else if (this.parent.numSpacing.isDefault) {
            this.parent.numSpacing.value = this.parent.tickSpacing.value * 2.0;
        }
        if (this.multiplier > 0.0) {
            if (this.parent.min.isDefault) {
                this.parent.min.value = this.originator.min.value * this.multiplier + this.constant;
            } else if (this.originator.min.isDefault) {
                this.originator.min.value = (this.parent.min.value - this.constant) / this.multiplier;
            }
            if (this.parent.max.isDefault) {
                this.parent.max.value = this.originator.max.value * this.multiplier + this.constant;
            } else if (this.originator.max.isDefault) {
                this.originator.max.value = (this.parent.max.value - this.constant) / this.multiplier;
            }
        } else {
            if (this.parent.max.isDefault) {
                this.parent.max.value = this.originator.min.value * this.multiplier + this.constant;
            } else if (this.originator.max.isDefault) {
                this.originator.max.value = (this.parent.min.value - this.constant) / this.multiplier;
            }
            if (this.parent.min.isDefault) {
                this.parent.min.value = this.originator.max.value * this.multiplier + this.constant;
            } else if (this.originator.min.isDefault) {
                this.originator.min.value = (this.parent.max.value - this.constant) / this.multiplier;
            }
        }
    }

    public double getConstant() {
        return this.constant;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public JCAxis getOriginator() {
        return this.originator;
    }

    public JCAxis getParent() {
        return this.parent;
    }

    public void setConstant(double d2) {
        if (this.constant == d2) {
            return;
        }
        this.constant = d2;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public void setMultiplier(double d2) {
        if (this.multiplier == d2) {
            return;
        }
        this.multiplier = d2;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }

    public void setOriginator(JCAxis jCAxis) {
        if (this.originator == jCAxis) {
            return;
        }
        if (this.originator == this.parent) {
            throw new IllegalArgumentException("JCAxis cannot be related to itself");
        }
        this.originator = jCAxis;
        if (this.parent != null) {
            this.parent.setChanged(true, 2);
        }
    }
}

