/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AnnotationHandler;
import com.klg.jclass.chart.AxisHandler;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartInteriorRegion;
import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.DerivedDouble;
import com.klg.jclass.chart.DerivedInt;
import com.klg.jclass.chart.DerivedString;
import com.klg.jclass.chart.ErrorDialog;
import com.klg.jclass.chart.Extents;
import com.klg.jclass.chart.JCAxisFormula;
import com.klg.jclass.chart.JCAxisTitle;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLabelGenerator;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCValueLabel;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComponent;

public class JCAxis
extends ChartInteriorRegion
implements Serializable {
    protected int gap = 3;
    protected JCAxisTitle title = null;
    protected DerivedDouble min = new DerivedDouble(0.0, true);
    protected DerivedDouble max = new DerivedDouble(0.0, true);
    protected DerivedDouble origin = new DerivedDouble(0.0, true);
    protected DerivedInt originPlacement = new DerivedInt(0, true);
    protected DerivedInt placement = new DerivedInt(0, true);
    protected JCChartStyle gridStyle;
    protected DerivedDouble gridSpacing = new DerivedDouble(0.0, true);
    protected boolean gridVisible = false;
    protected JCAxisFormula formula = null;
    protected boolean editable = true;
    protected boolean logarithmic = false;
    protected boolean reversed = false;
    protected boolean vertical = false;
    protected int annotationRotation = 0;
    protected JCAxis placementAxis = null;
    protected double placementLocation = 0.0;
    protected JCLabelGenerator labelGenerator = null;
    protected boolean decimalPadded = true;
    protected int savedXAxisAnnotationMethod;
    protected long timeUnit = 1000L;
    protected Date timeBase = null;
    protected DerivedString timeFormat = new DerivedString("", true);
    protected Polygon sideplane;
    protected int tickLength = 4;
    protected JCChartArea chartArea = null;
    protected double step = 1.0;
    public static final long SECONDS = 1000L;
    public static final long MINUTES = 60000L;
    public static final long HOURS = 3600000L;
    public static final long DAYS = 86400000L;
    public static final long WEEKS = 604800000L;
    public static final long MONTHS = 2678400000L;
    public static final long YEARS = 31536000000L;
    protected MinMax dataLimits = null;
    protected DerivedInt precision = new DerivedInt(1, true);
    protected static final int MAX_PRECISION = 14;
    protected int maximumPrecision = 14;
    protected DerivedDouble numSpacing = new DerivedDouble(0.0, true);
    protected int logIncrement = 1;
    protected DerivedDouble tickSpacing = new DerivedDouble(0.0, true);
    public static final int AUTOMATIC = 0;
    public static final int MIN = 1;
    public static final int MAX = 2;
    public static final int ZERO = 3;
    public static final int VALUE_ANCHORED = 4;
    public static final int ORIGIN = 5;
    public static final int VALUE = 0;
    public static final int VALUE_LABELS = 1;
    public static final int TIME_LABELS = 2;
    public static final int POINT_LABELS = 3;
    protected int annotationMethod = 0;
    public static final int ROTATE_NONE = 0;
    public static final int ROTATE_90 = 1;
    public static final int ROTATE_180 = 2;
    public static final int ROTATE_270 = 3;
    protected transient int chartType;
    protected transient boolean isPrimary;
    protected transient JCAxis otherAxis;
    private transient AxisHandler axisHandler = null;
    protected AnnotationHandler annoHandler = new AnnotationHandler(this);
    private boolean axisDrawn = false;
    private static int axisNum = 0;
    private boolean hasBar = false;
    boolean frontPlane = true;
    static final int TROUGH_TOP = 1;
    static final int TROUGH_BOTTOM = 2;
    static final int TROUGH_LEFT = 1;
    static final int TROUGH_RIGHT = 2;

    public JCAxis() {
        this.init();
    }

    public JCAxis(JCChartArea jCChartArea, boolean bl, int n2) {
        this.vertical = bl;
        this.annotationMethod = n2;
        this.chartArea = jCChartArea;
        this.init();
    }

    public void addValueLabel(JCValueLabel jCValueLabel) {
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < this.annoHandler.userValueLabels.size()) {
            JCValueLabel jCValueLabel2 = (JCValueLabel)this.annoHandler.userValueLabels.elementAt(n4);
            if (jCValueLabel2.value > jCValueLabel.value && n3 < 0) {
                n3 = n4;
                break;
            }
            if (jCValueLabel2.value == jCValueLabel.value) {
                n2 = n4;
                break;
            }
            ++n4;
        }
        if (n2 >= 0) {
            this.annoHandler.userValueLabels.setElementAt(jCValueLabel, n2);
        } else if (n3 >= 0) {
            this.annoHandler.userValueLabels.insertElementAt(jCValueLabel, n3);
        } else {
            this.annoHandler.userValueLabels.addElement(jCValueLabel);
        }
        jCValueLabel.setParent(this);
        this.setChanged(true, 2);
    }

    void adjustForOrthoExtent() {
        if (!this.visible) {
            return;
        }
        if (this.annoHandler.realPlacement == 1 || this.annoHandler.realPlacement == 2) {
            return;
        }
        if (this.placementAxis == null) {
            return;
        }
        Rectangle rectangle = this.chartArea.getPlotRect();
        Rectangle rectangle2 = this.chartArea.getChartAreaRect();
        if (this.vertical) {
            int n2 = this.annoHandler.realPlacement == 4 ? this.placementAxis.toPixel(this.placementLocation) : this.placementAxis.toPixel(this.placementAxis.origin.value);
            if (n2 < this.placementAxis.getLeft() || n2 > this.placementAxis.getLeft() + this.placementAxis.getWidth()) {
                return;
            }
            if (n2 < this.annoHandler.extents.ortho) {
                if (this.chartArea.getPlotArea().getLeftIsDefault()) {
                    int n3 = this.annoHandler.extents.ortho - n2;
                    rectangle.width -= n3;
                    rectangle.x += n3;
                }
                this.setSize(this.annoHandler.extents.ortho, this.getHeight());
            } else if (rectangle2.width - n2 < this.annoHandler.extents.ortho) {
                if (this.chartArea.getPlotArea().getRightIsDefault()) {
                    int n4 = this.annoHandler.extents.ortho - (rectangle2.width - n2);
                    rectangle.width -= n4;
                }
                this.setSize(this.annoHandler.extents.ortho, this.getHeight());
            }
        } else {
            int n5 = this.annoHandler.realPlacement == 4 ? this.placementAxis.toPixel(this.placementLocation) : this.placementAxis.toPixel(this.placementAxis.origin.value);
            if (n5 < this.placementAxis.getTop() || n5 > this.placementAxis.getTop() + this.placementAxis.getHeight()) {
                return;
            }
            if (rectangle2.height - n5 < this.annoHandler.extents.ortho) {
                if (this.chartArea.getPlotArea().getBottomIsDefault()) {
                    int n6 = this.annoHandler.extents.ortho - (rectangle2.height - n5);
                    rectangle.height -= n6;
                }
                this.setSize(this.getWidth(), this.annoHandler.extents.ortho);
            } else if (n5 < this.annoHandler.extents.ortho) {
                if (this.chartArea.getPlotArea().getTopIsDefault()) {
                    int n7 = this.annoHandler.extents.ortho - n5;
                    rectangle.height -= n7;
                    rectangle.y += n7;
                }
                this.setSize(this.getWidth(), this.annoHandler.extents.ortho);
            }
        }
    }

    void calcAnchors() {
        if (!this.visible) {
            return;
        }
        this.annoHandler.calcAnchor();
        if (this.title.visible) {
            this.title.recalc(true);
            this.title.fixPlacement(this);
        }
    }

    void calcAnnotationExtents() {
        this.annoHandler.calcAnnotationExtents();
    }

    void calcAxisParams(boolean bl) {
        boolean bl2;
        this.setInitialSize();
        this.chartType = -1;
        JCAxis jCAxis = this;
        boolean bl3 = bl2 = this.formula != null && this.formula.getOriginator() != null;
        if (bl2) {
            jCAxis = this.formula.getOriginator();
        }
        this.hasBar = false;
        boolean bl4 = false;
        Iterator iterator = this.getParentChart().getOriginalDataView().iterator();
        while (iterator.hasNext()) {
            int n2;
            ChartDataView chartDataView = (ChartDataView)iterator.next();
            if (chartDataView.getXAxis() == jCAxis) {
                n2 = chartDataView.getChartType();
                if (!bl4) {
                    this.chartType = n2;
                    this.isPrimary = bl2 ^ true;
                    this.otherAxis = chartDataView.getYAxis();
                    bl4 = true;
                }
                if (!(bl2 || n2 != 9 && n2 != 10)) {
                    this.hasBar = true;
                }
            }
            if (chartDataView.getYAxis() != jCAxis) continue;
            n2 = chartDataView.getChartType();
            if (!bl4) {
                this.chartType = n2;
                this.isPrimary = false;
                this.otherAxis = chartDataView.getXAxis();
                bl4 = true;
            }
            if (bl2 || n2 != 9 && n2 != 10) continue;
            this.hasBar = true;
        }
        this.frontPlane = this.hasBar || !this.is3D();
        this.getAxisHandler().calcParams();
        this.recalc();
    }

    void calcTransformation() {
        this.getAxisHandler().calcTransformation();
    }

    void checkAnnotations() {
        if (!this.visible) {
            return;
        }
        this.annoHandler.checkAnnotations();
    }

    void clearLimits() {
        this.dataLimits = null;
    }

    private Graphics clipToExtents(Graphics graphics) {
        Graphics graphics2 = graphics.create();
        Extents extents = this.getExtents();
        if (this.vertical) {
            graphics2.clipRect(0, Math.max(0, this.getTop() - extents.minor), this.chartArea.getDrawingArea().width + 1, Math.min(this.chartArea.getDrawingArea().height, this.getHeight() + extents.major + extents.minor) + 1);
        } else {
            graphics2.clipRect(Math.max(0, this.getLeft() - extents.minor), 0, Math.min(this.chartArea.getDrawingArea().width, this.getWidth() + extents.major + extents.minor) + 1, this.chartArea.getDrawingArea().height + 1);
        }
        return graphics2;
    }

    private double dataLength() {
        return this.max.value - this.min.value;
    }

    public double dateToValue(Date date) {
        this.getTimeBase();
        return this.annoHandler.timeToData(date, this.timeUnit);
    }

    public void draw(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (graphics == null) {
            return;
        }
        this.axisDrawn = false;
        this.axisDrawn = this.vertical ? this.drawVertical(graphics) : this.drawHorizontal(graphics);
    }

    void drawAnnotationsAndTitle(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        Graphics graphics2 = graphics.create();
        if (this.axisDrawn) {
            this.annoHandler.draw(graphics2);
            if (this.title != null) {
                this.title.draw(graphics2);
            }
        }
        if (graphics2 != null) {
            graphics2.dispose();
        }
    }

    void drawGrid(Graphics graphics) {
        if (!this.gridVisible) {
            return;
        }
        if (this.gridSpacing.isDefault) {
            this.drawGridLinesAtLabels(graphics, false, Double.MAX_VALUE, Double.MAX_VALUE);
        } else {
            this.drawLinearGridLines(graphics, false, Double.MAX_VALUE, Double.MAX_VALUE);
        }
    }

    void drawGridInTrough(Graphics graphics, double d2, double d3) {
        if (!this.gridVisible) {
            return;
        }
        if (this.gridSpacing.isDefault) {
            this.drawGridLinesAtLabels(graphics, true, d2, d3);
        } else {
            this.drawLinearGridLines(graphics, true, d2, d3);
        }
    }

    private void drawGridLine(Graphics graphics, JCLineStyle jCLineStyle, double d2) {
        int n2 = this.toPixel(d2);
        Rectangle rectangle = this.chartArea.getPlotRect();
        int n3 = this.chartArea.getDeltaX();
        int n4 = this.chartArea.getDeltaY();
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.vertical) {
            int n5 = this.toPixel(this.max.value);
            int n6 = this.toPixel(this.min.value);
            Rectangle rectangle2 = graphics.getClipBounds();
            graphics.clipRect(rectangle2.x, Math.min(n5, n6) + n4, rectangle2.width, Math.abs(n5 - n6));
            if (this.is3D()) {
                if (!this.frontPlane) {
                    n4 = 0;
                }
                if (n3 < 0) {
                    graphics2D.draw(new Line2D.Double(rectangle.x, n2 + n4, rectangle.x + rectangle.width + n3, n2 + n4));
                } else {
                    graphics2D.draw(new Line2D.Double(rectangle.x + n3, n2 + n4, rectangle.x + rectangle.width, n2 + n4));
                }
            } else {
                graphics2D.draw(new Line2D.Double(rectangle.x, n2, rectangle.x + rectangle.width, n2));
            }
            graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        } else {
            int n7 = this.toPixel(this.max.value);
            int n8 = this.toPixel(this.min.value);
            Rectangle rectangle3 = graphics.getClipBounds();
            graphics.clipRect(Math.min(n7, n8) + n3, rectangle3.y, Math.abs(n7 - n8), rectangle3.height);
            if (this.is3D()) {
                if (!this.frontPlane) {
                    n3 = 0;
                }
                if (n4 < 0) {
                    graphics2D.draw(new Line2D.Double(n3 + n2, rectangle.y, n3 + n2, rectangle.y + rectangle.height + n4));
                } else {
                    graphics2D.draw(new Line2D.Double(n3 + n2, rectangle.y + n4, n3 + n2, rectangle.y + rectangle.height));
                }
            } else {
                graphics2D.draw(new Line2D.Double(n2, rectangle.y, n2, rectangle.y + rectangle.height));
            }
            graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        }
    }

    protected void drawGridLineInTrough(Graphics graphics, JCLineStyle jCLineStyle, double d2) {
        int n2 = this.toPixel(d2);
        Rectangle rectangle = this.chartArea.getPlotRect();
        int n3 = this.chartArea.getDeltaX();
        int n4 = this.chartArea.getDeltaY();
        if (this.vertical) {
            if (this.is3D() && this.isBar() && n3 != 0) {
                int n5;
                int n6 = this.linePosition();
                int n7 = this.toPixel(this.min.value);
                if (n7 < (n5 = this.toPixel(this.max.value))) {
                    jCLineStyle.drawSquaredLine(graphics, n6, n2, n6 + n3, n2 + n4, false, n4, n7, n5);
                } else {
                    jCLineStyle.drawSquaredLine(graphics, n6, n2, n6 + n3, n2 + n4, false, n4, n5, n7);
                }
            }
        } else if (this.is3D() && this.isBar() && n4 != 0) {
            int n8;
            int n9 = this.linePosition();
            int n10 = this.toPixel(this.min.value);
            if (n10 < (n8 = this.toPixel(this.max.value))) {
                jCLineStyle.drawSquaredLine(graphics, n2, n9, n2 + n3, n9 + n4, true, n3, n10, n8);
            } else {
                jCLineStyle.drawSquaredLine(graphics, n2, n9, n2 + n3, n9 + n4, true, n3, n8, n10);
            }
        }
    }

    private void drawGridLinesAtLabels(Graphics graphics, boolean bl, double d2, double d3) {
        JCLineStyle jCLineStyle = this.getGridStyle().getLineStyle();
        if (!jCLineStyle.updateGraphics(graphics)) {
            return;
        }
        int n2 = 0;
        while (n2 < this.annoHandler.valueLabels.size()) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n2);
            ChartText chartText = jCValueLabel.getChartText();
            if (chartText.visible) {
                if (bl) {
                    if (d2 == Double.MAX_VALUE || jCValueLabel.value >= d2 && jCValueLabel.value <= d3) {
                        this.drawGridLineInTrough(graphics, jCLineStyle, jCValueLabel.value);
                    }
                } else {
                    this.drawGridLine(graphics, jCLineStyle, jCValueLabel.value);
                }
            }
            ++n2;
        }
        jCLineStyle.resetGraphics(graphics);
    }

    private boolean drawHorizontal(Graphics graphics) {
        int n2 = this.getWidth();
        int n3 = this.getLeft();
        int n4 = this.linePosition();
        if (!(this.annoHandler.realPlacement != 5 && this.annoHandler.realPlacement != 4 || n4 <= this.chartArea.getPlotRect().y + this.chartArea.getPlotRect().height && n4 >= this.chartArea.getPlotRect().y)) {
            return false;
        }
        if (graphics.getColor() != this.getForeground()) {
            graphics.setColor(this.getForeground());
        }
        graphics.drawLine(n3, n4, n3 + n2, n4);
        this.getAxisHandler().drawTicks(graphics);
        return true;
    }

    private void drawLinearGridLines(Graphics graphics, boolean bl, double d2, double d3) {
        double d4 = this.gridSpacing.value;
        int n2 = this.pixelLength();
        double d5 = this.dataLength();
        double d6 = d4 / 2.0;
        if (d6 < 0.0) {
            d6 = -d6;
        }
        if (d4 * (double)n2 / d5 + 0.5 < 2.0) {
            if (d4 <= 0.0) {
                this.setGridVisible(false);
                this.setGridSpacingIsDefault(true);
            } else {
                ErrorDialog.raise(this, JCChartBundle.string("com.klg.jclass.chart.Key123"));
            }
            return;
        }
        JCLineStyle jCLineStyle = this.getGridStyle().getLineStyle();
        if (!jCLineStyle.updateGraphics(graphics)) {
            return;
        }
        double d7 = this.firstGridInc(d4);
        while (d7 <= this.max.value) {
            if (bl) {
                if (d2 == Double.MAX_VALUE || d7 >= d2 && d7 <= d3) {
                    this.drawGridLineInTrough(graphics, jCLineStyle, d7);
                }
            } else {
                this.drawGridLine(graphics, jCLineStyle, d7);
            }
            d7 += d4;
        }
        jCLineStyle.resetGraphics(graphics);
    }

    private boolean drawVertical(Graphics graphics) {
        int n2 = this.getHeight();
        int n3 = this.getTop();
        int n4 = this.linePosition();
        if (!(this.annoHandler.realPlacement != 5 && this.annoHandler.realPlacement != 4 || n4 <= this.chartArea.getPlotRect().x + this.chartArea.getPlotRect().width && n4 >= this.chartArea.getPlotRect().x)) {
            return false;
        }
        if (graphics.getColor() != this.getForeground()) {
            graphics.setColor(this.getForeground());
        }
        graphics.drawLine(n4, n3, n4, n3 + n2);
        this.getAxisHandler().drawTicks(graphics);
        return true;
    }

    double firstGridInc(double d2) {
        double d3 = this.firstInc(d2);
        double d4 = d3 - this.min.value;
        if (d4 >= d2) {
            d3 -= d2 * Math.floor(d4 / d2);
        }
        return d3;
    }

    double firstInc(double d2) {
        double d3 = this.min.value;
        if (d2 == 0.0) {
            return d3;
        }
        int n2 = (int)Math.ceil((this.min.value - (d3 = JCNumberUtil.precCorrect(this.precision.value, d3))) / d2);
        if (n2 < 0) {
            return d3;
        }
        double d4 = d3 + d2 * (double)n2;
        if ((d4 = JCNumberUtil.precCorrect(this.precision.value, d4)) > this.max.value) {
            return d3;
        }
        return d4;
    }

    int getAdjustedRealPlacement() {
        if (this.otherAxis != null && this.otherAxis.reversed) {
            if (this.annoHandler.realPlacement == 1) {
                return 2;
            }
            return 1;
        }
        return this.annoHandler.realPlacement;
    }

    int getAnnotationAnchor() {
        return this.annoHandler.anchor;
    }

    public int getAnnotationMethod() {
        return this.annotationMethod;
    }

    public int getAnnotationRotation() {
        return this.annotationRotation;
    }

    Vector getAnnotations() {
        return this.annoHandler.valueLabels;
    }

    AxisHandler getAxisHandler() {
        if (this.axisHandler == null) {
            this.axisHandler = AxisHandler.makeAxisHandler(this);
        }
        return this.axisHandler;
    }

    public Color getBackground() {
        return this.chartArea == null ? (this.parentChart == null ? null : (this.parentChart.isOpaque() ? this.parentChart.getBackground() : null)) : (this.chartArea.isOpaque() ? this.chartArea.getBackground() : null);
    }

    public JCChartArea getChartArea() {
        return this.chartArea;
    }

    Extents getExtents() {
        return this.annoHandler.extents;
    }

    public Font getFont() {
        return this.font == null ? (this.chartArea == null ? (this.parentChart == null ? null : this.parentChart.getFont()) : this.chartArea.getFont()) : this.font;
    }

    public Color getForeground() {
        return this.foreground == null ? (this.chartArea == null ? (this.parentChart == null ? null : this.parentChart.getForeground()) : this.chartArea.getForeground()) : this.foreground;
    }

    public JCAxisFormula getFormula() {
        if (this.formula == null) {
            this.formula = new JCAxisFormula(this);
        }
        return this.formula;
    }

    public int getGap() {
        return this.gap;
    }

    public JCValueLabel getGeneratedValueLabel(double d2) {
        JCValueLabel jCValueLabel = null;
        int n2 = 0;
        while (n2 < this.annoHandler.valueLabels.size()) {
            JCValueLabel jCValueLabel2 = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n2);
            if (d2 == jCValueLabel2.value) {
                jCValueLabel = jCValueLabel2;
                break;
            }
            ++n2;
        }
        return jCValueLabel;
    }

    public JCValueLabel[] getGeneratedValueLabels() {
        if (this.annoHandler.valueLabels == null || this.annoHandler.valueLabels.size() == 0) {
            return null;
        }
        JCValueLabel[] jCValueLabelArray = new JCValueLabel[this.annoHandler.valueLabels.size()];
        int n2 = 0;
        while (n2 < jCValueLabelArray.length) {
            jCValueLabelArray[n2] = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n2);
            ++n2;
        }
        return jCValueLabelArray;
    }

    public JCValueLabel getGeneratedValueLabels(int n2) {
        if (this.annoHandler.valueLabels == null || this.annoHandler.valueLabels.size() == 0) {
            return null;
        }
        JCValueLabel jCValueLabel = null;
        try {
            jCValueLabel = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n2);
        }
        catch (Exception exception) {}
        return jCValueLabel;
    }

    protected double[] getGridLineList() {
        if (!this.gridVisible) {
            return null;
        }
        if (this.gridSpacing.isDefault) {
            return this.getGridLinesAtLabelsList();
        }
        return this.getLinearGridLinesList();
    }

    private double[] getGridLinesAtLabelsList() {
        double[] dArray = new double[this.annoHandler.valueLabels.size()];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.annoHandler.valueLabels.size()) {
            JCValueLabel jCValueLabel = (JCValueLabel)this.annoHandler.valueLabels.elementAt(n3);
            ChartText chartText = jCValueLabel.getChartText();
            if (chartText.visible) {
                dArray[n2] = jCValueLabel.value;
                ++n2;
            }
            ++n3;
        }
        int n4 = n2;
        while (n4 < this.annoHandler.valueLabels.size()) {
            dArray[n4] = Double.MAX_VALUE;
            ++n4;
        }
        return dArray;
    }

    public double getGridSpacing() {
        return this.gridSpacing.value;
    }

    public boolean getGridSpacingIsDefault() {
        return this.gridSpacing.isDefault;
    }

    public JCChartStyle getGridStyle() {
        if (this.gridStyle == null) {
            this.gridStyle = new JCChartStyle();
            this.gridStyle.setLineStyle(new JCLineStyle(1, this.getForeground(), 1));
            this.gridStyle.addParent(this);
        }
        return this.gridStyle;
    }

    public JCLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    private double[] getLinearGridLinesList() {
        double d2 = this.gridSpacing.value;
        int n2 = this.pixelLength();
        double d3 = this.dataLength();
        double d4 = d2 / 2.0;
        if (d4 < 0.0) {
            d4 = -d4;
        }
        if (d2 * (double)n2 / d3 + 0.5 < 2.0) {
            if (d2 <= 0.0) {
                this.setGridVisible(false);
                this.setGridSpacingIsDefault(true);
            } else {
                ErrorDialog.raise(this, JCChartBundle.string("com.klg.jclass.chart.Key123"));
            }
            return null;
        }
        JCLineStyle jCLineStyle = this.getGridStyle().getLineStyle();
        double[] dArray = new double[(int)Math.ceil((this.max.value + d4 - this.min.value) / d2)];
        int n3 = 0;
        double d5 = this.firstGridInc(d2);
        while (d5 < this.max.value + d4) {
            dArray[n3] = d5;
            ++n3;
            d5 += d2;
        }
        return dArray;
    }

    public double getMax() {
        return this.max.value;
    }

    public boolean getMaxIsDefault() {
        return this.max.isDefault;
    }

    public int getMaxPrecision() {
        return this.maximumPrecision;
    }

    public double getMin() {
        return this.min.value;
    }

    public boolean getMinIsDefault() {
        return this.min.isDefault;
    }

    public double getNumSpacing() {
        return this.numSpacing.value;
    }

    public boolean getNumSpacingIsDefault() {
        return this.numSpacing.isDefault;
    }

    public double getOrigin() {
        return this.origin.value;
    }

    public boolean getOriginIsDefault() {
        return this.origin.isDefault;
    }

    public int getOriginPlacement() {
        return this.originPlacement.value;
    }

    public boolean getOriginPlacementIsDefault() {
        return this.originPlacement.isDefault;
    }

    public int getPlacement() {
        return this.placement.value;
    }

    public JCAxis getPlacementAxis() {
        return this.placementAxis;
    }

    public boolean getPlacementIsDefault() {
        return this.placement.isDefault;
    }

    public double getPlacementLocation() {
        return this.placementLocation;
    }

    public int getPrecision() {
        return this.precision.value;
    }

    public boolean getPrecisionIsDefault() {
        return this.precision.isDefault;
    }

    double getRealPlacementLocation() {
        switch (this.annoHandler.realPlacement) {
            case 1: {
                if (this.otherAxis == null) break;
                return this.otherAxis.getMin();
            }
            case 2: {
                if (this.otherAxis == null) break;
                return this.otherAxis.getMax();
            }
            case 5: {
                if (this.otherAxis == null) break;
                return this.otherAxis.getOrigin();
            }
            case 4: {
                return this.getPlacementLocation();
            }
        }
        return Double.MAX_VALUE;
    }

    public double getTickSpacing() {
        return this.tickSpacing.value;
    }

    public boolean getTickSpacingIsDefault() {
        return this.tickSpacing.isDefault;
    }

    public Date getTimeBase() {
        if (this.timeBase == null) {
            this.timeBase = new Date();
        }
        return this.timeBase;
    }

    public String getTimeFormat() {
        return this.timeFormat.value;
    }

    public boolean getTimeFormatIsDefault() {
        return this.timeFormat.isDefault;
    }

    public long getTimeUnit() {
        return this.timeUnit;
    }

    public JCAxisTitle getTitle() {
        if (this.title == null) {
            this.title = new JCAxisTitle();
            this.title.setParentAxis(this);
            this.title.setParentChart(this.parentChart);
            this.title.setParentRegion(this.chartArea);
        }
        return this.title;
    }

    public JCValueLabel getValueLabel(double d2) {
        JCValueLabel jCValueLabel = null;
        int n2 = 0;
        while (n2 < this.annoHandler.userValueLabels.size()) {
            JCValueLabel jCValueLabel2 = (JCValueLabel)this.annoHandler.userValueLabels.elementAt(n2);
            if (d2 == jCValueLabel2.value) {
                jCValueLabel = jCValueLabel2;
                break;
            }
            ++n2;
        }
        return jCValueLabel;
    }

    public JCValueLabel[] getValueLabels() {
        if (this.annoHandler.userValueLabels == null || this.annoHandler.userValueLabels.size() == 0) {
            return null;
        }
        JCValueLabel[] jCValueLabelArray = new JCValueLabel[this.annoHandler.userValueLabels.size()];
        int n2 = 0;
        while (n2 < jCValueLabelArray.length) {
            jCValueLabelArray[n2] = (JCValueLabel)this.annoHandler.userValueLabels.elementAt(n2);
            ++n2;
        }
        return jCValueLabelArray;
    }

    public JCValueLabel getValueLabels(int n2) {
        if (this.annoHandler.userValueLabels == null || this.annoHandler.userValueLabels.size() == 0) {
            return null;
        }
        JCValueLabel jCValueLabel = null;
        try {
            jCValueLabel = (JCValueLabel)this.annoHandler.userValueLabels.elementAt(n2);
        }
        catch (Exception exception) {}
        return jCValueLabel;
    }

    private void init() {
        this.setTitle(new JCAxisTitle());
        this.setName(String.valueOf(JCChartBundle.string("com.klg.jclass.chart.Key6")) + " " + ++axisNum);
    }

    private boolean is3D() {
        return this.chartArea != null && this.chartArea.getDraw3D();
    }

    protected boolean isBar() {
        return this.hasBar;
    }

    protected boolean isBottomSide() {
        boolean bl = false;
        if (this.otherAxis != null) {
            bl = this.otherAxis.reversed;
        }
        return !this.vertical && (this.annoHandler.realPlacement == 1 && !bl || this.annoHandler.realPlacement == 2 && bl);
    }

    public boolean isDecimalPadded() {
        return this.decimalPadded;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    protected boolean isLeftSide() {
        boolean bl = false;
        if (this.otherAxis != null) {
            bl = this.otherAxis.reversed;
        }
        return this.vertical && (this.annoHandler.realPlacement == 1 && !bl || this.annoHandler.realPlacement == 2 && bl);
    }

    public boolean isLogarithmic() {
        return this.logarithmic;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    protected boolean isRightSide() {
        boolean bl = false;
        if (this.otherAxis != null) {
            bl = this.otherAxis.reversed;
        }
        return this.vertical && (this.annoHandler.realPlacement == 2 && !bl || this.annoHandler.realPlacement == 1 && bl);
    }

    protected boolean isTopSide() {
        boolean bl = false;
        if (this.otherAxis != null) {
            bl = this.otherAxis.reversed;
        }
        return !this.vertical && (this.annoHandler.realPlacement == 2 && !bl || this.annoHandler.realPlacement == 1 && bl);
    }

    public boolean isVertical() {
        return this.vertical;
    }

    void layoutAnnotations() {
        if (!this.visible) {
            return;
        }
        this.annoHandler.layout();
        if (this.title != null) {
            this.title.layout();
        }
    }

    void layoutAxis(boolean bl) {
        int n2;
        int n3 = Math.max(-this.chartArea.getDeltaX(), 0);
        int n4 = Math.max(-this.chartArea.getDeltaY(), 0);
        int n5 = this.chartArea.getDeltaX();
        int n6 = this.chartArea.getDeltaY();
        int n7 = n2 = bl ? 1 : 0;
        if (this.vertical) {
            if (!this.is3D()) {
                this.setBounds(this.getLeft(), this.chartArea.getPlotRect().y, this.getWidth(), this.chartArea.getPlotRect().height);
            } else if (this.isBar()) {
                if (this.getLeft() < this.chartArea.getPlotRect().x) {
                    this.setBounds(this.getLeft() + n3 * n2, this.chartArea.getPlotRect().y + n4, this.getWidth(), this.chartArea.getPlotRect().height - JCNumberUtil.abs(n6));
                } else {
                    n3 = Math.max(this.chartArea.getDeltaX(), 0);
                    this.setBounds(this.getLeft() - n3 * n2, this.chartArea.getPlotRect().y + n4, this.getWidth(), this.chartArea.getPlotRect().height - JCNumberUtil.abs(n6));
                }
            } else {
                n4 = Math.max(this.chartArea.getDeltaY(), 0);
                if (this.getLeft() <= this.chartArea.getPlotRect().x) {
                    n3 = Math.max(this.chartArea.getDeltaX(), 0);
                    this.setBounds(this.chartArea.getPlotRect().x + n3 * n2 - this.getWidth(), this.chartArea.getPlotRect().y + n4, this.getWidth(), this.chartArea.getPlotRect().height - JCNumberUtil.abs(n6));
                } else {
                    this.setBounds(this.chartArea.getPlotRect().x + this.chartArea.getPlotRect().width - n3 * n2, this.chartArea.getPlotRect().y + n4, this.getWidth(), this.chartArea.getPlotRect().height - JCNumberUtil.abs(n6));
                }
            }
        } else if (!this.is3D()) {
            this.setBounds(this.chartArea.getPlotRect().x, this.getTop(), this.chartArea.getPlotRect().width, this.getHeight());
        } else if (this.isBar()) {
            if (this.getTop() <= this.chartArea.getPlotRect().y) {
                this.setBounds(this.chartArea.getPlotRect().x + n3, this.getTop() + n4 * n2, this.chartArea.getPlotRect().width - JCNumberUtil.abs(n5), this.getHeight());
            } else {
                n4 = Math.max(this.chartArea.getDeltaY(), 0);
                this.setBounds(this.chartArea.getPlotRect().x + n3, this.getTop() - n4 * n2, this.chartArea.getPlotRect().width - JCNumberUtil.abs(n5), this.getHeight());
            }
        } else {
            n3 = Math.max(this.chartArea.getDeltaX(), 0);
            if (this.getTop() <= this.chartArea.getPlotRect().y) {
                n4 = Math.max(this.chartArea.getDeltaY(), 0);
                this.setBounds(this.chartArea.getPlotRect().x + n3, this.chartArea.getPlotRect().y + n4 * n2 - this.getHeight(), this.chartArea.getPlotRect().width - JCNumberUtil.abs(n5), this.getHeight());
            } else {
                this.setBounds(this.chartArea.getPlotRect().x + n3, this.chartArea.getPlotRect().y + this.chartArea.getPlotRect().height - n4 * n2, this.chartArea.getPlotRect().width - JCNumberUtil.abs(n5), this.getHeight());
            }
        }
    }

    void layoutOrigin() {
        if (this.annoHandler.realPlacement != 5 && this.annoHandler.realPlacement != 4) {
            return;
        }
        if (this.placementAxis == null) {
            this.placementAxis = this.otherAxis;
        }
        if (this.placementAxis == null) {
            return;
        }
        double d2 = this.annoHandler.realPlacement == 4 ? this.placementLocation : this.placementAxis.origin.value;
        int n2 = this.placementAxis.toPixel(d2);
        if (this.vertical) {
            if (this.annoHandler.anchor == 1) {
                this.setLocation(n2, this.getTop());
            } else {
                this.setLocation(n2 - this.getWidth(), this.getTop());
            }
        } else if (this.annoHandler.anchor == 16) {
            this.setLocation(this.getLeft(), n2 - this.getHeight());
        } else {
            this.setLocation(this.getLeft(), n2);
        }
    }

    int linePosition() {
        int n2 = this.vertical ? (this.annoHandler.anchor == 2 ? this.getLeft() + this.getWidth() : (this.annoHandler.anchor == 1 ? this.getLeft() : this.getLeft() + this.getWidth() / 2)) : (this.annoHandler.anchor == 16 ? this.getTop() + this.getHeight() : (this.annoHandler.anchor == 32 ? this.getTop() : this.getTop() + this.getHeight() / 2));
        return n2;
    }

    void makeAnnotations() {
        this.annoHandler.makeAnnotations();
    }

    int pixelLength() {
        return this.vertical ? this.getHeight() : this.getWidth();
    }

    int pixelStart() {
        return this.vertical ? -this.getTop() : this.getLeft();
    }

    void postDrawOutlineTrough(Graphics graphics, int n2) {
        if (!this.visible) {
            return;
        }
        if (this.isBar() && this.is3D() && this.sideplane != null) {
            boolean bl;
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setClip(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
            JCFillStyle jCFillStyle = new JCFillStyle(this.chartArea.getPlotArea().getBackground(), 1);
            boolean bl2 = bl = this.isPrimary && this.vertical || !this.isPrimary && !this.vertical;
            if (!bl && !this.reversed && (n2 & 1) != 0 || !bl && this.reversed && (n2 & 2) != 0 || bl && !this.reversed && (n2 & 2) != 0 || bl && this.reversed && (n2 & 1) != 0) {
                jCFillStyle.drawOutlineLine(graphics, this.sideplane, 1, 2, this.getForeground());
            }
            if (!bl && !this.reversed && (n2 & 2) != 0 || !bl && this.reversed && (n2 & 1) != 0 || bl && !this.reversed && (n2 & 1) != 0 || bl && this.reversed && (n2 & 2) != 0) {
                jCFillStyle.drawOutlineLine(graphics, this.sideplane, 3, 4, this.getForeground());
            }
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    void preDraw(Graphics graphics, boolean bl, boolean bl2) {
        if (!this.visible) {
            return;
        }
        if (this.isBar() && this.is3D()) {
            boolean bl3;
            Serializable serializable;
            Color color = null;
            if (this.chartArea.isOpaque()) {
                color = this.chartArea.getPlotArea().getBackground();
            } else {
                serializable = this.chartArea.getParent();
                while (serializable != null && serializable instanceof JComponent && !((JComponent)serializable).isOpaque()) {
                    serializable = ((Component)serializable).getParent();
                }
                if (serializable != null && serializable instanceof JComponent && ((JComponent)serializable).isOpaque()) {
                    color = ((Component)serializable).getBackground();
                } else if (serializable != null && !(serializable instanceof JComponent)) {
                    color = ((Component)serializable).getBackground();
                }
            }
            if (color == null) {
                return;
            }
            serializable = new JCFillStyle(color, 1);
            boolean bl4 = bl3 = this.isPrimary && this.vertical || !this.isPrimary && !this.vertical;
            if (bl) {
                if (!this.vertical && this.chartArea.getDeltaY() <= 0 || this.vertical && this.chartArea.getDeltaX() <= 0) {
                    ((JCFillStyle)serializable).fillPolygonHighlight(graphics, this.sideplane);
                } else {
                    ((JCFillStyle)serializable).fillPolygonShadow(graphics, this.sideplane);
                }
            } else {
                int n2 = this.otherAxis.linePosition();
                if (bl2) {
                    Polygon polygon = new Polygon(this.sideplane.xpoints, this.sideplane.ypoints, this.sideplane.npoints);
                    if (this.vertical) {
                        polygon.ypoints[1] = n2;
                        polygon.ypoints[2] = n2 + this.chartArea.getDeltaY();
                    } else {
                        polygon.xpoints[0] = n2;
                        polygon.xpoints[4] = n2;
                        polygon.xpoints[3] = n2 + this.chartArea.getDeltaX();
                    }
                    if (!this.vertical && this.chartArea.getDeltaY() <= 0 || this.vertical && this.chartArea.getDeltaX() <= 0) {
                        ((JCFillStyle)serializable).fillPolygonHighlight(graphics, polygon);
                    } else {
                        ((JCFillStyle)serializable).fillPolygonShadow(graphics, polygon);
                    }
                } else {
                    Polygon polygon = new Polygon(this.sideplane.xpoints, this.sideplane.ypoints, this.sideplane.npoints);
                    if (this.vertical) {
                        polygon.ypoints[0] = n2;
                        polygon.ypoints[4] = n2;
                        polygon.ypoints[3] = n2 + this.chartArea.getDeltaY();
                    } else {
                        polygon.xpoints[1] = n2;
                        polygon.xpoints[2] = n2 + this.chartArea.getDeltaX();
                    }
                    if (!this.vertical && this.chartArea.getDeltaY() <= 0 || this.vertical && this.chartArea.getDeltaX() <= 0) {
                        ((JCFillStyle)serializable).fillPolygonHighlight(graphics, polygon);
                    } else {
                        ((JCFillStyle)serializable).fillPolygonShadow(graphics, polygon);
                    }
                }
            }
        }
    }

    void preDrawCalc() {
        if (!this.visible) {
            return;
        }
        if (this.isBar() && this.is3D()) {
            int[] nArray = new int[5];
            int[] nArray2 = new int[5];
            if (this.vertical) {
                nArray[0] = nArray[1] = this.linePosition();
                nArray2[0] = this.getTop() + this.getHeight();
                nArray2[1] = this.getTop();
                nArray[3] = nArray[2] = nArray[1] + this.chartArea.getDeltaX();
                nArray2[2] = nArray2[1] + this.chartArea.getDeltaY();
                nArray2[3] = nArray2[0] + this.chartArea.getDeltaY();
            } else {
                nArray[0] = this.getLeft() + this.getWidth();
                nArray[1] = this.getLeft();
                nArray2[0] = nArray2[1] = this.linePosition();
                nArray[2] = nArray[1] + this.chartArea.getDeltaX();
                nArray2[2] = nArray2[3] = nArray2[1] + this.chartArea.getDeltaY();
                nArray[3] = nArray[0] + this.chartArea.getDeltaX();
            }
            nArray[4] = nArray[0];
            nArray2[4] = nArray2[0];
            this.sideplane = new Polygon();
            int n2 = 0;
            while (n2 < 5) {
                this.sideplane.addPoint(nArray[n2], nArray2[n2]);
                ++n2;
            }
        }
    }

    void preDrawOutlineTrough(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.isBar() && this.is3D()) {
            Rectangle rectangle = graphics.getClipBounds();
            graphics.setClip(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
            JCFillStyle jCFillStyle = new JCFillStyle(this.chartArea.getPlotArea().getBackground(), 1);
            jCFillStyle.drawOutlinePolygon(graphics, this.sideplane, this.getForeground());
            graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    double range() {
        return this.getAxisHandler().range();
    }

    public void recalc() {
        this.setChanged(false, 0, false);
    }

    public void setAnnotationMethod(int n2) {
        if (n2 == this.annotationMethod) {
            this.savedXAxisAnnotationMethod = this.annotationMethod;
            return;
        }
        switch (n2) {
            case 3: {
                if (this.chartArea != null && !this.chartArea.isXAxis(this)) {
                    throw new IllegalArgumentException("Only X axes can use point labels");
                }
            }
            case 0: 
            case 1: 
            case 2: {
                this.savedXAxisAnnotationMethod = this.annotationMethod = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid AnnotationMethod value in JCAxis");
            }
        }
        this.setChanged(true, 2);
    }

    public void setAnnotationRotation(int n2) {
        if (n2 == this.annotationRotation) {
            return;
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.annotationRotation = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid AnnotationRotation value in JCAxis");
            }
        }
        this.setChanged(true, 2);
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        if (this.getLeft() == n2 && this.getTop() == n3 && this.getWidth() == n4 && this.getHeight() == n5) {
            return;
        }
        super.setBounds(n2, n3, n4, n5);
        this.setChanged(true, 2, false);
        this.calcTransformation();
    }

    public void setDecimalPadded(boolean bl) {
        this.decimalPadded = bl;
    }

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public void setGap(int n2) {
        if (this.gap == n2) {
            return;
        }
        this.gap = n2;
        this.setChanged(true, 2);
    }

    public void setGridSpacing(double d2) {
        this.gridSpacing.value = d2;
        this.gridSpacing.isDefault = false;
        this.setChanged(true, 2);
    }

    public void setGridSpacingIsDefault(boolean bl) {
        if (this.gridSpacing.isDefault == bl) {
            return;
        }
        this.gridSpacing.isDefault = bl;
        this.setChanged(true, 2);
    }

    public void setGridStyle(JCChartStyle jCChartStyle) {
        if (jCChartStyle == this.gridStyle) {
            return;
        }
        this.gridStyle = jCChartStyle;
        this.setChanged(true, 2);
    }

    public void setGridVisible(boolean bl) {
        if (bl == this.gridVisible) {
            return;
        }
        this.gridVisible = bl;
        this.setChanged(true, 2);
    }

    void setInitialSize() {
        if (this.vertical) {
            this.setBounds(0, 0, 30, this.chartArea.getSize().height);
        } else {
            this.setBounds(0, this.chartArea.getSize().height - 30, this.chartArea.getSize().width, 30);
        }
    }

    public void setLabelGenerator(JCLabelGenerator jCLabelGenerator) {
        if (this.labelGenerator == jCLabelGenerator) {
            return;
        }
        this.labelGenerator = jCLabelGenerator;
        this.numberLocalization = false;
        this.setChanged(true, 2);
    }

    void setLimits(MinMax minMax) {
        if (this.dataLimits == null) {
            this.dataLimits = new MinMax();
        }
        this.dataLimits.union(minMax);
        if (this.dataLimits.min > this.dataLimits.max) {
            this.dataLimits = null;
        }
    }

    public void setLogarithmic(boolean bl) {
        if (this.logarithmic == bl) {
            return;
        }
        this.logarithmic = bl;
        this.axisHandler = null;
        this.setChanged(true, 2);
    }

    public void setMax(double d2) {
        this.max.value = d2;
        this.max.isDefault = false;
        this.setChanged(true, 2);
    }

    public void setMaxIsDefault(boolean bl) {
        if (this.max.isDefault == bl) {
            return;
        }
        this.max.isDefault = bl;
        this.setChanged(true, 2);
    }

    public void setMaxPrecision(int n2) {
        JCAxis jCAxis = this;
        synchronized (jCAxis) {
            this.maximumPrecision = n2;
        }
        this.setChanged(true, 2);
    }

    public void setMin(double d2) {
        this.min.value = d2;
        this.min.isDefault = false;
        this.setChanged(true, 2);
    }

    public void setMinIsDefault(boolean bl) {
        if (this.min.isDefault == bl) {
            return;
        }
        this.min.isDefault = bl;
        this.setChanged(true, 2);
    }

    public void setNumSpacing(double d2) {
        this.numSpacing.value = d2;
        this.numSpacing.isDefault = false;
        this.setChanged(true, 2);
    }

    public void setNumSpacingIsDefault(boolean bl) {
        this.numSpacing.isDefault = bl;
        this.setChanged(true, 2);
    }

    public void setOrigin(double d2) {
        this.origin.value = d2;
        this.origin.isDefault = false;
        this.setChanged(true, 2);
    }

    public void setOriginIsDefault(boolean bl) {
        if (this.origin.isDefault == bl) {
            return;
        }
        this.origin.isDefault = bl;
        this.setChanged(true, 2);
    }

    public void setOriginPlacement(int n2) {
        if (this.originPlacement.value == n2) {
            return;
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.originPlacement.value = n2;
                this.originPlacement.isDefault = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid OriginPlacement in JCAxis");
            }
        }
        this.setChanged(true, 2);
    }

    public void setOriginPlacementIsDefault(boolean bl) {
        if (this.originPlacement.isDefault == bl) {
            return;
        }
        this.originPlacement.isDefault = bl;
        if (bl) {
            this.originPlacement.value = 0;
        }
        this.setChanged(true, 2);
    }

    public void setParentChart(JCChart jCChart) {
        if (this.parentChart == jCChart) {
            return;
        }
        super.setParentChart(jCChart);
        if (jCChart != null) {
            this.chartArea = jCChart.getChartArea();
        }
        this.setParentRegion(this.chartArea);
        if (this.title != null) {
            this.title.setParentAxis(this);
            this.title.setParentChart(jCChart);
            this.title.setParentRegion(this.chartArea);
        }
        if (this.annoHandler != null) {
            this.annoHandler.setValueLabelParent(jCChart);
        }
    }

    public void setPlacement(int n2) {
        if (this.placement.value == n2) {
            return;
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                this.placement.value = n2;
                this.placement.isDefault = false;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Placement value in JCAxis");
            }
        }
        this.setChanged(true, 2);
    }

    public void setPlacement(JCAxis jCAxis) {
        this.placementAxis = jCAxis;
        this.setPlacement(5);
    }

    public void setPlacement(JCAxis jCAxis, double d2) {
        this.placementAxis = jCAxis;
        this.placementLocation = d2;
        this.setPlacement(4);
    }

    public void setPlacementAxis(JCAxis jCAxis) {
        this.placementAxis = jCAxis;
        this.setChanged(true, 2);
    }

    public void setPlacementIsDefault(boolean bl) {
        if (this.placement.isDefault == bl) {
            return;
        }
        this.placement.isDefault = bl;
        if (bl) {
            this.placement.value = 0;
        }
        this.setChanged(true, 2);
    }

    public void setPlacementLocation(double d2) {
        this.placementLocation = d2;
        this.setChanged(true, 2);
    }

    public void setPrecision(int n2) {
        this.precision.value = n2;
        this.precision.isDefault = false;
        this.setChanged(true, 2);
    }

    public void setPrecisionIsDefault(boolean bl) {
        this.precision.isDefault = bl;
        this.setChanged(true, 2);
    }

    public void setReversed(boolean bl) {
        this.reversed = bl;
        this.setChanged(true, 2);
    }

    public void setTickSpacing(double d2) {
        this.tickSpacing.value = d2;
        this.tickSpacing.isDefault = false;
        this.setChanged(true, 2);
    }

    public void setTickSpacingIsDefault(boolean bl) {
        this.tickSpacing.isDefault = bl;
        this.setChanged(true, 2);
    }

    public void setTimeAnnotationLocale(Locale locale) {
        if (this.annotationMethod == 2) {
            this.annoHandler.getDateFormatter().setLocale(locale);
            this.setChanged(true, 1);
        }
    }

    public void setTimeBase(Date date) {
        if (date == null) {
            return;
        }
        if (this.timeBase != null && this.timeBase.equals(date)) {
            return;
        }
        this.timeBase = date;
        this.setChanged(true, 2);
    }

    public void setTimeFormat(String string) {
        this.setTimeFormat(string, true);
    }

    public void setTimeFormat(String string, boolean bl) {
        if (this.timeFormat.value != null && this.timeFormat.value.equals(string)) {
            return;
        }
        this.timeFormat.value = string;
        this.timeFormat.isDefault = false;
        if (bl) {
            this.setChanged(true, 2);
        }
    }

    public void setTimeFormatIsDefault(boolean bl) {
        this.setTimeFormatIsDefault(bl, true);
    }

    public void setTimeFormatIsDefault(boolean bl, boolean bl2) {
        if (this.timeFormat.isDefault == bl) {
            return;
        }
        this.timeFormat.isDefault = bl;
        if (bl2) {
            this.setChanged(true, 2);
        }
    }

    public void setTimeUnit(long l2) {
        if (this.timeUnit == l2) {
            return;
        }
        if (l2 != 1000L && l2 != 60000L && l2 != 3600000L && l2 != 86400000L && l2 != 604800000L && l2 != 2678400000L && l2 != 31536000000L) {
            throw new IllegalArgumentException("Invalid TimeUnit value in JCAxis");
        }
        this.timeUnit = l2;
        this.setChanged(true, 2);
    }

    public void setTitle(JCAxisTitle jCAxisTitle) {
        if (jCAxisTitle == null) {
            return;
        }
        this.title = jCAxisTitle;
        this.title.setParentAxis(this);
        this.title.setParentChart(this.parentChart);
        this.title.setParentRegion(this.chartArea);
        this.setChanged(true, 2);
    }

    public void setValueLabels(int n2, JCValueLabel jCValueLabel) {
        if (this.annoHandler.userValueLabels == null) {
            this.annoHandler.userValueLabels = new Vector();
        }
        if (n2 < 0 || n2 > this.annoHandler.userValueLabels.size()) {
            throw new IllegalArgumentException("Invalid ValueLabels index in JCAxis");
        }
        if (jCValueLabel != null) {
            jCValueLabel.setParent(this);
        }
        if (n2 < this.annoHandler.userValueLabels.size()) {
            this.annoHandler.userValueLabels.setElementAt(jCValueLabel, n2);
        } else {
            this.annoHandler.userValueLabels.insertElementAt(jCValueLabel, n2);
        }
        this.setChanged(true, 2);
    }

    public void setValueLabels(JCValueLabel[] jCValueLabelArray) {
        this.annoHandler.userValueLabels = new Vector();
        if (jCValueLabelArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < jCValueLabelArray.length) {
            if (jCValueLabelArray[n2] != null) {
                jCValueLabelArray[n2].setParent(this);
            }
            this.annoHandler.userValueLabels.addElement(jCValueLabelArray[n2]);
            ++n2;
        }
        this.annoHandler.sortValueLabels();
        this.setChanged(true, 2);
    }

    public void setVertical(boolean bl) {
        if (this.vertical == bl) {
            return;
        }
        this.vertical = bl;
        this.setChanged(true, 2);
    }

    public String timeBaseToString(boolean bl) {
        return bl ? this.annoHandler.getDateFormatter().timeLabel(this.timeFormat.value, this.getTimeBase()) : this.annoHandler.getDateFormatter().timeLabel(this.getTimeBase());
    }

    public double toData(int n2) {
        return this.getAxisHandler().toData(n2);
    }

    public double toData(int n2, boolean bl) {
        if (this.frontPlane && !bl) {
            return this.toData(n2 - (this.vertical ? this.chartArea.getDeltaY() : this.parentChart.getChartArea().getDeltaX()));
        }
        if (!this.frontPlane && bl) {
            return this.toData(n2 + (this.vertical ? this.chartArea.getDeltaY() : this.parentChart.getChartArea().getDeltaX()));
        }
        return this.toData(n2);
    }

    public int toPixel(double d2) {
        return this.getAxisHandler().toPixel(d2);
    }

    public int toPixel(double d2, boolean bl) {
        if (this.frontPlane && !bl) {
            return this.toPixel(d2) + (this.vertical ? this.chartArea.getDeltaY() : this.parentChart.getChartArea().getDeltaX());
        }
        if (!this.frontPlane && bl) {
            return this.toPixel(d2) - (this.vertical ? this.chartArea.getDeltaY() : this.parentChart.getChartArea().getDeltaX());
        }
        return this.toPixel(d2);
    }

    public String toString() {
        String string = this.getName();
        return string == null ? String.valueOf(JCChartBundle.string("com.klg.jclass.chart.Key141")) + (this.vertical ? JCChartBundle.string("com.klg.jclass.chart.Key147") : JCChartBundle.string("com.klg.jclass.chart.Key44")) + " " + JCChartBundle.string("com.klg.jclass.chart.Key6") : string;
    }

    void translate(double d2) {
        this.getAxisHandler().translate(d2);
        this.setChanged(true, 2, false);
    }

    public Date valueToDate(double d2) {
        this.getTimeBase();
        return this.annoHandler.dataToTime(d2, this.timeUnit);
    }
}

