/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.JCSymbolStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotPoint;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;

public class FastPlotChartDraw
extends ChartDraw {
    protected MinMax xlim = new MinMax();
    protected MinMax ylim = new MinMax();
    Point prev = null;
    Point next = null;
    Point last = null;
    Rectangle r = null;
    public static final int TOP_EDGE = 8;
    public static final int BOTTOM_EDGE = 4;
    public static final int RIGHT_EDGE = 2;
    public static final int LEFT_EDGE = 1;

    public void draw(Graphics graphics) {
        this.draw(graphics, -1, -1);
    }

    public void draw(Graphics graphics, int n2, int n3) {
        try {
            if (this.seriesList == null) {
                return;
            }
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle.width == 0 || rectangle.height == 0) {
                return;
            }
            boolean bl = false;
            if (n2 >= 0 && n3 >= 0 && n3 >= n2) {
                bl = true;
            }
            Graphics graphics2 = graphics.create();
            boolean bl2 = this.xaxis.isLogarithmic();
            boolean bl3 = this.yaxis.isLogarithmic();
            int n4 = 0;
            int n5 = this.seriesList.size();
            int n6 = n4;
            while (n6 < n5) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n6);
                if (chartDataViewSeries.isVisible() && chartDataViewSeries.maxXIndex() != 0 && chartDataViewSeries.maxYIndex() != 0) {
                    JCChartStyle jCChartStyle;
                    if (!bl) {
                        n2 = chartDataViewSeries.getFirstPoint();
                        n3 = chartDataViewSeries.getLastPoint();
                    } else {
                        int n7 = chartDataViewSeries.getLastPoint();
                        if (n2 < n7) {
                            n2 = n7;
                        }
                    }
                    double[] dArray = chartDataViewSeries.getX();
                    double[] dArray2 = chartDataViewSeries.getY();
                    double d2 = 0.0;
                    double d3 = this.holeValue;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    if (bl && n2 > 0) {
                        d2 = dArray[n2 - 1];
                        d3 = dArray2[n2 - 1];
                    }
                    if ((jCChartStyle = chartDataViewSeries.getStyle()) != null) {
                        JCLineStyle jCLineStyle = jCChartStyle.getLineStyle();
                        boolean bl6 = false;
                        if (!jCLineStyle.updateGraphics(graphics2)) {
                            bl6 = true;
                        }
                        Line2D.Double double_ = new Line2D.Double();
                        JCSymbolStyle jCSymbolStyle = jCChartStyle.getSymbolStyle();
                        boolean bl7 = jCSymbolStyle.getShape() == 0;
                        PlotPoint plotPoint = new PlotPoint();
                        plotPoint.valid = false;
                        PlotPoint[] plotPointArray = new PlotPoint[]{new PlotPoint(), new PlotPoint()};
                        int n8 = n2;
                        while (n8 <= n3) {
                            double d4 = dArray[n8];
                            if (bl2 && d4 <= 0.0) {
                                d4 = this.holeValue;
                            }
                            double d5 = dArray2[n8];
                            if (bl3 && d5 <= 0.0) {
                                d5 = this.holeValue;
                            }
                            plotPointArray[0].valid = false;
                            plotPointArray[1].valid = false;
                            bl4 = this.plotClip(d2, d3, d4, d5, this.xlim, this.ylim, plotPointArray, bl4, this.inverted);
                            int n9 = 0;
                            while (n9 < plotPointArray.length) {
                                Color color;
                                if (!bl6 && plotPointArray[n9].valid && plotPoint.valid && this.chartType == 0) {
                                    color = null;
                                    if (this.dataObject.getColorHandler() != null) {
                                        color = this.dataObject.getColorHandler().getColor(d2, d3, d4, d5);
                                        if (color == null) {
                                            color = jCLineStyle.getColor();
                                        }
                                        if (!graphics2.getColor().equals(color)) {
                                            graphics2.setColor(color);
                                        }
                                    }
                                    double_.setLine(plotPoint.px, plotPoint.py, plotPointArray[n9].px, plotPointArray[n9].py);
                                    ((Graphics2D)graphics2).draw(double_);
                                }
                                if (n9 == 0 || plotPointArray[n9].valid) {
                                    if (plotPoint.valid && plotPoint.drawPoint && !bl7) {
                                        color = null;
                                        if (this.dataObject.getColorHandler() != null) {
                                            color = this.dataObject.getColorHandler().getColor(d2, d3);
                                        }
                                        jCSymbolStyle.draw(graphics, plotPoint.px, plotPoint.py, color);
                                    }
                                    plotPoint.px = plotPointArray[n9].px;
                                    plotPoint.py = plotPointArray[n9].py;
                                    plotPoint.drawPoint = plotPointArray[n9].drawPoint;
                                    plotPoint.valid = plotPointArray[n9].valid;
                                }
                                ++n9;
                            }
                            if (!bl4) {
                                plotPoint.valid = false;
                            }
                            d2 = d4;
                            d3 = d5;
                            ++n8;
                        }
                        if (plotPoint.valid && plotPoint.drawPoint && !bl7) {
                            Color color = null;
                            if (this.dataObject.getColorHandler() != null) {
                                color = this.dataObject.getColorHandler().getColor(d2, d3);
                            }
                            jCSymbolStyle.draw(graphics, plotPoint.px, plotPoint.py, color);
                        }
                    }
                }
                ++n6;
            }
            graphics2.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        return jCDataIndex.dataView.getXAxis().vertical ? n2 - this.r.x : n3 - this.r.y;
    }

    public JCDataIndex pick(Point point, int n2) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        int n3 = point.x - rectangle.x;
        int n4 = point.y - rectangle.y;
        int n5 = -1;
        int n6 = -1;
        JCDataIndex jCDataIndex = null;
        double d2 = Double.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        boolean bl = this.xaxis.isLogarithmic();
        boolean bl2 = this.yaxis.isLogarithmic();
        int n7 = 0;
        int n8 = this.seriesList.size();
        double d3 = 0.0;
        double d4 = 0.0;
        try {
            int n9 = n7;
            while (n9 < n8) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n9);
                if (chartDataViewSeries != null && chartDataViewSeries.isVisible()) {
                    int n10 = chartDataViewSeries.getFirstPoint();
                    int n11 = chartDataViewSeries.getLastPoint();
                    if (n10 != Integer.MAX_VALUE && n11 != Integer.MAX_VALUE) {
                        double[] dArray = chartDataViewSeries.getX();
                        double[] dArray2 = chartDataViewSeries.getY();
                        int n12 = n10;
                        while (n12 <= n11) {
                            d3 = dArray[n12];
                            d4 = dArray2[n12];
                            if (!(d3 == this.holeValue || d4 == this.holeValue || d3 > this.xlim.max || d3 < this.xlim.min || d4 > this.ylim.max || d4 < this.ylim.min || bl && d3 <= 0.0 || bl2 && d4 <= 0.0)) {
                                double d5 = Double.MAX_VALUE;
                                switch (n2) {
                                    case 1: {
                                        int n13 = this.xaxis.toPixel(d3, this.drawFront);
                                        d5 = this.inverted ? Math.abs(n13 - n4) : Math.abs(n13 - n3);
                                        break;
                                    }
                                    case 2: {
                                        int n14 = this.yaxis.toPixel(d4, this.drawFront);
                                        d5 = this.inverted ? Math.abs(n14 - n3) : Math.abs(n14 - n4);
                                        break;
                                    }
                                    default: {
                                        int n13 = this.xaxis.toPixel(d3, this.drawFront);
                                        int n14 = this.yaxis.toPixel(d4, this.drawFront);
                                        double d6 = d5 = this.inverted ? Math.sqrt((n14 - n3) * (n14 - n3) + (n13 - n4) * (n13 - n4)) : Math.sqrt((n13 - n3) * (n13 - n3) + (n14 - n4) * (n14 - n4));
                                    }
                                }
                                if (d5 < d2) {
                                    n5 = n9;
                                    n6 = n12;
                                    d2 = d5;
                                }
                            }
                            ++n12;
                        }
                    }
                }
                ++n9;
            }
            if (n5 >= 0 && n6 >= 0) {
                jCDataIndex = new JCDataIndex(n6, (ChartDataViewSeries)this.seriesList.get(n5), n5);
                jCDataIndex.distance = (int)d2;
            }
            return jCDataIndex;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    boolean plotClip(double d2, double d3, double d4, double d5, MinMax minMax, MinMax minMax2, PlotPoint[] plotPointArray, boolean bl, boolean bl2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        double d6 = minMax.min;
        double d7 = minMax.max;
        double d8 = minMax2.min;
        double d9 = minMax2.max;
        boolean bl3 = true;
        boolean bl4 = true;
        int n7 = 0;
        int n8 = 0;
        boolean bl5 = false;
        boolean bl6 = true;
        if (!bl) {
            if (d3 == this.holeValue || d2 == this.holeValue) {
                n7 = 1;
                bl6 = false;
                bl5 = true;
            } else {
                n6 = (d2 > d7 ? 1 : 0) << 1;
                n5 = d2 < d6 ? 1 : 0;
                n4 = (d3 > d9 ? 1 : 0) << 3;
                n3 = (d3 < d8 ? 1 : 0) << 2;
                n7 = n6 | n5 | n4 | n3;
            }
        } else {
            n6 = (d2 > d7 ? 1 : 0) << 1;
            n5 = d2 < d6 ? 1 : 0;
            n4 = (d3 > d9 ? 1 : 0) << 3;
            n3 = (d3 < d8 ? 1 : 0) << 2;
            n7 = n6 | n5 | n4 | n3;
        }
        if (d5 == this.holeValue || d4 == this.holeValue) {
            n8 = 1;
            bl6 = false;
            bl5 = true;
        } else {
            n6 = d4 > d7 ? 1 : 0;
            n5 = n6 << 1;
            n4 = d4 < d6 ? 1 : 0;
            n3 = (d5 > d9 ? 1 : 0) << 3;
            n2 = (d5 < d8 ? 1 : 0) << 2;
            n8 = n5 | n4 | n3 | n2;
        }
        n6 = n7;
        n5 = n8;
        n4 = 0;
        while (bl6 && (n6 | n5) != 0 && (n6 & n5) == 0) {
            int n9;
            double d10;
            double d11;
            int n10 = n3 = n6 != 0 ? n6 : n5;
            if ((n3 & 1) != 0) {
                d11 = d6;
                d10 = d3 + (d5 - d3) * (d6 - d2) / (d4 - d2);
                n2 = (d10 > d9 ? 1 : 0) << 3;
                n9 = (d10 < d8 ? 1 : 0) << 2;
                n3 = n2 | n9;
            } else if ((n3 & 2) != 0) {
                d10 = d3 + (d5 - d3) * (d7 - d2) / (d4 - d2);
                d11 = d7;
                n2 = (d10 > d9 ? 1 : 0) << 3;
                n9 = (d10 < d8 ? 1 : 0) << 2;
                n3 = n2 | n9;
            } else if ((n3 & 4) != 0) {
                d11 = d2 + (d4 - d2) * (d8 - d3) / (d5 - d3);
                d10 = d8;
                n2 = (d11 > d7 ? 1 : 0) << 1;
                n9 = d11 < d6 ? 1 : 0;
                n3 = n2 | n9;
            } else {
                d11 = d2 + (d4 - d2) * (d9 - d3) / (d5 - d3);
                d10 = d9;
                n2 = (d11 > d7 ? 1 : 0) << 1;
                n9 = d11 < d6 ? 1 : 0;
                n3 = n2 | n9;
            }
            if (n6 != 0) {
                n6 = n3;
                d2 = d11;
                d3 = d10;
                bl3 = false;
                if (n4 > 4) {
                    n6 = 0;
                }
                n4 = n6 == 0 ? 0 : n4 + 1;
                continue;
            }
            n5 = n3;
            d4 = d11;
            d5 = d10;
            bl4 = false;
            if (n4 > 4) {
                n5 = 0;
            }
            int n11 = n4 = n5 == 0 ? 0 : n4 + 1;
        }
        int n12 = n3 = bl || !bl5 || n7 != 0 && n8 != 0 ? 0 : 1;
        if ((n6 | n5) == 0 || n3 != 0) {
            if (bl) {
                if (!bl5) {
                    this.addClippedPoint(plotPointArray, 0, d4, d5, this.xaxis, this.yaxis, bl2, bl4);
                    bl = n8 == 0;
                } else {
                    bl = false;
                }
            } else {
                if (n3 != 0 && n8 == 0) {
                    d2 = d4;
                    d3 = d5;
                    bl3 = bl4;
                }
                this.addClippedPoint(plotPointArray, 0, d2, d3, this.xaxis, this.yaxis, bl2, bl3);
                if (n3 == 0) {
                    this.addClippedPoint(plotPointArray, 1, d4, d5, this.xaxis, this.yaxis, bl2, bl4);
                }
                bl = n8 == 0;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public void recalc() {
        this.recalc(-1, -1, -1);
    }

    public void recalc(int n2, int n3) {
        this.recalc(n2, n3, -1);
    }

    public void recalc(int n2, int n3, int n4) {
        super.recalc();
        boolean bl = false;
        if (n2 >= 0 && n3 >= 0 && n3 >= n2) {
            bl = true;
        }
        if (n4 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        this.inverted = this.xaxis.vertical;
        this.holeValue = this.dataObject.getHoleValue();
        if (bl) {
            int n5 = 0;
            int n6 = this.seriesList.size();
            int n7 = n5;
            while (n7 < n6) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n7);
                if (chartDataViewSeries.isVisible() && chartDataViewSeries.maxXIndex() != 0 && chartDataViewSeries.maxYIndex() != 0) {
                    double[] dArray = chartDataViewSeries.getX();
                    double[] dArray2 = chartDataViewSeries.getY();
                    int n8 = n2;
                    while (n8 <= n3) {
                        this.xlim.setMinMax(dArray[n8], this.holeValue, this.xaxis.isLogarithmic());
                        this.ylim.setMinMax(dArray2[n8], this.holeValue, this.yaxis.isLogarithmic());
                        ++n8;
                    }
                }
                ++n7;
            }
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        } else if (n4 == -1 || n4 == 0) {
            this.xlim = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
            this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.getXAxis().vertical;
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        if (this.last == null) {
            this.last = bl ? new Point(n2, jCDataIndex.dataView.getXAxis().toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.getXAxis().toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.x, n3);
        } else if (bl) {
            this.last.x = n2;
        } else {
            this.last.y = n3;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
    }

    void startEdit(JCDataIndex jCDataIndex) {
        double d2;
        double d3;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject || jCDataIndex.series == null) {
            return;
        }
        int n2 = jCDataIndex.series.getDrawingOrder();
        this.r = this.chartArea.getDrawingArea();
        this.last = null;
        this.next = null;
        this.prev = null;
        int n3 = jCDataIndex.point;
        if (n3 - 1 >= 0) {
            d3 = jCDataIndex.series.getX(n3 - 1);
            d2 = jCDataIndex.series.getY(n3 - 1);
            if (d3 != Double.MAX_VALUE && d2 != Double.MAX_VALUE && d3 != this.dataObject.getHoleValue() && d2 != this.dataObject.getHoleValue() && JCNumberUtil.locateXY(d3, d2, this.xlim.min, this.xlim.max, this.ylim.min, this.ylim.max) == 0) {
                Point point = this.prev = this.inverted ? new Point(this.yaxis.toPixel(d2) + this.r.x, this.xaxis.toPixel(d3) + this.r.y) : new Point(this.xaxis.toPixel(d3) + this.r.x, this.yaxis.toPixel(d2) + this.r.y);
            }
        }
        if (n3 + 1 <= jCDataIndex.series.getLastPoint()) {
            d3 = jCDataIndex.series.getX(n3 + 1);
            d2 = jCDataIndex.series.getY(n3 + 1);
            if (d3 != Double.MAX_VALUE && d2 != Double.MAX_VALUE && d3 != this.dataObject.getHoleValue() && d2 != this.dataObject.getHoleValue() && JCNumberUtil.locateXY(d3, d2, this.xlim.min, this.xlim.max, this.ylim.min, this.ylim.max) == 0) {
                this.next = this.inverted ? new Point(this.yaxis.toPixel(d2) + this.r.x, this.xaxis.toPixel(d3) + this.r.y) : new Point(this.xaxis.toPixel(d3) + this.r.x, this.yaxis.toPixel(d2) + this.r.y);
            }
        }
    }

    public Point unpick(int n2, int n3) {
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
        double d2 = chartDataViewSeries.getY(n2);
        double d3 = chartDataViewSeries.getX(n2);
        int n4 = -1;
        int n5 = -1;
        if (d2 != this.holeValue && d3 != this.holeValue) {
            if (this.inverted) {
                n4 = this.yaxis.toPixel(d2, this.drawFront);
                n5 = this.xaxis.toPixel(d3, this.drawFront);
            } else {
                n4 = this.xaxis.toPixel(d3, this.drawFront);
                n5 = this.yaxis.toPixel(d2, this.drawFront);
            }
            return new Point(n4, n5);
        }
        return null;
    }
}

