/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotPoint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.io.Serializable;

public class FastHiloChartDraw
extends ChartDraw {
    public static final int NUM_SERIES_PER_DATA = 2;
    public static final int HI_SERIES_INDEX = 0;
    public static final int LO_SERIES_INDEX = 1;
    protected MinMax xlim = new MinMax();
    protected MinMax ylim = new MinMax();
    Point start = null;
    Point end = null;
    Rectangle r = null;

    public void draw(Graphics graphics) {
        try {
            if (this.seriesList == null) {
                return;
            }
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle.width == 0 || rectangle.height == 0) {
                return;
            }
            int n2 = this.seriesList.size() / 2;
            int n3 = 0;
            int n4 = n2;
            boolean bl = this.xaxis.isLogarithmic();
            boolean bl2 = this.yaxis.isLogarithmic();
            int n5 = n3;
            while (n5 < n4) {
                JCLineStyle jCLineStyle;
                Serializable serializable;
                boolean bl3 = true;
                boolean bl4 = true;
                int n6 = Integer.MAX_VALUE;
                int n7 = Integer.MAX_VALUE;
                int n8 = 2 * n5;
                int n9 = 0;
                while (n9 < 2) {
                    serializable = (ChartDataViewSeries)this.seriesList.get(n8);
                    if (!((ChartDataViewSeries)serializable).isVisible()) {
                        bl3 = false;
                        break;
                    }
                    if (((ChartDataViewSeries)serializable).maxXIndex() == 0 || ((ChartDataViewSeries)serializable).maxYIndex() == 0) {
                        bl4 = false;
                        break;
                    }
                    n6 = Math.min(n6, ((ChartDataViewSeries)serializable).getFirstPoint());
                    n7 = Math.min(n7, ((ChartDataViewSeries)serializable).getLastPoint());
                    ++n9;
                    ++n8;
                }
                if (bl4 && bl3 && (serializable = ((ChartDataViewSeries)this.seriesList.get(2 * n5)).getStyle()) != null && (jCLineStyle = ((JCChartStyle)serializable).getLineStyle()).updateGraphics(graphics)) {
                    Line2D.Double double_ = new Line2D.Double();
                    PlotPoint[] plotPointArray = new PlotPoint[]{new PlotPoint(), new PlotPoint()};
                    int n10 = n6;
                    while (n10 <= n7) {
                        int n11 = 2 * n5;
                        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n11++);
                        double d2 = chartDataViewSeries.getX(n10);
                        if (bl && d2 <= 0.0) {
                            d2 = this.holeValue;
                        }
                        double d3 = chartDataViewSeries.getY(n10);
                        if (bl2 && d3 <= 0.0) {
                            d3 = this.holeValue;
                        }
                        chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n11++);
                        double d4 = chartDataViewSeries.getX(n10);
                        if (bl && d4 <= 0.0) {
                            d4 = this.holeValue;
                        }
                        double d5 = chartDataViewSeries.getY(n10);
                        if (bl2 && d5 <= 0.0) {
                            d5 = this.holeValue;
                        }
                        plotPointArray[0].valid = false;
                        plotPointArray[1].valid = false;
                        this.financialClip(d2, d3, d4, d5, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                        if (plotPointArray[0].valid && plotPointArray[1].valid) {
                            double_.setLine(plotPointArray[0].px, plotPointArray[0].py, plotPointArray[1].px, plotPointArray[1].py);
                            ((Graphics2D)graphics).draw(double_);
                        }
                        ++n10;
                    }
                    jCLineStyle.resetGraphics(graphics);
                }
                ++n5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
        return jCDataIndex.dataView.getXAxis().vertical ? n2 - this.r.x : n3 - this.r.y;
    }

    public int getNumSeriesPerData() {
        return 2;
    }

    public JCDataIndex pick(Point point, int n2) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        int n3 = point.x - rectangle.x;
        int n4 = point.y - rectangle.y;
        int n5 = -1;
        int n6 = -1;
        JCDataIndex jCDataIndex = null;
        double d2 = Double.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        double d3 = this.dataObject.getHoleValue();
        boolean bl = this.xaxis.isLogarithmic();
        boolean bl2 = this.yaxis.isLogarithmic();
        int n7 = this.seriesList.size() / 2;
        int n8 = 0;
        int n9 = n7;
        try {
            int n10 = n8;
            while (n10 < n9) {
                boolean bl3 = true;
                boolean bl4 = true;
                int n11 = Integer.MAX_VALUE;
                int n12 = Integer.MAX_VALUE;
                int n13 = 2 * n10;
                int n14 = 0;
                while (n14 < 2) {
                    ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n13);
                    if (!chartDataViewSeries.isVisible()) {
                        bl4 = false;
                        break;
                    }
                    if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) {
                        bl3 = false;
                        break;
                    }
                    n11 = Math.min(n11, chartDataViewSeries.getFirstPoint());
                    n12 = Math.min(n12, chartDataViewSeries.getLastPoint());
                    ++n14;
                    ++n13;
                }
                if (bl3 && bl4) {
                    int n15 = 2 * n10;
                    double[] dArray = ((ChartDataViewSeries)this.seriesList.get(n15)).getX();
                    double[] dArray2 = ((ChartDataViewSeries)this.seriesList.get(n15)).getY();
                    double[] dArray3 = ((ChartDataViewSeries)this.seriesList.get(n15 + 1)).getX();
                    double[] dArray4 = ((ChartDataViewSeries)this.seriesList.get(n15 + 1)).getY();
                    double d4 = 0.0;
                    double d5 = 0.0;
                    int n16 = n11;
                    while (n16 <= n12) {
                        int n17 = 0;
                        while (n17 < 2) {
                            switch (n17) {
                                case 0: {
                                    d4 = dArray[n16];
                                    d5 = dArray2[n16];
                                    break;
                                }
                                case 1: {
                                    d4 = dArray3[n16];
                                    d5 = dArray4[n16];
                                    break;
                                }
                            }
                            if (!(d4 == d3 || d5 == d3 || d4 > this.xlim.max || this.xlim.min > d4 || d5 > this.ylim.max || this.ylim.min > d5 || bl && d4 <= 0.0 || bl2 && d5 <= 0.0)) {
                                double d6;
                                switch (n2) {
                                    case 1: {
                                        int n18 = this.xaxis.toPixel(d4, this.drawFront);
                                        d6 = this.inverted ? Math.abs(n18 - n4) : Math.abs(n18 - n3);
                                        break;
                                    }
                                    case 2: {
                                        int n19 = this.yaxis.toPixel(d5, this.drawFront);
                                        d6 = this.inverted ? Math.abs(n19 - n3) : Math.abs(n19 - n4);
                                        break;
                                    }
                                    default: {
                                        int n18 = this.xaxis.toPixel(d4, this.drawFront);
                                        int n19 = this.yaxis.toPixel(d5, this.drawFront);
                                        double d7 = d6 = this.inverted ? Math.sqrt((n19 - n3) * (n19 - n3) + (n18 - n4) * (n18 - n4)) : Math.sqrt((n18 - n3) * (n18 - n3) + (n19 - n4) * (n19 - n4));
                                    }
                                }
                                if (d2 > d6) {
                                    n5 = n10 * 2 + n17;
                                    n6 = n16;
                                    d2 = d6;
                                }
                            }
                            ++n17;
                        }
                        ++n16;
                    }
                }
                ++n10;
            }
            if (n5 >= 0 && n6 >= 0) {
                jCDataIndex = new JCDataIndex(n6, (ChartDataViewSeries)this.seriesList.get(n5), n5);
                jCDataIndex.distance = (int)d2;
            }
            return jCDataIndex;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    public void recalc() {
        this.recalc(-1);
    }

    public void recalc(int n2) {
        super.recalc();
        if (n2 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        this.holeValue = this.dataObject.getHoleValue();
        this.inverted = this.xaxis.vertical;
        int n3 = this.seriesList.size() / 2;
        if (n2 == -1 || n2 == 0) {
            this.xlim = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
            this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.getXAxis().vertical;
        this.chartArea.drawRubberLine(this.start, this.end);
        if (this.end == null) {
            this.end = bl ? new Point(n2, jCDataIndex.dataView.getXAxis().toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.getXAxis().toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.x, n3);
        } else if (bl) {
            this.end.x = n2;
        } else {
            this.end.y = n3;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
    }

    void startEdit(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        int n2 = jCDataIndex.series.getDrawingOrder() / 2;
        this.r = this.chartArea.getDrawingArea();
        this.start = null;
        this.end = null;
        int n3 = n2 * 2;
        int n4 = jCDataIndex.seriesIndex - n3;
        double d2 = ((ChartDataViewSeries)this.seriesList.get(n3 + n4)).getX(jCDataIndex.point);
        double d3 = ((ChartDataViewSeries)this.seriesList.get(n3 + n4)).getY(jCDataIndex.point);
        this.start = this.inverted ? new Point(this.yaxis.toPixel(d3) + this.r.x, this.xaxis.toPixel(d2) + this.r.y) : new Point(this.xaxis.toPixel(d2) + this.r.x, this.yaxis.toPixel(d3) + this.r.y);
    }

    public Point unpick(int n2, int n3) {
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
        if (chartDataViewSeries == null) {
            return null;
        }
        double d2 = chartDataViewSeries.getY(n2);
        double d3 = chartDataViewSeries.getX(n2);
        int n4 = -1;
        int n5 = -1;
        if (d2 != this.holeValue && d3 != this.holeValue) {
            if (this.inverted) {
                n4 = this.yaxis.toPixel(d2, this.drawFront);
                n5 = this.xaxis.toPixel(d3, this.drawFront);
            } else {
                n4 = this.xaxis.toPixel(d3, this.drawFront);
                n5 = this.yaxis.toPixel(d2, this.drawFront);
            }
            return new Point(n4, n5);
        }
        return null;
    }
}

