/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCHLOCChartFormat;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotPoint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.io.Serializable;
import java.util.List;

public class FastHLOCChartDraw
extends ChartDraw {
    public static final int NUM_SERIES_PER_DATA = 4;
    public static final int HI_SERIES_INDEX = 0;
    public static final int LO_SERIES_INDEX = 1;
    public static final int OPEN_SERIES_INDEX = 2;
    public static final int CLOSE_SERIES_INDEX = 3;
    protected JCHLOCChartFormat hlocf = null;
    protected MinMax xlim = new MinMax();
    protected MinMax ylim = new MinMax();
    Point start = null;
    Point end = null;
    Rectangle r = null;

    public void draw(Graphics graphics) {
        try {
            if (this.seriesList == null) {
                return;
            }
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle.width == 0 || rectangle.height == 0) {
                return;
            }
            boolean bl = this.hlocf.isOpenCloseFullWidth();
            boolean bl2 = this.hlocf.isShowingOpen();
            boolean bl3 = this.hlocf.isShowingClose();
            boolean bl4 = this.xaxis.isLogarithmic();
            boolean bl5 = this.yaxis.isLogarithmic();
            int n2 = this.seriesList.size() / 4;
            int n3 = 0;
            int n4 = n2;
            int n5 = n3;
            while (n5 < n4) {
                JCLineStyle jCLineStyle;
                Serializable serializable;
                int n6 = this.hlocf.getTickSize(n5);
                boolean bl6 = true;
                boolean bl7 = true;
                int n7 = Integer.MAX_VALUE;
                int n8 = Integer.MAX_VALUE;
                int n9 = 4 * n5;
                int n10 = 0;
                while (n10 < 4) {
                    serializable = (ChartDataViewSeries)this.seriesList.get(n9);
                    if (!((ChartDataViewSeries)serializable).isVisible()) {
                        bl7 = false;
                        break;
                    }
                    if (((ChartDataViewSeries)serializable).maxXIndex() == 0 || ((ChartDataViewSeries)serializable).maxYIndex() == 0) {
                        bl6 = false;
                        break;
                    }
                    n7 = Math.min(n7, ((ChartDataViewSeries)serializable).getFirstPoint());
                    n8 = Math.min(n8, ((ChartDataViewSeries)serializable).getLastPoint());
                    ++n10;
                    ++n9;
                }
                if (bl6 && bl7 && (serializable = ((ChartDataViewSeries)this.seriesList.get(4 * n5)).getStyle()) != null && (jCLineStyle = ((JCChartStyle)serializable).getLineStyle()).updateGraphics(graphics)) {
                    PlotPoint[] plotPointArray = new PlotPoint[]{new PlotPoint(), new PlotPoint()};
                    int n11 = n7;
                    while (n11 <= n8) {
                        this.drawPoints(graphics, this.seriesList, n5, n11, plotPointArray, jCLineStyle, bl, bl2, bl3, n6, bl4, bl5);
                        ++n11;
                    }
                    jCLineStyle.resetGraphics(graphics);
                }
                ++n5;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private final void drawPoints(Graphics graphics, List list, int n2, int n3, PlotPoint[] plotPointArray, JCLineStyle jCLineStyle, boolean bl, boolean bl2, boolean bl3, int n4, boolean bl4, boolean bl5) {
        int n5;
        double d2;
        double d3;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n6 = 4 * n2;
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)list.get(n6++);
        double d4 = chartDataViewSeries.getX(n3);
        if (bl4 && d4 <= 0.0) {
            d4 = this.holeValue;
        }
        double d5 = chartDataViewSeries.getY(n3);
        if (bl5 && d5 <= 0.0) {
            d5 = this.holeValue;
        }
        chartDataViewSeries = (ChartDataViewSeries)list.get(n6++);
        double d6 = chartDataViewSeries.getX(n3);
        if (bl4 && d6 <= 0.0) {
            d6 = this.holeValue;
        }
        double d7 = chartDataViewSeries.getY(n3);
        if (bl5 && d7 <= 0.0) {
            d7 = this.holeValue;
        }
        plotPointArray[0].valid = false;
        plotPointArray[1].valid = false;
        this.financialClip(d4, d5, d6, d7, this.xlim, this.ylim, plotPointArray, this.inverted, false);
        if (plotPointArray[0].valid && plotPointArray[1].valid) {
            graphics2D.draw(new Line2D.Double(plotPointArray[0].px, plotPointArray[0].py, plotPointArray[1].px, plotPointArray[1].py));
        }
        if (n4 > 0 && bl2) {
            chartDataViewSeries = (ChartDataViewSeries)list.get(n6++);
            d3 = chartDataViewSeries.getX(n3);
            if (bl4 && d3 <= 0.0) {
                d3 = this.holeValue;
            }
            d2 = chartDataViewSeries.getY(n3);
            if (bl5 && d2 <= 0.0) {
                d2 = this.holeValue;
            }
            if (d3 != this.holeValue && d2 != this.holeValue) {
                n5 = this.xaxis.toPixel(d3, this.drawFront);
                d4 = this.xaxis.toData(n5 - n4, this.drawFront);
                d5 = d2;
                d6 = bl ? this.xaxis.toData(n5 + n4, this.drawFront) : d3;
                d7 = d2;
                plotPointArray[0].valid = false;
                plotPointArray[1].valid = false;
                this.financialClip(d4, d5, d6, d7, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                if (plotPointArray[0].valid && plotPointArray[1].valid) {
                    graphics2D.draw(new Line2D.Double(plotPointArray[0].px, plotPointArray[0].py, plotPointArray[1].px, plotPointArray[1].py));
                }
            }
        } else {
            ++n6;
        }
        if (n4 > 0 && bl3) {
            chartDataViewSeries = (ChartDataViewSeries)list.get(n6++);
            d3 = chartDataViewSeries.getX(n3);
            if (bl4 && d3 <= 0.0) {
                d3 = this.holeValue;
            }
            d2 = chartDataViewSeries.getY(n3);
            if (bl5 && d2 <= 0.0) {
                d2 = this.holeValue;
            }
            if (d3 != this.holeValue && d2 != this.holeValue) {
                n5 = this.xaxis.toPixel(d3, this.drawFront);
                d4 = bl ? this.xaxis.toData(n5 - n4, this.drawFront) : d3;
                d5 = d2;
                d6 = this.xaxis.toData(n5 + n4, this.drawFront);
                d7 = d2;
                plotPointArray[0].valid = false;
                plotPointArray[1].valid = false;
                this.financialClip(d4, d5, d6, d7, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                if (plotPointArray[0].valid && plotPointArray[1].valid) {
                    graphics2D.draw(new Line2D.Double(plotPointArray[0].px, plotPointArray[0].py, plotPointArray[1].px, plotPointArray[1].py));
                }
            }
        } else {
            ++n6;
        }
    }

    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
        return jCDataIndex.dataView.getXAxis().vertical ? n2 - this.r.x : n3 - this.r.y;
    }

    public int getNumSeriesPerData() {
        return 4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JCDataIndex pick(Point point, int n2) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        int n3 = point.x - rectangle.x;
        int n4 = point.y - rectangle.y;
        int n5 = -1;
        int n6 = -1;
        JCDataIndex jCDataIndex = null;
        double d2 = Double.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        double d3 = this.xlim.max;
        double d4 = this.xlim.min;
        double d5 = this.ylim.max;
        double d6 = this.ylim.min;
        boolean bl = this.xaxis.isLogarithmic();
        boolean bl2 = this.yaxis.isLogarithmic();
        boolean bl3 = this.hlocf.isShowingOpen();
        boolean bl4 = this.hlocf.isShowingClose();
        boolean bl5 = this.hlocf.isOpenCloseFullWidth();
        int n7 = !this.xaxis.vertical && !this.xaxis.reversed || this.xaxis.vertical && this.xaxis.reversed ? -1 : 1;
        double d7 = this.dataObject.getHoleValue();
        int n8 = this.seriesList.size() / 4;
        int n9 = 0;
        int n10 = n8;
        try {
            int n11 = n9;
            while (n11 < n10) {
                int n12 = this.hlocf.getTickSize(n11);
                double d8 = n12 == 0 ? 0.0 : Math.abs(this.xaxis.toData(0) - this.xaxis.toData(n12));
                boolean bl6 = true;
                boolean bl7 = true;
                int n13 = Integer.MAX_VALUE;
                int n14 = Integer.MAX_VALUE;
                int n15 = 4 * n11;
                int n16 = 0;
                while (n16 < 4) {
                    ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n15);
                    if (!chartDataViewSeries.isVisible()) {
                        bl7 = false;
                        break;
                    }
                    if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) {
                        bl6 = false;
                        break;
                    }
                    n13 = Math.min(n13, chartDataViewSeries.getFirstPoint());
                    n14 = Math.min(n14, chartDataViewSeries.getLastPoint());
                    ++n16;
                    ++n15;
                }
                if (bl6 && bl7) {
                    int n17 = 4 * n11;
                    double[] dArray = ((ChartDataViewSeries)this.seriesList.get(n17)).getX();
                    double[] dArray2 = ((ChartDataViewSeries)this.seriesList.get(n17)).getY();
                    double[] dArray3 = ((ChartDataViewSeries)this.seriesList.get(n17 + 1)).getX();
                    double[] dArray4 = ((ChartDataViewSeries)this.seriesList.get(n17 + 1)).getY();
                    double[] dArray5 = ((ChartDataViewSeries)this.seriesList.get(n17 + 2)).getX();
                    double[] dArray6 = ((ChartDataViewSeries)this.seriesList.get(n17 + 2)).getY();
                    double[] dArray7 = ((ChartDataViewSeries)this.seriesList.get(n17 + 3)).getX();
                    double[] dArray8 = ((ChartDataViewSeries)this.seriesList.get(n17 + 3)).getY();
                    double d9 = 0.0;
                    double d10 = 0.0;
                    int n18 = n13;
                    while (n18 <= n14) {
                        boolean bl8 = false;
                        boolean bl9 = (dArray[n18] == d7 || dArray2[n18] == d7 || dArray3[n18] == d7 || dArray4[n18] == d7 || bl && dArray[n18] <= 0.0 || bl2 && dArray2[n18] <= 0.0 || bl && dArray3[n18] <= 0.0 || bl2 && dArray4[n18] <= 0.0) ^ true;
                        boolean bl10 = (dArray5[n18] == d7 || dArray6[n18] == d7 || bl && dArray5[n18] <= 0.0 || bl2 && dArray6[n18] <= 0.0) ^ true;
                        boolean bl11 = (dArray7[n18] == d7 || dArray8[n18] == d7 || bl && dArray7[n18] <= 0.0 || bl2 && dArray8[n18] <= 0.0) ^ true;
                        int n19 = bl9 ? 0 : 2;
                        block15: while (n19 < 4) {
                            double d11;
                            switch (n19) {
                                case 0: {
                                    d9 = dArray[n18];
                                    d10 = dArray2[n18];
                                    break;
                                }
                                case 1: {
                                    d9 = dArray3[n18];
                                    d10 = dArray4[n18];
                                    break;
                                }
                                case 2: {
                                    if (!bl3 || !bl10 || n12 == 0) {
                                        ++n19;
                                        continue block15;
                                    }
                                    if (!bl8) {
                                        d9 = dArray5[n18];
                                        d10 = dArray6[n18];
                                        if (bl5) {
                                            d9 += (double)(-n7) * d8;
                                        }
                                        bl8 = true;
                                        break;
                                    }
                                    d9 = dArray5[n18] + (double)n7 * d8;
                                    bl8 = false;
                                    break;
                                }
                                case 3: {
                                    if (!bl4 || !bl11 || n12 == 0) {
                                        ++n19;
                                        continue block15;
                                    }
                                    if (!bl8) {
                                        d9 = dArray7[n18];
                                        d10 = dArray8[n18];
                                        if (bl5) {
                                            d9 += (double)n7 * d8;
                                        }
                                        bl8 = true;
                                        break;
                                    }
                                    d9 = dArray7[n18] - (double)n7 * d8;
                                    bl8 = false;
                                }
                            }
                            if (d9 > d3 || d4 > d9 || d10 > d5 || d6 > d10) {
                                if (bl8) continue;
                                ++n19;
                                continue;
                            }
                            switch (n2) {
                                case 1: {
                                    int n20 = this.xaxis.toPixel(d9, this.drawFront);
                                    d11 = this.inverted ? Math.abs(n20 - n4) : Math.abs(n20 - n3);
                                    break;
                                }
                                case 2: {
                                    int n21 = this.yaxis.toPixel(d10, this.drawFront);
                                    d11 = this.inverted ? Math.abs(n21 - n3) : Math.abs(n21 - n4);
                                    break;
                                }
                                default: {
                                    int n20 = this.xaxis.toPixel(d9, this.drawFront);
                                    int n21 = this.yaxis.toPixel(d10, this.drawFront);
                                    double d12 = d11 = this.inverted ? Math.sqrt((n21 - n3) * (n21 - n3) + (n20 - n4) * (n20 - n4)) : Math.sqrt((n20 - n3) * (n20 - n3) + (n21 - n4) * (n21 - n4));
                                }
                            }
                            if (d2 > d11) {
                                n5 = n11 * 4 + n19;
                                n6 = n18;
                                d2 = d11;
                            }
                            if (bl8) continue;
                            ++n19;
                        }
                        ++n18;
                    }
                }
                ++n11;
            }
            if (n5 >= 0 && n6 >= 0) {
                jCDataIndex = new JCDataIndex(n6, (ChartDataViewSeries)this.seriesList.get(n5), n5);
                jCDataIndex.distance = (int)d2;
            }
            return jCDataIndex;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    public void recalc() {
        this.recalc(-1);
    }

    public void recalc(int n2) {
        super.recalc();
        if (n2 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.hlocf = (JCHLOCChartFormat)this.dataObject.getChartFormat();
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        this.holeValue = this.dataObject.getHoleValue();
        this.inverted = this.xaxis.vertical;
        int n3 = this.seriesList.size() / 4;
        if (n2 == -1 || n2 == 0) {
            this.xlim = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
            this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.getXAxis().vertical;
        this.chartArea.drawRubberLine(this.start, this.end);
        if (this.end == null) {
            this.end = bl ? new Point(n2, jCDataIndex.dataView.getXAxis().toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.getXAxis().toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.x, n3);
        } else if (bl) {
            this.end.x = n2;
        } else {
            this.end.y = n3;
        }
        this.chartArea.drawRubberLine(this.start, this.end);
    }

    void startEdit(JCDataIndex jCDataIndex) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        int n2 = jCDataIndex.series.getDrawingOrder() / 4;
        this.r = this.chartArea.getDrawingArea();
        this.start = null;
        this.end = null;
        int n3 = n2 * 4;
        int n4 = jCDataIndex.seriesIndex - n3;
        double d2 = ((ChartDataViewSeries)this.seriesList.get(n3 + n4)).getX(jCDataIndex.point);
        double d3 = ((ChartDataViewSeries)this.seriesList.get(n3 + n4)).getY(jCDataIndex.point);
        this.start = this.inverted ? new Point(this.yaxis.toPixel(d3) + this.r.x, this.xaxis.toPixel(d2) + this.r.y) : new Point(this.xaxis.toPixel(d2) + this.r.x, this.yaxis.toPixel(d3) + this.r.y);
    }

    public Point unpick(int n2, int n3) {
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
        if (chartDataViewSeries == null) {
            return null;
        }
        double d2 = chartDataViewSeries.getY(n2);
        double d3 = chartDataViewSeries.getX(n2);
        int n4 = -1;
        int n5 = -1;
        if (d2 != this.holeValue && d3 != this.holeValue) {
            if (this.inverted) {
                n4 = this.yaxis.toPixel(d2, this.drawFront);
                n5 = this.xaxis.toPixel(d3, this.drawFront);
            } else {
                n4 = this.xaxis.toPixel(d3, this.drawFront);
                n5 = this.yaxis.toPixel(d2, this.drawFront);
            }
            return new Point(n4, n5);
        }
        return null;
    }
}

