/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCCandleChartFormat;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotPoint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class FastCandleChartDraw
extends ChartDraw {
    public static final int NUM_SERIES_PER_DATA = 4;
    public static final int HI_SERIES_INDEX = 0;
    public static final int LO_SERIES_INDEX = 1;
    public static final int OPEN_SERIES_INDEX = 2;
    public static final int CLOSE_SERIES_INDEX = 3;
    protected JCCandleChartFormat cf = null;
    protected boolean isComplex = false;
    protected MinMax xlim = new MinMax();
    protected MinMax ylim = new MinMax();
    Point start = null;
    Point end = null;
    Rectangle r = null;
    boolean useRubberBand = false;

    public void draw(Graphics graphics) {
        try {
            if (this.seriesList == null) {
                return;
            }
            Rectangle rectangle = graphics.getClipBounds();
            if (rectangle.width == 0 || rectangle.height == 0) {
                return;
            }
            this.isComplex = this.cf.isComplex();
            boolean bl = false;
            boolean bl2 = true;
            boolean bl3 = true;
            boolean bl4 = this.xaxis.isLogarithmic();
            boolean bl5 = this.yaxis.isLogarithmic();
            Graphics graphics2 = graphics.create();
            int n2 = this.seriesList.size() / 4;
            int n3 = 0;
            while (n3 < n2) {
                block29: {
                    JCChartStyle jCChartStyle;
                    JCChartStyle jCChartStyle2;
                    JCChartStyle jCChartStyle3;
                    JCLineStyle jCLineStyle;
                    int n4;
                    int n5;
                    int n6;
                    int n7;
                    int n8;
                    block31: {
                        JCChartStyle jCChartStyle4;
                        block30: {
                            boolean bl6 = true;
                            n8 = Integer.MAX_VALUE;
                            n7 = Integer.MAX_VALUE;
                            boolean bl7 = true;
                            n6 = 0;
                            int n9 = 0;
                            n6 = 4 * n3;
                            n9 = 0;
                            while (n9 < 4) {
                                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n6);
                                if (!chartDataViewSeries.isVisible()) {
                                    bl7 = false;
                                    break;
                                }
                                if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) {
                                    bl6 = false;
                                    break;
                                }
                                n8 = Math.min(n8, chartDataViewSeries.getFirstPoint());
                                n7 = Math.min(n7, chartDataViewSeries.getLastPoint());
                                ++n9;
                                ++n6;
                            }
                            if (!bl7 || !bl6) break block29;
                            n5 = 0;
                            n4 = 0;
                            jCChartStyle4 = this.cf.getHiloStyle(n3);
                            if (jCChartStyle4 == null) break block29;
                            jCLineStyle = jCChartStyle4.getLineStyle();
                            if (!this.isComplex) break block30;
                            jCChartStyle3 = this.cf.getRisingCandleStyle(n3);
                            if (jCChartStyle3 == null) break block29;
                            n5 = jCChartStyle3.getSymbolSize();
                            jCChartStyle2 = this.cf.getFallingCandleStyle(n3);
                            if (jCChartStyle2 == null) break block29;
                            n4 = jCChartStyle2.getSymbolSize();
                            jCChartStyle = this.cf.getCandleOutlineStyle(n3);
                            if (jCChartStyle != null) break block31;
                            break block29;
                        }
                        jCChartStyle3 = jCChartStyle4;
                        jCChartStyle2 = jCChartStyle4;
                        jCChartStyle = jCChartStyle4;
                        n4 = n5 = jCChartStyle4.getSymbolSize();
                    }
                    boolean bl8 = jCLineStyle.updateGraphics(graphics);
                    PlotPoint[] plotPointArray = new PlotPoint[]{new PlotPoint(), new PlotPoint()};
                    int n10 = n8;
                    while (n10 <= n7) {
                        block33: {
                            double d2;
                            double d3;
                            double d4;
                            double d5;
                            double d6;
                            double d7;
                            double d8;
                            double d9;
                            block32: {
                                int n11 = 4 * n3;
                                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n11++);
                                double d10 = chartDataViewSeries.getX(n10);
                                double d11 = chartDataViewSeries.getY(n10);
                                chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n11++);
                                double d12 = chartDataViewSeries.getX(n10);
                                double d13 = chartDataViewSeries.getY(n10);
                                if (d11 < d13) {
                                    d9 = d10;
                                    d8 = d11;
                                    d10 = d12;
                                    d11 = d13;
                                    d12 = d9;
                                    d13 = d8;
                                }
                                chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n11++);
                                d7 = chartDataViewSeries.getX(n10);
                                d6 = chartDataViewSeries.getY(n10);
                                chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n11++);
                                d5 = chartDataViewSeries.getX(n10);
                                d4 = chartDataViewSeries.getY(n10);
                                bl = d6 < d4;
                                bl3 = (d11 == this.holeValue || d13 == this.holeValue || d10 == this.holeValue || d12 == this.holeValue || bl4 && d10 <= 0.0 || bl5 && d11 <= 0.0 || bl4 && d12 <= 0.0 || bl5 && d13 <= 0.0) ^ true;
                                bl2 = (d4 == this.holeValue || d6 == this.holeValue || d5 == this.holeValue || d7 == this.holeValue || bl4 && d5 <= 0.0 || bl5 && d4 <= 0.0 || bl4 && d7 <= 0.0 || bl5 && d6 <= 0.0) ^ true;
                                d9 = d10;
                                d8 = d11;
                                if (!bl3 || !bl8) break block32;
                                if (bl2) {
                                    d3 = bl ? d5 : d7;
                                    d2 = bl ? d4 : d6;
                                } else {
                                    d3 = d12;
                                    d2 = d13;
                                }
                                plotPointArray[0].valid = false;
                                plotPointArray[1].valid = false;
                                this.financialClip(d9, d8, d3, d2, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                                if (plotPointArray[0].valid && plotPointArray[1].valid) {
                                    ((Graphics2D)graphics).draw(new Line2D.Double(plotPointArray[0].px, plotPointArray[0].py, plotPointArray[1].px, plotPointArray[1].py));
                                }
                                if (!bl2) break block33;
                                d9 = d12;
                                d8 = d13;
                                d3 = bl ? d7 : d5;
                                d2 = bl ? d6 : d4;
                                plotPointArray[0].valid = false;
                                plotPointArray[1].valid = false;
                                this.financialClip(d9, d8, d3, d2, this.xlim, this.ylim, plotPointArray, this.inverted, false);
                                if (plotPointArray[0].valid && plotPointArray[1].valid) {
                                    ((Graphics2D)graphics).draw(new Line2D.Double(plotPointArray[0].px, plotPointArray[0].py, plotPointArray[1].px, plotPointArray[1].py));
                                }
                            }
                            if (bl2) {
                                boolean bl9 = false;
                                int n12 = Integer.MAX_VALUE;
                                int n13 = Integer.MAX_VALUE;
                                int n14 = Integer.MIN_VALUE;
                                int n15 = Integer.MIN_VALUE;
                                double d14 = d7;
                                double d15 = d6;
                                int n16 = this.xaxis.toPixel(d14, this.drawFront);
                                int n17 = (bl ? n5 : n4) / 2;
                                d9 = this.xaxis.toData(n16 - n17, this.drawFront);
                                d8 = d15;
                                d3 = this.xaxis.toData(n16 + n17, this.drawFront);
                                d2 = d15;
                                boolean bl10 = (d6 > this.ylim.max && d4 > this.ylim.max || d6 < this.ylim.min && d4 < this.ylim.min) ^ true;
                                plotPointArray[0].valid = false;
                                plotPointArray[1].valid = false;
                                this.financialClip(d9, d8, d3, d2, this.xlim, this.ylim, plotPointArray, this.inverted, bl10);
                                n6 = 0;
                                while (n6 < plotPointArray.length && !bl9) {
                                    if (plotPointArray[n6].valid) {
                                        n12 = Math.min(n12, plotPointArray[n6].px);
                                        n14 = Math.max(n14, plotPointArray[n6].px);
                                        n13 = Math.min(n13, plotPointArray[n6].py);
                                        n15 = Math.max(n15, plotPointArray[n6].py);
                                    } else {
                                        bl9 = true;
                                    }
                                    ++n6;
                                }
                                if (!bl9) {
                                    d14 = d5;
                                    d15 = d4;
                                    n16 = this.xaxis.toPixel(d14, this.drawFront);
                                    d9 = this.xaxis.toData(n16 - n17, this.drawFront);
                                    d8 = d15;
                                    d3 = this.xaxis.toData(n16 + n17, this.drawFront);
                                    d2 = d15;
                                    plotPointArray[0].valid = false;
                                    plotPointArray[1].valid = false;
                                    this.financialClip(d9, d8, d3, d2, this.xlim, this.ylim, plotPointArray, this.inverted, bl10);
                                    n6 = 0;
                                    while (n6 < plotPointArray.length && !bl9) {
                                        if (plotPointArray[n6].valid) {
                                            n12 = Math.min(n12, plotPointArray[n6].px);
                                            n14 = Math.max(n14, plotPointArray[n6].px);
                                            n13 = Math.min(n13, plotPointArray[n6].py);
                                            n15 = Math.max(n15, plotPointArray[n6].py);
                                        } else {
                                            bl9 = true;
                                        }
                                        ++n6;
                                    }
                                    if (!bl9) {
                                        if (bl) {
                                            this.drawCandleRect(graphics2, jCChartStyle3.getFillStyle(), jCChartStyle.getLineStyle(), n12, n13, n14, n15, this.isComplex, bl);
                                        } else {
                                            this.drawCandleRect(graphics2, jCChartStyle2.getFillStyle(), jCChartStyle.getLineStyle(), n12, n13, n14, n15, this.isComplex, bl);
                                        }
                                    }
                                }
                            }
                        }
                        ++n10;
                    }
                    jCLineStyle.resetGraphics(graphics);
                }
                ++n3;
            }
            graphics2.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    private final void drawCandleRect(Graphics graphics, JCFillStyle jCFillStyle, JCLineStyle jCLineStyle, int n2, int n3, int n4, int n5, boolean bl, boolean bl2) {
        int n6 = Math.max(n4 - n2, 1);
        int n7 = Math.max(n5 - n3, 1);
        if (bl) {
            jCFillStyle.fillRect(graphics, n2, n3, n6 == 1 ? n6 : n6 + 1, n7 == 1 ? n7 : n7 + 1);
            if (jCLineStyle.updateGraphics(graphics)) {
                ((Graphics2D)graphics).draw(new Rectangle2D.Double(n2, n3, n6, n7));
            }
        } else if (jCLineStyle.updateGraphics(graphics)) {
            if (!bl2) {
                graphics.fillRect(n2, n3, n6 == 1 ? n6 : n6 + 1, n7 == 1 ? n7 : n7 + 1);
            }
            ((Graphics2D)graphics).draw(new Rectangle2D.Double(n2, n3, n6, n7));
        }
    }

    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
        } else {
            this.chartArea.drawRubberLine(this.start, this.end);
        }
        return jCDataIndex.dataView.getXAxis().vertical ? n2 - this.r.x : n3 - this.r.y;
    }

    public int getNumSeriesPerData() {
        return 4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JCDataIndex pick(Point point, int n2) {
        Rectangle rectangle = this.chartArea.getDrawingArea();
        int n3 = point.x - rectangle.x;
        int n4 = point.y - rectangle.y;
        int n5 = -1;
        int n6 = -1;
        JCDataIndex jCDataIndex = null;
        double d2 = Double.MAX_VALUE;
        if (this.seriesList == null) {
            return jCDataIndex;
        }
        boolean bl = this.xaxis.isLogarithmic();
        boolean bl2 = this.yaxis.isLogarithmic();
        int n7 = this.seriesList.size() / 4;
        try {
            int n8 = 0;
            while (n8 < n7) {
                boolean bl3 = true;
                int n9 = Integer.MAX_VALUE;
                int n10 = Integer.MAX_VALUE;
                boolean bl4 = true;
                int n11 = 4 * n8;
                int n12 = 0;
                while (n12 < 4) {
                    ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n11);
                    if (!chartDataViewSeries.isVisible()) {
                        bl4 = false;
                        break;
                    }
                    if (chartDataViewSeries.maxXIndex() == 0 || chartDataViewSeries.maxYIndex() == 0) {
                        bl3 = false;
                        break;
                    }
                    n9 = Math.min(n9, chartDataViewSeries.getFirstPoint());
                    n10 = Math.min(n10, chartDataViewSeries.getLastPoint());
                    ++n12;
                    ++n11;
                }
                if (bl4 && bl3) {
                    Object object;
                    double d3 = 0.0;
                    double d4 = 0.0;
                    if (this.isComplex) {
                        object = this.cf.getRisingCandleStyle(n8);
                        if (object != null) {
                            d3 = Math.abs(this.xaxis.toData(0) - this.xaxis.toData(((JCChartStyle)object).getSymbolSize()));
                        }
                        if ((object = this.cf.getFallingCandleStyle(n8)) != null) {
                            d4 = Math.abs(this.xaxis.toData(0) - this.xaxis.toData(((JCChartStyle)object).getSymbolSize()));
                        }
                    } else {
                        object = this.cf.getHiloStyle(n8);
                        if (object != null) {
                            d4 = d3 = Math.abs(this.xaxis.toData(0) - this.xaxis.toData(((JCChartStyle)object).getSymbolSize()));
                        }
                    }
                    object = ((ChartDataViewSeries)this.seriesList.get(4 * n8)).getX();
                    double[] dArray = ((ChartDataViewSeries)this.seriesList.get(4 * n8)).getY();
                    double[] dArray2 = ((ChartDataViewSeries)this.seriesList.get(4 * n8 + 1)).getX();
                    double[] dArray3 = ((ChartDataViewSeries)this.seriesList.get(4 * n8 + 1)).getY();
                    double[] dArray4 = ((ChartDataViewSeries)this.seriesList.get(4 * n8 + 2)).getX();
                    double[] dArray5 = ((ChartDataViewSeries)this.seriesList.get(4 * n8 + 2)).getY();
                    double[] dArray6 = ((ChartDataViewSeries)this.seriesList.get(4 * n8 + 3)).getX();
                    double[] dArray7 = ((ChartDataViewSeries)this.seriesList.get(4 * n8 + 3)).getY();
                    double d5 = 0.0;
                    double d6 = 0.0;
                    int n13 = n9;
                    while (n13 <= n10) {
                        int n14;
                        int n15;
                        Object object2 = object[n13];
                        double d7 = dArray[n13];
                        Object object3 = dArray2[n13];
                        double d8 = dArray3[n13];
                        if (d7 < d8) {
                            Object object4 = object2;
                            double d9 = d7;
                            object2 = object3;
                            d7 = d8;
                            object3 = object4;
                            d8 = d9;
                        }
                        double d10 = dArray4[n13];
                        double d11 = dArray5[n13];
                        double d12 = dArray6[n13];
                        double d13 = dArray7[n13];
                        boolean bl5 = (d13 == this.holeValue || d11 == this.holeValue || d12 == this.holeValue || d10 == this.holeValue || bl && d12 <= 0.0 || bl2 && d13 <= 0.0 || bl && d10 <= 0.0 || bl2 && d11 <= 0.0) ^ true;
                        double d14 = d11 < d13 ? d3 : d4;
                        boolean bl6 = false;
                        if (!(d7 == this.holeValue || d8 == this.holeValue || object2 == this.holeValue || object3 == this.holeValue || bl && object2 <= 0.0 || bl2 && d7 <= 0.0 || bl && object3 <= 0.0 || bl2 && d8 <= 0.0)) {
                            if (bl5) {
                                n15 = 0;
                                n14 = 4;
                            } else {
                                n15 = 0;
                                n14 = 2;
                            }
                        } else if (bl5) {
                            n15 = 2;
                            n14 = 4;
                        } else {
                            n15 = 0;
                            n14 = 0;
                        }
                        int n16 = n15;
                        block15: while (n16 < n14) {
                            double d15;
                            switch (n16) {
                                case 0: {
                                    d5 = (double)object2;
                                    d6 = d7;
                                    break;
                                }
                                case 1: {
                                    d5 = object3;
                                    d6 = d8;
                                    break;
                                }
                                case 2: {
                                    if (d14 == 0.0) {
                                        ++n16;
                                        continue block15;
                                    }
                                    if (!bl6) {
                                        d5 = d10 - d14;
                                        d6 = d11;
                                        bl6 = true;
                                        break;
                                    }
                                    d5 = d10 + d14;
                                    bl6 = false;
                                    break;
                                }
                                case 3: {
                                    if (d14 == 0.0) {
                                        ++n16;
                                        continue block15;
                                    }
                                    if (!bl6) {
                                        d5 = d12 - d14;
                                        d6 = d13;
                                        bl6 = true;
                                        break;
                                    }
                                    d5 = d12 + d14;
                                    bl6 = false;
                                }
                            }
                            if (d5 > this.xlim.max || this.xlim.min > d5 || d6 > this.ylim.max || this.ylim.min > d6) {
                                if (bl6) continue;
                                ++n16;
                                continue;
                            }
                            switch (n2) {
                                case 1: {
                                    int n17 = this.xaxis.toPixel(d5, this.drawFront);
                                    d15 = this.inverted ? Math.abs(n17 - n4) : Math.abs(n17 - n3);
                                    break;
                                }
                                case 2: {
                                    int n18 = this.yaxis.toPixel(d6, this.drawFront);
                                    d15 = this.inverted ? Math.abs(n18 - n3) : Math.abs(n18 - n4);
                                    break;
                                }
                                default: {
                                    int n17 = this.xaxis.toPixel(d5, this.drawFront);
                                    int n18 = this.yaxis.toPixel(d6, this.drawFront);
                                    double d16 = d15 = this.inverted ? Math.sqrt((n18 - n3) * (n18 - n3) + (n17 - n4) * (n17 - n4)) : Math.sqrt((n17 - n3) * (n17 - n3) + (n18 - n4) * (n18 - n4));
                                }
                            }
                            if (d2 > d15) {
                                n5 = n8 * 4 + n16;
                                n6 = n13;
                                d2 = d15;
                            }
                            if (bl6) continue;
                            ++n16;
                        }
                        ++n13;
                    }
                }
                ++n8;
            }
            if (n5 >= 0 && n6 >= 0) {
                jCDataIndex = new JCDataIndex(n6, (ChartDataViewSeries)this.seriesList.get(n5), n5);
                jCDataIndex.distance = (int)d2;
            }
            return jCDataIndex;
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            return null;
        }
    }

    public void recalc() {
        this.recalc(-1);
    }

    public void recalc(int n2) {
        super.recalc();
        if (n2 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.cf = (JCCandleChartFormat)this.dataObject.getChartFormat();
        this.holeValue = this.dataObject.getHoleValue();
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        this.inverted = this.xaxis.vertical;
        if (n2 == -1 || n2 == 0) {
            this.xlim = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
            this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
            this.dataObject.getDataBounds(this.xlim, this.ylim);
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.getXAxis().vertical;
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
        } else {
            this.chartArea.drawRubberLine(this.start, this.end);
        }
        if (bl) {
            this.end.x = n2;
        } else {
            this.end.y = n3;
        }
        if (this.useRubberBand) {
            this.chartArea.drawRubberBand(this.end, this.start);
        } else {
            this.chartArea.drawRubberLine(this.start, this.end);
        }
    }

    void startEdit(JCDataIndex jCDataIndex) {
        double d2;
        double d3;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        boolean bl = jCDataIndex.dataView.getXAxis().vertical;
        int n2 = jCDataIndex.series.getDrawingOrder() / 4;
        this.r = this.chartArea.getDrawingArea();
        this.start = null;
        this.end = null;
        this.useRubberBand = false;
        int n3 = n2 * 4;
        int n4 = jCDataIndex.seriesIndex - n3;
        int n5 = 0;
        int n6 = 0;
        if (this.isComplex) {
            JCChartStyle jCChartStyle = this.cf.getRisingCandleStyle(n2);
            if (jCChartStyle != null) {
                n5 = jCChartStyle.getSymbolSize();
            }
            if ((jCChartStyle = this.cf.getFallingCandleStyle(n2)) != null) {
                n6 = jCChartStyle.getSymbolSize();
            }
        } else {
            JCChartStyle jCChartStyle = this.cf.getHiloStyle(n2);
            if (jCChartStyle != null) {
                n6 = n5 = jCChartStyle.getSymbolSize();
            }
        }
        boolean bl2 = (d3 = ((ChartDataViewSeries)this.seriesList.get(n3 + 2)).getY(jCDataIndex.point)) < (d2 = ((ChartDataViewSeries)this.seriesList.get(n3 + 3)).getY(jCDataIndex.point));
        int n7 = bl2 ? n5 : n6;
        double d4 = ((ChartDataViewSeries)this.seriesList.get(n3 + n4)).getX(jCDataIndex.point);
        double d5 = ((ChartDataViewSeries)this.seriesList.get(n3 + n4)).getY(jCDataIndex.point);
        if (n4 > 1) {
            this.useRubberBand = true;
            if (bl) {
                this.start = new Point(this.yaxis.toPixel(d5) + this.r.x, this.xaxis.toPixel(d4) + this.r.y - n7 / 2);
                this.end = new Point(this.start.x, this.start.y + n7);
            } else {
                this.start = new Point(this.xaxis.toPixel(d4) + this.r.x - n7 / 2, this.yaxis.toPixel(d5) + this.r.y);
                this.end = new Point(this.start.x + n7, this.start.y);
            }
        } else {
            this.start = bl ? new Point(this.yaxis.toPixel(d5) + this.r.x, this.xaxis.toPixel(d4) + this.r.y) : new Point(this.xaxis.toPixel(d4) + this.r.x, this.yaxis.toPixel(d5) + this.r.y);
            this.end = new Point(this.start.x, this.start.y);
        }
    }

    public Point unpick(int n2, int n3) {
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
        if (chartDataViewSeries == null) {
            return null;
        }
        double d2 = chartDataViewSeries.getY(n2);
        double d3 = chartDataViewSeries.getX(n2);
        int n4 = -1;
        int n5 = -1;
        if (d2 != this.holeValue && d3 != this.holeValue) {
            if (this.inverted) {
                n4 = this.yaxis.toPixel(d2, this.drawFront);
                n5 = this.xaxis.toPixel(d3, this.drawFront);
            } else {
                n4 = this.xaxis.toPixel(d3, this.drawFront);
                n5 = this.yaxis.toPixel(d2, this.drawFront);
            }
            return new Point(n4, n5);
        }
        return null;
    }
}

