/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.EditableChartDataModel;
import com.klg.jclass.chart.HoleValueChartDataModel;
import com.klg.jclass.chart.LabelledChartDataModel;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public class DataHandler {
    private ChartDataView view;

    public DataHandler(ChartDataView chartDataView) {
        this.view = chartDataView;
    }

    public void addSeries() {
        int n2;
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null) {
            return;
        }
        int n3 = n2 = this.view.getNumSeries();
        double[] dArray = chartDataModel.getXSeries(n3);
        double[] dArray2 = chartDataModel.getYSeries(n3);
        boolean bl = this.view.isBatched();
        this.view.setBatched(true);
        ChartDataViewSeries chartDataViewSeries = new ChartDataViewSeries(dArray, dArray2, this.view);
        this.view.addSeries(chartDataViewSeries);
        this.reloadSeriesLabel(n3);
        this.view.setChanged(true);
        this.view.setBatched(bl);
    }

    public void appendData() {
        this.refreshData(this.view.getDataSource());
    }

    public void changeChartType(int n2) {
        this.view.setChartType(n2);
    }

    public boolean editPoint(int n2, int n3, double d2) {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof EditableChartDataModel)) {
            return false;
        }
        EditableChartDataModel editableChartDataModel = (EditableChartDataModel)chartDataModel;
        return editableChartDataModel.setDataItem(n2, n3, d2);
    }

    public void insertSeries(int n2) {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null) {
            return;
        }
        int n3 = this.view.getNumSeries();
        if (n2 >= n3) {
            return;
        }
        double[] dArray = chartDataModel.getXSeries(n2);
        double[] dArray2 = chartDataModel.getYSeries(n2);
        boolean bl = this.view.isBatched();
        this.view.setBatched(true);
        ChartDataViewSeries chartDataViewSeries = this.view.addSeries(n2);
        chartDataViewSeries.setX(dArray);
        chartDataViewSeries.setY(dArray2);
        this.reloadSeriesLabel(n2);
        this.view.setChanged(true);
        this.view.setBatched(bl);
    }

    public void loadData(ChartDataModel chartDataModel) {
        int n2 = chartDataModel == null ? 0 : chartDataModel.getNumSeries();
        Vector<ChartDataViewSeries> vector = chartDataModel != null ? new Vector<ChartDataViewSeries>(n2) : null;
        List list = this.view.getSeries();
        boolean bl = this.view.isBatched();
        this.view.setBatched(true);
        if (chartDataModel != null && n2 != 0) {
            int n3 = 0;
            this.view.setX(chartDataModel.getXSeries(0));
            int n4 = 0;
            while (n4 < n2) {
                ChartDataViewSeries chartDataViewSeries;
                double[] dArray = chartDataModel.getXSeries(n4);
                double[] dArray2 = chartDataModel.getYSeries(n4);
                if (dArray2 != null && n3 < dArray2.length) {
                    n3 = dArray2.length;
                }
                if (dArray != this.view.getX()) {
                    this.view.setX(null);
                }
                if (n4 < list.size()) {
                    chartDataViewSeries = (ChartDataViewSeries)list.get(n4);
                    chartDataViewSeries.setX(dArray);
                    chartDataViewSeries.setY(dArray2);
                } else {
                    chartDataViewSeries = new ChartDataViewSeries(dArray, dArray2, this.view);
                    chartDataViewSeries.setDrawingOrder(n4);
                }
                vector.add(chartDataViewSeries);
                ++n4;
            }
        } else {
            this.view.setX(null);
        }
        this.view.setSeries(vector);
        this.view.setChanged(true);
        this.view.setBatched(bl);
    }

    public void refreshData(ChartDataModel chartDataModel) {
        int n2;
        int n3 = n2 = this.view == null ? 0 : this.view.getNumSeries();
        if (chartDataModel != null && n2 != 0) {
            this.view.setX(chartDataModel.getXSeries(0));
            int n4 = 0;
            while (n4 < n2) {
                double[] dArray = chartDataModel.getXSeries(n4);
                double[] dArray2 = chartDataModel.getYSeries(n4);
                if (dArray != this.view.getX()) {
                    this.view.setX(null);
                }
                ChartDataViewSeries chartDataViewSeries = this.view.getSeries(n4);
                chartDataViewSeries.setX(dArray);
                chartDataViewSeries.setY(dArray2);
                ++n4;
            }
        } else {
            this.view.setX(null);
        }
    }

    public void reload() {
        this.refreshData(this.view.getDataSource());
        this.reloadHoleValue();
        this.reloadAllSeriesLabels();
    }

    public void reloadAllPointLabels() {
        if (this.view == null) {
            return;
        }
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof LabelledChartDataModel)) {
            this.view.setPointLabels(new Vector());
            return;
        }
        LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)chartDataModel);
        String[] stringArray = labelledChartDataModel.getPointLabels();
        Vector<Object> vector = stringArray == null ? new Vector() : new Vector<String>(Arrays.asList(stringArray));
        this.view.setPointLabels(vector);
    }

    public void reloadAllSeriesLabels() {
        if (this.view == null) {
            return;
        }
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof LabelledChartDataModel)) {
            return;
        }
        LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)chartDataModel);
        String[] stringArray = labelledChartDataModel.getSeriesLabels();
        if (stringArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.view.getNumSeries() && n2 < stringArray.length) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(n2);
            chartDataViewSeries.setLabel(stringArray[n2]);
            ++n2;
        }
    }

    public void reloadDataSourceName() {
        if (this.view == null) {
            return;
        }
        if (this.view.getDataSource() instanceof LabelledChartDataModel) {
            LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)this.view.getDataSource());
            this.view.setName(labelledChartDataModel.getDataSourceName());
        }
    }

    public void reloadHoleValue() {
        if (this.view == null) {
            return;
        }
        if (this.view.getDataSource() instanceof HoleValueChartDataModel) {
            HoleValueChartDataModel holeValueChartDataModel = (HoleValueChartDataModel)((Object)this.view.getDataSource());
            this.view.setHoleValue(holeValueChartDataModel.getHoleValue());
        }
    }

    public void reloadPoint(int n2, int n3) {
        int n4;
        ChartDataModel chartDataModel = this.view.getDataSource();
        int n5 = n4 = chartDataModel == null ? 0 : chartDataModel.getNumSeries();
        if (chartDataModel != null && n2 >= 0 && n2 < n4) {
            this.view.setChanged(true);
        }
    }

    public void reloadPointLabel(int n2) {
        if (this.view == null) {
            return;
        }
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof LabelledChartDataModel)) {
            return;
        }
        LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)chartDataModel);
        String[] stringArray = labelledChartDataModel.getPointLabels();
        if (stringArray != null && n2 < stringArray.length) {
            this.view.setPointLabel(n2, stringArray[n2]);
        }
    }

    public void reloadSeries(int n2) {
        int n3;
        ChartDataModel chartDataModel = this.view.getDataSource();
        int n4 = n3 = chartDataModel == null ? 0 : chartDataModel.getNumSeries();
        if (chartDataModel != null && n2 >= 0 && n2 < n3) {
            ChartDataViewSeries chartDataViewSeries = this.view.getSeries(n2);
            double[] dArray = chartDataModel.getYSeries(n2);
            chartDataViewSeries.setY(dArray);
            if (this.view.getX() == null) {
                double[] dArray2 = chartDataModel.getXSeries(n2);
                chartDataViewSeries.setX(dArray2);
            }
            this.view.setChanged(true);
        }
    }

    public void reloadSeriesLabel(int n2) {
        if (this.view == null) {
            return;
        }
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null || !(chartDataModel instanceof LabelledChartDataModel)) {
            return;
        }
        LabelledChartDataModel labelledChartDataModel = (LabelledChartDataModel)((Object)chartDataModel);
        String[] stringArray = labelledChartDataModel.getSeriesLabels();
        if (stringArray != null && n2 < stringArray.length && n2 < this.view.getNumSeries()) {
            this.view.getSeries(n2).setLabel(stringArray[n2]);
        }
    }

    public void removeSeries(int n2) {
        ChartDataModel chartDataModel = this.view.getDataSource();
        if (chartDataModel == null) {
            return;
        }
        int n3 = this.view.getNumSeries();
        if (n2 >= n3) {
            return;
        }
        this.view.removeSeries(n2);
    }

    public void reset() {
        this.loadData(this.view.getDataSource());
        this.reloadHoleValue();
        this.reloadAllPointLabels();
        this.reloadAllSeriesLabels();
        this.reloadDataSourceName();
    }
}

