/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartInteriorRegion;
import com.klg.jclass.chart.ChartRegion;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.util.JCNumberUtil;
import com.klg.jclass.util.swing.TextRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.CellRendererPane;

public class ChartText
extends ChartInteriorRegion
implements Serializable {
    protected int adjust = 1;
    protected int rotation = 0;
    protected String text = null;
    protected JCAxis parentAxis = null;
    protected static TextRenderer rendComp = new TextRenderer();
    protected transient Image buffer;
    boolean isHTML = false;
    public static final int LEFT = 0;
    public static final int CENTER = 1;
    public static final int RIGHT = 2;
    public static final int DEG_0 = 0;
    public static final int DEG_90 = 1;
    public static final int DEG_180 = 2;
    public static final int DEG_270 = 3;

    public ChartText() {
    }

    public ChartText(JCChart jCChart, String string, ChartRegion chartRegion) {
        this.setParentRegion(chartRegion);
        this.setText(string);
        this.setParentChart(jCChart);
    }

    public ChartText(JCChart jCChart, String string, JCAxis jCAxis) {
        this.setParentAxis(jCAxis);
        this.setText(string);
        this.setParentChart(jCChart);
    }

    public Dimension calcLineSize() {
        if (this.isHTML) {
            int n2 = 1;
            n2 += JCNumberUtil.countInString("<p>", this.text);
            n2 += JCNumberUtil.countInString("<br>", this.text);
            n2 += JCNumberUtil.countInString("<P>", this.text);
            return new Dimension(this.getWidth(), this.getHeight() / (n2 += JCNumberUtil.countInString("<BR>", this.text)));
        }
        if (this.getFont() == null) {
            return new Dimension(0, 0);
        }
        FontMetrics fontMetrics = null;
        try {
            fontMetrics = this.parentChart.getGraphics().getFontMetrics(this.getFont());
        }
        catch (Exception exception) {}
        return new Dimension(this.getWidth(), fontMetrics.getAscent());
    }

    protected Dimension calcSize() {
        if (this.isHTML) {
            return rendComp.calcHTMLTextSize(this.text);
        }
        Font font = this.getFont();
        if (font == null) {
            return new Dimension(0, 0);
        }
        FontMetrics fontMetrics = null;
        try {
            fontMetrics = this.parentChart.getGraphics().getFontMetrics(font);
        }
        catch (Exception exception) {}
        if (fontMetrics != null) {
            if (this.text == null) {
                return new Dimension(0, fontMetrics.getHeight());
            }
            Dimension dimension = new Dimension(fontMetrics.stringWidth(this.text), fontMetrics.getHeight());
            JCNumberUtil.fudgeItalicLabel(font, dimension);
            return dimension;
        }
        return new Dimension(0, 0);
    }

    public void draw(Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (graphics == null) {
            return;
        }
        if (this.parentChart == null) {
            return;
        }
        boolean bl = this.transparent;
        if (this.transparent && this.background != null) {
            this.transparent = false;
        }
        super.draw(graphics);
        this.transparent = bl;
        Graphics graphics2 = graphics.create();
        Rectangle rectangle = this.getDrawingArea();
        graphics2.setColor(this.getForeground());
        graphics2.setFont(this.getFont());
        FontMetrics fontMetrics = null;
        try {
            fontMetrics = this.parentChart.getGraphics().getFontMetrics(this.getFont());
        }
        catch (Exception exception) {}
        if (this.text != null && fontMetrics != null) {
            Graphics2D graphics2D = (Graphics2D)graphics2;
            if (this.rotation == 1) {
                graphics2D.translate(rectangle.width, 0);
                graphics2D.rotate(1.5707963267948966, rectangle.x, rectangle.y);
            } else if (this.rotation == 2) {
                graphics2D.translate(rectangle.width, rectangle.height);
                graphics2D.rotate(Math.PI, rectangle.x, rectangle.y);
            } else if (this.rotation == 3) {
                graphics2D.translate(0, rectangle.height + 1);
                graphics2D.rotate(4.71238898038469, rectangle.x, rectangle.y);
            }
            if (this.isHTML) {
                ChartRegion chartRegion = this.parentAxis == null ? this.getParentRegion() : this.parentAxis.getParentRegion();
                CellRendererPane cellRendererPane = chartRegion.getCellRendererPane();
                if (cellRendererPane != null) {
                    if (this.rotation == 0 || this.rotation == 2) {
                        rendComp.drawHTMLText(graphics2D, cellRendererPane, chartRegion, this.text, this.getLeft(), this.getTop(), this.getWidth(), this.getHeight());
                    } else {
                        rendComp.drawHTMLText(graphics2D, cellRendererPane, chartRegion, this.text, this.getLeft(), this.getTop(), this.getHeight(), this.getWidth());
                    }
                }
            } else if (this.text.length() > 0) {
                graphics2D.drawString(this.text, rectangle.x + 1, rectangle.y + fontMetrics.getAscent());
            }
        }
        if (graphics2 != null) {
            graphics2.dispose();
        }
        this.setChanged(false, 0);
    }

    public int getAdjust() {
        return this.adjust;
    }

    public Color getBackground() {
        return this.background == null ? (this.parentAxis == null ? (this.parentChart == null ? null : (this.parentChart.isOpaque() ? this.parentChart.getBackground() : null)) : this.parentAxis.getBackground()) : this.background;
    }

    public Font getFont() {
        return this.font == null ? (this.parentAxis == null ? (this.parentChart == null ? null : this.parentChart.getFont()) : this.parentAxis.getFont()) : this.font;
    }

    public Color getForeground() {
        return this.foreground == null ? (this.parentRegion == null ? (this.parentAxis == null ? (this.parentChart == null ? null : this.parentChart.getForeground()) : this.parentAxis.getForeground()) : this.parentRegion.getForeground()) : this.foreground;
    }

    public int getRotation() {
        return this.rotation;
    }

    public String getText() {
        return this.text;
    }

    public Dimension preferredSize() {
        this.recalc();
        Dimension dimension = this.size();
        return dimension;
    }

    public void recalc() {
        this.recalc(false);
    }

    void recalc(boolean bl) {
        boolean bl2 = false;
        if (this.isChanged(2)) {
            bl2 = true;
        } else if (!bl) {
            return;
        }
        Dimension dimension = this.calcSize();
        if (dimension.width == 0 || dimension.height == 0) {
            this.setSize(0, 0);
        } else if (this.rotation == 0 || this.rotation == 2) {
            this.setSize(dimension.width, dimension.height);
        } else {
            this.setSize(dimension.height, dimension.width);
        }
        if (bl2) {
            this.setChanged(false, 0);
        }
    }

    public void setAdjust(int n2) {
        if (n2 == this.adjust) {
            return;
        }
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                this.adjust = n2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid Adjust in ChartText.  Must be one of LEFT, CENTER or RIGHT");
            }
        }
        this.setChanged(true, 1);
    }

    void setParentAxis(JCAxis jCAxis) {
        this.parentAxis = jCAxis;
    }

    public void setParentChart(JCChart jCChart) {
        super.setParentChart(jCChart);
        this.setChanged(true, 2, false);
        this.recalc();
    }

    public void setRotation(int n2) {
        if (n2 == this.rotation) {
            return;
        }
        this.rotation = n2;
        this.setChanged(true, 2);
    }

    public void setText(String string) {
        this.setText(string, true);
    }

    public void setText(String string, boolean bl) {
        this.text = string;
        this.isHTML = JCNumberUtil.isHTML(this.text);
        if (bl) {
            this.setVisible(true);
        }
        if (this.parentChart == null) {
            return;
        }
        this.setChanged(true, 2);
    }

    public String toString() {
        if (this.text == null) {
            return super.toString();
        }
        return this.text;
    }
}

