/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.BarPoint;
import com.klg.jclass.chart.ChartDataView;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.Drawable;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChartArea;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.PlotPoint;
import com.klg.jclass.chart.TrackChange;
import java.awt.Graphics;
import java.awt.Point;
import java.io.Serializable;
import java.util.List;

public abstract class ChartDraw
extends TrackChange
implements Drawable,
Serializable {
    protected List seriesList = null;
    protected boolean inverted = false;
    protected double holeValue = Double.MAX_VALUE;
    boolean fastUpdate = false;
    boolean cachePlotData = true;
    protected JCAxis xaxis = null;
    protected JCAxis yaxis = null;
    int chartType = -1;
    protected ChartDataView dataObject = null;
    protected JCChartArea chartArea = null;
    protected int numActiveDataSeries;
    protected boolean drawFront = true;
    public static String[] drawables = new String[]{"com.klg.jclass.chart.FastPlotChartDraw", "com.klg.jclass.chart.FastPlotChartDraw", "com.klg.jclass.chart.PolarChartDraw", "com.klg.jclass.chart.RadarChartDraw", "com.klg.jclass.chart.RadarChartDraw", "com.klg.jclass.chart.FastHiloChartDraw", "com.klg.jclass.chart.FastHLOCChartDraw", "com.klg.jclass.chart.FastCandleChartDraw", "com.klg.jclass.chart.AreaChartDraw", "com.klg.jclass.chart.BarChartDraw", "com.klg.jclass.chart.SBarChartDraw", "com.klg.jclass.chart.PieChartDraw", "com.klg.jclass.chart.SAreaChartDraw"};
    public static final int BASE_MARGIN = 10;
    public static final int NUM_SERIES_PER_DATA = 1;
    static final int TROUGH_NOT_DRAWN = 0;
    static final int TROUGH_DRAWN = 1;
    static final int FINISH_TROUGH_LATER = 2;

    public ChartDraw() {
    }

    public ChartDraw(ChartDataView chartDataView) {
        this.setDataView(chartDataView);
    }

    void addClippedPoint(PlotPoint[] plotPointArray, int n2, double d2, double d3, JCAxis jCAxis, JCAxis jCAxis2, boolean bl, boolean bl2) {
        PlotPoint plotPoint = plotPointArray[n2];
        if (bl) {
            plotPoint.px = jCAxis2.toPixel(d3, this.drawFront);
            plotPoint.py = jCAxis.toPixel(d2, this.drawFront);
        } else {
            plotPoint.px = jCAxis.toPixel(d2, this.drawFront);
            plotPoint.py = jCAxis2.toPixel(d3, this.drawFront);
        }
        plotPoint.drawPoint = bl2;
        plotPoint.valid = true;
    }

    protected void calcTransientData() {
    }

    public abstract void draw(Graphics var1);

    public void draw(Graphics graphics, int n2, int n3) {
    }

    /*
     * Unable to fully structure code
     */
    int drawXAxisTroughGrid(Graphics var1_1, int var2_2, int var3_3, JCAxis var4_4, int var5_5, double var6_6, int var8_7, int var9_8, double var10_9, double var12_10, double[] var14_11, int var15_12, int var16_13, JCLineStyle var17_14) {
        block13: {
            var18_15 = this.isDrawOverBar(this.inverted, var5_5, var3_3, var2_2, var6_6, var12_10, var10_9);
            if (!this.inverted && var2_2 > 0 || this.inverted && var3_3 > 0) {
                var19_16 = var8_7;
                var20_17 = var9_8;
            } else {
                var19_16 = var9_8;
                var20_17 = var8_7;
            }
            var21_18 = var16_13 == 1 ? var4_4.getMin() : var4_4.getMax();
            while (var15_12 >= 0 && var15_12 < var14_11.length && var14_11[var15_12] == 1.7976931348623157E308) {
                var15_12 += var16_13;
            }
            var23_19 = var17_14.updateGraphics(var1_1);
            if ((this.inverted || var2_2 <= 0) && (!this.inverted || var3_3 <= 0)) ** GOTO lbl39
            while (var15_12 >= 0 && var15_12 < var14_11.length && var4_4.toPixel(var14_11[var15_12], this.drawFront) <= (var18_15 != false ? var19_16 : var20_17)) {
                if (var23_19) {
                    var4_4.drawGridLineInTrough(var1_1, var17_14, var14_11[var15_12]);
                }
                if (var14_11[var15_12] == var21_18) {
                    var17_14.resetGraphics(var1_1);
                    if (var16_13 == 1) {
                        var4_4.postDrawOutlineTrough(var1_1, 1);
                    } else {
                        var4_4.postDrawOutlineTrough(var1_1, 2);
                    }
                    var17_14.updateGraphics(var1_1);
                }
                var15_12 += var16_13;
            }
            break block13;
lbl-1000:
            // 1 sources

            {
                if (var23_19) {
                    var4_4.drawGridLineInTrough(var1_1, var17_14, var14_11[var15_12]);
                }
                if (var14_11[var15_12] == var21_18) {
                    var17_14.resetGraphics(var1_1);
                    if (var16_13 == 1) {
                        var4_4.postDrawOutlineTrough(var1_1, 1);
                    } else {
                        var4_4.postDrawOutlineTrough(var1_1, 2);
                    }
                    var17_14.updateGraphics(var1_1);
                }
                var15_12 += var16_13;
lbl39:
                // 2 sources

                ** while (var15_12 >= 0 && var15_12 < var14_11.length && var4_4.toPixel((double)var14_11[var15_12], (boolean)this.drawFront) > (var18_15 != false ? var19_16 : var20_17))
            }
        }
        var17_14.resetGraphics(var1_1);
        return var15_12;
    }

    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        return -1;
    }

    void finalDrawAxisTroughGrid(Graphics graphics, JCAxis jCAxis, JCAxis jCAxis2, int n2, boolean bl, double[] dArray, int n3, int n4, JCLineStyle jCLineStyle) {
        if (!bl && jCAxis2.isVisible() && jCAxis2.gridVisible) {
            jCAxis2.drawGridInTrough(graphics, Double.MAX_VALUE, Double.MAX_VALUE);
        }
        if (jCAxis.isVisible() && jCAxis.gridVisible) {
            boolean bl2 = jCLineStyle.updateGraphics(graphics);
            while (n3 >= 0 && n3 < dArray.length && dArray[n3] == Double.MAX_VALUE) {
                n3 += n4;
            }
            while (n3 >= 0 && n3 < dArray.length) {
                if (bl2) {
                    jCAxis.drawGridLineInTrough(graphics, jCLineStyle, dArray[n3]);
                }
                n3 += n4;
            }
            jCLineStyle.resetGraphics(graphics);
        }
        if (!bl) {
            jCAxis2.postDrawOutlineTrough(graphics, 3);
        }
        if (n2 == 0) {
            jCAxis.postDrawOutlineTrough(graphics, 2);
        } else {
            jCAxis.postDrawOutlineTrough(graphics, 1);
        }
    }

    void financialClip(double d2, double d3, double d4, double d5, MinMax minMax, MinMax minMax2, PlotPoint[] plotPointArray, boolean bl, boolean bl2) {
        boolean bl3;
        double d6 = minMax.min;
        double d7 = minMax.max;
        double d8 = minMax2.min;
        double d9 = minMax2.max;
        boolean bl4 = true;
        boolean bl5 = true;
        if (d3 == this.dataObject.getHoleValue() || d2 == this.dataObject.getHoleValue() || d5 == this.dataObject.getHoleValue() || d4 == this.dataObject.getHoleValue()) {
            return;
        }
        boolean bl6 = d2 == d4;
        boolean bl7 = bl3 = d3 == d5;
        if (!bl6 && !bl3) {
            return;
        }
        if ((d3 < d8 && d5 < d8 || d3 > d9 && d5 > d9) && (!bl3 || !bl2)) {
            return;
        }
        if (d3 < d8) {
            d3 = d8;
            bl4 = false;
        } else if (d3 > d9) {
            d3 = d9;
            bl4 = false;
        }
        if (d5 < d8) {
            d5 = d8;
            bl5 = false;
        } else if (d5 > d9) {
            d5 = d9;
            bl5 = false;
        }
        if (d2 < d6 && d4 < d6 || d2 > d7 && d4 > d7) {
            return;
        }
        if (d2 < d6) {
            d2 = d6;
            bl4 = false;
        } else if (d2 > d7) {
            d2 = d7;
            bl4 = false;
        }
        if (d4 < d6) {
            d4 = d6;
            bl5 = false;
        } else if (d4 > d7) {
            d4 = d7;
            bl5 = false;
        }
        this.addClippedPoint(plotPointArray, 0, d2, d3, this.xaxis, this.yaxis, bl, bl4);
        this.addClippedPoint(plotPointArray, 1, d4, d5, this.xaxis, this.yaxis, bl, bl5);
    }

    void finishDrawYAxisTroughGrid(Graphics graphics, int n2, int n3, JCAxis jCAxis, int n4, double d2, double d3) {
        if (!this.inverted && n4 == 0 && n3 >= 0 || !this.inverted && n4 == 1 && n3 < 0 || this.inverted && n4 == 0 && n2 < 0 || this.inverted && n4 == 1 && n2 >= 0) {
            if (jCAxis.isVisible() && jCAxis.gridVisible) {
                jCAxis.drawGridInTrough(graphics, -1.7976931348623157E308, Math.min(d2, d3));
            }
            jCAxis.postDrawOutlineTrough(graphics, 2);
        } else {
            if (jCAxis.isVisible() && jCAxis.gridVisible) {
                jCAxis.drawGridInTrough(graphics, Math.max(d3, d2), Double.MAX_VALUE);
            }
            jCAxis.postDrawOutlineTrough(graphics, 1);
        }
    }

    public static String getDrawClass(int n2) {
        return drawables[n2];
    }

    public static String[] getDrawables() {
        return drawables;
    }

    public int getNumSeriesPerData() {
        return 1;
    }

    boolean isDrawFinalGridAndTrough(BarPoint barPoint, boolean bl, boolean bl2, int n2, int n3) {
        if (bl) {
            return true;
        }
        if (barPoint != null) {
            int n4 = 0;
            int n5 = 0;
            if (bl2) {
                n5 = barPoint.front.y + barPoint.front.height;
                n4 = barPoint.front.y;
            } else {
                n4 = barPoint.front.x;
                n5 = barPoint.front.x + barPoint.front.width;
            }
            int n6 = Math.max(n2, n3);
            int n7 = Math.min(n2, n3);
            return n4 <= n6 && n5 <= n6 && n4 >= n7 && n5 >= n7;
        }
        return true;
    }

    boolean isDrawOverBar(boolean bl, int n2, int n3, int n4, double d2, double d3, double d4) {
        return !bl && n2 == 0 && n3 <= 0 || !bl && n2 != 0 && n3 > 0 || bl && n2 == 0 && n4 > 0 || bl && n2 != 0 && n4 <= 0 ? d2 >= d3 && d2 >= d4 : d2 <= d3 && d2 <= d4;
    }

    public boolean isDrawingOnFront() {
        return this.drawFront;
    }

    public static ChartDraw makeDrawObject(ChartDataView chartDataView) {
        ChartDraw chartDraw = null;
        try {
            chartDraw = (ChartDraw)Class.forName(drawables[chartDataView.getChartType()]).newInstance();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            chartDraw = null;
            throw new RuntimeException("Could not find a drawable for chart type " + chartDataView.getChartType());
        }
        if (chartDraw != null) {
            chartDraw.setDataView(chartDataView);
        }
        return chartDraw;
    }

    public JCDataIndex pick(Point point, int n2) {
        return null;
    }

    public void recalc() {
        this.numActiveDataSeries = 0;
        List list = this.dataObject.getSeries();
        if (list == null || list.size() == 0) {
            return;
        }
        int n2 = 0;
        while (n2 < list.size()) {
            if (((ChartDataViewSeries)list.get(n2)).isVisible()) {
                ++this.numActiveDataSeries;
            }
            ++n2;
        }
        this.drawFront = this.chartArea == null || !this.chartArea.getDraw3D() || this.dataObject.is3DChartType() || this.dataObject.getXAxis().frontPlane && this.dataObject.getYAxis().frontPlane && this.dataObject.getDrawFrontPlane();
    }

    public void recalc(int n2, int n3) {
    }

    public void setChanged(boolean bl, int n2) {
        super.setChanged(bl, n2);
        if (!this.changed && this.dataObject != null) {
            this.dataObject.setChanged(false, 0, false);
        }
    }

    public void setChanged(boolean bl, int n2, boolean bl2) {
        if (bl2) {
            this.setChanged(bl, n2);
        } else {
            this.changed = bl;
            if (!this.changed && this.dataObject != null) {
                this.dataObject.setChanged(false, 0, false);
            }
        }
    }

    public void setDataView(ChartDataView chartDataView) {
        this.dataObject = chartDataView;
        this.chartArea = chartDataView.getParent().getChartArea();
        if (this.dataObject != null) {
            this.chartType = this.dataObject.getChartType();
        }
    }

    public static void setDrawClass(int n2, String string) {
        ChartDraw.drawables[n2] = string;
    }

    public static void setDrawables(String[] stringArray) {
        if (stringArray.length <= 12) {
            throw new IllegalArgumentException("Array too small for pre-existing chart types");
        }
        drawables = stringArray;
    }

    void showEdit(JCDataIndex jCDataIndex, int n2, int n3) {
    }

    void startEdit(JCDataIndex jCDataIndex) {
    }

    int tryDrawYAxisTroughGrid(Graphics graphics, int n2, int n3, JCAxis jCAxis, int n4, int n5) {
        boolean bl = false;
        boolean bl2 = false;
        if (!this.inverted && n2 > 0 || this.inverted && n3 > 0) {
            if (n4 > jCAxis.linePosition()) {
                if (jCAxis.isVisible() && jCAxis.gridVisible) {
                    jCAxis.drawGridInTrough(graphics, Double.MAX_VALUE, Double.MAX_VALUE);
                }
                jCAxis.postDrawOutlineTrough(graphics, 3);
                bl = true;
            } else if (n5 > jCAxis.linePosition()) {
                if (jCAxis.isVisible() && jCAxis.gridVisible) {
                    jCAxis.drawGridInTrough(graphics, Double.MAX_VALUE, Double.MAX_VALUE);
                }
                bl2 = true;
                bl = true;
            }
        } else if (n5 < jCAxis.linePosition()) {
            if (jCAxis.isVisible() && jCAxis.gridVisible) {
                jCAxis.drawGridInTrough(graphics, Double.MAX_VALUE, Double.MAX_VALUE);
            }
            jCAxis.postDrawOutlineTrough(graphics, 3);
            bl = true;
        } else if (n4 < jCAxis.linePosition()) {
            if (jCAxis.isVisible() && jCAxis.gridVisible) {
                jCAxis.drawGridInTrough(graphics, Double.MAX_VALUE, Double.MAX_VALUE);
            }
            bl2 = true;
            bl = true;
        }
        return bl2 ? 2 : (bl ? 1 : 0);
    }

    public Point unpick(int n2, int n3) {
        return null;
    }
}

