/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.Changeable;
import com.klg.jclass.chart.ChartDataEvent;
import com.klg.jclass.chart.ChartDataListener;
import com.klg.jclass.chart.ChartDataManageable;
import com.klg.jclass.chart.ChartDataModel;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.DataHandler;
import com.klg.jclass.chart.DoubleCoord;
import com.klg.jclass.chart.EditableChartDataModel;
import com.klg.jclass.chart.JCAreaChartFormat;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCBarChartFormat;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartTypeFormat;
import com.klg.jclass.chart.JCDataCoord;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCDrawableColorHandler;
import com.klg.jclass.chart.JCPieChartFormat;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.chart.data.ChartDataSourceUtil;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ChartDataView
implements Changeable,
ChartDataListener,
Serializable {
    protected Vector series = new Vector();
    public static final int PICK_FOCUS_LOCAL = -1;
    public static final int PICK_FOCUS_XY = 0;
    public static final int PICK_FOCUS_X = 1;
    public static final int PICK_FOCUS_Y = 2;
    public static final String ERRMSG_INVALID_SERIES_INDEX = "Invalid ChartDataViewSeries index";
    private double[] xvalues = null;
    protected boolean batched = false;
    protected boolean fastUpdate = false;
    protected boolean bufferPlotData = true;
    protected double holeValue = Double.MAX_VALUE;
    protected int chartType = 0;
    protected String name = null;
    protected int drawingOrder = -1;
    protected boolean drawFrontPlane = true;
    protected ChartDataModel dataSource = null;
    protected transient DataHandler dataHandler;
    protected JCAxis xaxis = null;
    protected JCAxis yaxis = null;
    protected List pointLabels = new Vector();
    private transient Object transientData = null;
    protected boolean inverted = false;
    protected int pickFocus = 0;
    protected boolean visibleInLegend = true;
    private Vector styles = new Vector();
    protected boolean autoLabel = false;
    protected Color outlineColor = null;
    protected JCDrawableColorHandler colorHandler;
    protected boolean visible = true;
    protected boolean changed = true;
    protected int changedFlag = 0;
    protected boolean allowPick = true;
    protected double step = 1.0;
    protected JCChart chart = null;
    protected MinMax xLimits;
    protected MinMax yLimits;
    public static final String[] format_class_names = new String[]{null, null, null, null, null, "com.klg.jclass.chart.JCHiloChartFormat", "com.klg.jclass.chart.JCHLOCChartFormat", "com.klg.jclass.chart.JCCandleChartFormat", "com.klg.jclass.chart.JCAreaChartFormat", "com.klg.jclass.chart.JCBarChartFormat", "com.klg.jclass.chart.JCBarChartFormat", "com.klg.jclass.chart.JCPieChartFormat", "com.klg.jclass.chart.JCAreaChartFormat"};
    protected Hashtable formatClassHashtable = new Hashtable();
    protected static int dataViewNum = 0;

    public ChartDataView() {
        this.setChartType(0);
        this.name = String.valueOf(JCChartBundle.string("com.klg.jclass.chart.Key26")) + ++dataViewNum;
    }

    ChartDataView(JCChart jCChart) {
        this.setChartType(0);
        this.setParent(jCChart);
        this.name = String.valueOf(JCChartBundle.string("com.klg.jclass.chart.Key26")) + ++dataViewNum;
    }

    public ChartDataViewSeries addSeries(int n2) {
        ChartDataViewSeries chartDataViewSeries = null;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > this.series.size()) {
            n2 = this.series.size();
        }
        chartDataViewSeries = new ChartDataViewSeries();
        chartDataViewSeries.init(null, null, this);
        chartDataViewSeries.setDrawingOrder(n2);
        this.series.add(n2, chartDataViewSeries);
        if (this.autoLabel && this.chart != null) {
            this.chart.getChartLabelManager().addAutoLabels(this, n2, -1);
        }
        this.setChanged(true, 2);
        return chartDataViewSeries;
    }

    public void addSeries(ChartDataViewSeries chartDataViewSeries) {
        chartDataViewSeries.setDrawingOrder(this.series.size());
        this.series.add(chartDataViewSeries);
        if (this.autoLabel && this.chart != null) {
            this.chart.getChartLabelManager().addAutoLabels(this, this.series.size() - 1, -1);
        }
        this.setChanged(true, 2);
    }

    void calcLimits() {
        if (this.xaxis != null) {
            this.xLimits = new MinMax();
            this.calcXMinMax(this.xLimits);
            this.xaxis.setLimits(this.xLimits);
        }
        if (this.yaxis != null) {
            this.yLimits = new MinMax();
            boolean bl = false;
            switch (this.chartType) {
                case 10: {
                    bl = ((JCBarChartFormat)this.getChartFormat()).is100Percent();
                    break;
                }
                case 12: {
                    bl = ((JCAreaChartFormat)this.getChartFormat()).is100Percent();
                    break;
                }
            }
            if (this.chartType == 10 || this.chartType == 12) {
                this.calcYMinMaxOfTotals(this.yLimits);
                if (bl) {
                    this.yLimits.min = this.yLimits.min < 0.0 ? -100.0 : 0.0;
                    this.yLimits.max = this.yLimits.max > 0.0 ? 100.0 : 0.0;
                }
            } else {
                this.calcYMinMax(this.yLimits);
            }
            this.yaxis.setLimits(this.yLimits);
        }
    }

    public void calcTransientData() {
        ChartDraw chartDraw;
        boolean bl;
        boolean bl2 = bl = this.getChartType() == 11;
        if (bl && (chartDraw = this.chart.getChartArea().getDrawable(this)) != null) {
            chartDraw.calcTransientData();
        }
    }

    void calcXMinMax(MinMax minMax) {
        this.step = Double.MAX_VALUE;
        int n2 = 0;
        while (n2 < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.get(n2);
            if (chartDataViewSeries.isIncluded()) {
                chartDataViewSeries.getXMinMax(minMax);
                chartDataViewSeries.calcStep(this);
            }
            ++n2;
        }
        if (this.step != Double.MAX_VALUE && this.step != 0.0 && this.step < this.xaxis.step) {
            this.xaxis.step = this.step;
        }
        if (this.xaxis.step == Double.MAX_VALUE) {
            this.xaxis.step = 1.0;
        }
    }

    void calcYMinMax(MinMax minMax) {
        int n2 = 0;
        while (n2 < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.get(n2);
            if (chartDataViewSeries.isIncluded()) {
                chartDataViewSeries.getYMinMax(minMax);
            }
            ++n2;
        }
    }

    private void calcYMinMaxOfTotals(MinMax minMax) {
        Point point = this.getFirstLast();
        if (point == null) {
            return;
        }
        int n2 = this.series.size();
        MinMax minMax2 = new MinMax();
        int n3 = point.x;
        while (n3 <= point.y) {
            MinMax minMax3 = new MinMax(0.0, 0.0);
            int n4 = 0;
            while (n4 < n2) {
                double d2;
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.get(n4);
                if (chartDataViewSeries.isIncluded() && (d2 = chartDataViewSeries.getY(n3)) != this.holeValue) {
                    if (d2 >= 0.0) {
                        minMax3.max += d2;
                    } else {
                        minMax3.min += d2;
                    }
                }
                ++n4;
            }
            minMax2.union(minMax3);
            ++n3;
        }
        minMax.union(minMax2);
    }

    public void chartDataChange(ChartDataEvent chartDataEvent) {
        if (chartDataEvent == null) {
            return;
        }
        switch (chartDataEvent.getType()) {
            case 0: {
                this.getDataHandler().reloadPoint(chartDataEvent.getSeriesIndex(), chartDataEvent.getPointIndex());
                break;
            }
            case 1: {
                this.getDataHandler().reloadSeries(chartDataEvent.getSeriesIndex());
                break;
            }
            case 2: {
                this.getDataHandler().addSeries();
                break;
            }
            case 3: {
                this.getDataHandler().insertSeries(chartDataEvent.getSeriesIndex());
                break;
            }
            case 5: {
                this.getDataHandler().removeSeries(chartDataEvent.getSeriesIndex());
                break;
            }
            case 6: {
                this.getDataHandler().reloadAllPointLabels();
                break;
            }
            case 7: {
                this.getDataHandler().reloadPointLabel(chartDataEvent.getPointIndex());
                break;
            }
            case 8: {
                this.getDataHandler().reloadAllSeriesLabels();
                break;
            }
            case 9: {
                this.getDataHandler().reloadSeriesLabel(chartDataEvent.getSeriesIndex());
                break;
            }
            case 10: {
                this.getDataHandler().reloadDataSourceName();
                break;
            }
            case 15: {
                this.getDataHandler().reloadHoleValue();
                break;
            }
            case 11: {
                boolean bl;
                this.getDataHandler().appendData();
                int n2 = this.getChartType();
                if (!this.fastUpdate || !this.chart.isDisplayable() || n2 != 0 && n2 != 1 && n2 != 8 || !this.checkNewPoints(chartDataEvent.getSeriesIndex()) || !(bl = this.doFastUpdate(chartDataEvent.getPointIndex(), chartDataEvent.getSeriesIndex()))) break;
                return;
            }
            case 12: {
                this.getDataHandler().reset();
                break;
            }
            case 13: {
                this.getDataHandler().reload();
                break;
            }
            case 14: {
                this.getDataHandler().changeChartType(chartDataEvent.getSeriesIndex());
                break;
            }
            default: {
                throw new RuntimeException("Unkwown event type: " + chartDataEvent.getType());
            }
        }
        this.setChanged(true, 34);
    }

    public boolean checkNewPoints(int n2) {
        int n3 = 0;
        while (n3 < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = this.getSeries(n3);
            int n4 = chartDataViewSeries.maxIndex();
            int n5 = n4 - n2 + 1;
            while (n5 <= n4) {
                double d2 = chartDataViewSeries.getX(n5);
                if (d2 != this.holeValue && (this.xaxis.getMaxIsDefault() && d2 > this.xaxis.getMax() || this.xaxis.getMinIsDefault() && d2 < this.xaxis.getMin())) {
                    return false;
                }
                double d3 = chartDataViewSeries.getY(n5);
                if (d3 != this.holeValue && (this.yaxis.getMaxIsDefault() && d3 > this.yaxis.getMax() || this.yaxis.getMinIsDefault() && d3 < this.yaxis.getMin())) {
                    return false;
                }
                ++n5;
            }
            ++n3;
        }
        return true;
    }

    void clearLimits() {
        if (this.xaxis != null) {
            this.xaxis.clearLimits();
        }
        if (this.yaxis != null) {
            this.yaxis.clearLimits();
        }
        this.xLimits = null;
        this.yLimits = null;
        this.xaxis.step = Double.MAX_VALUE;
        this.yaxis.step = Double.MAX_VALUE;
    }

    public JCDataCoord coordToDataCoord(int n2, int n3) {
        return this.map(n2, n3);
    }

    public JCDataIndex coordToDataIndex(int n2, int n3, int n4) {
        Point point = this.chart.getChartArea().getLocation();
        return this.chart.getChartArea().pick(new Point(n2 - point.x, n3 - point.y), this, n4);
    }

    public Point dataCoordToCoord(double d2, double d3) {
        return this.unmap(d2, d3);
    }

    public Point dataIndexToCoord(JCDataIndex jCDataIndex) {
        Point point = this.chart.unpick(this, jCDataIndex.point, jCDataIndex.seriesIndex);
        return point;
    }

    public boolean doFastUpdate(int n2, int n3) {
        boolean bl = false;
        ChartDraw chartDraw = this.chart.getChartArea().getDrawable(this);
        if (chartDraw != null) {
            Graphics graphics = null;
            try {
                chartDraw.recalc(n2, n2 + n3 - 1);
                graphics = this.chart.getChartArea().getGraphics();
                Rectangle rectangle = this.chart.getChartArea().getDrawingArea();
                graphics.translate(rectangle.x, rectangle.y);
                Rectangle rectangle2 = this.chart.getChartArea().clipForDrawing();
                graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                chartDraw.draw(graphics, n2, n2 + n3 - 1);
                bl = true;
            }
            catch (Exception exception) {}
        }
        if (bl) {
            this.chart.firePaint();
        }
        return bl;
    }

    void draw(Graphics graphics) {
    }

    boolean editPoint(ChartDataViewSeries chartDataViewSeries, int n2, double d2) {
        if (this.dataSource == null) {
            return true;
        }
        if (!(this.dataSource instanceof EditableChartDataModel)) {
            return false;
        }
        int n3 = this.series.indexOf(chartDataViewSeries);
        if (n3 == -1) {
            throw new RuntimeException("Bad row in editPoint!");
        }
        return this.getDataHandler().editPoint(n3, n2, d2);
    }

    public boolean getAutoLabel() {
        return this.autoLabel;
    }

    public boolean getBufferPlotData() {
        return this.bufferPlotData;
    }

    public boolean getChanged() {
        return this.changed;
    }

    public boolean getChanged(int n2) {
        return (this.changedFlag & n2) == n2;
    }

    public JCChartTypeFormat getChartFormat() {
        return this.getChartFormat(this.chartType);
    }

    public JCChartTypeFormat getChartFormat(int n2) {
        if (n2 == 10) {
            n2 = 9;
        } else if (n2 == 12) {
            n2 = 8;
        }
        if (n2 >= 0 && n2 < format_class_names.length && format_class_names[n2] != null) {
            JCChartTypeFormat jCChartTypeFormat = (JCChartTypeFormat)this.formatClassHashtable.get(new Integer(n2));
            if (jCChartTypeFormat == null) {
                try {
                    jCChartTypeFormat = (JCChartTypeFormat)Class.forName(format_class_names[n2]).newInstance();
                    jCChartTypeFormat.setParent(this);
                    this.formatClassHashtable.put(new Integer(n2), jCChartTypeFormat);
                }
                catch (Exception exception) {}
            }
            return jCChartTypeFormat;
        }
        return null;
    }

    public List getChartStyle() {
        if (this.styles == null || this.styles.size() == 0) {
            return null;
        }
        return new Vector(this.styles);
    }

    public JCChartStyle getChartStyle(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("ChartStyle index must be positive");
        }
        if (n2 >= this.styles.size()) {
            while (n2 >= this.styles.size()) {
                this.styles.add(null);
            }
        }
        JCChartStyle[] jCChartStyleArray = new JCChartStyle[]{(JCChartStyle)this.styles.get(n2)};
        if (jCChartStyleArray[0] == null) {
            JCChartStyle jCChartStyle = new JCChartStyle();
            jCChartStyleArray[0] = JCChartStyle.makeDefault(this.chart, this);
            this.styles.set(n2, jCChartStyleArray[0]);
            jCChartStyle = null;
        }
        return jCChartStyleArray[0];
    }

    public int getChartType() {
        return this.chartType;
    }

    public JCDrawableColorHandler getColorHandler() {
        return this.colorHandler;
    }

    void getDataBoundValues(MinMax minMax, MinMax minMax2) {
        if (this.xLimits != null) {
            minMax.reset(this.xLimits);
        }
        if (this.yLimits != null) {
            minMax2.reset(this.yLimits);
        }
    }

    void getDataBounds(MinMax minMax, MinMax minMax2) {
        boolean bl;
        boolean bl2 = this.chartType == 2;
        boolean bl3 = this.chartType == 3 || this.chartType == 4;
        boolean bl4 = bl2 || bl3;
        boolean bl5 = bl = this.chartType == 6 || this.chartType == 7;
        if (minMax.min == Double.MAX_VALUE && minMax.max == -1.7976931348623157E308) {
            this.calcXMinMax(minMax);
        }
        if (minMax2.min == Double.MAX_VALUE && minMax2.max == -1.7976931348623157E308) {
            this.calcYMinMax(minMax2);
        }
        if (minMax.min == Double.MAX_VALUE && minMax.max == -1.7976931348623157E308) {
            minMax.min = -1.7976931348623157E308;
            minMax.max = Double.MAX_VALUE;
        }
        if (minMax2.min == Double.MAX_VALUE && minMax2.max == -1.7976931348623157E308) {
            minMax2.min = -1.7976931348623157E308;
            minMax2.max = Double.MAX_VALUE;
        }
        if (bl) {
            double d2 = JCNumberUtil.abs(this.xaxis.getTickSpacing());
            minMax.min -= d2;
            minMax.max += d2;
        }
        if (!this.xaxis.min.isDefault && this.xaxis.min.value > minMax.min || this.xaxis.formula != null && this.xaxis.formula.getOriginator() != null && this.xaxis.min.value > minMax.min || bl4) {
            minMax.min = this.xaxis.min.value;
        }
        if (!this.xaxis.max.isDefault && this.xaxis.max.value < minMax.max || this.xaxis.formula != null && this.xaxis.formula.getOriginator() != null && this.xaxis.max.value < minMax.max || bl4) {
            minMax.max = this.xaxis.max.value;
        }
        if (!this.yaxis.min.isDefault && this.yaxis.min.value > minMax2.min || this.yaxis.formula != null && this.yaxis.formula.getOriginator() != null && this.yaxis.min.value > minMax2.min || bl4) {
            minMax2.min = this.yaxis.min.value;
        }
        if (bl2 && minMax2.min < 0.0) {
            if (JCNumberUtil.abs(minMax2.min) > minMax2.max) {
                minMax2.max = JCNumberUtil.abs(minMax2.min);
            }
            minMax2.min = 0.0;
        }
        if (!this.yaxis.max.isDefault && this.yaxis.max.value < minMax2.max || this.yaxis.formula != null && this.yaxis.formula.getOriginator() != null && this.yaxis.max.value < minMax2.max || bl4) {
            minMax2.max = this.yaxis.max.value;
        }
    }

    protected DataHandler getDataHandler() {
        if (this.dataHandler == null) {
            this.dataHandler = new DataHandler(this);
        }
        return this.dataHandler;
    }

    public ChartDataModel getDataSource() {
        return this.dataSource;
    }

    public boolean getDrawFrontPlane() {
        return this.drawFrontPlane;
    }

    public int getDrawingOrder() {
        return this.drawingOrder;
    }

    public boolean getFastUpdate() {
        return this.fastUpdate;
    }

    public Point getFirstLast() {
        if (this.series == null) {
            return null;
        }
        int n2 = -1;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MAX_VALUE;
        int n5 = 0;
        while (n5 < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.get(n5);
            if (chartDataViewSeries.isVisible()) {
                int n6;
                if (n2 < chartDataViewSeries.getFirstPoint()) {
                    n2 = chartDataViewSeries.getFirstPoint();
                }
                if (n3 > chartDataViewSeries.getLastPoint()) {
                    n3 = chartDataViewSeries.getLastPoint();
                }
                if (n4 > (n6 = chartDataViewSeries.maxIndex())) {
                    n4 = n6;
                }
            }
            ++n5;
        }
        if (n4 == Integer.MAX_VALUE) {
            return null;
        }
        if (n2 > n4) {
            return null;
        }
        if (n3 > n4) {
            n3 = n4;
        }
        if (n2 > n3) {
            return null;
        }
        return new Point(n2, n3);
    }

    public double getHoleValue() {
        return this.holeValue;
    }

    public String getName() {
        return this.name;
    }

    public int getNumPointLabels() {
        return this.pointLabels.size();
    }

    public int getNumSeries() {
        return this.series == null ? 0 : this.series.size();
    }

    public int getNumSeriesPerData() {
        int n2 = 1;
        switch (this.chartType) {
            case 5: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 4;
                break;
            }
            case 7: {
                n2 = 4;
                break;
            }
        }
        return n2;
    }

    /*
     * Unable to fully structure code
     */
    DoubleCoord getOrigin(MinMax var1_1, MinMax var2_2, boolean var3_3) {
        block23: {
            block22: {
                block21: {
                    block20: {
                        block18: {
                            block19: {
                                var4_4 = new DoubleCoord(var1_1.min, var2_2.min);
                                if (!var3_3) {
                                    return var4_4;
                                }
                                var5_5 = this.chart.getChartArea().getAngleUnit();
                                if (!this.xaxis.origin.isDefault) break block18;
                                if (this.chartType != 2 && this.chartType != 3 && this.chartType != 4) break block19;
                                switch (var5_5) {
                                    case 1: {
                                        var4_4.x = 90.0;
                                        ** GOTO lbl37
                                    }
                                    case 2: {
                                        var4_4.x = 1.5707963267948966;
                                        ** GOTO lbl37
                                    }
                                    case 3: {
                                        var4_4.x = 100.0;
                                        ** GOTO lbl37
                                    }
                                    default: {
                                        if (this.chartType == 10) break block20;
                                    }
                                }
                            }
                            switch (this.xaxis.originPlacement.value) {
                                case 3: {
                                    var4_4.x = 0.0;
                                    ** GOTO lbl37
                                }
                                case 1: {
                                    var4_4.x = var1_1.min;
                                    ** GOTO lbl37
                                }
                                case 2: {
                                    var4_4.x = var1_1.max;
                                    ** GOTO lbl37
                                }
                                case 0: {
                                    var4_4.x = var1_1.min <= 0.0 && var1_1.max >= 0.0 ? 0.0 : var1_1.min;
                                    ** GOTO lbl37
                                }
                                default: {
                                    if (this.chartType == 10) break block20;
                                }
                            }
                        }
                        var4_4.x = JCNumberUtil.boundAngle(var5_5, this.xaxis.origin.value);
lbl37:
                        // 8 sources

                        if (this.chartType == 10) break block20;
                        if (this.chartType != 12) break block21;
                    }
                    var4_4.y = this.yaxis.logarithmic ? JCNumberUtil.max(var2_2.min, 0.0) : 0.0;
                    ** GOTO lbl65
                }
                if (this.chartType != 2 && this.chartType != 3 && this.chartType != 4) break block22;
                var4_4.y = this.yaxis.reversed ? var2_2.min : var2_2.max;
                ** GOTO lbl65
            }
            if (!this.yaxis.origin.isDefault) break block23;
            switch (this.yaxis.originPlacement.value) {
                case 3: {
                    var4_4.y = 0.0;
                    ** GOTO lbl65
                }
                case 1: {
                    var4_4.y = var2_2.min;
                    ** GOTO lbl65
                }
                case 2: {
                    var4_4.y = var2_2.max;
                    ** GOTO lbl65
                }
                case 0: {
                    var4_4.y = !(this.chartType != 9 && this.chartType != 8 || this.yaxis.logarithmic) ? 0.0 : (var2_2.min <= 0.0 && var2_2.max >= 0.0 ? 0.0 : var2_2.min);
                    ** GOTO lbl65
                }
                default: {
                    return var4_4;
                }
            }
        }
        var4_4.y = this.yaxis.origin.value;
lbl65:
        // 7 sources

        return var4_4;
    }

    public Color getOutlineColor() {
        if (this.outlineColor == null) {
            if (this.chart != null && this.chart.getChartArea() != null) {
                return this.chart.getChartArea().getForeground();
            }
            return null;
        }
        return this.outlineColor;
    }

    public JCChart getParent() {
        return this.chart;
    }

    public int getPickFocus() {
        return this.pickFocus;
    }

    public String getPointLabel(int n2) {
        if (n2 < 0 || n2 >= this.pointLabels.size()) {
            throw new IllegalArgumentException("Invalid point label index");
        }
        return (String)this.pointLabels.get(n2);
    }

    public List getPointLabels() {
        return this.pointLabels;
    }

    public List getSeries() {
        return new Vector(this.series);
    }

    public ChartDataViewSeries getSeries(int n2) {
        if (n2 < 0 || n2 >= this.series.size()) {
            throw new IllegalArgumentException(ERRMSG_INVALID_SERIES_INDEX);
        }
        return (ChartDataViewSeries)this.series.get(n2);
    }

    public int getSeriesIndex(ChartDataViewSeries chartDataViewSeries) {
        return this.series.indexOf(chartDataViewSeries);
    }

    public int getSeriesIndex(String string) {
        try {
            int n2 = 0;
            while (n2 < this.series.size()) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.get(n2);
                if (string.equals(chartDataViewSeries.getName())) {
                    return n2;
                }
                ++n2;
            }
        }
        catch (Exception exception) {}
        return -1;
    }

    Object getTransientData() {
        return this.transientData;
    }

    public int getVisibleDataSeries() {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.series.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.series.get(n3);
            if (chartDataViewSeries.isVisible()) {
                ++n2;
            }
            ++n3;
        }
        return n2;
    }

    double[] getX() {
        return this.xvalues;
    }

    public double[] getXArrayCopy() {
        if (this.xvalues == null) {
            return null;
        }
        double[] dArray = new double[this.xvalues.length];
        System.arraycopy(this.xvalues, 0, dArray, 0, this.xvalues.length);
        return dArray;
    }

    public JCAxis getXAxis() {
        return this.xaxis;
    }

    public MinMax getXLimits() {
        return this.xLimits;
    }

    public JCAxis getYAxis() {
        return this.yaxis;
    }

    public MinMax getYLimits() {
        return this.yLimits;
    }

    public boolean is3DChartType() {
        return this.chartType == 9 || this.chartType == 10;
    }

    public boolean isBatched() {
        return this.batched;
    }

    public boolean isChanged() {
        return this.getChanged();
    }

    public boolean isChanged(int n2) {
        return this.getChanged(n2);
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean isVisibleInLegend() {
        return this.visibleInLegend;
    }

    public JCDataCoord map(int n2, int n3) {
        Rectangle rectangle = this.chart.getChartArea().getDrawingArea();
        Point point = this.chart.getChartArea().getLocation();
        n2 -= rectangle.x + point.x;
        n3 -= rectangle.y + point.y;
        JCDataCoord jCDataCoord = new JCDataCoord(this.holeValue, this.holeValue);
        if (this.xaxis != null) {
            double d2 = jCDataCoord.x = this.xaxis.vertical ? this.xaxis.toData(n3) : this.xaxis.toData(n2);
        }
        if (this.yaxis != null) {
            jCDataCoord.y = this.yaxis.vertical ? this.yaxis.toData(n3) : this.yaxis.toData(n2);
        }
        return jCDataCoord;
    }

    private void markAsChanged(int n2) {
        int n3 = 0;
        if ((n2 & 0x80) > 0) {
            n3 |= 2;
        } else if ((n2 & 0x40) > 0) {
            n3 |= 1;
        }
        if (n3 != 0) {
            if (this.xaxis != null) {
                this.xaxis.setChanged(true, n3, false);
            }
            if (this.yaxis != null) {
                this.yaxis.setChanged(true, n3, false);
            }
        }
        if (this.chart != null && this.chart.getChartArea() != null) {
            this.chart.getChartArea().setChanged(true, n2 & 3, false);
        }
        int n4 = 0;
        if ((n2 & 0x20) > 0) {
            n4 |= 2;
        } else if ((n2 & 0x10) > 0) {
            n4 |= 1;
        }
        if (n4 != 0 && this.chart != null && this.chart.getLegend() != null) {
            this.chart.getLegend().setChanged(true, n4, false);
        }
    }

    public void outputData(OutputStream outputStream) {
        block2: {
            String string = ChartDataSourceUtil.buildDataSourceString(this.getDataSource());
            if (string == null) break block2;
            try {
                DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
                dataOutputStream.writeBytes(string);
                dataOutputStream.flush();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private void propagateChange() {
        if (!this.changed) {
            return;
        }
        if (this.isBatched()) {
            return;
        }
        if (this.chart == null) {
            return;
        }
        if (this.chart.isBatched()) {
            return;
        }
        this.chart.update();
        this.setChanged(false, 0);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            if (this.dataSource != null && this.dataSource instanceof ChartDataManageable) {
                ((ChartDataManageable)((Object)this.dataSource)).getChartDataManager().addChartDataListener(this);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    public void removeSeries(int n2) {
        if (n2 < 0 || n2 >= this.series.size()) {
            throw new IllegalArgumentException(ERRMSG_INVALID_SERIES_INDEX);
        }
        this.series.remove(n2);
        if (this.autoLabel && this.chart != null) {
            this.chart.getChartLabelManager().removeAutoLabels(this, n2, -1);
        }
        this.setChanged(true, 2);
    }

    public void setAutoLabel(boolean bl) {
        if (this.autoLabel == bl) {
            return;
        }
        this.autoLabel = bl;
        if (this.chart != null) {
            if (this.autoLabel) {
                this.chart.getChartLabelManager().generateAutoLabels(this);
            } else {
                this.chart.getChartLabelManager().removeAutoLabels(this);
            }
        }
        this.setChanged(true, 2);
    }

    public void setBatched(boolean bl) {
        if (this.batched == bl) {
            return;
        }
        this.batched = bl;
        if (!this.batched) {
            this.propagateChange();
        }
    }

    public void setBufferPlotData(boolean bl) {
        if (this.bufferPlotData == bl) {
            return;
        }
        this.bufferPlotData = bl;
    }

    protected void setChanged(boolean bl) {
        this.changed = bl;
    }

    public void setChanged(boolean bl, int n2) {
        this.changed = bl;
        if (!this.changed) {
            this.changedFlag = n2;
            return;
        }
        this.changedFlag |= n2;
        this.markAsChanged(n2);
        this.propagateChange();
    }

    public void setChanged(boolean bl, int n2, boolean bl2) {
        if (this.changed == bl && (this.changedFlag & n2) == n2) {
            return;
        }
        if (bl2) {
            this.setChanged(bl, n2);
        } else {
            this.changed = bl;
            if (this.changed) {
                this.changedFlag |= n2;
                this.markAsChanged(n2);
            } else {
                this.changedFlag = n2;
            }
        }
    }

    public void setChartStyle(int n2, JCChartStyle jCChartStyle) {
        if (n2 < 0 || n2 > this.styles.size()) {
            throw new IllegalArgumentException("Invalid ChartStyle index in ChartDataView.");
        }
        jCChartStyle.addParent(this);
        if (n2 < this.styles.size()) {
            this.styles.set(n2, jCChartStyle);
        } else {
            this.styles.add(n2, jCChartStyle);
        }
        this.setChanged(true, 33);
    }

    public void setChartStyle(List list) {
        this.styles = new Vector();
        if (list == null) {
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JCChartStyle jCChartStyle = (JCChartStyle)iterator.next();
            jCChartStyle.addParent(this);
            this.styles.add(jCChartStyle);
        }
        this.setChanged(true, 33);
    }

    public void setChartType(int n2) {
        if (this.chartType == n2) {
            return;
        }
        if (this.xaxis != null) {
            this.xaxis.annotationMethod = this.xaxis.savedXAxisAnnotationMethod;
        }
        switch (n2) {
            case 2: 
            case 3: 
            case 4: {
                throw new IllegalArgumentException("Currently unsupported chart type");
            }
            default: {
                throw new IllegalArgumentException("Invalid chart type");
            }
            case 0: 
            case 1: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
        }
        switch (this.chartType) {
            case 11: {
                if (this.yaxis != null) {
                    this.yaxis.setVisible(true);
                    this.yaxis.setChanged(true, 2, false);
                }
                if (this.xaxis == null) break;
                this.xaxis.setVisible(true);
                this.xaxis.setChanged(true, 2, false);
                break;
            }
            case 9: 
            case 10: {
                if (this.xaxis == null) break;
                this.xaxis.setChanged(true, 2, false);
                break;
            }
        }
        this.chartType = n2;
        this.getChartFormat(this.chartType);
        switch (this.chartType) {
            case 0: 
            case 1: 
            case 5: 
            case 6: 
            case 7: {
                if (this.yaxis == null || this.xaxis == null) break;
                boolean bl = false;
                if (this.yaxis.getOriginPlacementIsDefault() && this.yaxis.originPlacement.value != 0) {
                    this.yaxis.originPlacement.value = 0;
                    bl = true;
                }
                if (this.yaxis.getPlacementIsDefault() && this.yaxis.placement.value != 0) {
                    this.yaxis.placement.value = 0;
                    bl = true;
                }
                if (bl) {
                    this.yaxis.setChanged(true, 2, false);
                }
                if (!this.xaxis.getPlacementIsDefault() || this.xaxis.placement.value == 0) break;
                this.xaxis.placement.value = 0;
                this.xaxis.setChanged(true, 2, false);
                break;
            }
            case 9: 
            case 10: {
                int n3;
                if (this.yaxis == null || this.xaxis == null) break;
                this.xaxis.savedXAxisAnnotationMethod = this.xaxis.annotationMethod;
                this.xaxis.placementAxis = this.yaxis;
                boolean bl = true;
                if (this.chart != null) {
                    n3 = 0;
                    while (n3 < this.chart.getChartArea().getXAxes().size()) {
                        if (this.chart.getChartArea().getXAxis((int)n3).annotationMethod != 0) {
                            bl = false;
                            break;
                        }
                        ++n3;
                    }
                }
                if (bl) {
                    this.xaxis.annotationMethod = 3;
                }
                if (this.xaxis.getPlacementIsDefault()) {
                    this.xaxis.placement.value = 5;
                }
                this.xaxis.setChanged(true, 2, false);
                n3 = 0;
                if (this.yaxis.getPlacementIsDefault()) {
                    this.yaxis.placement.value = 1;
                    n3 = 1;
                }
                if (this.yaxis.getOriginPlacementIsDefault()) {
                    this.yaxis.originPlacement.value = 3;
                    n3 = 1;
                }
                if (n3 == 0) break;
                this.yaxis.setChanged(true, 2, false);
                break;
            }
            case 8: 
            case 12: {
                if (this.yaxis == null || this.xaxis == null) break;
                boolean bl = false;
                if (this.yaxis.getPlacementIsDefault()) {
                    this.yaxis.placement.value = 1;
                    bl = true;
                }
                if (this.yaxis.getOriginPlacementIsDefault()) {
                    this.yaxis.originPlacement.value = 3;
                    bl = true;
                }
                if (bl) {
                    this.yaxis.setChanged(true, 2, false);
                }
                if (this.xaxis.getPlacementIsDefault()) {
                    this.xaxis.placement.value = 5;
                }
                this.xaxis.placementAxis = this.yaxis;
                this.xaxis.setChanged(true, 2, false);
                break;
            }
        }
        if (this.chart != null) {
            this.chart.getChartArea().removeDrawable(this);
        }
        this.transientData = null;
        this.setChanged(true, 34);
    }

    public void setColorHandler(JCDrawableColorHandler jCDrawableColorHandler) {
        if (this.colorHandler == jCDrawableColorHandler) {
            return;
        }
        this.colorHandler = jCDrawableColorHandler;
        this.setChanged(true, 33);
    }

    public void setDataSource(ChartDataModel chartDataModel) {
        boolean bl = false;
        if (this.dataSource instanceof ChartDataManageable) {
            ((ChartDataManageable)((Object)this.dataSource)).getChartDataManager().removeChartDataListener(this);
        }
        this.dataSource = chartDataModel;
        if (this.dataSource == null) {
            this.series = new Vector();
            if (this.autoLabel && this.chart != null) {
                this.chart.getChartLabelManager().clearAutoLabels(this);
            }
            this.setX(null);
            this.setChanged(true, 162);
            return;
        }
        bl = this.isBatched();
        this.setBatched(true);
        this.getDataHandler().reset();
        this.getDataHandler().reloadAllPointLabels();
        this.getDataHandler().reloadAllSeriesLabels();
        this.getDataHandler().reloadDataSourceName();
        if (chartDataModel instanceof ChartDataManageable) {
            ((ChartDataManageable)((Object)chartDataModel)).getChartDataManager().addChartDataListener(this);
        }
        if (!(this.dataSource instanceof EditableChartDataModel) && !(this.dataSource instanceof ChartDataManageable)) {
            this.dataSource = null;
        }
        if (this.autoLabel && this.chart != null) {
            this.chart.getChartLabelManager().generateAutoLabels(this);
        }
        this.setChanged(true, 162, false);
        this.setBatched(bl);
    }

    public void setDrawFrontPlane(boolean bl) {
        this.drawFrontPlane = bl;
        this.setChanged(true, 2);
    }

    public void setDrawingOrder(int n2) {
        if (n2 < 0 || this.chart != null && n2 >= this.chart.getOriginalDataView().size()) {
            throw new IllegalArgumentException("DrawingOrder property for ChartDataView is out of range");
        }
        this.drawingOrder = n2;
        this.setChanged(true, 17);
    }

    public void setFastUpdate(boolean bl) {
        if (this.fastUpdate == bl) {
            return;
        }
        this.fastUpdate = bl;
    }

    public void setHoleValue(double d2) {
        this.holeValue = d2;
        this.setChanged(true, 130);
    }

    public void setInverted(boolean bl) {
        int n2 = 0;
        if (this.inverted == bl) {
            return;
        }
        this.inverted = bl;
        if (this.xaxis != null) {
            this.xaxis.vertical = bl;
        }
        if (this.yaxis != null) {
            this.yaxis.vertical = bl ^ true;
        }
        n2 = 130;
        if (this.chartType == 5 || this.chartType == 6 || this.chartType == 7) {
            n2 |= 0x20;
        }
        this.setChanged(true, n2);
    }

    public void setName(String string) {
        if (this.name != null && this.name.equals(string)) {
            return;
        }
        if (string != null) {
            this.name = string;
        }
        this.setChanged(true, 33);
    }

    public void setOutlineColor(Color color) {
        if (this.outlineColor == color) {
            return;
        }
        this.outlineColor = color;
        this.setChanged(true, 34);
    }

    public void setParent(JCChart jCChart) {
        this.chart = jCChart;
        if (this.chart != null && this.chart.getChartArea() != null) {
            if (this.xaxis == null || !this.chart.getChartArea().getXAxes().contains(this.xaxis)) {
                this.xaxis = this.chart.getChartArea().getXAxis(0);
            }
            if (this.yaxis == null || !this.chart.getChartArea().getYAxes().contains(this.yaxis)) {
                this.yaxis = this.chart.getChartArea().getYAxis(0);
            }
        }
        this.setChanged(true, 2, false);
    }

    public void setPickFocus(int n2) {
        this.pickFocus = n2;
    }

    public void setPointLabel(int n2, String string) {
        if (n2 < 0 || n2 >= this.pointLabels.size()) {
            throw new IllegalArgumentException("Invalid point label index");
        }
        this.pointLabels.set(n2, string);
        this.setChanged(true, 130);
    }

    public void setPointLabels(List list) {
        this.pointLabels = list;
        this.setChanged(true, 130);
    }

    public void setSeries(int n2, ChartDataViewSeries chartDataViewSeries) {
        if (n2 < 0 || n2 >= this.series.size()) {
            throw new IllegalArgumentException(ERRMSG_INVALID_SERIES_INDEX);
        }
        this.series.set(n2, chartDataViewSeries);
        if (this.autoLabel && this.chart != null) {
            int n3 = 0;
            while (n3 <= chartDataViewSeries.maxIndex()) {
                this.chart.getChartLabelManager().setAutoLabelText(this, n2, n3);
                ++n3;
            }
        }
        this.setChanged(true, 162);
    }

    public void setSeries(List list) {
        if (this.autoLabel && this.chart != null) {
            this.chart.getChartLabelManager().removeAutoLabels(this);
        }
        this.series = list == null ? new Vector() : new Vector(list);
        if (this.autoLabel && this.chart != null) {
            this.chart.getChartLabelManager().generateAutoLabels(this);
        }
        if (this.chart != null) {
            if (this.chartType == 11) {
                ((JCPieChartFormat)this.getChartFormat()).getOtherStyle();
            }
            int n2 = 0;
            while (n2 < this.series.size()) {
                this.getChartStyle(n2);
                ++n2;
            }
        }
        this.setChanged(true, 162);
    }

    void setTransientData(Object object) {
        this.transientData = object;
        if (this.chart != null && this.chart.getLegend() != null) {
            this.chart.getLegend().setChanged(true, 2, false);
        }
    }

    public void setVisible(boolean bl) {
        if (this.visible == bl) {
            return;
        }
        this.setVisibleInLegend(bl);
        this.visible = bl;
        this.setChanged(true, 2);
    }

    public void setVisibleInLegend(boolean bl) {
        if (bl == this.visibleInLegend) {
            return;
        }
        this.visibleInLegend = bl;
        this.setChanged(true, 32);
    }

    void setX(double[] dArray) {
        this.xvalues = dArray;
    }

    public void setXAxis(JCAxis jCAxis) {
        this.xaxis = jCAxis;
        this.setChanged(true, 130);
    }

    public void setYAxis(JCAxis jCAxis) {
        this.yaxis = jCAxis;
        this.setChanged(true, 130);
    }

    public String toString() {
        String string = this.getName();
        return string == null ? JCChartBundle.string("com.klg.jclass.chart.Key142") : string;
    }

    public Point unmap(double d2, double d3) {
        Rectangle rectangle = this.chart.getChartArea().getDrawingArea();
        Point point = this.chart.getChartArea().getLocation();
        Point point2 = new Point(rectangle.x + point.x, rectangle.y + point.y);
        if (this.xaxis != null) {
            if (this.xaxis.vertical) {
                point2.y += this.xaxis.toPixel(d2);
            } else {
                point2.x += this.xaxis.toPixel(d2);
            }
        }
        if (this.yaxis != null) {
            if (this.yaxis.vertical) {
                point2.y += this.yaxis.toPixel(d3);
            } else {
                point2.x += this.yaxis.toPixel(d3);
            }
        }
        return point2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.changed;
        this.changed = true;
        int n2 = this.changedFlag;
        this.changedFlag = 2;
        objectOutputStream.defaultWriteObject();
        this.changed = bl;
        this.changedFlag = n2;
    }
}

