/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.BarPoint;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCBarChartFormat;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCChartUtil;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.JCLineStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.io.Serializable;

public class BarChartDraw
extends ChartDraw
implements Serializable {
    public static final int SIDE_0 = 1;
    public static final int SIDE_1 = 2;
    public static final int SIDE_2 = 4;
    public static final int SIDE_3 = 8;
    public static final int OUTLINE_SENSITIVITY = 3;
    protected Point firstLast = null;
    Color outlineColor = Color.black;
    protected int x_reversed = 0;
    protected int y_reversed = 0;
    protected int delta_x = 0;
    protected int delta_y = 0;
    double xAxisPos = Double.MAX_VALUE;
    double[] xGridLineList = null;
    JCLineStyle gridLineStyle = null;
    boolean fastAction = false;
    boolean inAction = false;
    double yOrigin = 0.0;
    protected transient BarPoint[][] pts = null;
    double bar_base;
    int top;
    int bottom;
    int left;
    int right;
    protected boolean is_3d = false;
    boolean drawOutline = true;
    Rectangle r = null;
    boolean editInverted = false;
    Point start = null;
    Point end = null;

    protected int calcFillOrientation(double d2, double d3, boolean bl, boolean bl2) {
        if (!bl) {
            if (!bl2 && d2 >= d3 || bl2 && d2 < d3) {
                return 2;
            }
            return 1;
        }
        if (!bl2 && d2 >= d3 || bl2 && d2 < d3) {
            return 3;
        }
        return 4;
    }

    public void draw(Graphics graphics) {
        int n2;
        int n3;
        if (this.firstLast == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.width == 0 || rectangle.height == 0) {
            return;
        }
        if (this.pts == null) {
            try {
                this.recalc();
                if (this.pts == null) {
                    return;
                }
            }
            catch (Exception exception) {}
        }
        this.outlineColor = this.dataObject.getOutlineColor();
        if (this.is_3d) {
            boolean bl;
            boolean bl2;
            int n4;
            int n5;
            int n6;
            n3 = 0;
            boolean bl3 = false;
            int n7 = this.inverted ? (this.delta_y > 0 ? 1 ^ this.x_reversed : this.x_reversed) : (this.delta_x <= 0 ? 1 ^ this.x_reversed : this.x_reversed);
            n2 = 0;
            int n8 = 0;
            int n9 = this.seriesList.size() - 1;
            if (n7 != 0) {
                n6 = this.firstLast.y;
                n5 = n9;
                n4 = -1;
                bl2 = n6 >= this.firstLast.x;
                n2 = this.xGridLineList.length - 1;
            } else {
                n6 = this.firstLast.x;
                n5 = n8;
                n4 = 1;
                bl2 = n6 <= this.firstLast.y;
                n2 = 0;
            }
            BarPoint barPoint = null;
            int n10 = n6;
            while (bl2) {
                bl = n7 != 0 ? n5 >= n8 : n5 <= n9;
                int n11 = n5;
                while (bl) {
                    BarPoint barPoint2 = null;
                    try {
                        barPoint2 = this.pts[n10 - this.firstLast.x][n11];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    if (!(barPoint2 == null || this.fastAction && this.inAction)) {
                        int n12 = 0;
                        int n13 = 0;
                        if (this.inverted) {
                            n13 = barPoint2.front.y + barPoint2.front.height;
                            n12 = barPoint2.front.y;
                        } else {
                            n12 = barPoint2.front.x;
                            n13 = barPoint2.front.x + barPoint2.front.width;
                        }
                        if (!n3) {
                            int n14 = this.tryDrawYAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.yaxis, n12, n13);
                            if (n14 == 1) {
                                n3 = 1;
                            } else if (n14 == 2) {
                                bl3 = true;
                                n3 = 1;
                            }
                        }
                        if (this.xaxis.gridVisible) {
                            n2 = this.drawXAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.xaxis, this.y_reversed, this.xAxisPos, n12, n13, barPoint2.y, this.yOrigin, this.xGridLineList, n2, n4, this.gridLineStyle);
                        }
                    }
                    if (barPoint2 != null && barPoint2.x != this.holeValue && barPoint2.y != this.holeValue && !((ChartDataViewSeries)this.seriesList.get(n11)).getStyle().getFillStyle().isCustomStackable()) {
                        this.draw_3dbar(graphics, n10, n11, barPoint2.top, barPoint2.side, this.calcFillOrientation(barPoint2.y, 0.0, this.inverted, this.yaxis.reversed), this.drawOutline);
                        barPoint = barPoint2;
                        if (bl3) {
                            this.finishDrawYAxisTroughGrid(graphics, this.delta_x, this.delta_y, this.yaxis, this.y_reversed, barPoint2.y, this.yOrigin);
                            bl3 = false;
                        }
                    }
                    bl = n7 != 0 ? n11 > n8 : n11 < n9;
                    n11 += n4;
                }
                bl2 = n7 != 0 ? n10 > this.firstLast.x : n10 < this.firstLast.y;
                n10 += n4;
            }
            if (!this.fastAction || !this.inAction) {
                bl = true;
                if (barPoint != null) {
                    bl = this.isDrawFinalGridAndTrough(barPoint, this.isDrawOverBar(this.inverted, this.y_reversed, this.delta_y, this.delta_x, this.xAxisPos, barPoint.y, this.yOrigin), this.inverted, this.xaxis.toPixel(this.xaxis.max.value, this.drawFront), this.xaxis.toPixel(this.xaxis.min.value, this.drawFront));
                }
                if (bl) {
                    this.finalDrawAxisTroughGrid(graphics, this.xaxis, this.yaxis, n7, n3 != 0, this.xGridLineList, n2, n4, this.gridLineStyle);
                }
            }
        }
        n3 = 0;
        while (n3 < this.seriesList.size()) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
            if (chartDataViewSeries.isVisible()) {
                JCChartStyle jCChartStyle = chartDataViewSeries.getStyle();
                n2 = this.firstLast.x;
                while (n2 <= this.firstLast.y) {
                    BarPoint barPoint = null;
                    try {
                        barPoint = this.pts[n2 - this.firstLast.x][n3];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    if (barPoint != null && barPoint.x != this.holeValue && barPoint.y != this.holeValue) {
                        JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
                        if (jCFillStyle.isCustomStackable()) {
                            jCFillStyle.fillImageRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height, barPoint.y >= 0.0, this.inverted);
                        } else {
                            jCFillStyle.updateFillOrientation(new Rectangle(barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height), this.calcFillOrientation(barPoint.y, 0.0, this.inverted, this.yaxis.reversed));
                            if (this.drawOutline) {
                                jCFillStyle.fillOutlineRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height, this.outlineColor);
                            } else {
                                jCFillStyle.fillRect(graphics, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height);
                            }
                            jCFillStyle.resetFillOrientation();
                        }
                    }
                    ++n2;
                }
            }
            n3 += 1;
        }
    }

    void draw_3dbar(Graphics graphics, int n2, int n3, Point[] pointArray, Point[] pointArray2, int n4, boolean bl) {
        Polygon polygon;
        JCFillStyle jCFillStyle = ((ChartDataViewSeries)this.seriesList.get(n3)).getStyle().getFillStyle();
        if (pointArray != null) {
            polygon = JCNumberUtil.pointsToPolygon(pointArray);
            jCFillStyle.updateFillOrientation(polygon.getBounds(), n4);
            if (this.delta_y <= 0) {
                if (bl) {
                    jCFillStyle.fillOutlinePolygonHighlight(graphics, polygon, this.outlineColor);
                } else {
                    jCFillStyle.fillPolygonHighlight(graphics, polygon);
                }
            } else if (bl) {
                jCFillStyle.fillOutlinePolygonShadow(graphics, polygon, this.outlineColor);
            } else {
                jCFillStyle.fillPolygonShadow(graphics, polygon);
            }
            jCFillStyle.resetFillOrientation();
        }
        if (pointArray2 != null) {
            polygon = JCNumberUtil.pointsToPolygon(pointArray2);
            jCFillStyle.updateFillOrientation(polygon.getBounds(), n4);
            if (this.delta_x <= 0) {
                if (bl) {
                    jCFillStyle.fillOutlinePolygonHighlight(graphics, polygon, this.outlineColor);
                } else {
                    jCFillStyle.fillPolygonHighlight(graphics, polygon);
                }
            } else if (bl) {
                jCFillStyle.fillOutlinePolygonShadow(graphics, polygon, this.outlineColor);
            } else {
                jCFillStyle.fillPolygonShadow(graphics, polygon);
            }
            jCFillStyle.resetFillOrientation();
        }
    }

    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberBand(this.end, this.start);
        int n4 = this.editInverted ? n2 - this.r.x : n3 - this.r.y;
        return n4;
    }

    public JCDataIndex pick(Point point, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        boolean bl;
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        int n7 = -1;
        int n8 = -1;
        JCDataIndex jCDataIndex = null;
        int n9 = Integer.MAX_VALUE;
        if (this.firstLast == null || this.pts == null) {
            return null;
        }
        boolean bl2 = bl = this.delta_x != 0 || this.delta_y != 0;
        if (bl) {
            int n10;
            n6 = this.inverted ? (this.delta_y > 0 ? 1 ^ this.x_reversed : this.x_reversed) : (this.delta_x <= 0 ? 1 ^ this.x_reversed : this.x_reversed);
            int n11 = 0;
            int n12 = this.seriesList.size() - 1;
            if (n6 != 0) {
                n5 = this.firstLast.y;
                n4 = n12;
                n10 = -1;
                n3 = n5 < this.firstLast.x ? 0 : 1;
            } else {
                n5 = this.firstLast.x;
                n4 = n11;
                n10 = 1;
                n3 = n5 > this.firstLast.y ? 0 : 1;
            }
            int n13 = n5;
            while (n3 != 0) {
                boolean bl3 = n6 != 0 ? n4 >= n11 : n4 <= n12;
                int n14 = n4;
                while (bl3) {
                    BarPoint barPoint = null;
                    try {
                        barPoint = this.pts[n13 - this.firstLast.x][n14];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    if (barPoint != null) {
                        int n15 = JCChartUtil.distanceTo3dPolygon(point2.x, point2.y, barPoint.top, this.inverted, n2);
                        int n16 = JCChartUtil.distanceTo3dPolygon(point2.x, point2.y, barPoint.side, this.inverted, n2);
                        if (n15 <= n9 || n16 <= n9) {
                            n7 = n14;
                            n8 = n13;
                            n9 = Math.min(n16, n15);
                        }
                    }
                    bl3 = n6 != 0 ? n14 > n11 : n14 < n12;
                    n14 += n10;
                }
                n3 = n6 != 0 ? (n13 <= this.firstLast.x ? 0 : 1) : (n13 >= this.firstLast.y ? 0 : 1);
                n13 += n10;
            }
        }
        n6 = this.firstLast.x;
        while (n6 <= this.firstLast.y) {
            n5 = n6 - this.firstLast.x;
            if (this.pts[n5] != null) {
                n4 = 0;
                while (n4 < this.pts[n5].length) {
                    if (((ChartDataViewSeries)this.seriesList.get(n4)).isVisible()) {
                        BarPoint barPoint = null;
                        try {
                            barPoint = this.pts[n5][n4];
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                        if (barPoint != null && barPoint.x != this.holeValue && barPoint.y != this.holeValue) {
                            n3 = 0;
                            if (barPoint.front != null && (n3 = JCChartUtil.distanceToFrontRect(point2.x, point2.y, barPoint.front.x, barPoint.front.y, barPoint.front.width, barPoint.front.height, this.inverted, n2)) <= n9) {
                                n7 = n4;
                                n8 = n6;
                                n9 = n3;
                            }
                        }
                    }
                    ++n4;
                }
            }
            ++n6;
        }
        if (n7 >= 0 && n8 >= 0) {
            jCDataIndex = new JCDataIndex(n8, (ChartDataViewSeries)this.seriesList.get(n7), n7);
            jCDataIndex.distance = n9;
        }
        return jCDataIndex;
    }

    public void recalc() {
        super.recalc();
        JCBarChartFormat jCBarChartFormat = (JCBarChartFormat)this.dataObject.getChartFormat();
        if (jCBarChartFormat == null || jCBarChartFormat.clusterWidth == 0) {
            this.pts = null;
            return;
        }
        this.delta_x = this.chartArea.getDeltaX();
        this.delta_y = this.chartArea.getDeltaY();
        this.is_3d = this.delta_x != 0 || this.delta_y != 0;
        int n2 = jCBarChartFormat.clusterOverlap;
        if (this.is_3d && n2 > 0) {
            n2 = 0;
        }
        MinMax minMax = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
        MinMax minMax2 = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
        this.dataObject.getDataBounds(minMax, minMax2);
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        double d2 = 1.0 - (double)n2 / 100.0;
        double d3 = this.numActiveDataSeries;
        d3 = (d3 - 1.0) * d2 + 1.0;
        this.bar_base = this.dataObject.step * (double)jCBarChartFormat.clusterWidth / (d3 * 100.0);
        double d4 = d3 * this.bar_base / 2.0;
        double d5 = d2 * this.bar_base;
        this.inverted = this.xaxis.vertical;
        minMax.min -= d4;
        minMax.max += d4;
        this.xaxis.setLimits(minMax);
        this.xaxis.calcTransformation();
        this.xaxis.layoutAnnotations();
        this.xaxis.checkAnnotations();
        minMax2.min = JCNumberUtil.min(this.yaxis.origin.value, minMax2.min);
        minMax2.max = JCNumberUtil.max(this.yaxis.origin.value, minMax2.max);
        this.yaxis.setLimits(minMax2);
        this.yaxis.calcTransformation();
        minMax = this.xaxis.dataLimits;
        minMax2 = this.yaxis.dataLimits;
        boolean bl = this.xaxis.isLogarithmic();
        boolean bl2 = this.yaxis.isLogarithmic();
        this.drawOutline = Math.abs(this.xaxis.toPixel(this.xaxis.min.value + this.bar_base, this.drawFront) - this.xaxis.toPixel(this.xaxis.min.value, this.drawFront)) > 3;
        int n3 = this.inverted ? this.yaxis.getWidth() : this.xaxis.getHeight();
        int n4 = this.inverted ? this.xaxis.getWidth() : this.yaxis.getHeight();
        this.left = this.inverted ? this.yaxis.getLeft() : this.xaxis.getLeft();
        this.right = this.left + n3 - 1;
        this.top = this.inverted ? this.xaxis.getTop() : this.yaxis.getTop();
        this.bottom = this.top + n4 - 1;
        this.firstLast = this.dataObject.getFirstLast();
        if (this.firstLast == null) {
            return;
        }
        this.seriesList = this.dataObject.getSeries();
        int n5 = this.seriesList.size();
        int n6 = this.dataObject.getVisibleDataSeries();
        this.holeValue = this.dataObject.getHoleValue();
        this.pts = new BarPoint[this.firstLast.y - this.firstLast.x + 1][n5];
        this.yOrigin = this.yaxis.origin.value;
        int n7 = this.yaxis.toPixel(this.yOrigin, this.drawFront);
        this.x_reversed = this.xaxis.reversed ? 1 : 0;
        int n8 = this.y_reversed = this.yaxis.reversed ? 1 : 0;
        int n9 = this.inverted ? (this.delta_y > 0 ? 1 ^ this.x_reversed : this.x_reversed) : (this.delta_x <= 0 ? 1 ^ this.x_reversed : this.x_reversed);
        this.fastAction = this.chartArea.getFastAction();
        this.inAction = this.chartArea.getInAction();
        if (!this.fastAction || !this.inAction) {
            this.xAxisPos = this.xaxis.getRealPlacementLocation();
            this.xGridLineList = this.xaxis.getGridLineList();
            if (this.xGridLineList == null) {
                this.xGridLineList = new double[0];
            }
            this.gridLineStyle = this.xaxis.getGridStyle().getLineStyle();
        }
        boolean bl3 = true;
        int n10 = this.firstLast.x;
        while (n10 <= this.firstLast.y) {
            int n11 = 0;
            int n12 = 0;
            while (n12 < this.seriesList.size()) {
                BarPoint[] barPointArray = this.pts[n10 - this.firstLast.x];
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n12);
                if (chartDataViewSeries.isVisible()) {
                    double d6 = chartDataViewSeries.getX(n10);
                    double d7 = chartDataViewSeries.getX(n10) - d4;
                    double d8 = d7 + (double)n11 * d5;
                    double d9 = d8 + this.bar_base;
                    ++n11;
                    if (!(d8 < this.xaxis.min.value && d9 <= this.xaxis.min.value || d8 >= this.xaxis.max.value && d9 > this.xaxis.max.value)) {
                        int n13;
                        int n14;
                        int n15;
                        int n16;
                        double d10;
                        barPointArray[n12] = new BarPoint();
                        barPointArray[n12].x = d8;
                        if (minMax != null && (d9 <= minMax.min || d8 >= minMax.max)) {
                            barPointArray[n12].x = this.holeValue;
                        }
                        if (d6 == this.holeValue || bl && d6 <= 0.0) {
                            barPointArray[n12].x = this.holeValue;
                        }
                        barPointArray[n12].y = (d10 = chartDataViewSeries.getY(n10)) == this.holeValue || bl2 && d10 <= 0.0 ? this.holeValue : d10;
                        BarPoint barPoint = barPointArray[n12];
                        barPoint.front = null;
                        barPoint.top = null;
                        barPoint.side = null;
                        if (this.inverted) {
                            n16 = this.yaxis.toPixel(barPoint.y, this.drawFront);
                            n15 = this.xaxis.toPixel(barPoint.x, this.drawFront);
                            n14 = n15 - this.xaxis.toPixel(barPoint.x + this.bar_base, this.drawFront);
                            n13 = n16 - n7;
                        } else {
                            n16 = this.xaxis.toPixel(barPoint.x, this.drawFront);
                            n15 = this.yaxis.toPixel(barPoint.y, this.drawFront);
                            n13 = this.xaxis.toPixel(barPoint.x + this.bar_base, this.drawFront) - n16;
                            n14 = n7 - n15;
                        }
                        if (this.is_3d && barPoint.x != this.holeValue && barPoint.y != this.holeValue) {
                            int n17;
                            Point[] pointArray = new Point[4];
                            Point[] pointArray2 = new Point[4];
                            pointArray[0] = new Point(0, 0);
                            pointArray[1] = new Point(this.delta_x, this.delta_y);
                            pointArray[2] = new Point(0, 0);
                            pointArray[3] = new Point(-this.delta_x, -this.delta_y);
                            pointArray2[0] = new Point(0, 0);
                            pointArray2[1] = new Point(this.delta_x, this.delta_y);
                            pointArray2[2] = new Point(0, 0);
                            pointArray2[3] = new Point(-this.delta_x, -this.delta_y);
                            if (this.inverted) {
                                pointArray2[0].x = n13 >= 0 ? (this.delta_x > 0 ? n16 : n7) : (this.delta_x > 0 ? n7 : n16);
                                n17 = n9 != 0 ? n15 : n15 - n14;
                                pointArray[0].x = n16 - n13;
                                pointArray[0].y = n17;
                                pointArray[2].x = n13;
                                pointArray2[0].y = n15 - n14;
                                pointArray2[2].y = n14;
                                barPoint.top = pointArray;
                                barPoint.side = pointArray2;
                            } else {
                                pointArray[0].y = n14 >= 0 ? (this.delta_y <= 0 ? n15 : n7) : (this.delta_y <= 0 ? n7 : n15);
                                pointArray2[0].x = n17 = n9 != 0 ? n16 : n16 + n13;
                                pointArray2[0].y = n15 + n14;
                                pointArray2[2].y = -n14;
                                pointArray[0].x = n16;
                                pointArray[2].x = n13;
                                barPoint.top = pointArray;
                                barPoint.side = pointArray2;
                            }
                        }
                        if (this.inverted) {
                            n16 = n7;
                            n15 = this.xaxis.toPixel(barPoint.x, this.drawFront);
                            n13 = this.yaxis.toPixel(barPoint.y, this.drawFront) - n16;
                            n14 = n15 - this.xaxis.toPixel(barPoint.x + this.bar_base, this.drawFront);
                            n15 -= n14;
                        }
                        if (n13 < 0) {
                            n13 = -n13;
                            n16 -= n13;
                        }
                        if (n14 < 0) {
                            n14 = -n14;
                            n15 -= n14;
                        }
                        if (this.inverted) {
                            n14 = Math.max(1, n14);
                        } else {
                            n13 = Math.max(1, n13);
                        }
                        barPoint.front = new Rectangle(n16, n15, n13, n14);
                    }
                }
                ++n12;
            }
            ++n10;
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        BarPoint barPoint = null;
        try {
            barPoint = this.pts[jCDataIndex.point - this.firstLast.x][jCDataIndex.series.getDrawingOrder()];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (barPoint == null) {
            return;
        }
        if (this.start == null || this.end == null) {
            this.start = new Point(0, 0);
            this.end = new Point(0, 0);
        } else {
            this.chartArea.drawRubberBand(this.end, this.start);
        }
        if (this.editInverted) {
            this.start.x = n2;
            this.start.y = barPoint.front.y + this.r.y;
            this.end.x = barPoint.front.x + this.r.x;
            this.end.y = barPoint.front.y + this.r.y + barPoint.front.height;
        } else {
            this.start.x = barPoint.front.x + this.r.x;
            this.start.y = n3;
            this.end.x = barPoint.front.x + this.r.x + barPoint.front.width;
            this.end.y = barPoint.front.height + barPoint.front.y + this.r.y;
        }
        this.chartArea.drawRubberBand(this.end, this.start);
    }

    void startEdit(JCDataIndex jCDataIndex) {
        this.r = this.chartArea.getDrawingArea();
        this.editInverted = jCDataIndex.dataView.getXAxis().vertical;
        this.end = null;
        this.start = null;
    }

    public Point unpick(int n2, int n3) {
        BarPoint barPoint = null;
        try {
            barPoint = this.pts[n2 - this.firstLast.x][n3];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        if (barPoint == null) {
            return null;
        }
        double d2 = barPoint.y;
        double d3 = barPoint.x;
        int n4 = -1;
        int n5 = -1;
        if (d2 != this.holeValue && d3 != this.holeValue) {
            if (this.inverted) {
                n4 = this.yaxis.toPixel(d2, this.drawFront);
                n5 = barPoint.front.y + barPoint.front.height / 2;
            } else {
                n5 = this.yaxis.toPixel(d2, this.drawFront);
                n4 = barPoint.front.x + barPoint.front.width / 2;
            }
            return new Point(n4, n5);
        }
        return null;
    }
}

