/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.ChartText;
import com.klg.jclass.chart.ErrorDialog;
import com.klg.jclass.chart.JCAxis;
import com.klg.jclass.chart.JCChart;
import com.klg.jclass.chart.JCChartBundle;
import com.klg.jclass.chart.JCValueLabel;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Vector;

abstract class AxisHandler {
    JCAxis parent = null;
    double shift;
    double scale = 1.0;

    AxisHandler() {
    }

    abstract void calcParams();

    abstract void calcPrecision();

    abstract void calcTransformation();

    protected void drawTick(Graphics graphics, int n2, int n3) {
        if (this.parent.vertical) {
            graphics.drawLine(n2 - this.parent.tickLength / 2, n3, n2 + this.parent.tickLength / 2, n3);
        } else {
            graphics.drawLine(n3, n2 - this.parent.tickLength / 2, n3, n2 + this.parent.tickLength / 2);
        }
    }

    void drawTicks(Graphics graphics) {
        int n2 = this.parent.linePosition();
        Vector vector = this.parent.getAnnotations();
        int n3 = 0;
        while (n3 < vector.size()) {
            JCValueLabel jCValueLabel = (JCValueLabel)vector.elementAt(n3);
            if (jCValueLabel.getChartText().isVisible()) {
                int n4 = this.parent.toPixel(jCValueLabel.value);
                this.drawTick(graphics, n2, n4);
            }
            ++n3;
        }
    }

    boolean fixBounds() {
        if (!this.parent.min.isDefault && !this.parent.max.isDefault && this.parent.min.value >= this.parent.max.value) {
            String string = JCChartBundle.string("com.klg.jclass.chart.Key105");
            string = String.valueOf(string) + JCChartBundle.string("com.klg.jclass.chart.Key130");
            ErrorDialog.raise(this.parent, string);
            this.parent.max.isDefault = true;
            return true;
        }
        return false;
    }

    abstract String format(double var1, int var3);

    void getAnnoExtent(Dimension dimension, double d2, int n2) {
        Dimension dimension2;
        JCChart jCChart = this.parent.getParentChart();
        FontMetrics fontMetrics = null;
        try {
            fontMetrics = jCChart.getGraphics().getFontMetrics(this.parent.getFont());
        }
        catch (Exception exception) {}
        if (fontMetrics == null) {
            return;
        }
        if (this.parent.labelGenerator != null) {
            Object object = this.parent.labelGenerator.makeLabel(d2, n2);
            if (object == null) {
                return;
            }
            if (object instanceof ChartText) {
                ChartText chartText = (ChartText)object;
                chartText.setParentChart(this.parent.getParentChart());
                dimension2 = new Dimension(chartText.getWidth(), chartText.getHeight());
            } else {
                String string = object instanceof String ? (String)object : object.toString();
                dimension2 = new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
            }
        } else {
            String string = this.format(d2, n2);
            dimension2 = new Dimension(fontMetrics.stringWidth(string), fontMetrics.getHeight());
        }
        if (this.parent.annotationRotation == 0) {
            if (dimension.width < dimension2.width) {
                dimension.width = dimension2.width;
            }
            if (dimension.height < dimension2.height) {
                dimension.height = dimension2.height;
            }
        } else {
            if (dimension.width < dimension2.height) {
                dimension.width = dimension2.height;
            }
            if (dimension.height < dimension2.width) {
                dimension.height = dimension2.width;
            }
        }
    }

    static AxisHandler makeAxisHandler(JCAxis jCAxis) {
        AxisHandler axisHandler = null;
        try {
            axisHandler = jCAxis.logarithmic ? (AxisHandler)Class.forName("com.klg.jclass.chart.LogAxisHandler").newInstance() : (AxisHandler)Class.forName("com.klg.jclass.chart.LinearAxisHandler").newInstance();
        }
        catch (Exception exception) {
            axisHandler = null;
        }
        if (axisHandler != null) {
            axisHandler.setParent(jCAxis);
        }
        return axisHandler;
    }

    abstract double range();

    void setParent(JCAxis jCAxis) {
        this.parent = jCAxis;
    }

    abstract double toData(int var1);

    abstract int toPixel(double var1);

    abstract void translate(double var1);
}

