/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.chart;

import com.klg.jclass.chart.AreaPolygon;
import com.klg.jclass.chart.ChartDataViewSeries;
import com.klg.jclass.chart.ChartDraw;
import com.klg.jclass.chart.JCChartStyle;
import com.klg.jclass.chart.JCDataIndex;
import com.klg.jclass.chart.JCFillStyle;
import com.klg.jclass.chart.MinMax;
import com.klg.jclass.util.JCNumberUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;

public class AreaChartDraw
extends ChartDraw {
    protected Point firstLast = null;
    Color outlineColor = Color.black;
    protected MinMax xlim = null;
    protected MinMax ylim = null;
    protected Vector[] polyList;
    static final int XINSIDE = 1;
    static final int XBYX1 = 2;
    static final int XBYX2 = 3;
    static final int YINSIDE = 10;
    static final int YBYTOP = 11;
    static final int YBYORIGIN = 12;
    Point prev = null;
    Point next = null;
    Point last = null;
    Rectangle r = null;

    protected int calcFillOrientation(Rectangle rectangle, double d2, boolean bl, boolean bl2, boolean bl3) {
        if (!bl) {
            int n2 = this.yaxis.toPixel(d2, this.drawFront);
            if (rectangle.y < n2) {
                rectangle.height = Math.abs(n2 - rectangle.y);
                if (!bl2) {
                    return 6;
                }
                return 8;
            }
            if (!bl2) {
                return 7;
            }
            return 9;
        }
        int n3 = this.yaxis.toPixel(d2, this.drawFront);
        if (rectangle.x < n3) {
            rectangle.width = Math.abs(n3 - rectangle.x);
            if (!bl2) {
                return 8;
            }
            return 9;
        }
        if (!bl2) {
            return 6;
        }
        return 7;
    }

    private boolean clipAreaPolygon(double d2, double d3, double d4, double d5, int n2, AreaPolygon areaPolygon, boolean bl, boolean bl2) {
        int n3 = 0;
        int n4 = 0;
        if (!bl) {
            if (d2 == this.holeValue || d3 == Double.MAX_VALUE) {
                n4 = 1;
                n3 = 1;
            } else {
                n3 = JCNumberUtil.locateX(d2, this.xaxis.min.value, this.xaxis.max.value);
            }
        }
        if (n4 == 0) {
            if (d4 == this.holeValue || d5 == Double.MAX_VALUE) {
                n4 = 1;
                n3 = 1;
            } else {
                n4 = JCNumberUtil.locateX(d4, this.xaxis.min.value, this.xaxis.max.value);
                if (bl && n4 != 0) {
                    n3 = JCNumberUtil.locateX(d2, this.xaxis.min.value, this.xaxis.max.value);
                }
            }
        }
        if (n3 != 0 && n4 != 0 && n3 == n4) {
            return false;
        }
        if (bl) {
            if (bl2) {
                areaPolygon.poly.addPoint(this.yaxis.toPixel(d5, this.drawFront), this.xaxis.toPixel(d4, this.drawFront));
            } else {
                areaPolygon.poly.addPoint(this.xaxis.toPixel(d4, this.drawFront), this.yaxis.toPixel(d5, this.drawFront));
            }
            areaPolygon.endPoint = n2;
        } else {
            if (bl2) {
                areaPolygon.poly.addPoint(this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront), this.xaxis.toPixel(d2, this.drawFront));
                areaPolygon.poly.addPoint(this.yaxis.toPixel(d3, this.drawFront), this.xaxis.toPixel(d2, this.drawFront));
                areaPolygon.poly.addPoint(this.yaxis.toPixel(d5, this.drawFront), this.xaxis.toPixel(d4, this.drawFront));
            } else {
                areaPolygon.poly.addPoint(this.xaxis.toPixel(d2, this.drawFront), this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront));
                areaPolygon.poly.addPoint(this.xaxis.toPixel(d2, this.drawFront), this.yaxis.toPixel(d3, this.drawFront));
                areaPolygon.poly.addPoint(this.xaxis.toPixel(d4, this.drawFront), this.yaxis.toPixel(d5, this.drawFront));
            }
            areaPolygon.startPoint = n2 - 1;
            areaPolygon.endPoint = n2;
        }
        return true;
    }

    public void draw(Graphics graphics) {
        this.draw(graphics, -1, -1, true);
    }

    public void draw(Graphics graphics, int n2, int n3) {
        this.draw(graphics, n2, n3, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void draw(Graphics graphics, int n2, int n3, boolean bl) {
        if (this.seriesList == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (rectangle.width == 0) return;
        if (rectangle.height == 0) {
            return;
        }
        boolean bl2 = false;
        if (n2 >= 0 && n3 >= 0 && n3 >= n2) {
            bl2 = true;
        }
        if (this.polyList == null) {
            return;
        }
        this.outlineColor = this.dataObject.getOutlineColor();
        int n4 = bl ? 0 : this.polyList.length - 1;
        while (!(bl ? n4 >= this.polyList.length : n4 < 0)) {
            JCChartStyle jCChartStyle;
            ChartDataViewSeries chartDataViewSeries;
            if (!this.cachePlotData) {
                this.recalc(-1, -1, n4);
            }
            if (this.polyList[n4] != null && (chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n4)).isVisible() && (jCChartStyle = chartDataViewSeries.getStyle()) != null) {
                int n5;
                int n6;
                AreaPolygon areaPolygon;
                JCFillStyle jCFillStyle = jCChartStyle.getFillStyle();
                if (!bl2) {
                    areaPolygon = null;
                    n6 = 0;
                    while (n6 < this.polyList[n4].size()) {
                        areaPolygon = (AreaPolygon)this.polyList[n4].elementAt(n6);
                        if (areaPolygon != null) {
                            Rectangle rectangle2 = areaPolygon.poly.getBounds();
                            n5 = this.calcFillOrientation(rectangle2, this.yaxis.origin.value, this.inverted, this.xaxis.reversed, this.yaxis.reversed);
                            jCFillStyle.updateFillOrientation(rectangle2, n5);
                            jCFillStyle.fillOutlinePolygon(graphics, areaPolygon.poly, this.outlineColor);
                            jCFillStyle.resetFillOrientation();
                        }
                        ++n6;
                    }
                } else {
                    areaPolygon = null;
                    n6 = 0;
                    while (n6 < this.polyList[n4].size()) {
                        areaPolygon = (AreaPolygon)this.polyList[n4].elementAt(n6);
                        if (areaPolygon != null && n2 <= areaPolygon.endPoint) {
                            if (areaPolygon.startPoint >= n2 - 1 && areaPolygon.endPoint <= n3) {
                                jCFillStyle.fillOutlinePolygon(graphics, areaPolygon.poly, this.outlineColor);
                            } else if (n2 - 1 > areaPolygon.startPoint) {
                                int n7 = n2 - areaPolygon.startPoint;
                                if (n7 < 0) {
                                    n7 = 0;
                                }
                                n5 = areaPolygon.poly.npoints - n7;
                                int[] nArray = new int[n5];
                                int[] nArray2 = new int[n5];
                                int n8 = 0;
                                while (n8 < n5) {
                                    nArray[n8] = areaPolygon.poly.xpoints[n7 + n8];
                                    nArray2[n8] = areaPolygon.poly.ypoints[n7 + n8];
                                    ++n8;
                                }
                                if (this.inverted) {
                                    nArray2[n5 - 1] = nArray2[0];
                                } else {
                                    nArray[n5 - 1] = nArray[0];
                                }
                                Polygon polygon = new Polygon(nArray, nArray2, n5);
                                jCFillStyle.fillOutlinePartialPolygon(graphics, polygon, this.outlineColor);
                            }
                        }
                        ++n6;
                    }
                }
                if (!this.cachePlotData) {
                    this.polyList[n4] = null;
                }
            }
            n4 += bl ? 1 : -1;
        }
    }

    int endEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return -1;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        return jCDataIndex.dataView.getXAxis().vertical ? n2 - this.r.x : n3 - this.r.y;
    }

    private int findLastPoly(Vector vector) {
        int n2 = 0;
        while (n2 < vector.size()) {
            if (vector.elementAt(n2) == null) {
                return n2 - 1;
            }
            ++n2;
        }
        return vector.size() - 1;
    }

    private void finishAreaPolygon(AreaPolygon areaPolygon, int[] nArray, int[] nArray2, boolean bl) {
        int n2;
        int n3;
        Polygon polygon = areaPolygon.poly;
        int n4 = polygon.npoints;
        int n5 = areaPolygon.endPoint;
        while (n5 >= areaPolygon.startPoint) {
            n3 = n4 - 1 - (areaPolygon.endPoint - n5);
            n2 = nArray == null ? this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront) : nArray[n5];
            if (bl) {
                polygon.addPoint(n2, polygon.ypoints[n3]);
            } else {
                polygon.addPoint(polygon.xpoints[n3], n2);
            }
            --n5;
        }
        if (bl) {
            polygon.xpoints[0] = polygon.xpoints[polygon.npoints - 1];
        } else {
            polygon.ypoints[0] = polygon.ypoints[polygon.npoints - 1];
        }
        n3 = areaPolygon.startPoint;
        while (n3 <= areaPolygon.endPoint) {
            n2 = n3 - areaPolygon.startPoint + 1;
            nArray2[n3] = bl ? areaPolygon.poly.xpoints[n2] : areaPolygon.poly.ypoints[n2];
            ++n3;
        }
    }

    private void finishAreaPolygon(Polygon polygon, boolean bl) {
        if (bl) {
            polygon.addPoint(this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront), polygon.ypoints[polygon.npoints - 1]);
        } else {
            polygon.addPoint(polygon.xpoints[polygon.npoints - 1], this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront));
        }
        polygon.addPoint(polygon.xpoints[0], polygon.ypoints[0]);
    }

    protected double[] getYVals(ChartDataViewSeries chartDataViewSeries) {
        double[] dArray = chartDataViewSeries.getY();
        double[] dArray2 = new double[dArray.length];
        int n2 = 0;
        while (n2 < dArray2.length) {
            dArray2[n2] = dArray[n2] == this.holeValue || this.yaxis.isLogarithmic() && dArray[n2] <= 0.0 ? Double.MAX_VALUE : dArray[n2];
            ++n2;
        }
        return dArray2;
    }

    public JCDataIndex pick(Point point, int n2) {
        return this.pick(point, n2, false);
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    public JCDataIndex pick(Point point, int n2, boolean bl) {
        Object object;
        double d2;
        Object object2;
        double d3;
        Object object3;
        Rectangle rectangle = this.chartArea.getDrawingArea();
        Point point2 = new Point(point.x - rectangle.x, point.y - rectangle.y);
        int n3 = -1;
        int n4 = -1;
        JCDataIndex jCDataIndex = null;
        int n5 = this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront);
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        long l2 = 0L;
        int n9 = 0;
        int n10 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        int n11 = 0;
        int n12 = 0;
        long l3 = rectangle.width + rectangle.height;
        int n13 = bl ? 0 : this.seriesList.size() - 1;
        boolean bl4 = true;
        do {
            boolean bl5;
            if (!bl4 || (bl4 = false) || !true) {
                ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n13);
                if (chartDataViewSeries != null && chartDataViewSeries.isVisible() && this.firstLast != null && (double)this.firstLast.x != this.holeValue && (double)this.firstLast.y != this.holeValue) {
                    object3 = this.getYVals(chartDataViewSeries);
                    n8 = n13;
                    d3 = chartDataViewSeries.getX(this.firstLast.x);
                    object2 = object3[this.firstLast.x];
                    bl2 = d3 == this.holeValue || object2 == Double.MAX_VALUE;
                    n11 = bl2 ? 1 : JCNumberUtil.locateXY(d3, object2, this.xlim.min, this.xlim.max, this.ylim.min, this.ylim.max);
                    boolean bl6 = false;
                    int n14 = this.firstLast.x + 1;
                    while (n14 <= this.firstLast.y && l3 > 0L) {
                        boolean bl7;
                        d2 = chartDataViewSeries.getX(n14);
                        object = object3[n14];
                        bl3 = d2 == this.holeValue || object == Double.MAX_VALUE;
                        n12 = bl3 ? 2 : JCNumberUtil.locateXY(d2, object, this.xlim.min, this.xlim.max, this.ylim.min, this.ylim.max);
                        boolean bl8 = bl7 = bl2 || bl3;
                        if (!(n11 != 0 && n12 != 0 || bl7)) {
                            long l4;
                            double d8;
                            long l5;
                            if (this.inverted) {
                                if (!bl6) {
                                    d5 = this.xaxis.toPixel(d3, this.drawFront);
                                    d4 = this.yaxis.toPixel((double)object2, this.drawFront);
                                }
                                d7 = this.xaxis.toPixel(d2, this.drawFront);
                                d6 = this.yaxis.toPixel((double)object, this.drawFront);
                                l2 = d6 < (double)n5 && d4 > (double)n5 || d4 < (double)n5 && d6 > (double)n5 ? ((l5 = JCNumberUtil.distTrap(point2.y, point2.x, n5, d5, d8 = d5 + ((double)n5 - d4) * (d7 - d5) / (d6 - d4), d4, n5)) < (l4 = JCNumberUtil.distTrap(point2.y, point2.x, n5, d8, d7, n5, d6)) ? l5 : l4) : JCNumberUtil.distTrap(point2.y, point2.x, n5, d5, d7, d4, d6);
                            } else {
                                if (!bl6) {
                                    d4 = this.xaxis.toPixel(d3, this.drawFront);
                                    d5 = this.yaxis.toPixel((double)object2, this.drawFront);
                                }
                                d6 = this.xaxis.toPixel(d2, this.drawFront);
                                d7 = this.yaxis.toPixel((double)object, this.drawFront);
                                l2 = d7 < (double)n5 && d5 > (double)n5 || d5 < (double)n5 && d7 > (double)n5 ? ((l5 = JCNumberUtil.distTrap(point2.x, point2.y, n5, d4, d8 = d4 + ((double)n5 - d5) * (d6 - d4) / (d7 - d5), d5, n5)) < (l4 = JCNumberUtil.distTrap(point2.x, point2.y, n5, d8, d6, n5, d7)) ? l5 : l4) : JCNumberUtil.distTrap(point2.x, point2.y, n5, d4, d6, d5, d7);
                            }
                            if (l2 < l3) {
                                n6 = n14 - 1;
                                n7 = n13;
                                l3 = l2;
                            }
                            bl6 = true;
                            d4 = d6;
                            d5 = d7;
                        } else {
                            bl6 = false;
                        }
                        d3 = d2;
                        object2 = object;
                        bl2 = bl3;
                        n11 = n12;
                        ++n14;
                    }
                }
                n13 += bl ? 1 : -1;
            }
            if (bl) {
                if (n13 < this.seriesList.size()) continue;
                bl5 = false;
            } else {
                if (n13 >= 0) continue;
                bl5 = false;
            }
            if (!bl5) break;
        } while (l3 > 0L);
        if (n7 == -1) {
            return null;
        }
        int n15 = n7;
        n9 = n6;
        if (n9 < this.firstLast.x) {
            n9 = this.firstLast.x;
            n10 = this.firstLast.x + 1;
        } else if (n9 > this.firstLast.y) {
            n9 = this.firstLast.y - 1;
            n10 = this.firstLast.y;
        } else {
            n10 = n9 + 1;
            if (n10 > this.firstLast.y) {
                n10 = --n9 + 1;
            }
        }
        if (n9 < this.firstLast.x) {
            n9 = n10 = this.firstLast.x;
        }
        object3 = (ChartDataViewSeries)this.seriesList.get(n15);
        double[] dArray = this.getYVals((ChartDataViewSeries)object3);
        d3 = ((ChartDataViewSeries)object3).getX(n9);
        object2 = dArray[n9];
        d2 = ((ChartDataViewSeries)object3).getX(n10);
        object = dArray[n10];
        n11 = d3 == this.holeValue || object2 == Double.MAX_VALUE ? 1 : JCNumberUtil.locateXY(d3, object2, this.xlim.min, this.xlim.max, this.ylim.min, this.ylim.max);
        int n16 = n12 = d2 == this.holeValue || object == Double.MAX_VALUE ? 1 : JCNumberUtil.locateXY(d2, object, this.xlim.min, this.xlim.max, this.ylim.min, this.ylim.max);
        if (this.inverted) {
            if (n11 == 0) {
                d5 = this.xaxis.toPixel(d3, this.drawFront);
                d4 = this.yaxis.toPixel((double)object2, this.drawFront);
            }
            if (n12 == 0) {
                d7 = this.xaxis.toPixel(d2, this.drawFront);
                d6 = this.yaxis.toPixel((double)object, this.drawFront);
            }
        } else {
            if (n11 == 0) {
                d4 = this.xaxis.toPixel(d3, this.drawFront);
                d5 = this.yaxis.toPixel((double)object2, this.drawFront);
            }
            if (n12 == 0) {
                d6 = this.xaxis.toPixel(d2, this.drawFront);
                d7 = this.yaxis.toPixel((double)object, this.drawFront);
            }
        }
        if (n11 == 0 || n12 == 0) {
            if (n11 == 0 && n12 == 0) {
                switch (n2) {
                    case 1: {
                        n4 = Math.abs((double)point2.x - d4) < Math.abs((double)point2.x - d6) ? n9 : n10;
                        break;
                    }
                    case 2: {
                        n4 = Math.abs((double)point2.y - d5) < Math.abs((double)point2.y - d7) ? n9 : n10;
                        break;
                    }
                    default: {
                        long l6 = (long)(((double)point2.x - d4) * ((double)point2.x - d4) + ((double)point2.y - d5) * ((double)point2.y - d5));
                        long l7 = (long)(((double)point2.x - d6) * ((double)point2.x - d6) + ((double)point2.y - d7) * ((double)point2.y - d7));
                        n4 = l6 < l7 ? n9 : n10;
                        break;
                    }
                }
            } else {
                n4 = n11 != 0 ? n10 : n9;
            }
            if ((n3 = n7) >= 0 && n4 >= 0) {
                jCDataIndex = new JCDataIndex(n4, (ChartDataViewSeries)this.seriesList.get(n3), n3);
                jCDataIndex.distance = (int)l3;
            }
        }
        return jCDataIndex;
    }

    public void recalc() {
        this.recalc(-1, -1, -1);
    }

    public void recalc(int n2, int n3) {
        this.recalc(n2, n3, -1);
    }

    public void recalc(int n2, int n3, int n4) {
        super.recalc();
        this.fastUpdate = this.dataObject.getFastUpdate();
        this.cachePlotData = this.fastUpdate ? true : this.dataObject.getBufferPlotData();
        boolean bl = false;
        if (n2 >= 0 && n3 >= 0 && n3 >= n2 && this.polyList != null) {
            bl = true;
        }
        if (n4 == -1) {
            this.seriesList = this.dataObject.getSeries();
        }
        if (this.seriesList == null) {
            return;
        }
        this.inverted = this.dataObject.getXAxis().vertical;
        this.holeValue = this.dataObject.getHoleValue();
        this.firstLast = this.dataObject.getFirstLast();
        this.xaxis = this.dataObject.getXAxis();
        this.yaxis = this.dataObject.getYAxis();
        this.xlim = new MinMax(this.dataObject.getXLimits().min, this.dataObject.getXLimits().max);
        this.ylim = new MinMax(this.dataObject.getYLimits().min, this.dataObject.getYLimits().max);
        this.dataObject.getDataBounds(this.xlim, this.ylim);
        boolean bl2 = this.xaxis.isLogarithmic();
        boolean bl3 = this.yaxis.isLogarithmic();
        int n5 = this.dataObject.getChartType();
        if (!this.cachePlotData && n4 == -1) {
            if (this.polyList == null) {
                this.polyList = new Vector[this.seriesList.size()];
            }
            return;
        }
        if (!bl) {
            this.polyList = new Vector[this.seriesList.size()];
        }
        int n6 = n4 == -1 ? 0 : n4;
        int n7 = n4 == -1 ? this.seriesList.size() : n4 + 1;
        Object object = null;
        int n8 = n6;
        while (n8 < n7) {
            ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n8);
            if (!bl) {
                this.polyList[n8] = null;
            }
            if (chartDataViewSeries.maxXIndex() != 0 && chartDataViewSeries.maxYIndex() != 0) {
                int n9;
                Object object2;
                int n10;
                if (!bl) {
                    n2 = chartDataViewSeries.getFirstPoint();
                    n3 = chartDataViewSeries.getLastPoint();
                    n10 = n3 - n2 + 1;
                    this.polyList[n8] = new Vector();
                } else {
                    int n11;
                    n10 = n3 + 1;
                    int n12 = n11 = this.polyList[n8] == null ? 0 : this.polyList[n8].size();
                    if (n2 < n11) {
                        n2 = n11;
                    }
                }
                double[] dArray = this.getYVals(chartDataViewSeries);
                double d2 = 0.0;
                double d3 = Double.MAX_VALUE;
                boolean bl4 = false;
                int n13 = 0;
                if (bl && n2 > 0) {
                    d2 = chartDataViewSeries.getX(n2 - 1);
                    d3 = dArray[n2 - 1];
                    n13 = this.findLastPoly(this.polyList[n8]);
                    if (n13 >= 0) {
                        object2 = (AreaPolygon)this.polyList[n8].elementAt(n13);
                        if (n2 - 1 >= ((AreaPolygon)object2).startPoint && n2 - 1 <= ((AreaPolygon)object2).endPoint) {
                            bl4 = true;
                            ((AreaPolygon)object2).poly.npoints -= 2;
                        }
                    } else {
                        bl4 = false;
                        ++n13;
                        if (d2 == this.holeValue || d3 == Double.MAX_VALUE) {
                            d2 = 0.0;
                            d3 = Double.MAX_VALUE;
                        }
                        object2 = new AreaPolygon();
                        ((AreaPolygon)object2).series = n8;
                        this.polyList[n8].addElement(object2);
                    }
                } else {
                    object2 = new AreaPolygon();
                    ((AreaPolygon)object2).series = n8;
                    this.polyList[n8].addElement(object2);
                }
                object2 = null;
                if (n5 == 12) {
                    object2 = new int[n3 - n2 + 1];
                    n9 = 0;
                    while (n9 < ((Object)object2).length) {
                        object2[n9] = object != null && n9 < (object).length ? object[n9] : (Object)this.yaxis.toPixel(this.yaxis.origin.value, this.drawFront);
                        ++n9;
                    }
                }
                n9 = n2;
                while (n9 <= n3) {
                    if (n9 < dArray.length) {
                        double d4 = chartDataViewSeries.getX(n9);
                        if (bl2 && d4 <= 0.0) {
                            d4 = this.holeValue;
                        }
                        double d5 = dArray[n9];
                        if (bl3 && d5 <= 0.0) {
                            d5 = this.holeValue;
                        }
                        if (!(bl4 = this.clipAreaPolygon(d2, d3, d4, d5, n9, (AreaPolygon)this.polyList[n8].elementAt(n13), bl4, this.inverted)) && ((AreaPolygon)this.polyList[n8].elementAt((int)n13)).poly.npoints > 0) {
                            AreaPolygon areaPolygon = (AreaPolygon)this.polyList[n8].elementAt(n13);
                            if (n5 == 12) {
                                this.finishAreaPolygon(areaPolygon, (int[])object, (int[])object2, this.inverted);
                            } else {
                                this.finishAreaPolygon(areaPolygon.poly, this.inverted);
                            }
                            ++n13;
                            AreaPolygon areaPolygon2 = new AreaPolygon();
                            areaPolygon2.series = n8;
                            this.polyList[n8].addElement(areaPolygon2);
                        }
                        d2 = d4;
                        d3 = d5;
                    }
                    ++n9;
                }
                AreaPolygon areaPolygon = (AreaPolygon)this.polyList[n8].elementAt(n13);
                if (areaPolygon.poly.npoints > 0) {
                    if (n5 == 12) {
                        this.finishAreaPolygon(areaPolygon, (int[])object, (int[])object2, this.inverted);
                    } else {
                        this.finishAreaPolygon(areaPolygon.poly, this.inverted);
                    }
                } else {
                    this.polyList[n8].setElementAt(null, n13);
                }
                if (n5 == 12) {
                    object = object2;
                }
            }
            ++n8;
        }
    }

    void showEdit(JCDataIndex jCDataIndex, int n2, int n3) {
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
        if (this.last == null) {
            this.last = jCDataIndex.dataView.getXAxis().vertical ? new Point(n2, jCDataIndex.dataView.getXAxis().toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.getXAxis().toPixel(jCDataIndex.series.getX(jCDataIndex.point), this.drawFront) + this.r.x, n3);
        } else if (jCDataIndex.dataView.getXAxis().vertical) {
            this.last.x = n2;
        } else {
            this.last.y = n3;
        }
        this.chartArea.drawRubberLine(this.prev, this.last);
        this.chartArea.drawRubberLine(this.last, this.next);
    }

    void startEdit(JCDataIndex jCDataIndex) {
        double d2;
        double d3;
        double d4;
        double d5;
        if (jCDataIndex == null || jCDataIndex.dataView != this.dataObject) {
            return;
        }
        int n2 = jCDataIndex.series.getDrawingOrder();
        ChartDataViewSeries chartDataViewSeries = jCDataIndex.series;
        boolean bl = jCDataIndex.dataView.getXAxis().vertical;
        this.r = this.chartArea.getDrawingArea();
        this.last = null;
        this.next = null;
        this.prev = null;
        double[] dArray = this.getYVals(chartDataViewSeries);
        if (jCDataIndex.point - 1 >= 0 && jCDataIndex.point - 1 >= chartDataViewSeries.getFirstPoint() && jCDataIndex.point - 1 <= chartDataViewSeries.getLastPoint()) {
            d5 = chartDataViewSeries.getX(jCDataIndex.point - 1);
            d4 = dArray[jCDataIndex.point - 1];
            if (d5 == jCDataIndex.dataView.getHoleValue() || d4 == jCDataIndex.dataView.getHoleValue()) {
                d4 = jCDataIndex.dataView.getYAxis().origin.value;
                d5 = chartDataViewSeries.getX(jCDataIndex.point);
            }
        } else {
            d5 = chartDataViewSeries.getX(jCDataIndex.point);
            d4 = jCDataIndex.dataView.getYAxis().origin.value;
        }
        this.prev = bl ? new Point(jCDataIndex.dataView.getYAxis().toPixel(d4, this.drawFront) + this.r.x, jCDataIndex.dataView.getXAxis().toPixel(d5, this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.getXAxis().toPixel(d5, this.drawFront) + this.r.x, jCDataIndex.dataView.getYAxis().toPixel(d4, this.drawFront) + this.r.y);
        if (jCDataIndex.point + 1 < chartDataViewSeries.maxXIndex() && jCDataIndex.point + 1 >= chartDataViewSeries.getFirstPoint() && jCDataIndex.point + 1 <= chartDataViewSeries.getLastPoint()) {
            d3 = chartDataViewSeries.getX(jCDataIndex.point + 1);
            d2 = dArray[jCDataIndex.point + 1];
            if (d3 == jCDataIndex.dataView.getHoleValue() || d2 == jCDataIndex.dataView.getHoleValue()) {
                d2 = jCDataIndex.dataView.getYAxis().origin.value;
                d3 = chartDataViewSeries.getX(jCDataIndex.point);
            }
        } else {
            d3 = chartDataViewSeries.getX(jCDataIndex.point);
            d2 = jCDataIndex.dataView.getYAxis().origin.value;
        }
        this.next = bl ? new Point(jCDataIndex.dataView.getYAxis().toPixel(d2, this.drawFront) + this.r.x, jCDataIndex.dataView.getXAxis().toPixel(d3, this.drawFront) + this.r.y) : new Point(jCDataIndex.dataView.getXAxis().toPixel(d3, this.drawFront) + this.r.x, jCDataIndex.dataView.getYAxis().toPixel(d2, this.drawFront) + this.r.y);
    }

    public Point unpick(int n2, int n3) {
        ChartDataViewSeries chartDataViewSeries = (ChartDataViewSeries)this.seriesList.get(n3);
        double[] dArray = this.getYVals(chartDataViewSeries);
        double d2 = dArray[n2];
        double d3 = chartDataViewSeries.getX(n2);
        int n4 = -1;
        int n5 = -1;
        if (d3 != this.holeValue && d2 != Double.MAX_VALUE) {
            if (this.inverted) {
                n4 = this.yaxis.toPixel(d2, this.drawFront);
                n5 = this.xaxis.toPixel(d3, this.drawFront);
            } else {
                n4 = this.xaxis.toPixel(d3, this.drawFront);
                n5 = this.yaxis.toPixel(d2, this.drawFront);
            }
            return new Point(n4, n5);
        }
        return null;
    }
}

